/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.metrics;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.tool.Job;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RoutingMetric<T> {
    private static Logger logger = LoggerFactory.getLogger(RoutingMetric.class);

    public abstract T calculate(Cell var1);

    public T calculate(Network net) {
        return null;
    }

    protected T processNets(Cell cell, T startValue) {
        T result = startValue;
        boolean debug = Job.getDebug();
        if (cell == null) {
            return result;
        }
        Iterator<Network> it = cell.getNetlist().getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (debug) {
                logger.trace("process net: " + net.getName());
            }
            result = this.reduce(result, net);
        }
        return result;
    }

    protected T reduce(T result, ArcInst instance, Network net) {
        throw new UnsupportedOperationException();
    }

    protected T reduce(T result, Network net) {
        throw new UnsupportedOperationException();
    }
}

