/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util;

import com.sun.electric.util.TextUtils;

public class ClientOS {
    public static final OS os = ClientOS.OSInitialize();
    public static double osVersion;

    public static String getOSPrefix() {
        String osPrefix = "";
        if (os == OS.WINDOWS) {
            osPrefix = "Win";
        } else if (os == OS.MACINTOSH) {
            osPrefix = "Mac";
        } else if (os == OS.UNIX) {
            osPrefix = "Linux";
        }
        return osPrefix;
    }

    public static String userDir() {
        return ClientOS.isOSMac() ? System.getProperty("user.home") : System.getProperty("user.dir");
    }

    private static OS OSInitialize() {
        osVersion = 0.0;
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                String versionStr = osName.substring(8);
                osVersion = TextUtils.atof(versionStr);
                return OS.WINDOWS;
            }
            if (osName.startsWith("linux") || osName.startsWith("solaris") || osName.startsWith("sunos")) {
                return OS.UNIX;
            }
            if (osName.startsWith("mac")) {
                return OS.MACINTOSH;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("No OS detected");
        return null;
    }

    public static boolean isOSWindows() {
        return os == OS.WINDOWS;
    }

    public static boolean isOSMac() {
        return os == OS.MACINTOSH;
    }

    public static boolean isOSLinux() {
        return os == OS.UNIX;
    }

    public static double getOSVersion() {
        return osVersion;
    }

    public static enum OS {
        WINDOWS("Windows"),
        UNIX("UNIX"),
        MACINTOSH("Macintosh");

        private String name;

        private OS(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

