/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.IconParameters;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CompileVerilogStruct {
    private List<VModule> allModules;
    private int errorCount;
    private ErrorLogger errorLogger;
    private boolean hasParentLogger;
    private boolean verbose;
    private boolean hasErrors;
    private VModule curModule;
    private List<TokenList> tList;
    private int tokenIndex;
    private static final int MODE_UNKNOWN = 0;
    private static final int MODE_IN = 1;
    private static final int MODE_OUT = 2;
    private static final int MODE_INOUT = 3;

    public CompileVerilogStruct(File f, boolean verbose, ErrorLogger logger) {
        this.verbose = verbose;
        try {
            String line;
            InputStreamReader is = new InputStreamReader(new FileInputStream(f));
            LineNumberReader lineReader = new LineNumberReader(is);
            ArrayList<String> stringList = new ArrayList<String>();
            while ((line = lineReader.readLine()) != null) {
                stringList.add(line);
            }
            lineReader.close();
            String[] strings = new String[stringList.size()];
            for (int i = 0; i < stringList.size(); ++i) {
                strings[i] = (String)stringList.get(i);
            }
            this.processVerilog(strings, logger);
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + e.getMessage());
            this.hasErrors = true;
            return;
        }
    }

    public CompileVerilogStruct(Cell verilogCell, boolean verbose) {
        this.verbose = verbose;
        String[] strings = verilogCell.getTextViewContents();
        if (strings == null) {
            System.out.println("Cell " + verilogCell.describe(true) + " has no text in it");
            return;
        }
        this.processVerilog(strings, null);
    }

    public CompileVerilogStruct(String[] strings, boolean verbose) {
        this.verbose = verbose;
        this.processVerilog(strings, null);
    }

    public boolean hadErrors() {
        return this.hasErrors;
    }

    public List<VModule> getModules() {
        return this.allModules;
    }

    private void processVerilog(String[] strings, ErrorLogger logger) {
        if (this.verbose) {
            Job.getUserInterface().startProgressDialog("Compiling Verilog", null);
            Job.getUserInterface().setProgressNote("Scanning...");
        }
        this.allModules = new ArrayList<VModule>();
        this.tList = new ArrayList<TokenList>();
        this.errorCount = 0;
        this.errorLogger = logger;
        this.hasParentLogger = logger != null;
        this.hasErrors = false;
        this.doScanner(strings);
        if (this.verbose) {
            Job.getUserInterface().setProgressNote("Parsing...");
            Job.getUserInterface().setProgressValue(0);
        }
        this.doParser();
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        for (VModule module : this.allModules) {
            if (!module.defined) {
                for (Library lib : Library.getVisibleLibraries()) {
                    Iterator<Cell> it = lib.getCells();
                    while (it.hasNext()) {
                        Cell libCell = it.next();
                        if (!libCell.getName().equals(module.name)) continue;
                        module.cell = libCell.otherView(View.LAYOUT);
                        if (module.cell != null) continue;
                        module.cell = libCell;
                        break;
                    }
                    if (module.cell == null) continue;
                    break;
                }
            }
            for (int i = 0; i < module.wires.size(); ++i) {
                String wire = (String)module.wires.get(i);
                String assignedName = (String)module.assignments.get(wire);
                if (assignedName == null) continue;
                module.wires.remove(i);
                --i;
            }
            for (VInstance in : module.instances) {
                for (VPort lp : in.ports.keySet()) {
                    String[] signalNames = (String[])in.ports.get(lp);
                    for (int i = 0; i < signalNames.length; ++i) {
                        ArrayList<VPort> portsOnNet;
                        String assignedName = (String)module.assignments.get(signalNames[i]);
                        if (assignedName == null) {
                            assignedName = signalNames[i];
                        }
                        if ((portsOnNet = (ArrayList<VPort>)module.allNetworks.get(assignedName)) == null) {
                            portsOnNet = new ArrayList<VPort>();
                            module.allNetworks.put(assignedName, portsOnNet);
                        }
                        portsOnNet.add(lp);
                    }
                }
            }
        }
        if (this.errorLogger != null && !this.hasParentLogger) {
            this.errorLogger.termLogging(true);
        }
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void resetTokenListPointer() {
        this.tokenIndex = 0;
    }

    private TokenList getNextToken() {
        if (this.tokenIndex >= this.tList.size()) {
            return null;
        }
        TokenList token = this.tList.get(this.tokenIndex++);
        return token;
    }

    private TokenList peekNextToken() {
        if (this.tokenIndex >= this.tList.size()) {
            return null;
        }
        return this.tList.get(this.tokenIndex);
    }

    private TokenType getTokenType(TokenList token) {
        if (token == null) {
            return TokenType.UNKNOWN;
        }
        return token.type;
    }

    private TokenList needNextToken(TokenType type) {
        TokenList token = this.getNextToken();
        if (token == null) {
            this.reportErrorMsg(null, "End of file encountered");
            return null;
        }
        if (token.type != type) {
            this.reportErrorMsg(token, "Expecting a " + type.getName());
            this.parseToSemicolon();
            return null;
        }
        return token;
    }

    private void doScanner(String[] strings) {
        String buf = "";
        int bufPos = 0;
        int lineNum = 0;
        boolean space = false;
        block25: while (true) {
            int end;
            if (bufPos >= buf.length()) {
                if (lineNum >= strings.length) {
                    return;
                }
                buf = strings[lineNum++];
                if (this.verbose && lineNum % 100 == 0) {
                    Job.getUserInterface().setProgressValue(lineNum * 100 / strings.length);
                }
                bufPos = 0;
                space = true;
            } else {
                space = Character.isWhitespace(buf.charAt(bufPos));
            }
            while (bufPos < buf.length() && Character.isWhitespace(buf.charAt(bufPos))) {
                ++bufPos;
            }
            if (bufPos >= buf.length()) continue;
            char c = buf.charAt(bufPos);
            if (Character.isLetter(c)) {
                char eChar;
                for (end = bufPos; end < buf.length() && (Character.isLetterOrDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                VKeyword key = VKeyword.findKeyword(buf.substring(bufPos, end));
                if (key != null) {
                    new TokenList(TokenType.KEYWORD, key, lineNum, space);
                } else {
                    String ident = buf.substring(bufPos, end);
                    new TokenList(TokenType.IDENTIFIER, ident, lineNum, space);
                }
                bufPos = end;
                continue;
            }
            if (TextUtils.isDigit(c)) {
                char eChar;
                for (end = bufPos + 1; end < buf.length() && (TextUtils.isDigit(eChar = buf.charAt(end)) || eChar == '_'); ++end) {
                }
                new TokenList(TokenType.DECIMAL, buf.substring(bufPos, end), lineNum, space);
                bufPos = end;
                continue;
            }
            switch (c) {
                case '\\': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n' && !Character.isWhitespace(buf.charAt(end)); ++end) {
                    }
                    String ident = buf.substring(bufPos + 1, end);
                    new TokenList(TokenType.IDENTIFIER, ident, lineNum, space);
                    bufPos = end;
                    continue block25;
                }
                case '/': {
                    if (end < buf.length() && buf.charAt(end) == '/') {
                        for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                        }
                        if (end >= buf.length() || buf.charAt(end) == '\n') {
                            // empty if block
                        }
                        bufPos = ++end;
                        continue block25;
                    }
                    if (end < buf.length() && buf.charAt(end) == '*') {
                        bufPos = end + 1;
                        while (true) {
                            if (bufPos < buf.length() - 1 && buf.charAt(bufPos) == '*' && buf.charAt(bufPos + 1) == '/') {
                                bufPos += 2;
                                continue block25;
                            }
                            if (++bufPos < buf.length() - 1) continue;
                            if (lineNum >= strings.length) {
                                return;
                            }
                            buf = strings[lineNum++];
                            if (this.verbose && lineNum % 100 == 0) {
                                Job.getUserInterface().setProgressValue(lineNum * 100 / strings.length);
                            }
                            bufPos = 0;
                            space = true;
                        }
                    }
                    new TokenList(TokenType.SLASH, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '\"': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                        if (buf.charAt(end) != '\"') continue;
                        if (end + 1 >= buf.length() || buf.charAt(end + 1) != '\"') break;
                        ++end;
                    }
                    String newString = buf.substring(bufPos + 1, end);
                    newString.replaceAll("\"\"", "\"");
                    new TokenList(TokenType.STRING, newString, lineNum, space);
                    if (buf.charAt(end) == '\"') {
                        // empty if block
                    }
                    bufPos = ++end;
                    continue block25;
                }
                case '`': {
                    for (end = bufPos + 1; end < buf.length() && buf.charAt(end) != '\n'; ++end) {
                    }
                    if (end >= buf.length() || buf.charAt(end) == '\n') {
                        // empty if block
                    }
                    bufPos = ++end;
                    continue block25;
                }
                case '\'': {
                    if (bufPos + 2 < buf.length() && buf.charAt(bufPos + 2) == '\'') {
                        new TokenList(TokenType.CHAR, new Character(buf.charAt(bufPos + 1)), lineNum, space);
                        bufPos += 3;
                        continue block25;
                    }
                    if (this.tList.size() > 0 && bufPos < buf.length() - 1) {
                        TokenList prevTL = this.tList.get(this.tList.size() - 1);
                        char nextC = buf.charAt(bufPos + 1);
                        if (prevTL.type == TokenType.DECIMAL && Character.toLowerCase(nextC) == 'b') {
                            char chr;
                            StringBuffer sb = new StringBuffer();
                            bufPos += 2;
                            while (bufPos < buf.length() && ((chr = Character.toLowerCase(buf.charAt(bufPos))) == '0' || chr == '1' || chr == 'x' || chr == 'z')) {
                                sb.append(chr);
                                ++bufPos;
                            }
                            int len = TextUtils.atoi(prevTL.toString());
                            if (sb.length() < len) {
                                int modulo = sb.length();
                                if (modulo == 0) {
                                    this.reportErrorMsg(prevTL, "Zero-length bitstring");
                                    sb.append('0');
                                    modulo = 1;
                                }
                                for (int i = sb.length(); i < len; ++i) {
                                    sb.append(sb.charAt(i % modulo));
                                }
                            }
                            if (len > sb.length()) {
                                sb.delete(len, sb.length());
                            }
                            String bitSequence = sb.toString();
                            this.tList.remove(this.tList.size() - 1);
                            new TokenList(TokenType.BITS, bitSequence, lineNum, space);
                            continue block25;
                        }
                    }
                    new TokenList(TokenType.APOSTROPHE, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '(': {
                    new TokenList(TokenType.LEFTPAREN, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case ')': {
                    new TokenList(TokenType.RIGHTPAREN, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '[': {
                    new TokenList(TokenType.LEFTBRACKET, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case ']': {
                    new TokenList(TokenType.RIGHTBRACKET, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '{': {
                    new TokenList(TokenType.LEFTBRACE, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '}': {
                    new TokenList(TokenType.RIGHTBRACE, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case ',': {
                    new TokenList(TokenType.COMMA, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '?': {
                    new TokenList(TokenType.QUESTION, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '&': {
                    new TokenList(TokenType.AMPERSAND, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '|': {
                    new TokenList(TokenType.VERTICALBAR, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '#': {
                    new TokenList(TokenType.HASH, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '~': {
                    new TokenList(TokenType.TILDE, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '@': {
                    new TokenList(TokenType.ATSIGN, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '=': {
                    new TokenList(TokenType.EQUALS, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '-': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '-') {
                        bufPos = buf.length();
                        continue block25;
                    }
                    new TokenList(TokenType.MINUS, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case '.': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '.') {
                        new TokenList(TokenType.DOUBLEDOT, null, lineNum, space);
                        bufPos += 2;
                        continue block25;
                    }
                    new TokenList(TokenType.PERIOD, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case ':': {
                    if (bufPos + 1 < buf.length() && buf.charAt(bufPos + 1) == '=') {
                        new TokenList(TokenType.VARASSIGN, null, lineNum, space);
                        bufPos += 2;
                        continue block25;
                    }
                    new TokenList(TokenType.COLON, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
                case ';': {
                    new TokenList(TokenType.SEMICOLON, null, lineNum, space);
                    ++bufPos;
                    continue block25;
                }
            }
            new TokenList(TokenType.UNKNOWN, null, lineNum, space);
            ++bufPos;
        }
    }

    private void doParser() {
        TokenList token;
        this.curModule = null;
        this.resetTokenListPointer();
        int tokenCount = 0;
        while ((token = this.getNextToken()) != null) {
            if (this.verbose && ++tokenCount % 100 == 0) {
                Job.getUserInterface().setProgressValue(this.tokenIndex * 100 / this.tList.size());
            }
            if (token.type == TokenType.KEYWORD) {
                VKeyword vk = (VKeyword)token.pointer;
                if (vk == VKeyword.MODULE || vk == VKeyword.PRIMITIVE) {
                    this.curModule = this.parseModule(vk == VKeyword.PRIMITIVE);
                    if (this.curModule != null) continue;
                    this.reportErrorMsg(token, "module not found");
                    continue;
                }
                if (vk == VKeyword.ENDMODULE || vk == VKeyword.ENDPRIMITIVE) {
                    this.curModule = null;
                    continue;
                }
                if (vk == VKeyword.INPUT || vk == VKeyword.OUTPUT || vk == VKeyword.INOUT || vk == VKeyword.WIRE || vk == VKeyword.SUPPLY || vk == VKeyword.SUPPLY0 || vk == VKeyword.SUPPLY1) {
                    this.parseDeclare(token);
                    continue;
                }
                if (vk == VKeyword.TRANIF0 || vk == VKeyword.TRANIF1) {
                    VInstance inst = this.parseGate(token, vk == VKeyword.TRANIF0 ? PrimitiveNode.Function.TRAPMOS : PrimitiveNode.Function.TRANMOS);
                    if (inst == null) continue;
                    this.curModule.instances.add(inst);
                    continue;
                }
                if (vk == VKeyword.ASSIGN) {
                    this.parseAssign();
                    continue;
                }
                if (vk == VKeyword.LOGIC || vk == VKeyword.REAL || vk == VKeyword.REG || vk == VKeyword.ELECTRICAL || vk == VKeyword.PARAMETER) {
                    this.parseToSemicolon();
                    continue;
                }
                if (vk == VKeyword.ANALOG || vk == VKeyword.INITIAL) {
                    this.ignoreNextStatement();
                    continue;
                }
                if (vk == VKeyword.TABLE) {
                    this.ignoreToKeyword(VKeyword.ENDTABLE);
                    continue;
                }
                if (vk == VKeyword.SPECIFY) {
                    this.ignoreToKeyword(VKeyword.ENDSPECIFY);
                    continue;
                }
                if (vk == VKeyword.ALWAYS) {
                    this.ignoreAlwaysStatement();
                    continue;
                }
                if (vk == VKeyword.BEGIN) {
                    this.ignoreToKeyword(VKeyword.END);
                    continue;
                }
                this.reportErrorMsg(token, "Unknown keyword");
                continue;
            }
            if (token.type == TokenType.IDENTIFIER) {
                if (this.curModule == null) {
                    this.reportErrorMsg(token, "Instance declaration is not inside a Module");
                    this.parseToSemicolon();
                    break;
                }
                VInstance inst = this.parseInstance(token);
                if (inst == null) continue;
                this.curModule.instances.add(inst);
                continue;
            }
            this.reportErrorMsg(token, "Expecting an identifier");
            this.parseToSemicolon();
        }
        for (VModule module : this.allModules) {
            for (VInstance in : module.instances) {
                if (in.module == null) continue;
                for (VPort lp : in.ports.keySet()) {
                    boolean found = false;
                    for (VExport subPort : in.module.ports) {
                        if (!subPort.name.equals(lp.portName)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    VExport fp = new VExport(lp.portName);
                    in.module.ports.add(fp);
                }
            }
        }
    }

    private VModule parseModule(boolean primitive) {
        TokenList token = this.needNextToken(TokenType.IDENTIFIER);
        if (token == null) {
            return null;
        }
        String name = (String)token.pointer;
        VModule module = this.findModule(name);
        if (module == null) {
            module = new VModule(name, true, primitive);
        } else {
            if (module.defined) {
                this.reportWarningMsg(token, "Module already defined but redefined with new information");
            }
            module.defined = true;
            module.primitive = primitive;
        }
        token = this.needNextToken(TokenType.LEFTPAREN);
        if (token == null) {
            return null;
        }
        do {
            if ((token = this.needNextToken(TokenType.IDENTIFIER)) == null) {
                return null;
            }
            VExport port = new VExport((String)token.pointer);
            module.ports.add(port);
        } while (this.getTokenType(token = this.getNextToken()) == TokenType.COMMA);
        if (this.getTokenType(token) != TokenType.RIGHTPAREN) {
            this.reportErrorMsg(token, "Expecting a right parenthesis");
            this.parseToSemicolon();
            return null;
        }
        token = this.needNextToken(TokenType.SEMICOLON);
        if (token == null) {
            return null;
        }
        return module;
    }

    private void parseDeclare(TokenList declareToken) {
        if (this.curModule == null) {
            this.reportErrorMsg(declareToken, "Not in a module");
            this.parseToSemicolon();
            return;
        }
        int mode = 1;
        VKeyword vk = (VKeyword)declareToken.pointer;
        if (vk == VKeyword.OUTPUT) {
            mode = 2;
        } else if (vk == VKeyword.INOUT) {
            mode = 3;
        }
        TokenList token = this.getNextToken();
        int firstRange = -1;
        int secondRange = -1;
        if (this.getTokenType(token) == TokenType.LEFTBRACKET) {
            token = this.getNextToken();
            firstRange = TextUtils.atoi((String)token.pointer);
            token = this.needNextToken(TokenType.COLON);
            if (token == null) {
                return;
            }
            token = this.getNextToken();
            secondRange = TextUtils.atoi((String)token.pointer);
            token = this.needNextToken(TokenType.RIGHTBRACKET);
            if (token == null) {
                return;
            }
            token = this.getNextToken();
        }
        while (true) {
            if (this.getTokenType(token) != TokenType.IDENTIFIER) {
                this.reportErrorMsg(token, "Expected identifier");
                this.parseToSemicolon();
                return;
            }
            String idName = (String)token.pointer;
            boolean found = false;
            if (vk == VKeyword.WIRE || vk == VKeyword.SUPPLY || vk == VKeyword.SUPPLY0 || vk == VKeyword.SUPPLY1) {
                if (firstRange != -1 && secondRange != -1) {
                    String realName;
                    if (firstRange > secondRange) {
                        for (int i = firstRange; i >= secondRange; --i) {
                            realName = idName + "[" + i + "]";
                            if (this.curModule.wires.contains(realName)) {
                                this.reportErrorMsg(token, "Identifier " + realName + " defined twice");
                                this.parseToSemicolon();
                                return;
                            }
                            this.curModule.wires.add(realName);
                        }
                    } else {
                        for (int i = firstRange; i <= secondRange; ++i) {
                            realName = idName + "[" + i + "]";
                            if (this.curModule.wires.contains(realName)) {
                                this.reportErrorMsg(token, "Identifier " + realName + " defined twice");
                                this.parseToSemicolon();
                                return;
                            }
                            this.curModule.wires.add(realName);
                        }
                    }
                } else {
                    if (this.curModule.wires.contains(idName)) {
                        this.reportErrorMsg(token, "Identifier defined twice");
                        this.parseToSemicolon();
                        return;
                    }
                    this.curModule.wires.add(idName);
                }
            } else {
                for (VExport fp : this.curModule.ports) {
                    if (!fp.name.equals(idName)) continue;
                    fp.mode = mode;
                    fp.firstIndex = firstRange;
                    fp.secondIndex = secondRange;
                    found = true;
                    break;
                }
                if (!found) {
                    this.reportErrorMsg(token, "Unknown identifier");
                    this.parseToSemicolon();
                    return;
                }
            }
            token = this.getNextToken();
            if (this.getTokenType(token) != TokenType.COMMA) break;
            token = this.getNextToken();
        }
        if (this.getTokenType(token) != TokenType.SEMICOLON) {
            this.reportErrorMsg(token, "Unknown separator between identifiers");
            this.parseToSemicolon();
            return;
        }
    }

    private void parseAssign() {
        int i;
        String[] secondNames;
        String[] firstNames;
        TokenList token = this.getNextToken();
        if (this.getTokenType(token) == TokenType.HASH) {
            token = this.needNextToken(TokenType.DECIMAL);
            token = this.needNextToken(TokenType.IDENTIFIER);
        }
        if (this.getTokenType(token) == TokenType.LEFTBRACE) {
            ArrayList<String> strings = new ArrayList<String>();
            this.parseOpenBrace(strings);
            firstNames = new String[strings.size()];
            for (int i2 = 0; i2 < strings.size(); ++i2) {
                firstNames[i2] = (String)strings.get(i2);
            }
        } else {
            if (this.getTokenType(token) != TokenType.IDENTIFIER && this.getTokenType(token) != TokenType.BITS) {
                return;
            }
            firstNames = this.getSignalNames(token);
        }
        if ((token = this.needNextToken(TokenType.EQUALS)) == null) {
            return;
        }
        token = this.getNextToken();
        if (this.getTokenType(token) == TokenType.TILDE) {
            token = this.getNextToken();
        }
        if (this.getTokenType(token) == TokenType.LEFTPAREN) {
            while (this.getTokenType(token = this.getNextToken()) != TokenType.RIGHTPAREN) {
            }
            token = this.needNextToken(TokenType.SEMICOLON);
            return;
        }
        if (this.getTokenType(token) == TokenType.LEFTBRACE) {
            ArrayList<String> strings = new ArrayList<String>();
            this.parseOpenBrace(strings);
            secondNames = new String[strings.size()];
            for (i = 0; i < strings.size(); ++i) {
                secondNames[i] = (String)strings.get(i);
            }
        } else {
            if (this.getTokenType(token) != TokenType.IDENTIFIER && this.getTokenType(token) != TokenType.BITS) {
                return;
            }
            secondNames = this.getSignalNames(token);
        }
        if ((token = this.needNextToken(TokenType.SEMICOLON)) == null) {
            return;
        }
        if (firstNames.length > secondNames.length) {
            String[] newSecondNames = new String[firstNames.length];
            for (i = 0; i < firstNames.length; ++i) {
                newSecondNames[i] = secondNames[i % secondNames.length];
            }
            secondNames = newSecondNames;
        }
        if (firstNames.length != secondNames.length) {
            this.reportErrorMsg(token, "Assigning unequal length busses (first part is " + firstNames.length + " long, second part is " + secondNames.length + " long)");
            return;
        }
        for (int i3 = 0; i3 < firstNames.length; ++i3) {
            this.curModule.assignments.put(secondNames[i3], firstNames[i3]);
        }
    }

    private void parseOpenBrace(List<String> strings) {
        block10: {
            TokenList token = this.getNextToken();
            if (this.getTokenType(token) == TokenType.DECIMAL) {
                if (this.getRepeatClause(strings, token)) {
                    this.parseToSemicolon();
                }
                return;
            }
            while (true) {
                if (this.getTokenType(token) == TokenType.IDENTIFIER || this.getTokenType(token) == TokenType.BITS) {
                    String[] parts = this.getSignalNames(token);
                    for (int i = 0; i < parts.length; ++i) {
                        strings.add(parts[i]);
                    }
                } else if (this.getTokenType(token) == TokenType.LEFTBRACE) {
                    token = this.needNextToken(TokenType.DECIMAL);
                    if (token == null) {
                        this.parseToSemicolon();
                        return;
                    }
                    if (this.getRepeatClause(strings, token)) {
                        this.parseToSemicolon();
                        return;
                    }
                } else {
                    this.reportErrorMsg(token, "Unknown element in list");
                    this.parseToSemicolon();
                    return;
                }
                if (this.getTokenType(token = this.getNextToken()) != TokenType.COMMA) break;
                token = this.getNextToken();
            }
            if (this.getTokenType(token) == TokenType.RIGHTBRACE) break block10;
            this.reportErrorMsg(token, "Unknown separator in list");
            this.parseToSemicolon();
        }
    }

    private boolean getRepeatClause(List<String> strings, TokenList token) {
        int len = TextUtils.atoi(token.toString());
        token = this.needNextToken(TokenType.LEFTBRACE);
        if (token == null) {
            return true;
        }
        token = this.getNextToken();
        if (this.getTokenType(token) == TokenType.IDENTIFIER || this.getTokenType(token) == TokenType.BITS) {
            String[] parts = this.getSignalNames(token);
            for (int j = 0; j < len; ++j) {
                for (int i = 0; i < parts.length; ++i) {
                    strings.add(parts[i]);
                }
            }
        }
        if ((token = this.needNextToken(TokenType.RIGHTBRACE)) == null) {
            return true;
        }
        token = this.needNextToken(TokenType.RIGHTBRACE);
        return token == null;
    }

    private VInstance parseInstance(TokenList token) {
        String cellName = (String)token.pointer;
        token = this.getNextToken();
        if (this.getTokenType(token) == TokenType.HASH) {
            token = this.getNextToken();
            if (this.getTokenType(token) == TokenType.LEFTPAREN) {
                while (this.getTokenType(token = this.getNextToken()) != TokenType.RIGHTPAREN) {
                }
            }
            token = this.getNextToken();
        }
        if (this.getTokenType(token) != TokenType.IDENTIFIER) {
            this.reportErrorMsg(token, "Expecting an instance name identifier");
            this.parseToSemicolon();
            return null;
        }
        String instanceName = (String)token.pointer;
        token = this.needNextToken(TokenType.LEFTPAREN);
        if (token == null) {
            return null;
        }
        VModule module = this.findModule(cellName);
        if (module == null) {
            module = new VModule(cellName, false, false);
        }
        VInstance inst = new VInstance(module, instanceName);
        int argNum = 1;
        while (this.getTokenType(token = this.getNextToken()) != TokenType.RIGHTPAREN) {
            String[] sigNames;
            String portName = "ARG" + argNum;
            ++argNum;
            if (this.getTokenType(token) == TokenType.PERIOD) {
                token = this.needNextToken(TokenType.IDENTIFIER);
                if (token == null) {
                    return null;
                }
                portName = (String)token.pointer;
                token = this.needNextToken(TokenType.LEFTPAREN);
                if (token == null) {
                    return null;
                }
                token = this.getNextToken();
                if (this.getTokenType(token) == TokenType.LEFTBRACE) {
                    ArrayList<String> signalNames = new ArrayList<String>();
                    this.parseOpenBrace(signalNames);
                    String[] sigNames2 = new String[signalNames.size()];
                    for (int i = 0; i < signalNames.size(); ++i) {
                        sigNames2[i] = (String)signalNames.get(i);
                    }
                    inst.addConnection(new VPort(inst, portName, true), sigNames2);
                } else {
                    if (this.getTokenType(token) != TokenType.IDENTIFIER && this.getTokenType(token) != TokenType.BITS) {
                        this.reportErrorMsg(token, "Expecting an identifier");
                        this.parseToSemicolon();
                        return null;
                    }
                    sigNames = this.getSignalNames(token);
                    inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
                }
                token = this.needNextToken(TokenType.RIGHTPAREN);
                if (token == null) {
                    return null;
                }
            } else if (this.getTokenType(token) == TokenType.IDENTIFIER) {
                sigNames = this.getSignalNames(token);
                inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
            } else {
                this.reportErrorMsg(token, "Unknown separator between identifiers");
                this.parseToSemicolon();
                return null;
            }
            if (this.getTokenType(token = this.getNextToken()) == TokenType.RIGHTPAREN) break;
            if (this.getTokenType(token) == TokenType.COMMA) continue;
            this.reportErrorMsg(token, "Expecting a comma");
            this.parseToSemicolon();
            return null;
        }
        token = this.needNextToken(TokenType.SEMICOLON);
        if (token == null) {
            return null;
        }
        return inst;
    }

    private VInstance parseGate(TokenList declareToken, PrimitiveNode.Function fun) {
        if (this.curModule == null) {
            this.reportErrorMsg(declareToken, "Not in a module");
            this.parseToSemicolon();
            return null;
        }
        TokenList token = this.needNextToken(TokenType.IDENTIFIER);
        if (token == null) {
            return null;
        }
        String instanceName = (String)token.pointer;
        token = this.needNextToken(TokenType.LEFTPAREN);
        if (token == null) {
            return null;
        }
        VInstance inst = new VInstance(fun, instanceName);
        int argNum = 1;
        while (this.getTokenType(token = this.getNextToken()) != TokenType.RIGHTPAREN) {
            String portName = null;
            switch (argNum++) {
                case 1: {
                    portName = "s";
                    break;
                }
                case 2: {
                    portName = "d";
                    break;
                }
                case 3: {
                    portName = "g";
                }
            }
            if (this.getTokenType(token) != TokenType.IDENTIFIER) {
                this.reportErrorMsg(token, "Unknown separator between identifiers");
                this.parseToSemicolon();
                return null;
            }
            String[] sigNames = this.getSignalNames(token);
            inst.addConnection(new VPort(inst, portName, sigNames.length > 1), sigNames);
            token = this.getNextToken();
            if (this.getTokenType(token) == TokenType.RIGHTPAREN) break;
            if (this.getTokenType(token) == TokenType.COMMA) continue;
            this.reportErrorMsg(token, "Expecting a comma");
            this.parseToSemicolon();
            return null;
        }
        token = this.needNextToken(TokenType.SEMICOLON);
        if (token == null) {
            return null;
        }
        return inst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] getSignalNames(TokenList token) {
        int i;
        ArrayList<String> signalNames = new ArrayList<String>();
        if (this.getTokenType(token) == TokenType.BITS) {
            String bitString2 = token.toString();
            for (i = 0; i < bitString2.length(); ++i) {
                if (bitString2.charAt(i) == '0') {
                    signalNames.add("gnd");
                    continue;
                }
                if (bitString2.charAt(i) == '1') {
                    signalNames.add("vdd");
                    continue;
                }
                signalNames.add(bitString2.charAt(i) + "");
            }
        } else if (this.getTokenType(token) == TokenType.IDENTIFIER) {
            String signalName = (String)token.pointer;
            TokenList next2 = this.peekNextToken();
            if (this.getTokenType(next2) == TokenType.LEFTBRACKET) {
                this.getNextToken();
                TokenList index = this.needNextToken(TokenType.DECIMAL);
                if (index == null) {
                    return new String[0];
                }
                TokenList nxt = this.getNextToken();
                if (this.getTokenType(nxt) == TokenType.COLON) {
                    int i2;
                    int endIndex;
                    TokenList index2 = this.needNextToken(TokenType.DECIMAL);
                    if (index2 == null) {
                        return new String[0];
                    }
                    TokenList cls = this.needNextToken(TokenType.RIGHTBRACKET);
                    if (cls == null) {
                        return new String[0];
                    }
                    int startIndex = TextUtils.atoi((String)index.pointer);
                    if (startIndex < (endIndex = TextUtils.atoi((String)index2.pointer))) {
                        for (i2 = startIndex; i2 <= endIndex; ++i2) {
                            signalNames.add(signalName + "[" + i2 + "]");
                        }
                    } else {
                        for (i2 = startIndex; i2 >= endIndex; --i2) {
                            signalNames.add(signalName + "[" + i2 + "]");
                        }
                    }
                } else {
                    if (this.getTokenType(nxt) != TokenType.RIGHTBRACKET) return new String[0];
                    signalNames.add(signalName + "[" + (String)index.pointer + "]");
                }
            } else {
                boolean foundBus = false;
                for (String wire : this.curModule.wires) {
                    if (!wire.startsWith(signalName) || wire.length() <= signalName.length() || wire.charAt(signalName.length()) != '[') continue;
                    signalNames.add(wire);
                    foundBus = true;
                }
                if (!foundBus) {
                    for (VExport fp : this.curModule.ports) {
                        int i3;
                        if (!fp.name.equals(signalName)) continue;
                        if (fp.firstIndex < fp.secondIndex) {
                            foundBus = true;
                            for (i3 = fp.firstIndex; i3 <= fp.secondIndex; ++i3) {
                                signalNames.add(signalName + "[" + i3 + "]");
                            }
                            continue;
                        }
                        if (fp.firstIndex <= fp.secondIndex) continue;
                        foundBus = true;
                        for (i3 = fp.firstIndex; i3 >= fp.secondIndex; --i3) {
                            signalNames.add(signalName + "[" + i3 + "]");
                        }
                    }
                }
                if (!foundBus) {
                    signalNames.add(signalName);
                }
            }
        }
        String[] sigNames = new String[signalNames.size()];
        for (i = 0; i < signalNames.size(); ++i) {
            sigNames[i] = (String)signalNames.get(i);
        }
        return sigNames;
    }

    private VModule findModule(String name) {
        for (VModule mod : this.allModules) {
            if (!mod.name.equals(name)) continue;
            return mod;
        }
        return null;
    }

    private void ignoreAlwaysStatement() {
        TokenList token = this.needNextToken(TokenType.ATSIGN);
        if (token == null) {
            return;
        }
        this.ignoreParentheticalClause();
        this.ignoreNextStatement();
    }

    private void ignoreIfStatement() {
        this.ignoreParentheticalClause();
        this.ignoreNextStatement();
        TokenList token = this.peekNextToken();
        if (token.type == TokenType.KEYWORD && (VKeyword)token.pointer == VKeyword.ELSE) {
            this.getNextToken();
            this.ignoreNextStatement();
        }
    }

    private void parseToSemicolon() {
        TokenList token;
        while ((token = this.getNextToken()) != null && token.type != TokenType.SEMICOLON) {
        }
    }

    private void ignoreNextStatement() {
        TokenList token;
        while ((token = this.getNextToken()).type != TokenType.SEMICOLON) {
            if (token.type != TokenType.KEYWORD) continue;
            VKeyword vk = (VKeyword)token.pointer;
            if (vk == VKeyword.BEGIN) {
                this.ignoreUntilEndOfStatement(VKeyword.END, 0);
                break;
            }
            if (vk != VKeyword.IF) continue;
            this.ignoreIfStatement();
            break;
        }
    }

    private void ignoreParentheticalClause() {
        int numParens = 0;
        while (true) {
            TokenList token;
            if ((token = this.getNextToken()).type == TokenType.LEFTPAREN) {
                ++numParens;
                continue;
            }
            if (token.type == TokenType.RIGHTPAREN && --numParens <= 0) break;
        }
    }

    private void ignoreToKeyword(VKeyword keyword) {
        this.ignoreUntilEndOfStatement(keyword, 0);
    }

    private void ignoreUntilEndOfStatement(VKeyword keyword, int nestedLoop) {
        while (true) {
            TokenList token;
            if ((token = this.getNextToken()) == null) {
                return;
            }
            if (token.type != TokenType.KEYWORD) continue;
            VKeyword vk = (VKeyword)token.pointer;
            if (vk == VKeyword.BEGIN) {
                this.ignoreUntilEndOfStatement(VKeyword.END, nestedLoop + 1);
                continue;
            }
            if (vk == keyword && nestedLoop == 0) break;
        }
    }

    private void reportWarningMsg(TokenList tList, String warnMsg) {
        if (tList == null) {
            String msg = "WARNING " + warnMsg;
            if (this.verbose) {
                System.out.println(msg);
            } else {
                if (this.errorLogger == null) {
                    this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
                }
                this.errorLogger.logError(msg, 0);
            }
            return;
        }
        String msg = "WARNING on line " + tList.lineNum + ", " + warnMsg + ":";
        StringBuffer buffer = new StringBuffer();
        int pointer = tList.makeMessageLine(buffer);
        if (this.verbose) {
            System.out.println(msg);
            System.out.println(buffer.toString());
            buffer = new StringBuffer();
            for (int i = 0; i < pointer; ++i) {
                buffer.append(" ");
            }
            System.out.println(buffer.toString() + "^");
        } else {
            if (this.errorLogger == null) {
                this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
            }
            this.errorLogger.logWarning(msg + " " + buffer.toString(), null, 0);
        }
    }

    private void reportErrorMsg(TokenList tList, String errMsg) {
        String msg;
        this.hasErrors = true;
        ++this.errorCount;
        if (this.errorCount == 30) {
            msg = "TOO MANY ERRORS...LISTING NO MORE";
            if (this.verbose) {
                System.out.println(msg);
            } else {
                if (this.errorLogger == null) {
                    this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
                }
                this.errorLogger.logError(msg, 0);
            }
        }
        if (this.errorCount >= 30) {
            return;
        }
        if (tList == null) {
            msg = "ERROR " + errMsg;
            if (this.verbose) {
                System.out.println(msg);
            } else {
                if (this.errorLogger == null) {
                    this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
                }
                this.errorLogger.logError(msg, 0);
            }
            return;
        }
        msg = "ERROR on line " + tList.lineNum + ", " + errMsg + ":";
        StringBuffer buffer = new StringBuffer();
        int pointer = tList.makeMessageLine(buffer);
        if (this.verbose) {
            System.out.println(msg);
            System.out.println(buffer.toString());
            buffer = new StringBuffer();
            for (int i = 0; i < pointer; ++i) {
                buffer.append(" ");
            }
            System.out.println(buffer.toString() + "^");
        } else {
            if (this.errorLogger == null) {
                this.errorLogger = ErrorLogger.newInstance("Compile Verilog");
            }
            this.errorLogger.logError(msg + " " + buffer.toString(), 0);
        }
    }

    public Cell genCell(Library destLib, boolean schematic, EditingPreferences ep, IconParameters ip) {
        if (this.hasErrors()) {
            return null;
        }
        HashMap<NodeProto, Map<PortProto, Point2D>> portLocMap = new HashMap<NodeProto, Map<PortProto, Point2D>>();
        if (this.verbose) {
            Job.getUserInterface().startProgressDialog("Building Rats-Nest Cells", null);
        }
        ArrayList<VModule> secondPass = new ArrayList<VModule>();
        for (VModule mod : this.allModules) {
            if (!mod.isDefined() && mod.cell == null) {
                System.out.println("Creating dummy cell for module " + mod.name);
                mod.cell = Cell.makeInstance(ep, destLib, mod.name + "{ic}");
                double YSPACING = 4.0;
                double yPos = YSPACING / 2.0;
                for (VExport port : mod.ports) {
                    String portName = port.getName();
                    if (port.isBus()) {
                        portName = portName + "[" + port.firstIndex + ":" + port.secondIndex + "]";
                    }
                    PrimitiveNode pnp = Generic.tech().universalPinNode;
                    double width = pnp.getDefaultLambdaBaseWidth(ep);
                    double height = pnp.getDefaultLambdaBaseHeight(ep);
                    Point2D.Double center = new Point2D.Double(-YSPACING, yPos);
                    yPos += YSPACING;
                    NodeInst ni = NodeInst.makeInstance(pnp, ep, center, width, height, mod.cell);
                    PortCharacteristic characteristic = PortCharacteristic.UNKNOWN;
                    switch (port.mode) {
                        case 1: {
                            characteristic = PortCharacteristic.IN;
                            break;
                        }
                        case 2: {
                            characteristic = PortCharacteristic.OUT;
                            break;
                        }
                        case 3: {
                            characteristic = PortCharacteristic.BIDIR;
                        }
                    }
                    Export e = Export.newInstance(mod.cell, ni.getOnlyPortInst(), portName, ep, characteristic);
                    TextDescriptor td = e.getTextDescriptor(Export.EXPORT_NAME).withPos(AbstractTextDescriptor.Position.LEFT);
                    e.setTextDescriptor(Export.EXPORT_NAME, td);
                }
                double ySize = yPos - YSPACING / 2.0;
                double xSize = YSPACING * 2.0;
                NodeInst bbNi = NodeInst.newInstance(Artwork.tech().openedThickerPolygonNode, ep, new Point2D.Double(0.0, ySize / 2.0), xSize, ySize, mod.cell);
                if (bbNi == null) {
                    return null;
                }
                EPoint[] boxOutline = new EPoint[]{EPoint.fromLambda(-xSize / 2.0, 0.0), EPoint.fromLambda(-xSize / 2.0, ySize), EPoint.fromLambda(xSize / 2.0, ySize), EPoint.fromLambda(xSize / 2.0, 0.0), EPoint.fromLambda(-xSize / 2.0, 0.0)};
                bbNi.setTrace(boxOutline);
                TextDescriptor td = ep.getAnnotationTextDescriptor().withRelSize(ep.getIconGenBodyTextSize());
                bbNi.newVar(Schematics.SCHEM_FUNCTION, (Object)mod.getName(), td);
                continue;
            }
            secondPass.add(mod);
        }
        Cell cell = null;
        for (VModule mod : secondPass) {
            PortInst pi;
            String cellName = mod.name + (schematic ? "{sch}" : "{lay}");
            System.out.println("Creating cell " + cellName);
            if (this.verbose) {
                Job.getUserInterface().setProgressNote("Creating Nodes in Cell " + cellName);
                Job.getUserInterface().setProgressValue(0);
            }
            if ((cell = Cell.makeInstance(ep, destLib, cellName)) == null) {
                if (this.verbose) {
                    Job.getUserInterface().stopProgressDialog();
                }
                return null;
            }
            double GAP = 15.0;
            double x = 0.0;
            double y = 0.0;
            double highest = 0.0;
            double totalSize = 0.0;
            for (VInstance in : mod.instances) {
                double height;
                double width;
                if (in.module == null) {
                    PrimitiveNode tranNP = Schematics.tech().transistorNode;
                    width = tranNP.getDefWidth(ep);
                    height = tranNP.getDefHeight(ep);
                    totalSize += (width + GAP) * (height + GAP);
                    continue;
                }
                Cell subCell = in.module.cell;
                if (subCell == null) continue;
                width = subCell.getDefWidth();
                height = subCell.getDefHeight();
                totalSize += (width + GAP) * (height + GAP);
            }
            double cellSize = Math.sqrt(totalSize);
            HashMap<VInstance, NodeInst> placed = new HashMap<VInstance, NodeInst>();
            int instancesPlaced = 0;
            for (VInstance in : mod.instances) {
                Comparable<PrimitiveNode> np;
                NodeInst ni = null;
                double width = 0.0;
                double height = 0.0;
                if (in.module != null) {
                    np = in.module.cell;
                    if (np != null) {
                        width = np.getDefWidth(ep);
                        height = np.getDefHeight(ep);
                        ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x, y), width, height, cell, Orientation.IDENT, in.instanceName);
                    }
                } else {
                    np = Schematics.tech().transistorNode;
                    width = np.getDefWidth(ep);
                    height = np.getDefHeight(ep);
                    ni = NodeInst.makeInstance(np, ep, (Point2D)EPoint.fromLambda(x, y), width, height, cell, Orientation.R, in.instanceName, in.fun);
                }
                if (ni == null) continue;
                placed.put(in, ni);
                HashMap<PortProto, Point2D.Double> portMap = (HashMap<PortProto, Point2D.Double>)portLocMap.get(np);
                if (portMap == null) {
                    portMap = new HashMap<PortProto, Point2D.Double>();
                    portLocMap.put((NodeProto)((Object)np), (Map<PortProto, Point2D>)portMap);
                    Iterator<PortInst> it = ni.getPortInsts();
                    while (it.hasNext()) {
                        PortInst pi2 = it.next();
                        PortProto pp = pi2.getPortProto();
                        EPoint ept = pi2.getCenter();
                        Point2D.Double pt = new Point2D.Double(ept.getX() - ni.getAnchorCenterX(), ept.getY() - ni.getAnchorCenterY());
                        portMap.put(pp, pt);
                    }
                }
                if (this.verbose && ++instancesPlaced % 100 == 0) {
                    Job.getUserInterface().setProgressValue(instancesPlaced * 100 / mod.instances.size());
                }
                x += width + GAP;
                highest = Math.max(highest, height);
                if (!(x >= cellSize)) continue;
                x = 0.0;
                y += highest + GAP;
                highest = 0.0;
            }
            if (instancesPlaced > 0) {
                System.out.println("Placed " + instancesPlaced + " instances");
            }
            Netlist nl = cell.getNetlist();
            HashSet<VInstance> notFound = new HashSet<VInstance>();
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                HashSet<Network> used = new HashSet<Network>();
                for (int i = 0; i < ports.size(); ++i) {
                    VPort lp = (VPort)ports.get(i);
                    NodeInst ni = (NodeInst)placed.get(lp.in);
                    if (ni == null) {
                        this.hasErrors = true;
                        notFound.add(lp.in);
                        continue;
                    }
                    PortInst pi3 = this.findPortOnNode(ni, lp.portName);
                    if (pi3 == null) {
                        return null;
                    }
                    if (this.getPortWidth(pi3, nl) > 1) continue;
                    Network net = nl.getNetwork(pi3);
                    if (used.contains(net)) {
                        ports.remove(i);
                        --i;
                        continue;
                    }
                    used.add(net);
                }
            }
            for (VInstance in : notFound) {
                System.out.println("ERROR: Cannot find instance " + in.instanceName + " of module " + in.module.name);
            }
            if (this.verbose) {
                Job.getUserInterface().setProgressNote("Creating Arcs in Cell " + cellName);
                Job.getUserInterface().setProgressValue(0);
            }
            int total = 0;
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                for (int i = 1; i < ports.size(); ++i) {
                    ++total;
                }
            }
            for (VInstance in : mod.instances) {
                if (in.module == null) continue;
                for (VPort lp : in.ports.keySet()) {
                    String name;
                    ArcProto ap;
                    PrimitiveNode np;
                    NodeInst ni;
                    String[] signals = (String[])in.ports.get(lp);
                    if (signals.length == 1) continue;
                    boolean allScalar = true;
                    for (int i = 0; i < signals.length; ++i) {
                        if (signals[i].indexOf(91) < 0) continue;
                        allScalar = false;
                        break;
                    }
                    if (allScalar || (ni = (NodeInst)placed.get(in)) == null) continue;
                    PortProto pp = null;
                    Iterator<PortProto> it = ni.getProto().getPorts();
                    while (it.hasNext()) {
                        PortProto ppTry = it.next();
                        String tryName = ppTry.getName();
                        if (tryName.equals(lp.portName)) {
                            pp = ppTry;
                            break;
                        }
                        if (!tryName.startsWith(lp.portName) || tryName.length() <= lp.portName.length() || tryName.charAt(lp.portName.length()) != '[') continue;
                        pp = ppTry;
                        break;
                    }
                    if (pp == null) {
                        System.out.println("Cannot find port " + lp.portName + " on cell " + ni.getProto().describe(false));
                        continue;
                    }
                    if (pp == null) continue;
                    pi = ni.findPortInstFromEquivalentProto(pp);
                    EPoint piLoc = pi.getCenter();
                    double dX = 0.0;
                    double dY = 0.0;
                    double leftDist = Math.abs(piLoc.getX() - ni.getBounds().getMinX());
                    double rightDist = Math.abs(piLoc.getX() - ni.getBounds().getMaxX());
                    double downDist = Math.abs(piLoc.getY() - ni.getBounds().getMinY());
                    double upDist = Math.abs(piLoc.getY() - ni.getBounds().getMaxY());
                    double minDist = Math.min(Math.min(leftDist, rightDist), Math.min(upDist, downDist));
                    if (minDist == leftDist) {
                        dX = -5.0;
                    } else if (minDist == rightDist) {
                        dX = 5.0;
                    } else {
                        dY = minDist == upDist ? 5.0 : -5.0;
                    }
                    EPoint busPinLoc = EPoint.fromLambda(piLoc.getX() + dX, piLoc.getY() + dY);
                    if (signals.length == 1) {
                        np = Schematics.tech().wirePinNode;
                        ap = Schematics.tech().wire_arc;
                        if (!pi.getPortProto().getBasePort().connectsTo(ap)) {
                            ap = pi.getPortProto().getBasePort().getConnections()[0];
                            np = ap.findPinProto();
                        }
                        name = signals[0];
                    } else {
                        np = Schematics.tech().busPinNode;
                        ap = Schematics.tech().bus_arc;
                        name = this.makeBusName(signals);
                    }
                    NodeInst stubPin = NodeInst.makeInstance(np, ep, busPinLoc, np.getDefWidth(ep), np.getDefHeight(ep), cell);
                    ArcInst.makeInstance(ap, ep, pi, stubPin.getOnlyPortInst(), piLoc, busPinLoc, name);
                }
            }
            int count2 = 0;
            HashMap<String, PortInst> portMap = new HashMap<String, PortInst>();
            for (String netName : mod.allNetworks.keySet()) {
                List ports = (List)mod.allNetworks.get(netName);
                ArrayList<VPort> scalarPorts = new ArrayList<VPort>();
                for (VPort lp : ports) {
                    if (lp.onBus) continue;
                    scalarPorts.add(lp);
                }
                if (scalarPorts.size() == 1) {
                    VPort port = (VPort)scalarPorts.get(0);
                    NodeInst ni = (NodeInst)placed.get(port.in);
                    if (ni == null) continue;
                    pi = this.findPortOnNode(ni, port.portName);
                    if (pi != null) {
                        portMap.put(netName, pi);
                    }
                }
                if (scalarPorts.size() == 1) {
                    boolean exported = false;
                    block36: for (VExport e : mod.ports) {
                        if (e.firstIndex == e.secondIndex) {
                            if (!netName.equals(e.getName())) continue;
                            exported = true;
                            break;
                        }
                        for (int i = Math.min(e.firstIndex, e.secondIndex); i <= Math.max(e.firstIndex, e.secondIndex); ++i) {
                            if (!netName.equals(e.getName() + "[" + i + "]")) continue;
                            exported = true;
                            continue block36;
                        }
                    }
                    if (exported) {
                        PrimitiveNode np = Schematics.tech().wirePinNode;
                        ArcProto ap = Schematics.tech().wire_arc;
                        String name = netName;
                        VPort vPort = (VPort)scalarPorts.get(0);
                        NodeInst ni = (NodeInst)placed.get(vPort.in);
                        PortInst pi4 = this.findPortOnNode(ni, vPort.portName);
                        EPoint portLoc = pi4.getCenter();
                        Point2D.Double pinLoc = new Point2D.Double(portLoc.getX() - 5.0, portLoc.getY());
                        NodeInst stubPin = NodeInst.makeInstance(np, ep, pinLoc, np.getDefWidth(ep), np.getDefHeight(ep), cell);
                        ArcInst.makeInstance(ap, ep, pi4, stubPin.getOnlyPortInst(), portLoc, pinLoc, name);
                    }
                }
                for (int i = 1; i < scalarPorts.size(); ++i) {
                    ArcInst ai;
                    VPort fromPort = (VPort)scalarPorts.get(i - 1);
                    VPort toPort = (VPort)scalarPorts.get(i);
                    NodeInst fromNi = (NodeInst)placed.get(fromPort.in);
                    NodeInst toNi = (NodeInst)placed.get(toPort.in);
                    if (fromNi == null || toNi == null) continue;
                    PortInst fromPi = this.findPortOnNode(fromNi, fromPort.portName);
                    if (fromPi == null) {
                        return null;
                    }
                    PortInst toPi = this.findPortOnNode(toNi, toPort.portName);
                    if (toPi == null) {
                        return null;
                    }
                    portMap.put(netName, fromPi);
                    portMap.put(netName, toPi);
                    EPoint fromCtr = this.getPortCenter(fromPi, portLocMap);
                    EPoint toCtr = this.getPortCenter(toPi, portLocMap);
                    ArcProto ap = Generic.tech().unrouted_arc;
                    if (schematic && fromPi.getPortProto().getBasePort().connectsTo(Schematics.tech().wire_arc) && toPi.getPortProto().getBasePort().connectsTo(Schematics.tech().wire_arc)) {
                        ap = Schematics.tech().wire_arc;
                    }
                    if ((ai = ArcInst.makeInstance(ap, ep, fromPi, toPi, fromCtr, toCtr, netName)) != null && schematic) {
                        ai.setFixedAngle(false);
                    }
                    if (!this.verbose || ++count2 % 100 != 0) continue;
                    Job.getUserInterface().setProgressValue(count2 * 100 / total);
                }
            }
            HashMap<String, PortInst> allExports = new HashMap<String, PortInst>();
            for (VExport port : mod.ports) {
                PortInst pi5;
                PortCharacteristic pc = null;
                switch (port.mode) {
                    case 0: {
                        pc = PortCharacteristic.UNKNOWN;
                        break;
                    }
                    case 1: {
                        pc = PortCharacteristic.IN;
                        break;
                    }
                    case 2: {
                        pc = PortCharacteristic.OUT;
                        break;
                    }
                    case 3: {
                        pc = PortCharacteristic.BIDIR;
                    }
                }
                String portName = port.name;
                if (port.firstIndex != port.secondIndex) {
                    if (schematic) {
                        portName = portName + "[" + port.firstIndex + ":" + port.secondIndex + "]";
                    } else {
                        int low = Math.min(port.firstIndex, port.secondIndex);
                        int high = Math.max(port.firstIndex, port.secondIndex);
                        for (int i = low; i <= high; ++i) {
                            String thisPortName = portName + "[" + i + "]";
                            PortInst pi6 = (PortInst)portMap.get(thisPortName);
                            if (pi6 == null) {
                                VPort lp;
                                NodeInst ni;
                                List ports = (List)mod.allNetworks.get(thisPortName);
                                if (ports != null && ports.size() > 0 && (ni = (NodeInst)placed.get((lp = (VPort)ports.get(0)).in)) != null) {
                                    pi6 = ni.findPortInst(lp.portName);
                                }
                                if (pi6 == null) {
                                    PrimitiveNode np = Generic.tech().universalPinNode;
                                    ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x, y), np.getDefWidth(ep), np.getDefHeight(ep), cell);
                                    pi6 = ni.getOnlyPortInst();
                                    x += np.getDefWidth(ep) * 5.0 + GAP;
                                    highest = Math.max(highest, np.getDefHeight(ep) * 5.0);
                                    if (x >= cellSize) {
                                        x = 0.0;
                                        y += highest + GAP;
                                        highest = 0.0;
                                    }
                                }
                            }
                            Export.newInstance(cell, pi6, thisPortName, ep, pc);
                            allExports.put(thisPortName, pi6);
                        }
                        continue;
                    }
                }
                if ((pi5 = (PortInst)portMap.get(portName)) == null) {
                    NodeInst ni;
                    List ports = (List)mod.allNetworks.get(portName);
                    if (ports != null) {
                        VPort lp = (VPort)ports.get(0);
                        ni = (NodeInst)placed.get(lp.in);
                        if (lp != null && ni != null) {
                            pi5 = ni.findPortInst(lp.portName);
                        }
                    }
                    if (pi5 == null) {
                        PrimitiveNode np = Generic.tech().universalPinNode;
                        ni = NodeInst.makeInstance(np, ep, EPoint.fromLambda(x, y), np.getDefWidth(ep), np.getDefHeight(ep), cell);
                        pi5 = ni.getOnlyPortInst();
                        x += np.getDefWidth(ep) * 5.0 + GAP;
                        highest = Math.max(highest, np.getDefHeight(ep) * 5.0);
                        if (x >= cellSize) {
                            x = 0.0;
                            y += highest + GAP;
                            highest = 0.0;
                        }
                    }
                }
                Export.newInstance(cell, pi5, portName, ep, pc);
                allExports.put(portName, pi5);
            }
            for (String name2 : mod.assignments.keySet()) {
                String name1;
                PortInst pi1;
                PortInst pi2 = (PortInst)allExports.get(name2);
                if (pi2 == null || (pi1 = (PortInst)allExports.get(name1 = (String)mod.assignments.get(name2))) == null) continue;
                ArcProto ap = Generic.tech().unrouted_arc;
                ArcInst.makeInstance(ap, ep, pi1, pi2);
            }
            if (schematic) {
                try {
                    Cell iconCell = ip.makeIconForCell(cell, ep);
                    int exampleLocation = ep.getIconGenInstanceLocation();
                    if (exampleLocation != 4) {
                        Point2D.Double iconPos = new Point2D.Double(0.0, 0.0);
                        ERectangle cellBounds = cell.getBounds();
                        ERectangle iconBounds = iconCell.getBounds();
                        double halfWidth = ((RectangularShape)iconBounds).getWidth() / 2.0;
                        double halfHeight = ((RectangularShape)iconBounds).getHeight() / 2.0;
                        switch (exampleLocation) {
                            case 0: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                                break;
                            }
                            case 1: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMinX() - halfWidth, ((RectangularShape)cellBounds).getMaxY() + halfHeight);
                                break;
                            }
                            case 2: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMaxX() + halfWidth, ((RectangularShape)cellBounds).getMinY() - halfHeight);
                                break;
                            }
                            case 3: {
                                ((Point2D)iconPos).setLocation(((RectangularShape)cellBounds).getMinX() - halfWidth, ((RectangularShape)cellBounds).getMinY() - halfHeight);
                            }
                        }
                        DBMath.gridAlign(iconPos, ep.getAlignmentToGrid());
                        double px = iconCell.getBounds().getWidth();
                        double py = iconCell.getBounds().getHeight();
                        NodeInst.makeInstance(iconCell, ep, iconPos, px, py, cell);
                    }
                }
                catch (JobException e) {
                    // empty catch block
                }
            }
            if (count2 > 0) {
                System.out.println("Created " + count2 + " wires");
            }
            if (!this.verbose) continue;
            Job.getUserInterface().stopProgressDialog();
        }
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        return cell;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String makeBusName(String[] signals) {
        String prefix;
        int lastIndex;
        int startIndex;
        boolean breakBus;
        block17: {
            breakBus = false;
            startIndex = 0;
            lastIndex = 0;
            int dir = 0;
            int braPos = signals[0].indexOf(91);
            prefix = null;
            if (braPos < 0) break block17;
            prefix = signals[0].substring(0, braPos);
            for (int i = 0; i < signals.length; ++i) {
                int ind;
                block16: {
                    block18: {
                        braPos = signals[i].indexOf(91);
                        if (braPos < 0) {
                            breakBus = true;
                            break;
                        }
                        String pre = signals[i].substring(0, braPos);
                        if (!pre.equals(prefix)) {
                            breakBus = true;
                            break;
                        }
                        int cloPos = signals[i].indexOf(93, braPos);
                        if (cloPos < 0) {
                            breakBus = true;
                            break;
                        }
                        String index = signals[i].substring(braPos + 1, cloPos);
                        if (!TextUtils.isANumber(index)) {
                            breakBus = true;
                            break;
                        }
                        ind = TextUtils.atoi(index);
                        if (cloPos + 1 != signals[i].length()) {
                            breakBus = true;
                            break;
                        }
                        if (i == 0) {
                            startIndex = ind;
                            continue;
                        }
                        if (i != 1) break block18;
                        if (ind == startIndex + 1) {
                            dir = 1;
                            break block16;
                        } else if (ind == startIndex - 1) {
                            dir = -1;
                            break block16;
                        } else {
                            breakBus = true;
                            break;
                        }
                    }
                    if (ind != lastIndex + dir) {
                        breakBus = true;
                        break;
                    }
                }
                lastIndex = ind;
            }
        }
        if (!breakBus) {
            return prefix + "[" + startIndex + ":" + lastIndex + "]";
        }
        String name = "";
        int i = 0;
        while (i < signals.length) {
            if (i > 0) {
                name = name + ",";
            }
            name = name + signals[i];
            ++i;
        }
        return name;
    }

    private int getPortWidth(PortInst pi, Netlist nl) {
        int busWidth = 1;
        if (pi.getNodeInst().isCellInstance()) {
            busWidth = nl.getBusWidth((Export)pi.getPortProto());
        }
        return busWidth;
    }

    private PortInst findPortOnNode(NodeInst ni, String portName) {
        PortInst pi = ni.findPortInst(portName);
        if (pi != null) {
            return pi;
        }
        String desiredName = portName;
        int bracketPos = desiredName.indexOf(91);
        if (bracketPos >= 0) {
            desiredName = desiredName.substring(0, bracketPos);
        }
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pInst = it.next();
            String pName = pInst.getPortProto().getName();
            bracketPos = pName.indexOf(91);
            if (bracketPos >= 0) {
                pName = pName.substring(0, bracketPos);
            }
            if (!pName.equals(desiredName)) continue;
            if (pi != null) {
                pi = null;
                break;
            }
            pi = pInst;
        }
        if (pi != null) {
            return pi;
        }
        this.hasErrors = true;
        System.out.println("Cannot find port " + portName + " on node " + ni.describe(false));
        System.out.println("Check errors reported.");
        if (this.verbose) {
            Job.getUserInterface().stopProgressDialog();
        }
        return null;
    }

    private EPoint getPortCenter(PortInst pi, Map<NodeProto, Map<PortProto, Point2D>> portLocMap) {
        NodeInst ni = pi.getNodeInst();
        Map<PortProto, Point2D> portMap = portLocMap.get(ni.getProto());
        Point2D pt = portMap.get(pi.getPortProto());
        return EPoint.fromLambda(pt.getX() + ni.getAnchorCenterX(), pt.getY() + ni.getAnchorCenterY());
    }

    public List<String> getALSNetlist(Library destLib) {
        if (this.hasErrors) {
            return null;
        }
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("#*************************************************");
        netlist.add("#  ALS Netlist file");
        netlist.add("#");
        if (User.isIncludeDateAndVersionInOutput()) {
            netlist.add("#  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("#*************************************************");
        netlist.add("");
        for (VModule mod : this.allModules) {
            if (!mod.defined) continue;
            this.genALSInterface(mod, netlist);
        }
        netlist.add("#********* End of netlist *******************");
        return netlist;
    }

    private void genALSInterface(VModule module, List<String> netlist) {
        String modLine = "model " + module.name + "(";
        boolean first = true;
        for (VExport fp : module.ports) {
            for (int i = fp.firstIndex; i <= fp.secondIndex; ++i) {
                if (!first) {
                    modLine = modLine + ", ";
                }
                first = false;
                modLine = modLine + fp.name;
                if (i == -1) continue;
                modLine = modLine + "_" + i + "_";
            }
        }
        modLine = modLine + ")";
        netlist.add(modLine);
        for (VInstance in : module.instances) {
            first = true;
            String inName = in.instanceName.replaceAll("/", "_").replaceAll("\\[", "_").replaceAll("\\]", "_");
            String inLine = inName + ": " + in.module.name + "(";
            for (VPort lp : in.ports.keySet()) {
                if (!first) {
                    inLine = inLine + ", ";
                }
                first = false;
                String[] signalNames = (String[])in.ports.get(lp);
                for (int i = 0; i < signalNames.length; ++i) {
                    String name = signalNames[i].replaceAll("/", "_").replaceAll("\\[", "_").replaceAll("\\]", "_");
                    inLine = inLine + name;
                }
            }
            inLine = inLine + ")";
            netlist.add(inLine);
        }
        netlist.add("");
    }

    public List<String> getQUISCNetlist(Library destLib, boolean isIncludeDateAndVersionInOutput) {
        if (this.hasErrors) {
            return null;
        }
        ArrayList<String> netlist = new ArrayList<String>();
        netlist.add("!*************************************************");
        netlist.add("!  QUISC Command file");
        netlist.add("!");
        if (isIncludeDateAndVersionInOutput) {
            netlist.add("!  File Creation:    " + TextUtils.formatDate(new Date()));
        }
        netlist.add("!-------------------------------------------------");
        netlist.add("");
        for (VModule mod : this.allModules) {
            if (!mod.defined) continue;
            this.genQuiscInterface(mod, netlist);
        }
        netlist.add("!********* End of command file *******************");
        return netlist;
    }

    private void genQuiscInterface(VModule module, List<String> netlist) {
        netlist.add("create cell " + module.name);
        for (VInstance in : module.instances) {
            if (in.module == null) {
                netlist.add("create instance " + in.instanceName + " " + in.fun.getName());
                continue;
            }
            netlist.add("create instance " + in.instanceName + " " + in.module.name);
        }
        for (String netName : module.allNetworks.keySet()) {
            List ports = (List)module.allNetworks.get(netName);
            VPort last2 = null;
            for (VPort lp : ports) {
                if (last2 != null) {
                    netlist.add("connect " + last2.in.instanceName + " " + last2.portName + " " + lp.in.instanceName + " " + lp.portName);
                }
                last2 = lp;
            }
        }
        for (VExport port : module.ports) {
            for (int i = port.firstIndex; i <= port.secondIndex; ++i) {
                String name = port.name;
                if (i != -1) {
                    name = name + "[" + i + "]";
                }
                boolean found = false;
                for (VInstance in : module.instances) {
                    for (VPort lp : in.ports.keySet()) {
                        String[] signalNames = (String[])in.ports.get(lp);
                        for (int j = 0; j < signalNames.length; ++j) {
                            if (!signalNames[j].equals(name)) continue;
                            String line = "export " + in.instanceName + " " + lp.portName + " " + name + " ";
                            switch (port.mode) {
                                case 0: {
                                    line = line + "unknown";
                                    break;
                                }
                                case 1: {
                                    line = line + "input";
                                    break;
                                }
                                case 2: {
                                    line = line + "output";
                                    break;
                                }
                                case 3: {
                                    line = line + "inout";
                                }
                            }
                            netlist.add(line);
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                netlist.add("! DID NOT FIND EXPORT " + name);
            }
        }
    }

    private static class VKeyword {
        private String name;
        private static List<VKeyword> theKeywords = new ArrayList<VKeyword>();
        public static final VKeyword ALWAYS = new VKeyword("always");
        public static final VKeyword ANALOG = new VKeyword("analog");
        public static final VKeyword ASSIGN = new VKeyword("assign");
        public static final VKeyword BEGIN = new VKeyword("begin");
        public static final VKeyword ELECTRICAL = new VKeyword("electrical");
        public static final VKeyword ELSE = new VKeyword("else");
        public static final VKeyword END = new VKeyword("end");
        public static final VKeyword ENDMODULE = new VKeyword("endmodule");
        public static final VKeyword ENDPRIMITIVE = new VKeyword("endprimitive");
        public static final VKeyword ENDSPECIFY = new VKeyword("endspecify");
        public static final VKeyword ENDTABLE = new VKeyword("endtable");
        public static final VKeyword IF = new VKeyword("if");
        public static final VKeyword INITIAL = new VKeyword("initial");
        public static final VKeyword INOUT = new VKeyword("inout");
        public static final VKeyword INPUT = new VKeyword("input");
        public static final VKeyword LOGIC = new VKeyword("logic");
        public static final VKeyword MODULE = new VKeyword("module");
        public static final VKeyword OUTPUT = new VKeyword("output");
        public static final VKeyword PARAMETER = new VKeyword("parameter");
        public static final VKeyword PRIMITIVE = new VKeyword("primitive");
        public static final VKeyword REAL = new VKeyword("real");
        public static final VKeyword REG = new VKeyword("reg");
        public static final VKeyword SPECIFY = new VKeyword("specify");
        public static final VKeyword SUPPLY = new VKeyword("supply");
        public static final VKeyword SUPPLY0 = new VKeyword("supply0");
        public static final VKeyword SUPPLY1 = new VKeyword("supply1");
        public static final VKeyword TABLE = new VKeyword("table");
        public static final VKeyword TRANIF0 = new VKeyword("tranif0");
        public static final VKeyword TRANIF1 = new VKeyword("tranif1");
        public static final VKeyword WIRE = new VKeyword("wire");

        VKeyword(String name) {
            this.name = name;
            theKeywords.add(this);
        }

        public static VKeyword findKeyword(String tString) {
            for (VKeyword vk : theKeywords) {
                if (!vk.name.equals(tString)) continue;
                return vk;
            }
            return null;
        }
    }

    private class TokenList {
        private TokenType type;
        private Object pointer;
        private boolean space;
        private int lineNum;

        private TokenList(TokenType type, Object pointer, int lineNum, boolean space) {
            this.type = type;
            this.pointer = pointer;
            this.lineNum = lineNum;
            this.space = true;
            CompileVerilogStruct.this.tList.add(this);
        }

        public int makeMessageLine(StringBuffer buffer) {
            int lineNumber = this.lineNum;
            for (int index = CompileVerilogStruct.this.tList.indexOf(this); index > 0 && ((TokenList)((CompileVerilogStruct)CompileVerilogStruct.this).tList.get((int)(index - 1))).lineNum == lineNumber; --index) {
            }
            int pointer = 0;
            for (int i = index; i < CompileVerilogStruct.this.tList.size(); ++i) {
                TokenList tok = (TokenList)CompileVerilogStruct.this.tList.get(i);
                if (tok.lineNum != lineNumber) break;
                if (tok == this) {
                    pointer = buffer.length();
                }
                buffer.append(tok.toString());
                if (!tok.space) continue;
                buffer.append(" ");
            }
            return pointer;
        }

        public String toString() {
            if (this.type == TokenType.STRING) {
                return "\"" + this.pointer + "\" ";
            }
            if (this.type == TokenType.KEYWORD) {
                return ((VKeyword)this.pointer).name;
            }
            if (this.type == TokenType.DECIMAL) {
                return (String)this.pointer;
            }
            if (this.type == TokenType.BITS) {
                return (String)this.pointer;
            }
            if (this.type == TokenType.CHAR) {
                return ((Character)this.pointer).charValue() + "";
            }
            if (this.type == TokenType.IDENTIFIER) {
                if (this.pointer == null) {
                    return "NULL";
                }
                return this.pointer.toString();
            }
            return this.type.getChar();
        }
    }

    private static class TokenType {
        private String name;
        private String str;
        public static final TokenType LEFTPAREN = new TokenType("Left Parenthesis", "(");
        public static final TokenType RIGHTPAREN = new TokenType("Right Parenthesis", ")");
        public static final TokenType LEFTBRACKET = new TokenType("Left Bracket", "[");
        public static final TokenType RIGHTBRACKET = new TokenType("Right Bracket", "]");
        public static final TokenType LEFTBRACE = new TokenType("Left Brace", "{");
        public static final TokenType RIGHTBRACE = new TokenType("Right Brace", "}");
        public static final TokenType SLASH = new TokenType("Forward Slash", "/");
        public static final TokenType COMMA = new TokenType("Comma", ",");
        public static final TokenType MINUS = new TokenType("Minus", "-");
        public static final TokenType AMPERSAND = new TokenType("Ampersand", "&");
        public static final TokenType VERTICALBAR = new TokenType("Vertical Bar", "|");
        public static final TokenType PERIOD = new TokenType("Period", ".");
        public static final TokenType APOSTROPHE = new TokenType("Apostrophe", "'");
        public static final TokenType QUESTION = new TokenType("Question", "?");
        public static final TokenType HASH = new TokenType("Hash", "#");
        public static final TokenType COLON = new TokenType("Colon", ":");
        public static final TokenType SEMICOLON = new TokenType("Semicolon", ";");
        public static final TokenType ATSIGN = new TokenType("At Sign", "@");
        public static final TokenType EQUALS = new TokenType("Equals", "=");
        public static final TokenType DOUBLEDOT = new TokenType("DotDot", "..");
        public static final TokenType VARASSIGN = new TokenType("Assign", "=>");
        public static final TokenType UNKNOWN = new TokenType("Unknown", "");
        public static final TokenType IDENTIFIER = new TokenType("Identifier", "");
        public static final TokenType KEYWORD = new TokenType("Keyword", "");
        public static final TokenType DECIMAL = new TokenType("Decimal Number", "");
        public static final TokenType BITS = new TokenType("Bit Sequence", "");
        public static final TokenType CHAR = new TokenType("Character", "");
        public static final TokenType STRING = new TokenType("String", "");
        public static final TokenType TILDE = new TokenType("TILDE", "~");

        private TokenType(String name, String str) {
            this.name = name;
            this.str = str;
        }

        public String getName() {
            return this.name;
        }

        public String getChar() {
            return this.str;
        }
    }

    public static class VPort {
        private VInstance in;
        private String portName;
        private boolean onBus;

        public VPort(VInstance in, String portName, boolean onBus) {
            this.in = in;
            this.portName = portName;
            this.onBus = onBus;
        }
    }

    public static class VInstance {
        private VModule module;
        private PrimitiveNode.Function fun;
        private String instanceName;
        private Map<VPort, String[]> ports;

        public VInstance(VModule module, String instanceName) {
            this.module = module;
            this.fun = null;
            this.instanceName = instanceName;
            this.ports = new HashMap<VPort, String[]>();
        }

        public VInstance(PrimitiveNode.Function fun, String instanceName) {
            this.module = null;
            this.fun = fun;
            this.instanceName = instanceName;
            this.ports = new HashMap<VPort, String[]>();
        }

        public void addConnection(VPort lp, String[] signalNames) {
            this.ports.put(lp, signalNames);
        }

        public VModule getModule() {
            return this.module;
        }

        public PrimitiveNode.Function getFunction() {
            return this.fun;
        }
    }

    public static class VExport {
        private String name;
        private int mode;
        private int firstIndex;
        private int secondIndex;

        public VExport(String name) {
            this.name = name;
            this.mode = 0;
            this.secondIndex = -1;
            this.firstIndex = -1;
        }

        public String getName() {
            return this.name;
        }

        public boolean isBus() {
            return this.firstIndex >= 0;
        }
    }

    public class VModule {
        private String name;
        private boolean defined;
        private boolean primitive;
        private Cell cell;
        private List<VExport> ports;
        private List<String> wires;
        private List<VInstance> instances;
        private Map<String, String> assignments;
        private Map<String, List<VPort>> allNetworks;

        VModule(String name, boolean defined, boolean primitive) {
            this.name = name;
            this.defined = defined;
            this.primitive = primitive;
            this.cell = null;
            this.ports = new ArrayList<VExport>();
            this.wires = new ArrayList<String>();
            this.instances = new ArrayList<VInstance>();
            this.allNetworks = new HashMap<String, List<VPort>>();
            this.assignments = new HashMap<String, String>();
            CompileVerilogStruct.this.allModules.add(this);
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public String getName() {
            return this.name;
        }

        public List<VInstance> getInstances() {
            return this.instances;
        }

        public List<VExport> getPorts() {
            return this.ports;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public Cell getCell() {
            return this.cell;
        }
    }
}

