/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CIF
extends Geometry {
    private int crcChecksum;
    private int[] crcTab = new int[256];
    private boolean crcPrevIsCharSep;
    private int crcNumChars;
    private static final int[] crcRow = new int[]{79764919, 159529838, 319059676, 638119352, 1276238704, -1742489888, 881225847, 1762451694};
    private int cellNumber = 100;
    private Map<Cell, Integer> cellNumbers;
    private double scaleFactor;
    private static final String badNameChars = ":{}/\\";
    private CIFPreferences localPrefs;

    CIF(CIFPreferences cp, double techScale) {
        this.localPrefs = cp;
        this.cellNumbers = new HashMap<Cell, Integer>();
        this.scaleFactor = techScale / 10.0 * (double)this.localPrefs.cifScale;
    }

    @Override
    protected void start() {
        if (this.localPrefs.includeDateAndVersionInOutput) {
            this.writeLine("( Electric VLSI Design System, version " + Version.getVersion() + " );");
            Date now = new Date();
            this.writeLine("( written on " + TextUtils.formatDate(now) + " );");
        } else {
            this.writeLine("( Electric VLSI Design System );");
        }
        this.emitCopyright("( ", " );");
        int i = 0;
        while (i < this.crcTab.length) {
            this.crcTab[i] = 0;
            for (int j = 0; j < 8; ++j) {
                if ((1 << j & i) == 0) continue;
                this.crcTab[i] = this.crcTab[i] ^ crcRow[j];
            }
            int n = i++;
            this.crcTab[n] = this.crcTab[n] & 0xFFFFFFFF;
        }
        this.crcNumChars = 1;
        this.crcPrevIsCharSep = true;
        this.crcChecksum = this.crcTab[32];
    }

    @Override
    protected void done() {
        if (this.localPrefs.cifOutInstantiatesTopLevel) {
            this.writeLine("C " + this.cellNumber + ";");
        }
        this.writeLine("E");
        if (!this.crcPrevIsCharSep) {
            this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ 0x20) & 0xFF];
            ++this.crcNumChars;
        }
        for (int bytesread = this.crcNumChars; bytesread > 0; bytesread >>= 8) {
            this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ bytesread) & 0xFF];
        }
        this.crcChecksum = ~this.crcChecksum & 0xFFFFFFFF;
        System.out.println("MOSIS CRC: " + GenMath.unsignedIntValue(this.crcChecksum) + " " + this.crcNumChars);
    }

    @Override
    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        ++this.cellNumber;
        this.writeLine("DS " + this.cellNumber + " 1 " + this.localPrefs.cifScale + ";");
        String cellName = (cellGeom.nonUniqueName ? cellGeom.cell.getLibrary().getName() + ":" : "") + cellGeom.cell.getName() + ";";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cellName.length(); ++i) {
            char ch = cellName.charAt(i);
            if (badNameChars.indexOf(ch) != -1) {
                ch = '_';
            }
            sb.append(ch);
        }
        this.writeLine("9 " + sb.toString());
        this.cellNumbers.put(cellGeom.cell, new Integer(this.cellNumber));
        Set<Layer> layers = cellGeom.polyMap.keySet();
        for (Layer layer : layers) {
            if (this.writeLayer(layer)) continue;
            List<Object> polyList = cellGeom.polyMap.get(layer);
            for (Object polyObj : polyList) {
                if (this.includeGeometric()) {
                    Geometry.PolyWithGeom pg = (Geometry.PolyWithGeom)polyObj;
                    Poly poly = pg.poly;
                    this.writePoly(poly, cellGeom.cell, pg.geom);
                    continue;
                }
                PolyBase poly = (PolyBase)polyObj;
                this.writePoly(poly, cellGeom.cell, null);
            }
        }
        Iterator<NodeInst> noIt = cellGeom.cell.getNodes();
        while (noIt.hasNext()) {
            NodeInst ni = noIt.next();
            if (!ni.isCellInstance()) continue;
            this.writeNodable(ni);
        }
        this.writeLine("DF;");
    }

    @Override
    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return this.localPrefs.cifOutMergesBoxes;
    }

    @Override
    protected boolean includeGeometric() {
        return !this.localPrefs.cifOutMergesBoxes;
    }

    private boolean writeLayer(Layer layer) {
        String layName = layer.getCIFLayer();
        if (layName == null || layName.equals("")) {
            return true;
        }
        this.writeLine("L " + layName + ";");
        return false;
    }

    private void writePoly(PolyBase poly, Cell cell, Geometric geom) {
        PolyBase.Point[] points = poly.getPoints();
        if (poly.getStyle() == Poly.Type.DISC || poly.getStyle() == Poly.Type.CIRCLE) {
            this.checkResolution(poly, cell, geom);
            double r = ((Point2D)points[0]).distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            int radius = this.scale(r) * 2;
            int x = this.scale(((Point2D)points[0]).getX());
            int y = this.scale(((Point2D)points[0]).getY());
            String line = " R " + radius + " " + x + " " + y + ";";
            this.writeLine(line);
        } else {
            FixpRectangle bounds = poly.getBounds2D();
            if (((RectangularShape)bounds).getHeight() <= 0.0 || ((RectangularShape)bounds).getWidth() <= 0.0) {
                return;
            }
            FixpRectangle box = poly.getBox();
            if (box != null) {
                this.checkPointResolution(((RectangularShape)box).getWidth(), ((RectangularShape)box).getHeight(), cell, geom, poly.getLayer(), poly);
                this.checkPointResolution(((RectangularShape)box).getCenterX(), ((RectangularShape)box).getCenterY(), cell, geom, poly.getLayer(), poly);
                int width = this.scale(((RectangularShape)box).getWidth());
                int height = this.scale(((RectangularShape)box).getHeight());
                int x = this.scale(((RectangularShape)box).getCenterX());
                int y = this.scale(((RectangularShape)box).getCenterY());
                String line = " B " + width + " " + height + " " + x + " " + y + ";";
                this.writeLine(line);
                return;
            }
            this.checkResolution(poly, cell, geom);
            StringBuffer line = new StringBuffer(" P");
            for (int i = 0; i < points.length; ++i) {
                int x = this.scale(((Point2D)points[i]).getX());
                int y = this.scale(((Point2D)points[i]).getY());
                line.append(" " + x + " " + y);
            }
            line.append(";");
            this.writeLine(line.toString());
        }
    }

    private void writeNodable(NodeInst ni) {
        Cell cell = (Cell)ni.getProto();
        if (!this.localPrefs.expansionState.isExpanded(ni) && this.localPrefs.cifOutMimicsDisplay) {
            ERectangle bounds = ni.getBounds();
            Poly poly = new Poly(((RectangularShape)bounds).getCenterX(), ((RectangularShape)bounds).getCenterY(), ni.getXSize(), ni.getYSize());
            FixpTransform localPureTrans = ni.rotateOutAboutTrueCenter();
            poly.transform(localPureTrans);
            PolyBase.Point[] points = poly.getPoints();
            String line = "0V";
            for (int i = 0; i < 4; ++i) {
                line = line + " " + this.scale(((Point2D)points[i]).getX()) + " " + this.scale(((Point2D)points[i]).getY());
            }
            line = line + " " + this.scale(((Point2D)points[0]).getX()) + " " + this.scale(((Point2D)points[0]).getY());
            this.writeLine(line + ";");
            this.writeLine("2C \"" + cell.describe(false) + "\" T " + this.scale(((RectangularShape)bounds).getCenterX()) + " " + this.scale(((RectangularShape)bounds).getCenterY()) + ";");
            return;
        }
        int cellNum = this.cellNumbers.get(cell);
        int rotx = (int)(DBMath.cos(ni.getAngle()) * 100.0);
        int roty = (int)(DBMath.sin(ni.getAngle()) * 100.0);
        String line = "C " + cellNum + " R " + rotx + " " + roty;
        if (ni.isMirroredAboutXAxis()) {
            line = line + " M Y";
        }
        if (ni.isMirroredAboutYAxis()) {
            line = line + " M X";
        }
        line = line + " T " + this.scale(ni.getAnchorCenterX()) + " " + this.scale(ni.getAnchorCenterY());
        this.writeLine(line + ";");
    }

    private void writeLine(String line) {
        line = line + '\n';
        this.printWriter.print(line);
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c > ' ') {
                this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ c) & 0xFF];
                this.crcPrevIsCharSep = false;
            } else if (!this.crcPrevIsCharSep) {
                this.crcChecksum = this.crcChecksum << 8 ^ this.crcTab[(this.crcChecksum >> 24 ^ 0x20) & 0xFF];
                this.crcPrevIsCharSep = true;
            }
            ++this.crcNumChars;
        }
    }

    private int scale(double n) {
        return (int)(this.scaleFactor * n);
    }

    private void checkResolution(PolyBase poly, Cell cell, Geometric geom) {
        PolyBase.Point[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            double y;
            double x = ((Point2D)points[i]).getX();
            if (!this.checkPointResolution(x, y = ((Point2D)points[i]).getY(), cell, geom, poly.getLayer(), poly)) continue;
            return;
        }
    }

    private boolean checkPointResolution(double x, double y, Cell cell, Geometric geom, Layer layer, PolyBase poly) {
        boolean error;
        boolean badPoints = false;
        double scaleX = x * this.scaleFactor;
        double scaleY = y * this.scaleFactor;
        if ((double)Math.round(scaleX) != scaleX || (double)Math.round(scaleY) != scaleY) {
            System.out.println("Warning: resolution is too fine: (" + scaleX + "," + scaleY + ") should be (" + Math.round(scaleX) + "," + Math.round(scaleY) + ")");
            badPoints = true;
        }
        boolean badResolution = false;
        boolean bl = error = badPoints || badResolution;
        if (error) {
            String layerName = layer == null ? "**UNKNOWN**" : layer.getName();
            String msg = "Resolution less than CIF allows on layer " + layerName + ": (" + x + "," + y + ") not on " + 1.0 / this.scaleFactor + " grid";
            if (geom != null) {
                this.errorLogger.logError(msg, geom, cell, null, layer.getIndex());
            } else {
                this.errorLogger.logError(msg, poly, cell, layer.getIndex());
            }
        }
        return error;
    }

    private CIFVisitor makeCIFVisitor(int maxDepth) {
        CIFVisitor visitor = new CIFVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private class CIFVisitor
    extends Geometry.Visitor {
        CIFVisitor(Geometry outGeom, int maxHierDepth) {
            super(CIF.this, outGeom, maxHierDepth);
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = (NodeInst)no;
            if (ni.isCellInstance() && !((CIF)CIF.this).localPrefs.expansionState.isExpanded(ni) && ((CIF)CIF.this).localPrefs.cifOutMimicsDisplay) {
                return false;
            }
            return super.visitNodeInst(no, info);
        }
    }

    public static class CIFPreferences
    extends Output.OutputPreferences {
        int cifScale = IOTool.getCIFOutScaleFactor();
        boolean cifOutInstantiatesTopLevel = IOTool.isCIFOutInstantiatesTopLevel();
        boolean cifOutMergesBoxes = IOTool.isCIFOutMergesBoxes();
        boolean cifOutMimicsDisplay = IOTool.isCIFOutMimicsDisplay();
        NodeInst.ExpansionState expansionState;

        public CIFPreferences(boolean factory, Cell cell) {
            super(factory);
            this.expansionState = factory ? new NodeInst.ExpansionState(null, 1) : new NodeInst.ExpansionState(cell, 2);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            CIFVisitor visitor;
            CIF out = new CIF(this, cell.getTechnology().getScale());
            if (!(out.openTextOutputStream(filePath) || out.writeCell(cell, context, visitor = out.makeCIFVisitor(Geometry.getMaxHierDepth(cell))) || out.closeTextOutputStream())) {
                System.out.println(filePath + " written");
                if (out.errorLogger.getNumErrors() != 0) {
                    System.out.println(out.errorLogger.getNumErrors() + " CIF RESOLUTION ERRORS FOUND");
                }
            }
            return out.finishWrite();
        }
    }
}

