/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import java.io.Serializable;

public class Version
implements Comparable<Version>,
Serializable {
    public static final String ELECTRIC_VERSION = "9.05";
    private final String version;
    private final String oldStyle;
    private final int major;
    private final int minor;
    private final int details;
    private static String buildDate;
    private static final Version current;

    private Version(String version) {
        int major = 0;
        int minor = 0;
        int details = 0;
        int dot = version.indexOf(46);
        if (dot == -1) {
            major = Integer.parseInt(version);
        } else {
            int letters;
            String majorString = version.substring(0, dot);
            String restOfString = version.substring(dot + 1);
            major = Integer.parseInt(majorString);
            for (letters = 0; letters < restOfString.length() && Character.isDigit(restOfString.charAt(letters)); ++letters) {
            }
            String minorString = restOfString.substring(0, letters);
            minor = Integer.parseInt(minorString);
            if ((restOfString = restOfString.substring(letters)).length() == 0) {
                details = 999;
            } else if (restOfString.charAt(0) == '.') {
                details = 1000 + Integer.parseInt(restOfString.substring(1));
            } else {
                if (restOfString.startsWith("-")) {
                    restOfString = restOfString.substring(1);
                }
                while (restOfString.length() > 0 && Character.isLetter(restOfString.charAt(0))) {
                    details = details * 26 + Character.toLowerCase(restOfString.charAt(0)) - 97 + 1;
                    restOfString = restOfString.substring(1);
                }
                if (restOfString.length() > 0) {
                    System.out.println("Invalid version string " + version);
                }
            }
        }
        this.version = version;
        this.oldStyle = version.replaceFirst("-", "");
        this.major = major;
        this.minor = minor;
        this.details = details;
    }

    public static String[] getAuthorInformation() {
        return new String[]{"Steven M. Rubin", "Gilda Garret\u00f3n", "Dmitry Nadezhin"};
    }

    public static String getApplicationInformation() {
        return "The Electric VLSI Design System";
    }

    public static String getCopyrightInformation() {
        return "Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.";
    }

    public static String getWarrantyInformation() {
        return "Electric comes with ABSOLUTELY NO WARRANTY";
    }

    public static String getVersionInformation() {
        String versionText = "Version " + Version.getVersion();
        String buildText = Version.getBuildDate();
        if (buildText != null) {
            versionText = versionText + " (built on " + buildText + ")";
        }
        return versionText;
    }

    public static Version getVersion() {
        return current;
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getDetail() {
        return this.details;
    }

    public int hashCode() {
        return this.major * 1000000 + this.minor * 10000 + this.details;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return this.major == v.major && this.minor == v.minor && this.details == v.details;
        }
        return false;
    }

    @Override
    public int compareTo(Version v) {
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        if (this.details < v.details) {
            return -1;
        }
        if (this.details > v.details) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.version;
    }

    public String toOldStyleString() {
        return this.oldStyle;
    }

    public static Version parseVersion(String version) {
        return new Version(version);
    }

    private static Version loadVersionProperties() {
        String currentVersion = ELECTRIC_VERSION;
        return Version.parseVersion(currentVersion);
    }

    static {
        current = Version.loadVersionProperties();
    }
}

