/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableNetLayout;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.Job;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ImmutableLayoutHierarchyEnumerator {
    private Visitor visitor;
    private boolean caching;
    private int curNetId = 0;
    private int cellCnt = 0;
    private int instCnt = 0;
    private Map<Integer, NetDescription> netIdToNetDesc = new HashMap<Integer, NetDescription>();
    private HashMap<Cell, int[]> cellExternalIds = new HashMap();

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    private ImmutableLayoutHierarchyEnumerator() {
    }

    private int[] getExternalIds(Cell cell, Netlist netlist) {
        int[] externalIds = this.cellExternalIds.get(cell);
        if (externalIds != null) {
            return externalIds;
        }
        externalIds = new int[netlist.getNumExternalNetworks()];
        this.cellExternalIds.put(cell, externalIds);
        return externalIds;
    }

    private int[] numberNets(Cell cell, Netlist netlist, int[][] portNdxToNetIDs, CellInfo info) {
        int numNets = netlist.getNumNetworks();
        int[] externalIds = this.getExternalIds(cell, netlist);
        int[] netNdxToNetID = new int[numNets];
        int baseId = this.curNetId;
        Arrays.fill(externalIds, -1);
        if (portNdxToNetIDs != null) {
            int i;
            assert (portNdxToNetIDs.length == cell.getNumPorts() + 1);
            Global.Set globals = netlist.getGlobals();
            assert (portNdxToNetIDs[0].length == globals.size());
            for (i = 0; i < globals.size(); ++i) {
                Global global = globals.get(i);
                int netIndex = netlist.getNetwork(global).getNetIndex();
                externalIds[netIndex] = portNdxToNetIDs[0][i];
            }
            int numPorts = cell.getNumPorts();
            for (i = 0; i < numPorts; ++i) {
                Export export = cell.getPort(i);
                int[] ids = portNdxToNetIDs[i + 1];
                assert (ids.length == export.getNameKey().busWidth());
                for (int j = 0; j < ids.length; ++j) {
                    int netIndex = netlist.getNetwork(export, j).getNetIndex();
                    externalIds[netIndex] = ids[j];
                }
            }
            for (i = 0; i < externalIds.length; ++i) {
                assert (externalIds[i] >= 0);
            }
            baseId -= externalIds.length;
        }
        for (int i = 0; i < numNets; ++i) {
            int id;
            Network net = netlist.getNetwork(i);
            int localId = i;
            assert (baseId + localId <= this.curNetId);
            if (baseId + localId == this.curNetId) {
                if (portNdxToNetIDs == null && localId < externalIds.length) {
                    externalIds[localId] = localId;
                }
                assert (this.curNetId == baseId + localId);
                this.netIdToNetDesc.put(this.curNetId++, new NetDescription(net, info));
            } else if (localId >= externalIds.length || portNdxToNetIDs == null) {
                int cmp;
                NetDescription nd = this.netIdToNetDesc.get(baseId + localId);
                int n = !net.isUsernamed() ? 1 : (cmp = nd.net.isUsernamed() ? 0 : -1);
                if (cmp == 0 && net.isExported() != nd.net.isExported()) {
                    int n2 = cmp = net.isExported() ? -1 : 1;
                }
                if (cmp == 0) {
                    cmp = TextUtils.STRING_NUMBER_ORDER.compare(net.getName(), nd.net.getName());
                }
                if (cmp < 0) {
                    nd.net = net;
                }
            }
            netNdxToNetID[i] = id = localId < externalIds.length ? externalIds[localId] : baseId + localId;
        }
        return netNdxToNetID;
    }

    private static int[] getGlobalNetIDs(Nodable no, Netlist netlist, int[] netNdxToNetID) {
        Global.Set gs = netlist.getNetlist(no).getGlobals();
        int[] netIDs = new int[gs.size()];
        for (int i = 0; i < gs.size(); ++i) {
            int netIndex = netlist.getNetwork(no, gs.get(i)).getNetIndex();
            int netID = netNdxToNetID[netIndex];
            ImmutableLayoutHierarchyEnumerator.error(netID < 0, "no netID for net");
            netIDs[i] = netID;
        }
        return netIDs;
    }

    private static int[] getPortNetIDs(Nodable no, PortProto pp, Netlist netlist, int[] netNdxToNetID) {
        int busWidth = pp.getNameKey().busWidth();
        int[] netIDs = new int[busWidth];
        for (int j = 0; j < busWidth; ++j) {
            Network net = netlist.getNetwork(no, pp, j);
            ImmutableLayoutHierarchyEnumerator.error(net == null, "no network for net " + pp.getNameKey());
            int netIndex = net.getNetIndex();
            int netID = netNdxToNetID[netIndex];
            ImmutableLayoutHierarchyEnumerator.error(netID < 0, "no netID for net " + pp.getNameKey());
            netIDs[j] = netID;
        }
        return netIDs;
    }

    private static int[][] buildPortMap(Netlist netlist, Nodable ni, int[] netNdxToNetID) {
        Cell cell = (Cell)ni.getProto();
        int numPorts = cell.getNumPorts();
        int[][] portNdxToNetIDs = new int[numPorts + 1][];
        portNdxToNetIDs[0] = ImmutableLayoutHierarchyEnumerator.getGlobalNetIDs(ni, netlist, netNdxToNetID);
        for (int i = 0; i < numPorts; ++i) {
            Export pp = cell.getPort(i);
            portNdxToNetIDs[i + 1] = ImmutableLayoutHierarchyEnumerator.getPortNetIDs(ni, pp, netlist, netNdxToNetID);
        }
        return portNdxToNetIDs;
    }

    private void enumerateCell(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[][] portNdxToNetIDs, FixpTransform xformToRoot, CellInfo parent, Rectangle2D bounds) {
        Iterator<Object> it;
        CellInfo info = this.visitor.newCellInfo();
        int firstNetID = this.curNetId;
        int[] netNdxToNetID = this.numberNets(cell, netlist, portNdxToNetIDs, info);
        int lastNetIDPlusOne = this.curNetId;
        ++this.cellCnt;
        info.init(parentInst, cell, context, netlist, netNdxToNetID, portNdxToNetIDs, xformToRoot, this.netIdToNetDesc, parent);
        boolean enumInsts = this.visitor.enterCell(info);
        if (!enumInsts) {
            return;
        }
        if (bounds != null) {
            it = cell.searchIterator(bounds);
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                this.visitThisNode(ni, context, netlist, info, netNdxToNetID, xformToRoot);
            }
        } else {
            it = netlist.getNodables();
            while (it.hasNext()) {
                Nodable ni = (Nodable)it.next();
                this.visitThisNode(ni, context, netlist, info, netNdxToNetID, xformToRoot);
            }
        }
        this.visitor.exitCell(info);
        context.deleteVariableCache();
        for (int i = firstNetID; i < lastNetIDPlusOne; ++i) {
            this.netIdToNetDesc.remove(i);
        }
    }

    private void visitThisNode(Nodable ni, VarContext context, Netlist netlist, CellInfo info, int[] netNdxToNetID, FixpTransform xformToRoot) {
        ++this.instCnt;
        boolean descend = this.visitor.visitNodeInst(ni, info);
        NodeProto np = ni.getProto();
        if (descend && ni.isCellInstance() && !((Cell)np).isIcon()) {
            int[][] portNmToNetIDs2 = ImmutableLayoutHierarchyEnumerator.buildPortMap(netlist, ni, netNdxToNetID);
            FixpTransform xformToRoot2 = xformToRoot;
            if (ni instanceof NodeInst) {
                xformToRoot2 = new FixpTransform(xformToRoot);
                xformToRoot2.concatenate(((NodeInst)ni).rotateOut());
                xformToRoot2.concatenate(((NodeInst)ni).translateOut());
            }
            this.enumerateCell(ni, (Cell)np, this.caching ? context.pushCaching(ni) : context.push(ni), netlist.getNetlist(ni), portNmToNetIDs2, xformToRoot2, info, null);
        }
    }

    private void doIt(Cell root2, VarContext context, Netlist netlist, Visitor visitor, boolean cache, Rectangle2D bounds) {
        this.visitor = visitor;
        this.caching = cache;
        if (context == null) {
            context = VarContext.globalContext;
        }
        int[][] exportNdxToNetIDs = null;
        this.enumerateCell(null, root2, context, netlist, exportNdxToNetIDs, new FixpTransform(), null, bounds);
    }

    public static void enumerateCell(Cell root2, VarContext context, Visitor visitor) {
        ImmutableLayoutHierarchyEnumerator.enumerateCell(root2, context, visitor, Netlist.ShortResistors.NO);
    }

    public static void enumerateCell(Cell root2, VarContext context, Visitor visitor, Rectangle2D bounds) {
        new ImmutableLayoutHierarchyEnumerator().doIt(root2, context, root2.getNetlist(Netlist.ShortResistors.NO), visitor, false, bounds);
    }

    public static void enumerateCell(Cell root2, VarContext context, Visitor visitor, Netlist.ShortResistors shortResistors) {
        ImmutableLayoutHierarchyEnumerator.enumerateCell(root2.getNetlist(shortResistors), context, visitor);
    }

    public static void enumerateCell(Netlist rootNetlist, VarContext context, Visitor visitor) {
        ImmutableLayoutHierarchyEnumerator.enumerateCell(rootNetlist, context, visitor, false);
    }

    public static void enumerateCell(Netlist rootNetlist, VarContext context, Visitor visitor, boolean caching) {
        Netlist.ShortResistors shortResistors = rootNetlist.getShortResistors();
        new ImmutableLayoutHierarchyEnumerator().doIt(rootNetlist.getCell(), context, rootNetlist, visitor, caching, null);
    }

    private static class ImmutableNetlist {
        private final ImmutableNetLayout impl;
        private final int[] nm_net;

        private ImmutableNetlist(ImmutableNetLayout impl, Netlist.ShortResistors shortResisors) {
            this.impl = impl;
            this.nm_net = new int[impl.netMap.length];
        }

        private int getNetIndex(ImmutableArcInst a) {
            return -1;
        }

        private int getNetIndex(ImmutableNodeInst n, PortProtoId pp) {
            return -1;
        }
    }

    public static class CellInfo {
        private Nodable parentInst;
        private Cell cell;
        private CellTree cellTree;
        private VarContext context;
        private Netlist netlist;
        private int[] netNdxToNetID;
        private int[][] exportNdxToNetIDs;
        private FixpTransform xformToRoot;
        private Map<Integer, NetDescription> netIdToNetDesc;
        private CellInfo parentInfo;

        void init(Nodable parentInst, Cell cell, VarContext context, Netlist netlist, int[] netToNetID, int[][] exportNdxToNetIDs, FixpTransform xformToRoot, Map<Integer, NetDescription> netIdToNetDesc, CellInfo parentInfo) {
            this.parentInst = parentInst;
            this.cell = cell;
            this.cellTree = cell.tree();
            this.context = context;
            this.netlist = netlist;
            this.netNdxToNetID = netToNetID;
            this.exportNdxToNetIDs = exportNdxToNetIDs;
            this.xformToRoot = xformToRoot;
            this.netIdToNetDesc = netIdToNetDesc;
            this.parentInfo = parentInfo;
        }

        public final Cell getCell() {
            return this.cell;
        }

        public final boolean isRootCell() {
            return this.parentInfo == null;
        }

        public final VarContext getContext() {
            return this.context;
        }

        public final CellInfo getParentInfo() {
            return this.parentInfo;
        }

        public final Nodable getParentInst() {
            return this.parentInst;
        }

        public final CellInfo getRootInfo() {
            CellInfo i = this;
            while (i.getParentInfo() != null) {
                i = i.getParentInfo();
            }
            return i;
        }

        public final int[] getExportNetIDs(Export e) {
            if (this.isRootCell()) {
                int width = this.netlist.getBusWidth(e);
                int[] netIDs = new int[width];
                for (int i = 0; i < width; ++i) {
                    netIDs[i] = this.netlist.getNetwork(e, i).getNetIndex();
                }
                return netIDs;
            }
            return this.exportNdxToNetIDs[e.getPortIndex() + 1];
        }

        public final int getNetID(ArcInst ai) {
            Network net = this.netlist.getNetwork(ai, 0);
            return net != null ? this.getNetID(net.getNetIndex()) : -1;
        }

        public final int getNetID(NodeInst ni, PortProto p) {
            Network net = this.netlist.getNetwork(this.parentInst, p, 0);
            return net != null ? this.getNetID(net.getNetIndex()) : -1;
        }

        private int getNetID(int netIndex) {
            return this.netNdxToNetID[netIndex];
        }

        public final int[] getPortNetIDs(Nodable no, PortProto pp) {
            return ImmutableLayoutHierarchyEnumerator.getPortNetIDs(no, pp, this.netlist, this.netNdxToNetID);
        }

        public FixpTransform getTransformToRoot() {
            return this.xformToRoot;
        }
    }

    public static class NetDescription {
        private Network net;
        private CellInfo info;

        NetDescription(Network net, CellInfo info) {
            this.net = net;
            this.info = info;
        }

        public Network getNet() {
            return this.net;
        }

        public CellInfo getCellInfo() {
            return this.info;
        }
    }

    public static abstract class Visitor {
        public CellInfo newCellInfo() {
            return new CellInfo();
        }

        public abstract boolean enterCell(CellInfo var1);

        public abstract void exitCell(CellInfo var1);

        public abstract boolean visitNodeInst(Nodable var1, CellInfo var2);
    }
}

