/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellRevision;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.AbstractShapeBuilder;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.BoundsBuilder;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.util.collections.ImmutableArrayList;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;

public class CellBackup {
    public static final CellBackup[] NULL_ARRAY = new CellBackup[0];
    public static final ImmutableArrayList<CellBackup> EMPTY_LIST = ImmutableArrayList.of(new Object[0]);
    static int cellBackupsCreated = 0;
    public final CellRevision cellRevision;
    public final TechPool techPool;
    public final boolean modified;
    private BitSet wiped;
    private BitSet hardArcs;
    private AbstractShapeBuilder.Shrinkage shrinkage;
    private ERectangle primitiveBounds;

    private CellBackup(CellRevision cellRevision, TechPool techPool, boolean modified) {
        this.cellRevision = cellRevision;
        this.techPool = techPool;
        this.modified = modified;
        ++cellBackupsCreated;
    }

    public static CellBackup newInstance(ImmutableCell d, TechPool techPool) {
        if (d.cellId.idManager != techPool.idManager) {
            throw new IllegalArgumentException();
        }
        if (techPool.getTech(d.techId) == null) {
            throw new IllegalArgumentException();
        }
        CellRevision cellRevision = CellRevision.newInstance(d);
        TechPool restrictedPool = techPool.restrict(cellRevision.techUsages, techPool);
        return new CellBackup(cellRevision, restrictedPool, true);
    }

    public CellBackup with(ImmutableCell d, ImmutableNodeInst[] nodesArray, ImmutableArcInst[] arcsArray, ImmutableExport[] exportsArray, TechPool superPool) {
        CellRevision newRevision = this.cellRevision.with(d, nodesArray, arcsArray, exportsArray);
        TechPool restrictedPool = superPool.restrict(newRevision.techUsages, this.techPool);
        if (newRevision == this.cellRevision && restrictedPool == this.techPool) {
            return this;
        }
        if (arcsArray != null) {
            for (ImmutableArcInst a : arcsArray) {
                if (a == null || a.check(restrictedPool)) continue;
                throw new IllegalArgumentException("arc " + a.name + " is not compatible with TechPool");
            }
        }
        return new CellBackup(newRevision, restrictedPool, this.modified || newRevision != this.cellRevision);
    }

    public CellBackup withRevisionDate(long revisionDate) {
        CellRevision newRevision = this.cellRevision.withRevisionDate(revisionDate);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision, this.techPool, true);
    }

    public CellBackup withoutModified() {
        if (!this.modified) {
            return this;
        }
        return new CellBackup(this.cellRevision, this.techPool, false);
    }

    public CellBackup withTechPool(TechPool techPool) {
        TechPool restrictedPool = techPool.restrict(this.cellRevision.techUsages, this.techPool);
        if (this.techPool == restrictedPool) {
            return this;
        }
        if (techPool.idManager != this.techPool.idManager) {
            throw new IllegalArgumentException();
        }
        return new CellBackup(this.cellRevision, restrictedPool, this.modified);
    }

    CellBackup withRenamedIds(IdMapper idMapper, CellName newGroupName) {
        CellRevision newRevision = this.cellRevision.withRenamedIds(idMapper, newGroupName);
        if (newRevision == this.cellRevision) {
            return this;
        }
        return new CellBackup(newRevision, this.techPool, true);
    }

    void write(IdWriter writer) throws IOException {
        this.cellRevision.write(writer);
        writer.writeBoolean(this.modified);
    }

    static CellBackup read(IdReader reader, TechPool techPool) throws IOException {
        CellRevision newRevision = CellRevision.read(reader);
        boolean modified = reader.readBoolean();
        TechPool restrictedPool = techPool.restrict(newRevision.techUsages, techPool);
        return new CellBackup(newRevision, restrictedPool, modified);
    }

    public void check() {
        this.cellRevision.check();
        IdManager idManager = this.cellRevision.d.cellId.idManager;
        assert (this.techPool.idManager == idManager);
        BitSet techUsages = new BitSet();
        for (Technology tech : this.techPool.values()) {
            int techIndex = tech.getId().techIndex;
            assert (!techUsages.get(techIndex));
            techUsages.set(techIndex);
        }
        assert (techUsages.equals(this.cellRevision.techUsages));
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            if (a == null) continue;
            a.check(this.techPool);
        }
    }

    public String toString() {
        return this.cellRevision.toString();
    }

    public AbstractShapeBuilder.Shrinkage getShrinkage() {
        if (this.shrinkage == null) {
            this.shrinkage = new AbstractShapeBuilder.Shrinkage(this);
        }
        return this.shrinkage;
    }

    public ERectangle getPrimitiveBounds() {
        ERectangle primitiveBounds = this.primitiveBounds;
        if (primitiveBounds != null) {
            return primitiveBounds;
        }
        this.primitiveBounds = this.computePrimitiveBounds();
        return this.primitiveBounds;
    }

    public ERectangle computePrimitiveBounds() {
        ERectangle primitiveArcBounds = this.computePrimitiveBoundsOfArcs();
        long gridMinX = Long.MAX_VALUE;
        long gridMinY = Long.MAX_VALUE;
        long gridMaxX = Long.MIN_VALUE;
        long gridMaxY = Long.MIN_VALUE;
        long[] gridCoords = new long[4];
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            PrimitiveNode pn;
            if (!(n.protoId instanceof PrimitiveNodeId) || (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)) == Generic.tech().cellCenterNode) continue;
            if (pn == Generic.tech().invisiblePinNode) {
                boolean found = false;
                Iterator<Variable> it = n.getVariables();
                while (it.hasNext()) {
                    TextDescriptor td;
                    Variable var = it.next();
                    if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            pn.genBounds(n, gridCoords);
            gridMinX = Math.min(gridMinX, gridCoords[0]);
            gridMinY = Math.min(gridMinY, gridCoords[1]);
            gridMaxX = Math.max(gridMaxX, gridCoords[2]);
            gridMaxY = Math.max(gridMaxY, gridCoords[3]);
        }
        if (gridMinX > gridMaxX || gridMinY > gridMaxY) {
            return primitiveArcBounds;
        }
        if (primitiveArcBounds != null) {
            gridMinX = Math.min(gridMinX, primitiveArcBounds.getGridMinX());
            gridMaxX = Math.max(gridMaxX, primitiveArcBounds.getGridMaxX());
            gridMinY = Math.min(gridMinY, primitiveArcBounds.getGridMinY());
            gridMaxY = Math.max(gridMaxY, primitiveArcBounds.getGridMaxY());
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    ERectangle getElibPrimitiveBounds() {
        ERectangle primitiveArcBounds = this.computePrimitiveBoundsOfArcs();
        long gridMinX = Long.MAX_VALUE;
        long gridMinY = Long.MAX_VALUE;
        long gridMaxX = Long.MIN_VALUE;
        long gridMaxY = Long.MIN_VALUE;
        long[] gridCoords = new long[4];
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            PrimitiveNode pn;
            if (!(n.protoId instanceof PrimitiveNodeId) || (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)) == Generic.tech().cellCenterNode) continue;
            if (pn == Generic.tech().invisiblePinNode) {
                boolean found = false;
                Iterator<Variable> it = n.getVariables();
                while (it.hasNext()) {
                    TextDescriptor td;
                    Variable var = it.next();
                    if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            pn.genElibBounds(this, n, gridCoords);
            gridMinX = Math.min(gridMinX, gridCoords[0]);
            gridMinY = Math.min(gridMinY, gridCoords[1]);
            gridMaxX = Math.max(gridMaxX, gridCoords[2]);
            gridMaxY = Math.max(gridMaxY, gridCoords[3]);
        }
        if (gridMinX > gridMaxX || gridMinY > gridMaxY) {
            return primitiveArcBounds;
        }
        if (primitiveArcBounds != null) {
            gridMinX = Math.min(gridMinX, primitiveArcBounds.getGridMinX());
            gridMaxX = Math.max(gridMaxX, primitiveArcBounds.getGridMaxX());
            gridMinY = Math.min(gridMinY, primitiveArcBounds.getGridMinY());
            gridMaxY = Math.max(gridMaxY, primitiveArcBounds.getGridMaxY());
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    private ERectangle computePrimitiveBoundsOfArcs() {
        ImmutableArcInst.Iterable arcs = this.cellRevision.arcs;
        if (arcs.isEmpty()) {
            return null;
        }
        long gridMinX = Long.MAX_VALUE;
        long gridMinY = Long.MAX_VALUE;
        long gridMaxX = Long.MIN_VALUE;
        long gridMaxY = Long.MIN_VALUE;
        long[] gridCoords = new long[4];
        BoundsBuilder boundsBuilder = new BoundsBuilder(this.techPool);
        for (ImmutableArcInst a : arcs) {
            if (boundsBuilder.genBoundsEasy(a, gridCoords)) {
                gridMinX = Math.min(gridMinX, gridCoords[0]);
                gridMinY = Math.min(gridMinY, gridCoords[1]);
                gridMaxX = Math.max(gridMaxX, gridCoords[2]);
                gridMaxY = Math.max(gridMaxY, gridCoords[3]);
                continue;
            }
            boundsBuilder.genShapeOfArc(a);
        }
        ERectangle bounds = boundsBuilder.makeBounds();
        if (bounds != null) {
            gridMinX = Math.min(gridMinX, bounds.getGridMinX());
            gridMinY = Math.min(gridMinY, bounds.getGridMinY());
            gridMaxX = Math.max(gridMaxX, bounds.getGridMaxX());
            gridMaxY = Math.max(gridMaxY, bounds.getGridMaxY());
        }
        assert (gridMinX <= gridMaxX && gridMinY <= gridMaxY);
        long gridW = gridMaxX - gridMinX;
        long gridH = gridMaxY - gridMinY;
        return ERectangle.fromGrid(gridMinX, gridMinY, gridW, gridH);
    }

    public boolean isWiped(ImmutableNodeInst n) {
        if (this.wiped == null) {
            this.wiped = this.makeWiped();
        }
        return this.wiped.get(n.nodeId);
    }

    private BitSet makeWiped() {
        BitSet wiped = new BitSet();
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (!ap.isWipable()) continue;
            wiped.set(a.tailNodeId);
            wiped.set(a.headNodeId);
        }
        for (ImmutableNodeInst n : this.cellRevision.nodes) {
            NodeProtoId np = n.protoId;
            if (np instanceof PrimitiveNodeId && this.techPool.getPrimitiveNode((PrimitiveNodeId)np).isArcsWipe()) continue;
            wiped.clear(n.nodeId);
        }
        return wiped;
    }

    public boolean isHardArc(int arcId) {
        if (this.hardArcs == null) {
            this.hardArcs = this.makeHardArcs();
        }
        return this.hardArcs.get(arcId);
    }

    private BitSet makeHardArcs() {
        BitSet hardArcs = new BitSet();
        for (ImmutableArcInst a : this.cellRevision.arcs) {
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.isEasyShape(a, false)) continue;
            hardArcs.set(a.arcId);
        }
        return hardArcs;
    }
}

