/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.CellId;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.MinArea;
import com.sun.electric.tool.io.input.JELIB2;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import java.io.PrintStream;

public class PublicDebugMenu {
    static EMenuItem makeMenu() {
        return new EMenu("Debug", new EMenu("DRC", new EMenuItem("Check _Minimum Area..."){

            @Override
            public void run() {
                MinArea.checkMinareaLay();
            }
        }, new EMenuItem("Import Minimum Area _Test..."){

            @Override
            public void run() {
                MinArea.readMinareaLay();
            }
        }, new EMenuItem("E_xport Minimum Area Test..."){

            @Override
            public void run() {
                MinArea.writeMinareaLay();
            }
        }), new EMenu("Fast JELIB reader", PublicDebugMenu.jelibItem("Database", true, true, true, true, true), PublicDebugMenu.jelibItem("Snapshot", true, true, true, true, false), PublicDebugMenu.jelibItem("primitiveBounds", true, true, true, false, false), PublicDebugMenu.jelibItem("doBackup", true, true, false, false, false), PublicDebugMenu.jelibItem("instantiate", true, false, false, false, false), PublicDebugMenu.jelibItem("only parse", false, false, false, false, false)), new EMenu("SeaOfGatesRouter", PublicDebugMenu.sogItem("Animation", SeaOfGatesHandlers.Save.SAVE_SNAPSHOTS), PublicDebugMenu.sogItem("Partial-Animation", SeaOfGatesHandlers.Save.SAVE_PERIODIC), PublicDebugMenu.sogItem("Once", SeaOfGatesHandlers.Save.SAVE_ONCE), EMenuItem.SEPARATOR, PublicDebugMenu.sogItem("Dummy on CHANGE", Job.Type.CHANGE), PublicDebugMenu.sogItem("Dummy on SERVER_EXAMINE", Job.Type.SERVER_EXAMINE), PublicDebugMenu.sogItem("Dummy on CLIENT_EXAMINE", Job.Type.CLIENT_EXAMINE), new EMenuItem("Dummy on client"){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell == null) {
                    return;
                }
                PublicDebugMenu.routeIt(cell, UserInterfaceMain.getEditingPreferences(), System.out);
            }
        }, new EMenuItem("Dummy in Thread"){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell == null) {
                    return;
                }
                new SeaOfGatesThread(cell, UserInterfaceMain.getEditingPreferences()).start();
            }
        }));
    }

    private static EMenuItem jelibItem(String text2, final boolean instantiate, final boolean doBackup, final boolean getPrimitiveBounds, final boolean doSnapshot, final boolean doDatabase) {
        return new EMenuItem(text2){

            @Override
            public void run() {
                JELIB2.newJelibReader(instantiate, doBackup, getPrimitiveBounds, doSnapshot, doDatabase);
            }
        };
    }

    private static EMenuItem sogItem(String text2, final SeaOfGatesHandlers.Save save2) {
        return new EMenuItem(text2){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell != null) {
                    SeaOfGatesHandlers.startInJob(cell, null, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion, save2);
                }
            }
        };
    }

    private static EMenuItem sogItem(String text2, final Job.Type jobType) {
        return new EMenuItem(text2){

            @Override
            public void run() {
                Cell cell = Job.getUserInterface().needCurrentCell();
                if (cell != null) {
                    new SeaOfGatesJob(cell, jobType).startJob();
                }
            }
        };
    }

    private static void routeIt(Cell cell, EditingPreferences ep, PrintStream out) {
        SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine();
        SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
        prefs.useParallelRoutes = true;
        router.setPrefs(prefs);
        SeaOfGatesEngine.Handler handler = SeaOfGatesHandlers.getDummy(ep, out);
        router.routeIt(handler, cell);
    }

    private static class SeaOfGatesThread
    extends Thread {
        private final Snapshot snapshot;
        private final CellId cellId;
        private final EditingPreferences ep;

        private SeaOfGatesThread(Cell cell, EditingPreferences ep) {
            this.snapshot = cell.getDatabase().backup();
            this.cellId = cell.getId();
            this.ep = ep;
        }

        @Override
        public void run() {
            EDatabase database = new EDatabase(this.snapshot, "dummy");
            Cell cell = database.getCell(this.cellId);
            PublicDebugMenu.routeIt(cell, this.ep, System.err);
        }
    }

    private static class SeaOfGatesJob
    extends Job {
        private final Cell cell;

        protected SeaOfGatesJob(Cell cell, Job.Type jobType) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), jobType, null, null, Job.Priority.USER);
            this.cell = cell;
        }

        @Override
        public boolean doIt() throws JobException {
            PublicDebugMenu.routeIt(this.cell, this.getEditingPreferences(), System.out);
            return true;
        }
    }
}

