/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.api.minarea.launcher;

import com.sun.electric.api.minarea.LayoutCell;
import com.sun.electric.api.minarea.ManhattanOrientation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DefaultLayoutCell
implements LayoutCell,
Serializable {
    private String name;
    private transient int[] rectCoords = new int[4];
    private int numRectangles = 0;
    private final List<CellInst> subCells = new ArrayList<CellInst>();
    private int boundingMinX;
    private int boundingMinY;
    private int boundingMaxX;
    private int boundingMaxY;
    private transient boolean finished;

    public DefaultLayoutCell(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumRectangles() {
        return this.numRectangles;
    }

    @Override
    public void traverseRectangles(LayoutCell.RectangleHandler h) {
        for (int i = 0; i < this.numRectangles; ++i) {
            int minX = this.rectCoords[i * 4 + 0];
            int minY = this.rectCoords[i * 4 + 1];
            int maxX = this.rectCoords[i * 4 + 2];
            int maxY = this.rectCoords[i * 4 + 3];
            h.apply(minX, minY, maxX, maxY);
        }
    }

    @Override
    public void traverseRectangles(LayoutCell.RectangleHandler h, int offset, int count2) {
        if (offset < 0 || count2 < 0 || count2 > this.numRectangles - offset) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count2; ++i) {
            int minX = this.rectCoords[(i + offset) * 4 + 0];
            int minY = this.rectCoords[(i + offset) * 4 + 1];
            int maxX = this.rectCoords[(i + offset) * 4 + 2];
            int maxY = this.rectCoords[(i + offset) * 4 + 3];
            h.apply(minX, minY, maxX, maxY);
        }
    }

    @Override
    public void readRectangleCoords(int[] result2, int offset, int count2) {
        if (count2 > this.numRectangles - offset) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.rectCoords, offset * 4, result2, 0, count2 * 4);
    }

    @Override
    public int getNumSubcells() {
        return this.subCells.size();
    }

    @Override
    public void traverseSubcellInstances(LayoutCell.SubcellHandler h) {
        for (CellInst ci : this.subCells) {
            h.apply(ci.subCell, ci.anchorX, ci.anchorY, ci.orient);
        }
    }

    @Override
    public void traverseSubcellInstances(LayoutCell.SubcellHandler h, int offset, int count2) {
        if (offset < 0 || count2 < 0 || count2 > this.subCells.size() - offset) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < count2; ++i) {
            CellInst ci = this.subCells.get(offset + i);
            h.apply(ci.subCell, ci.anchorX, ci.anchorY, ci.orient);
        }
    }

    @Override
    public int getBoundingMinX() {
        if (!this.finished) {
            this.computeBoundingBox();
        }
        return this.boundingMinX;
    }

    @Override
    public int getBoundingMinY() {
        if (!this.finished) {
            this.computeBoundingBox();
        }
        return this.boundingMinY;
    }

    @Override
    public int getBoundingMaxX() {
        if (!this.finished) {
            this.computeBoundingBox();
        }
        return this.boundingMaxX;
    }

    @Override
    public int getBoundingMaxY() {
        if (!this.finished) {
            this.computeBoundingBox();
        }
        return this.boundingMaxY;
    }

    private void computeBoundingBox() {
        long lx = Long.MAX_VALUE;
        long ly = Long.MAX_VALUE;
        long hx = Long.MIN_VALUE;
        long hy = Long.MIN_VALUE;
        for (int i = 0; i < this.numRectangles; ++i) {
            lx = Math.min(lx, (long)this.rectCoords[i * 4 + 0]);
            ly = Math.min(ly, (long)this.rectCoords[i * 4 + 1]);
            hx = Math.max(hx, (long)this.rectCoords[i * 4 + 2]);
            hy = Math.max(hy, (long)this.rectCoords[i * 4 + 3]);
        }
        int[] bounds = new int[4];
        for (CellInst ci : this.subCells) {
            long x2 = ci.anchorX;
            long y = ci.anchorY;
            bounds[0] = ci.subCell.getBoundingMinX();
            bounds[1] = ci.subCell.getBoundingMinY();
            bounds[2] = ci.subCell.getBoundingMaxX();
            bounds[3] = ci.subCell.getBoundingMaxY();
            ci.orient.transformRects(bounds, 0, 1);
            lx = Math.min(lx, x2 + (long)bounds[0]);
            ly = Math.min(ly, y + (long)bounds[1]);
            hx = Math.max(hx, x2 + (long)bounds[2]);
            hy = Math.max(hy, y + (long)bounds[3]);
        }
        if (lx <= hx && ly <= hy) {
            if (lx < -1073741823L || hx > 0x3FFFFFFFL || ly < -1073741823L || hy > 0x3FFFFFFFL) {
                throw new IllegalArgumentException("Too large bounding box");
            }
            this.boundingMinX = (int)lx;
            this.boundingMinY = (int)ly;
            this.boundingMaxX = (int)hx;
            this.boundingMaxY = (int)hy;
        }
        this.finished = true;
    }

    public void setName(String name) {
        if (this.finished) {
            throw new IllegalStateException();
        }
        this.name = name;
    }

    public void addRectangle(int minX, int minY, int maxX, int maxY) {
        if (this.finished) {
            throw new IllegalStateException();
        }
        if (minX >= maxX || minY >= maxY) {
            throw new IllegalArgumentException();
        }
        if (this.numRectangles * 4 >= this.rectCoords.length) {
            int[] newRectCoords = new int[this.rectCoords.length * 2];
            System.arraycopy(this.rectCoords, 0, newRectCoords, 0, this.rectCoords.length);
            this.rectCoords = newRectCoords;
        }
        this.rectCoords[this.numRectangles * 4 + 0] = minX;
        this.rectCoords[this.numRectangles * 4 + 1] = minY;
        this.rectCoords[this.numRectangles * 4 + 2] = maxX;
        this.rectCoords[this.numRectangles * 4 + 3] = maxY;
        ++this.numRectangles;
    }

    public void addSubCell(LayoutCell subCell, int anchorX, int anchorY, ManhattanOrientation orient) {
        if (this.finished) {
            throw new IllegalStateException();
        }
        this.subCells.add(new CellInst(subCell, anchorX, anchorY, orient));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rectCoords = new int[this.numRectangles * 4];
        for (int i = 0; i < this.rectCoords.length; ++i) {
            this.rectCoords[i] = in.readInt();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (int i = 0; i < this.numRectangles * 4; ++i) {
            out.writeInt(this.rectCoords[i]);
        }
    }

    private static class CellInst
    implements Serializable {
        private static final long serialVersionUID = -3566544430516331439L;
        private final LayoutCell subCell;
        private final int anchorX;
        private final int anchorY;
        private final ManhattanOrientation orient;

        private CellInst(LayoutCell subCell, int anchorX, int anchorY, ManhattanOrientation orient) {
            this.subCell = subCell;
            this.anchorX = anchorX;
            this.anchorY = anchorY;
            this.orient = orient;
        }
    }
}

