/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BERT;
import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.NanosimDataAnalyzer;
import com.sun.electric.tool.simulation.test.NanosimDataGen;
import com.sun.electric.tool.simulation.test.NanosimModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class NanosimBERT
implements BERT {
    private Set events;
    private NanosimModel model;
    private List modules;

    public NanosimBERT(NanosimModel model) {
        this.model = model;
        this.events = new TreeSet();
        this.modules = new ArrayList();
    }

    @Override
    public BERT.DataModule createDataModule() {
        NanosimDataModule mod = new NanosimDataModule();
        this.modules.add(mod);
        return mod;
    }

    @Override
    public void run(double nanoseconds) {
        double nsStartTime = this.model.getTimeNS();
        this.events = this.getAllEvents(nsStartTime, nsStartTime + nanoseconds);
        double nsCurrentTime = nsStartTime;
        for (Event e : this.events) {
            if (e.eventTimeNS <= nsCurrentTime) {
                e.doIt(this.model);
                continue;
            }
            double waitTime = e.eventTimeNS - nsCurrentTime;
            this.model.waitNS(waitTime);
            nsCurrentTime = this.model.getTimeNS();
            e.doIt(this.model);
        }
        for (NanosimDataModule module : this.modules) {
            Iterator it2 = module.getTerminals();
            while (it2.hasNext()) {
                NanosimTerminal terminal = (NanosimTerminal)it2.next();
                if (!terminal.isEnabled() || !(terminal instanceof NanosimDataAnalyzer)) continue;
                NanosimDataAnalyzer ana = (NanosimDataAnalyzer)terminal;
                ana.printCapturedData();
            }
        }
    }

    @Override
    public void runMinutes(double minutes) {
        System.out.println("The Nanosim BERT does not support run(minutes) because it would never finish.");
    }

    private Set getAllEvents(double nsStartTime, double nsEndTime) {
        TreeSet set = new TreeSet();
        for (NanosimDataModule module : this.modules) {
            Iterator it2 = module.getTerminals();
            while (it2.hasNext()) {
                NanosimTerminal terminal = (NanosimTerminal)it2.next();
                if (!terminal.isEnabled()) continue;
                if (terminal instanceof NanosimDataAnalyzer) {
                    NanosimDataAnalyzer ana = (NanosimDataAnalyzer)terminal;
                    ana.clearCapturedData();
                }
                Set modevents = terminal.generateEvents(nsStartTime, nsEndTime);
                set.addAll(modevents);
            }
        }
        return set;
    }

    public static void main(String[] args) {
        NanosimModel model = new NanosimModel();
        NanosimBERT bert = new NanosimBERT(model);
        BERT.DataModule module = bert.createDataModule();
        module.setFrequency(1000000.0);
        BERT.DataGenerator gen = module.createDataGenerator();
        gen.setDelay(0.0);
        gen.addPinName("testpin");
        gen.addPinName("testpin2");
        gen.setPattern(new BitVector("1011101", ""), new BitVector("110100100", ""));
        BERT.DataAnalyzer ana = module.createDataAnalyzer();
        ana.setDelay(0, 0.1);
        ana.setPinName("testpinOut");
        ana.measureBER(gen);
        double time = 30.0;
        System.out.println("Events, time " + time + "ns:");
        NanosimBERT.printEvents(bert.getAllEvents(0.0, time));
        gen.setDelay(0.5);
        ana.setDelay(1, 0.5);
        System.out.println("-----------------------------------");
        System.out.println("Events, time " + time + "ns: with delay 0.5 gen, 1.5 ana");
        NanosimBERT.printEvents(bert.getAllEvents(0.0, time));
    }

    static void printEvents(Set set) {
        for (Event e : set) {
            System.out.println(e);
        }
    }

    public static class Event
    implements Comparable {
        private final Double eventTimeNS;
        private final int type;
        private final String node;
        private final double voltage;
        private final int state;
        private final NanosimDataAnalyzer analyzer;
        private static final int TYPE_CAPTURENODE = 1;
        private static final int TYPE_CAPTUREANDCHECKNODE = 2;
        private static final int TYPE_SETNODE = 3;

        protected static Event createSetNodeEvent(double eventTimeNS, String node, double voltage) {
            return new Event(eventTimeNS, 3, node, 0, voltage, null);
        }

        protected static Event createCaptureNodeEvent(double eventTimeNS, String node, NanosimDataAnalyzer analyzer) {
            return new Event(eventTimeNS, 1, node, 0, 0.0, analyzer);
        }

        protected static Event createCaptureAndCheckNodeEvent(double eventTimeNS, String node, int expectedState, NanosimDataAnalyzer analyzer) {
            return new Event(eventTimeNS, 2, node, expectedState, 0.0, analyzer);
        }

        private Event(double eventTimeNS, int type, String node, int state, double voltage, NanosimDataAnalyzer capturer) {
            this.eventTimeNS = new Double(eventTimeNS);
            this.type = type;
            this.node = node;
            this.state = state;
            this.voltage = voltage;
            this.analyzer = capturer;
        }

        private void doIt(NanosimModel model) {
            switch (this.type) {
                case 3: {
                    model.setNodeVoltage(this.node, this.voltage);
                    return;
                }
                case 1: {
                    this.captureNode(model);
                    return;
                }
                case 2: {
                    int curState = this.captureNode(model);
                    if (curState != this.state) {
                        System.out.println("Check Node from BERT Data Analyzer on pin '" + this.analyzer.getPinName() + "' failed @ sim time=" + this.eventTimeNS + "ns, expected " + this.state + " but was " + curState);
                        this.analyzer.logError();
                    }
                    return;
                }
            }
        }

        private int captureNode(NanosimModel model) {
            double curState = model.getNodeVoltage(this.node);
            int state = this.analyzer.voltageToState(curState);
            if (state == -1) {
                System.out.println("Error: analyzer captured node on pin " + this.analyzer.getPinName() + " of voltage " + curState + " at time " + this.eventTimeNS + "ns, which is not a valid low or high value.");
                state = 0;
            }
            boolean b = state == 1;
            this.analyzer.captureBit(b);
            return state;
        }

        public int compareTo(Object o) {
            Event otherEvent = (Event)o;
            int compare = this.eventTimeNS.compareTo(otherEvent.eventTimeNS);
            if (compare == 0) {
                Integer me = new Integer(this.type);
                Integer other = new Integer(otherEvent.type);
                compare = me.compareTo(other);
                if (compare == 0) {
                    return this.node.compareTo(otherEvent.node);
                }
                return compare;
            }
            return compare;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Event @ ");
            buf.append(this.eventTimeNS + "ns: ");
            switch (this.type) {
                case 3: {
                    buf.append("set node " + this.node + " to " + this.state);
                    break;
                }
                case 1: {
                    buf.append("capture node " + this.node);
                    break;
                }
                case 2: {
                    buf.append("capture node " + this.node + ", check it is " + this.state);
                }
            }
            return buf.toString();
        }

        public boolean equals(Object o) {
            return this.eventTimeNS.equals(o);
        }
    }

    public static abstract class NanosimTerminal
    implements BERT.Terminal {
        private NanosimDataModule parent;
        private boolean enabled;

        protected NanosimTerminal(NanosimDataModule parent) {
            this.parent = parent;
            this.enabled = true;
        }

        public abstract Set generateEvents(double var1, double var3);

        @Override
        public BERT.DataModule getParentModule() {
            return this.parent;
        }

        @Override
        public void setEnabled(boolean enable) {
            this.enabled = enable;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class NanosimDataModule
    implements BERT.DataModule {
        private double period = 1.0;
        private List terminals = new ArrayList();

        @Override
        public BERT.DataGenerator createDataGenerator() {
            NanosimDataGen gen = new NanosimDataGen(this);
            this.terminals.add(gen);
            return gen;
        }

        @Override
        public BERT.DataAnalyzer createDataAnalyzer() {
            NanosimDataAnalyzer ana = new NanosimDataAnalyzer(this);
            this.terminals.add(ana);
            return ana;
        }

        @Override
        public void setFrequency(double freqKHz) {
            this.period = 1.0 / freqKHz * 1000000.0;
        }

        @Override
        public double getFrequency() {
            return 1.0 / this.period * 1000000.0;
        }

        @Override
        public double getPeriod() {
            return this.period;
        }

        protected Iterator getTerminals() {
            return this.terminals.iterator();
        }
    }
}

