/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.general;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.general.RowCol;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;

public class SARowCol
extends RowCol {
    protected PlacementFrame.PlacementParameter numThreadsParam = new PlacementFrame.PlacementParameter((PlacementFrame)this, "threads", "Number of threads:", 4);
    protected PlacementFrame.PlacementParameter maxRuntimeParam = new PlacementFrame.PlacementParameter((PlacementFrame)this, "runtime", "Runtime (in seconds, 0 for no limit):", 240);
    protected PlacementFrame.PlacementParameter flipAlternateColsRows = new PlacementFrame.PlacementParameter((PlacementFrame)this, "flipColRow", "Flip alternate columns/rows", true);
    protected PlacementFrame.PlacementParameter makeStacksEven = new PlacementFrame.PlacementParameter((PlacementFrame)this, "makeStacksEven", "Force rows/columns to be equal length", true);
    private double temperature;
    private long timestampStart;
    private int stepsPerUpdate;
    private int numTemperatureSteps;
    private int numStepsDone;
    private int better;
    private int worse;
    private int worseAccepted;

    @Override
    public String getAlgorithmName() {
        return "Simulated-Annealing-Row/Col";
    }

    @Override
    public boolean runRowColPlacement(List<PlacementFrame.PlacementNode> placementNodes, List<PlacementFrame.PlacementNetwork> allNetworks) {
        int threadCount = this.numThreadsParam.getIntValue();
        if (threadCount >= this.numStacks / 2) {
            threadCount = this.numStacks / 2 - 1;
            if (threadCount <= 0) {
                threadCount = 1;
            }
            System.out.println("Note: Using only " + threadCount + " threads");
        }
        this.setParamterValues(threadCount, this.maxRuntimeParam.getIntValue());
        this.stepsPerUpdate = (int)Math.sqrt(this.nodesToPlace.size());
        this.temperature = 2000.0;
        this.numTemperatureSteps = this.countTemperatureSteps(this.temperature);
        this.numStepsDone = 0;
        this.timestampStart = System.currentTimeMillis();
        this.worseAccepted = 0;
        this.worse = 0;
        this.better = 0;
        SimulatedAnnealing[] threads = new SimulatedAnnealing[this.numOfThreads];
        for (int n = 0; n < this.numOfThreads; ++n) {
            threads[n] = new SimulatedAnnealing();
            threads[n].start();
        }
        for (int i = 0; i < this.numOfThreads; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        DecimalFormat formater = new DecimalFormat("###,###,###");
        String betterStr = formater.format(this.better);
        String worseStr = formater.format(this.worse);
        String worseAcceptedStr = formater.format(this.worseAccepted);
        System.out.println("Made " + betterStr + " moves that improve results, " + worseStr + " moves that worsened it (and " + worseAcceptedStr + " were accepted)");
        return true;
    }

    private int countTemperatureSteps(double startingTemperature) {
        double temp = startingTemperature;
        int steps = 0;
        while (temp > 1.0) {
            ++steps;
            temp = this.coolDown(temp);
        }
        return steps;
    }

    private double coolDown(double temp) {
        return temp * 0.99 - 0.1;
    }

    private void update() {
        if (this.runtime > 0) {
            long elapsedTime = System.currentTimeMillis() - this.timestampStart;
            double fractionDone = (double)elapsedTime / ((double)this.runtime * 1000.0);
            int stepsToDo = (int)((double)this.numTemperatureSteps * fractionDone);
            while (this.numStepsDone < stepsToDo) {
                this.temperature = this.coolDown(this.temperature);
                ++this.numStepsDone;
            }
        } else {
            this.temperature = this.coolDown(this.temperature);
        }
    }

    class SimulatedAnnealing
    extends Thread {
        Random rand = new Random();

        SimulatedAnnealing() {
        }

        @Override
        public void run() {
            while (SARowCol.this.temperature > 1.0) {
                for (int step = 0; step < SARowCol.this.stepsPerUpdate; ++step) {
                    int newIndex;
                    int oldIndex;
                    RowCol.ProxyNode node = null;
                    int r = this.rand.nextInt(SARowCol.this.numStacks);
                    if (r == 0) {
                        while (true) {
                            if ((oldIndex = SARowCol.this.lockRandomStack()) < 0) {
                                continue;
                            }
                            if (SARowCol.this.stackContents[oldIndex].size() > 1) break;
                            SARowCol.this.releaseStack(oldIndex);
                        }
                        newIndex = oldIndex;
                        node = SARowCol.this.getRandomNode(oldIndex);
                    } else {
                        boolean doSwap;
                        while (true) {
                            if ((oldIndex = SARowCol.this.lockRandomStack()) < 0) {
                                continue;
                            }
                            newIndex = SARowCol.this.lockRandomStack();
                            if (newIndex < 0) {
                                SARowCol.this.releaseStack(oldIndex);
                                continue;
                            }
                            if (SARowCol.this.stackContents[oldIndex].size() > 1 && SARowCol.this.stackContents[newIndex].size() > 1) break;
                            SARowCol.this.releaseStack(oldIndex);
                            SARowCol.this.releaseStack(newIndex);
                        }
                        node = SARowCol.this.getRandomNode(oldIndex);
                        boolean bl = doSwap = SARowCol.this.stackSizes[newIndex] > SARowCol.this.stackSizes[oldIndex];
                        if (doSwap) {
                            int swap = oldIndex;
                            oldIndex = newIndex;
                            newIndex = swap;
                            node = SARowCol.this.getRandomNode(oldIndex);
                        }
                    }
                    int newPlaceInStack = this.rand.nextInt(SARowCol.this.stackContents[newIndex].size() + 1);
                    if (newIndex == oldIndex && SARowCol.this.stackContents[newIndex].size() >= 2) {
                        int oldPlaceInStack = SARowCol.this.stackContents[oldIndex].indexOf(node);
                        while (true) {
                            if (oldPlaceInStack < newPlaceInStack) {
                                --newPlaceInStack;
                            }
                            if (SARowCol.this.stackContents[newIndex].get(newPlaceInStack) != node) break;
                            newPlaceInStack = this.rand.nextInt(SARowCol.this.stackContents[newIndex].size() + 1);
                        }
                    }
                    double networkMetricBefore = 0.0;
                    for (PlacementFrame.PlacementNetwork net : node.getNets()) {
                        networkMetricBefore += SARowCol.this.netLength(net, -1, -1);
                    }
                    SARowCol.this.proposeMove(node, oldIndex, newIndex, newPlaceInStack);
                    double networkMetricAfter = 0.0;
                    for (PlacementFrame.PlacementNetwork net : node.getNets()) {
                        networkMetricAfter += SARowCol.this.netLength(net, newIndex, oldIndex);
                    }
                    double gain = networkMetricBefore - networkMetricAfter;
                    if (gain < 0.0) {
                        SARowCol.this.worse++;
                    } else {
                        SARowCol.this.better++;
                    }
                    if (gain > 0.0 || Math.exp(gain / SARowCol.this.temperature) >= Math.random()) {
                        if (gain < 0.0) {
                            SARowCol.this.worseAccepted++;
                        }
                        SARowCol.this.implementMove(node, oldIndex, newIndex, newPlaceInStack);
                    }
                    SARowCol.this.releaseStack(oldIndex);
                    if (newIndex == oldIndex) continue;
                    SARowCol.this.releaseStack(newIndex);
                }
                SARowCol.this.update();
            }
        }
    }
}

