/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.MutableSignal;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class EpicOut
extends Input<Stimuli> {
    private Pattern whiteSpace = Pattern.compile("[ \t]+");
    private static final char separator = '.';
    private List<Signal<ScalarSample>> signalsByEpicIndex;
    private Set<Integer> currentSignals;

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        ArrayList<String> outFiles = new ArrayList<String>();
        outFiles.add(fileURL.getPath());
        String fileNameNoPath = TextUtils.getFileNameWithoutExtension(TextUtils.URLtoString(fileURL)) + "_";
        String topDirName = TextUtils.getFilePath(fileURL);
        File topDir = new File(topDirName);
        String[] fileList = topDir.list();
        for (int i = 0; i < fileList.length; ++i) {
            String newFile;
            if (!fileList[i].startsWith(fileNameNoPath) || !fileList[i].endsWith(".out") || outFiles.contains(newFile = topDirName + fileList[i])) continue;
            outFiles.add(newFile);
        }
        Collections.sort(outFiles, TextUtils.STRING_NUMBER_ORDER);
        if (outFiles.size() > 1) {
            System.out.println("Reading " + outFiles.size() + " files...");
        }
        sd.setNetDelimiter(" ");
        boolean first = true;
        for (String fileName : outFiles) {
            URL fURL = TextUtils.makeURLToFile(fileName);
            if (this.openTextInput(fURL)) {
                return sd;
            }
            System.out.println("Reading Epic output file: " + fileName);
            EpicOut.startProgressDialog("Epic output", fileName);
            this.readEpicFile(fileName, cell, sd, first);
            first = false;
            EpicOut.stopProgressDialog();
            this.closeInput();
        }
        return sd;
    }

    private void readEpicFile(String fileName, Cell cell, Stimuli sd, boolean first) throws IOException {
        String line;
        SignalCollection sc;
        double curTime = 0.0;
        if (first) {
            this.signalsByEpicIndex = new ArrayList<Signal<ScalarSample>>();
            this.currentSignals = new HashSet<Integer>();
            sc = Stimuli.newSignalCollection(sd, "TRANS SIGNALS");
        } else {
            sc = sd.findSignalCollection("TRANS SIGNALS");
        }
        double timeResolution = 1.0;
        double voltageResolution = 1.0;
        double currentResolution = 1.0;
        while ((line = this.getLine()) != null) {
            String[] split2;
            char ch;
            this.updateProgressDialog(line.length() + 1);
            if (line.length() == 0 || (ch = line.charAt(0)) == ';' || Character.isSpaceChar(ch)) continue;
            if (ch == '.') {
                split2 = this.whiteSpace.split(line);
                if (split2[0].equals(".index") && split2.length == 4) {
                    Signal<ScalarSample> s;
                    boolean isCurrent;
                    String name = split2[1];
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    } else if (name.startsWith("i1(") && name.endsWith(")")) {
                        name = name.substring(3, name.length() - 1);
                    }
                    String context = null;
                    String wholeName = name;
                    int sepPos = name.lastIndexOf(46);
                    if (sepPos >= 0) {
                        context = name.substring(0, sepPos);
                        name = name.substring(sepPos + 1);
                    }
                    int sigNum = TextUtils.atoi(split2[2]);
                    if (split2[3].equals("v")) {
                        isCurrent = false;
                    } else if (split2[3].equals("i")) {
                        isCurrent = true;
                    } else {
                        System.out.println("Error in line " + this.lineReader.getLineNumber() + ": Unknown waveform type: " + line);
                        break;
                    }
                    if (first) {
                        while (this.signalsByEpicIndex.size() <= sigNum) {
                            this.signalsByEpicIndex.add(null);
                        }
                        s = this.signalsByEpicIndex.get(sigNum);
                        if (s != null) continue;
                        s = ScalarSample.createSignal(sc, sd, name, context);
                        this.signalsByEpicIndex.set(sigNum, s);
                        if (!isCurrent) continue;
                        this.currentSignals.add(sigNum);
                        continue;
                    }
                    s = this.signalsByEpicIndex.get(sigNum);
                    if (s == null) {
                        System.out.println("WARNING: File " + fileName + " has unknown signal " + sigNum);
                        continue;
                    }
                    boolean nameSame = name.equals(s.getSignalName());
                    if (context != null) {
                        nameSame &= context.equals(s.getSignalContext());
                    }
                    if (nameSame) continue;
                    System.out.println("WARNING: File " + fileName + " signal " + sigNum + " is called '" + wholeName + "' but in an earlier file is called '" + s.getFullName() + "'");
                    continue;
                }
                if (split2[0].equals(".time_resolution") && split2.length == 2) {
                    timeResolution = TextUtils.atof(split2[1]) * 1.0E-9;
                    continue;
                }
                if (split2[0].equals(".current_resolution") && split2.length == 2) {
                    currentResolution = TextUtils.atof(split2[1]);
                    continue;
                }
                if (split2[0].equals(".voltage_resolution") && split2.length == 2) {
                    voltageResolution = TextUtils.atof(split2[1]);
                    continue;
                }
                if (split2[0].equals(".vdd") && split2.length == 2 || split2[0].equals(".simulation_time") && split2.length == 2 || split2[0].equals(".high_threshold") && split2.length == 2 || split2[0].equals(".low_threshold") && split2.length == 2 || split2[0].equals(".nnodes") && split2.length == 2 || split2[0].equals(".nelems") && split2.length == 2 || split2[0].equals(".extra_nodes") && split2.length == 2 || split2[0].equals(".bus_notation") && split2.length == 4 || split2[0].equals(".hier_separator") && split2.length == 2 || split2[0].equals(".case") && split2.length == 2) continue;
                System.out.println("Error in line " + this.lineReader.getLineNumber() + ": Unrecognized Epic command: " + line);
                break;
            }
            if (ch >= '0' && ch <= '9') {
                long num;
                split2 = this.whiteSpace.split(line);
                if (split2.length > 1) {
                    int num2 = TextUtils.atoi(split2[0]);
                    double value2 = TextUtils.atof(split2[1]);
                    value2 = this.currentSignals.contains(num2) ? (value2 *= currentResolution) : (value2 *= voltageResolution);
                    MutableSignal s = (MutableSignal)this.signalsByEpicIndex.get(num2);
                    if (s == null) {
                        System.out.println("Error in line " + this.lineReader.getLineNumber() + ": Signal " + num2 + " not defined");
                        break;
                    }
                    try {
                        s.addSample(curTime, new ScalarSample(value2));
                    }
                    catch (RuntimeException e) {}
                    continue;
                }
                try {
                    num = Long.parseLong(split2[0]);
                }
                catch (NumberFormatException e) {
                    num = 0L;
                }
                curTime = (double)num * timeResolution;
                continue;
            }
            System.out.println("Error in line " + this.lineReader.getLineNumber() + ": Unrecognized Epic line: " + line);
            break;
        }
    }
}

