/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.threadpool;

import scala.actors.threadpool.AbstractExecutorService;
import scala.actors.threadpool.BlockingQueue;
import scala.actors.threadpool.Callable;
import scala.actors.threadpool.CompletionService;
import scala.actors.threadpool.Executor;
import scala.actors.threadpool.Future;
import scala.actors.threadpool.FutureTask;
import scala.actors.threadpool.LinkedBlockingQueue;
import scala.actors.threadpool.RunnableFuture;
import scala.actors.threadpool.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final AbstractExecutorService aes;
    private final BlockingQueue completionQueue;

    private RunnableFuture newTaskFor(Callable callable) {
        if (this.aes == null) {
            return new FutureTask(callable);
        }
        return this.aes.newTaskFor(callable);
    }

    private RunnableFuture newTaskFor(Runnable runnable, Object object) {
        if (this.aes == null) {
            return new FutureTask(runnable, object);
        }
        return this.aes.newTaskFor(runnable, object);
    }

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue blockingQueue) {
        if (executor == null || blockingQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.aes = executor instanceof AbstractExecutorService ? (AbstractExecutorService)executor : null;
        this.completionQueue = blockingQueue;
    }

    public Future submit(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(callable);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    public Future submit(Runnable runnable, Object object) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        RunnableFuture runnableFuture = this.newTaskFor(runnable, object);
        this.executor.execute(new QueueingFuture(runnableFuture));
        return runnableFuture;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return (Future)this.completionQueue.poll(l, timeUnit);
    }

    private class QueueingFuture
    extends FutureTask {
        private final Future task;

        QueueingFuture(RunnableFuture runnableFuture) {
            super(runnableFuture, null);
            this.task = runnableFuture;
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this.task);
        }
    }
}

