/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.AbstractDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.redisplay.VectorDrawing;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ElectricPrinter;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.util.concurrent.utils.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixelDrawing {
    public static final int MINIMUMTEXTSIZE = 5;
    public static final int MAXIMUMTEXTSIZE = 100;
    public static final int SINGLETONSTOADD = 5;
    private static final boolean TAKE_STATS = true;
    private static int tinyCells;
    private static int tinyPrims;
    private static int totalCells;
    private static int renderedCells;
    private static int totalPrims;
    private static int tinyArcs;
    private static int linedArcs;
    private static int totalArcs;
    private static int offscreensCreated;
    private static int offscreenPixelsCreated;
    private static int offscreensUsed;
    private static int offscreenPixelsUsed;
    private static int cellsRendered;
    private static final boolean DEBUGRENDERTIMING = false;
    private ElapseTimer textTimer = ElapseTimer.createInstance();
    private ElapseTimer polyTimer = ElapseTimer.createInstance();
    private final Dimension sz;
    private double scale;
    private VarContext varContext = VarContext.globalContext;
    private double originX;
    private double originY;
    private int nowPrinting;
    private Rectangle2D drawBounds;
    boolean highlightingLayers;
    private boolean lastFullInstantiate = false;
    private List<NodeInst> inPlaceNodePath;
    private boolean canDrawText;
    private static double maxObjectSize;
    private static double halfMaxObjectSize;
    private final Point tempPt1 = new Point();
    private final Point tempPt2 = new Point();
    private final Point tempPt3 = new Point();
    private final Point tempPt4 = new Point();
    private final BufferedImage img;
    private final int[] opaqueData;
    private final int total;
    private int backgroundColor;
    private int backgroundValue;
    private HashMap<PrimitivePort, EGraphics> portGraphicsCache = new HashMap();
    private byte[][][] layerBitMaps;
    private byte[][] compositeRows;
    int numLayerBitMaps;
    private Color[] trueColorMap;
    private final int numBytesPerRow;
    private int numLayerBitMapsCreated;
    private Technology curTech;
    private Map<Layer, PatternedOpaqueLayer> patternedOpaqueLayers = new HashMap<Layer, PatternedOpaqueLayer>();
    private boolean renderedWindow;
    private boolean periodicRefresh;
    private int objectCount;
    private long lastRefreshTime;
    private EditWindow0 wnd;
    private static Dimension topSz;
    private static Map<ExpandedCellKey, ExpandedCellInfo> expandedCells;
    private static final Set<CellId> changedCells;
    private static double expandedScale;
    private static int numberToReconcile;
    private static final Rectangle2D CENTERRECT;
    static GraphicsPreferences gp;
    static AbstractDrawing.DrawingPreferences dp;
    static LayerVisibility lv;
    static EGraphics textGraphics;
    private static EGraphics gridGraphics;
    static EGraphics instanceGraphics;
    private int clipLX;
    private int clipHX;
    private int clipLY;
    private int clipHY;
    private final EditWindow0 dummyWnd = new EditWindow0(){

        public VarContext getVarContext() {
            return PixelDrawing.this.varContext;
        }

        public double getScale() {
            return PixelDrawing.this.scale;
        }

        public double getGlobalTextScale() {
            return PixelDrawing.this.wnd == null ? User.getGlobalTextScale() : PixelDrawing.this.wnd.getGlobalTextScale();
        }

        public String getDefaultFont() {
            return PixelDrawing.this.wnd == null ? User.getDefaultFont() : PixelDrawing.this.wnd.getDefaultFont();
        }
    };
    private double[] hsvTempArray = new double[3];
    private int textImageWidth = 0;
    private int textImageHeight = 0;
    private BufferedImage textImage = null;
    private Graphics2D textImageGraphics;
    private boolean[] arcOctTable = new boolean[9];
    private Point arcCenter;
    private int arcRadius;
    private int arcCol;
    private byte[][] arcLayerBitMap;
    private boolean arcThick;

    public PixelDrawing(Dimension sz) {
        this.sz = new Dimension(sz);
        this.clipLX = 0;
        this.clipHX = sz.width - 1;
        this.clipLY = 0;
        this.clipHY = sz.height - 1;
        this.img = new BufferedImage(sz.width, sz.height, 1);
        WritableRaster raster = this.img.getRaster();
        DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
        this.opaqueData = dbi.getData();
        this.total = sz.height * sz.width;
        this.numBytesPerRow = (sz.width + 7) / 8;
        this.renderedWindow = true;
    }

    public PixelDrawing(double scale, Rectangle screenBounds) {
        this.scale = scale;
        this.originX = -screenBounds.x;
        this.originY = screenBounds.y + screenBounds.height;
        this.sz = new Dimension(screenBounds.width, screenBounds.height);
        this.clipLX = 0;
        this.clipHX = this.sz.width - 1;
        this.clipLY = 0;
        this.clipHY = this.sz.height - 1;
        this.img = null;
        this.total = this.sz.height * this.sz.width;
        this.opaqueData = new int[this.total];
        this.numBytesPerRow = (this.sz.width + 7) / 8;
        this.clearImage(null, null);
    }

    void initOrigin(double scale, double offx, double offy) {
        this.scale = scale;
        this.originX = (double)(this.sz.width / 2) - offx * scale;
        this.originY = (double)(this.sz.height / 2) + offy * scale;
    }

    void initDrawing(double scale) {
        this.clearImage(null, null);
        this.initOrigin(scale, 0.0, 0.0);
    }

    public void setPrintingMode(int mode) {
        this.nowPrinting = mode;
    }

    public void setBackgroundColor(Color bg) {
        this.backgroundColor = bg.getRGB() & 0xFFFFFF;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }

    int[] getOpaqueData() {
        return this.opaqueData;
    }

    public Dimension getSize() {
        return this.sz;
    }

    public static void clearSubCellCache() {
        expandedCells = new HashMap<ExpandedCellKey, ExpandedCellInfo>();
    }

    public void setWindow(EditWindow0 wnd) {
        this.wnd = wnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImage(Drawing drawing, boolean fullInstantiate, Rectangle2D drawLimitBounds, boolean isPixelDrawing, double greekSizeLimit, double greekCellSizeLimit) {
        HashSet<CellId> changedCellsCopy;
        long initialUsed = 0L;
        ElapseTimer timer = ElapseTimer.createInstance();
        timer.start();
        initialUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        totalArcs = 0;
        linedArcs = 0;
        tinyArcs = 0;
        totalPrims = 0;
        renderedCells = 0;
        totalCells = 0;
        tinyPrims = 0;
        tinyCells = 0;
        cellsRendered = 0;
        offscreenPixelsUsed = 0;
        offscreensUsed = 0;
        offscreenPixelsCreated = 0;
        offscreensCreated = 0;
        if (fullInstantiate != this.lastFullInstantiate) {
            PixelDrawing.clearSubCellCache();
            this.lastFullInstantiate = fullInstantiate;
        }
        EditWindow wnd = drawing.wnd;
        Cell cell = wnd.getInPlaceEditTopCell();
        this.inPlaceNodePath = wnd.getInPlaceEditNodePath();
        textGraphics = textGraphics.withColor(gp.getColor(User.ColorPrefType.TEXT));
        gridGraphics = gridGraphics.withColor(gp.getColor(User.ColorPrefType.GRID));
        instanceGraphics = instanceGraphics.withColor(gp.getColor(User.ColorPrefType.INSTANCE));
        this.portGraphicsCache.clear();
        if (expandedScale != drawing.da.scale) {
            PixelDrawing.clearSubCellCache();
            expandedScale = drawing.da.scale;
        }
        this.varContext = wnd.getVarContext();
        this.initOrigin(expandedScale, drawing.da.offX, drawing.da.offY);
        this.canDrawText = expandedScale > 1.0;
        maxObjectSize = 2.0 / expandedScale;
        halfMaxObjectSize = maxObjectSize / 2.0;
        double width = (double)this.sz.width / this.scale;
        double height = (double)this.sz.height / this.scale;
        this.drawBounds = new Rectangle2D.Double(drawing.da.offX - width / 2.0, drawing.da.offY - height / 2.0, width, height);
        topSz = this.sz;
        lv = wnd.getLayerVisibility();
        this.highlightingLayers = false;
        Iterator<Layer> it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!lv.isHighlighted(layer)) continue;
            this.highlightingLayers = true;
            break;
        }
        Rectangle renderBounds = null;
        if (drawLimitBounds != null) {
            renderBounds = this.databaseToScreen(drawLimitBounds);
            this.clipLX = Math.max(renderBounds.x, 0);
            this.clipHX = Math.min(renderBounds.x + renderBounds.width, this.sz.width) - 1;
            this.clipLY = Math.max(renderBounds.y, 0);
            this.clipHY = Math.min(renderBounds.y + renderBounds.height, this.sz.height) - 1;
        } else {
            this.clipLX = 0;
            this.clipHX = this.sz.width - 1;
            this.clipLY = 0;
            this.clipHY = this.sz.height - 1;
        }
        this.clearImage(renderBounds, cell);
        this.periodicRefresh = true;
        this.wnd = wnd;
        this.objectCount = 0;
        this.lastRefreshTime = System.currentTimeMillis();
        Set<CellId> set = changedCells;
        synchronized (set) {
            changedCellsCopy = new HashSet<CellId>(changedCells);
            changedCells.clear();
        }
        PixelDrawing.forceRedraw(changedCellsCopy);
        VectorCache.theCache.forceRedraw();
        if (isPixelDrawing) {
            numberToReconcile = 5;
            for (ExpandedCellInfo count2 : expandedCells.values()) {
                count2.instanceCount = 0;
            }
            this.countCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, DBMath.MATID);
            this.drawCell(cell, drawLimitBounds, fullInstantiate, Orientation.IDENT, DBMath.MATID, wnd.getCell());
        } else {
            drawing.vd.render(this, this.scale, new Point2D.Double(drawing.da.offX, drawing.da.offY), cell, fullInstantiate, this.inPlaceNodePath, wnd.getCell(), renderBounds, this.varContext, greekSizeLimit, greekCellSizeLimit, lv);
        }
        BufferedImage i$ = this.img;
        synchronized (i$) {
            if (cell != null && wnd.isGrid()) {
                this.drawGrid(wnd, drawing.da);
            }
            this.composite(renderBounds);
        }
        if (isPixelDrawing) {
            timer.end();
            long curUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            long memConsumed = curUsed - initialUsed;
            System.out.println("Took " + timer + ", rendered " + cellsRendered + " cells, used " + offscreensUsed + " (" + offscreenPixelsUsed + " pixels) cached cells, created " + offscreensCreated + " (" + offscreenPixelsCreated + " pixels) new cell caches (my size is " + this.total + " pixels), memory used=" + memConsumed);
            System.out.println("   Cells (" + totalCells + ") " + tinyCells + " are tiny;" + " Primitives (" + totalPrims + ") " + tinyPrims + " are tiny;" + " Arcs (" + totalArcs + ") " + tinyArcs + " are tiny, " + linedArcs + " are lines");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printImage(double scale, Point2D offset, Cell cell, VarContext varContext, ElectricPrinter ep) {
        HashSet<CellId> changedCellsCopy;
        Object layer;
        gp = ep.getGraphicsPreferences();
        PixelDrawing.clearSubCellCache();
        this.lastFullInstantiate = false;
        expandedScale = this.scale = scale;
        textGraphics = textGraphics.withColor(gp.getColor(User.ColorPrefType.TEXT));
        gridGraphics = gridGraphics.withColor(gp.getColor(User.ColorPrefType.GRID));
        instanceGraphics = instanceGraphics.withColor(gp.getColor(User.ColorPrefType.INSTANCE));
        this.portGraphicsCache.clear();
        if (this.wnd != null) {
            varContext = this.wnd.getVarContext();
        }
        this.initOrigin(scale, offset.getX(), offset.getY());
        this.canDrawText = expandedScale > 1.0;
        maxObjectSize = 2.0 / expandedScale;
        halfMaxObjectSize = maxObjectSize / 2.0;
        topSz = this.sz;
        this.highlightingLayers = false;
        Iterator<Layer> it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            layer = it.next();
            if (!lv.isHighlighted((Layer)layer)) continue;
            this.highlightingLayers = true;
            break;
        }
        this.clipLX = 0;
        this.clipHX = this.sz.width - 1;
        this.clipLY = 0;
        this.clipHY = this.sz.height - 1;
        this.clearImage(null, cell);
        layer = changedCells;
        synchronized (layer) {
            changedCellsCopy = new HashSet<CellId>(changedCells);
            changedCells.clear();
        }
        PixelDrawing.forceRedraw(changedCellsCopy);
        VectorCache.theCache.forceRedraw();
        if (ep.getDisplayAlgorithm() == 0) {
            numberToReconcile = 5;
            for (ExpandedCellInfo count2 : expandedCells.values()) {
                count2.instanceCount = 0;
            }
            this.countCell(cell, null, false, Orientation.IDENT, DBMath.MATID);
            this.drawCell(cell, null, false, Orientation.IDENT, DBMath.MATID, cell);
        } else {
            VectorDrawing vd = new VectorDrawing(ep.isUseCellGreekingImages());
            vd.render(this, scale, offset, cell, false, null, null, null, varContext, ep.getGreekSizeLimit(), ep.getGreekCellSizeLimit(), lv);
        }
        BufferedImage bufferedImage = this.img;
        synchronized (bufferedImage) {
            this.composite(null);
        }
    }

    public void clearImage(Rectangle bounds, Cell cell) {
        this.initForTechnology(cell);
        this.backgroundValue = gp.getColor(User.ColorPrefType.BACKGROUND).getRGB();
        this.backgroundColor = this.backgroundValue & 0xFFFFFF;
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            byte[][] layerBitMap = this.layerBitMaps[i];
            if (layerBitMap == null) continue;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        assert (this.patternedOpaqueLayers.isEmpty());
        for (PatternedOpaqueLayer pol : this.patternedOpaqueLayers.values()) {
            byte[][] layerBitMap = pol.layerBitMap;
            for (int y = 0; y < this.sz.height; ++y) {
                byte[] row = layerBitMap[y];
                for (int x = 0; x < this.numBytesPerRow; ++x) {
                    row[x] = 0;
                }
            }
        }
        if (bounds == null) {
            for (int i = 0; i < this.total; ++i) {
                this.opaqueData[i] = this.backgroundValue;
            }
        } else {
            int lx = bounds.x;
            int hx = lx + bounds.width;
            int ly = bounds.y;
            int hy = ly + bounds.height;
            if (lx < 0) {
                lx = 0;
            }
            if (hx >= this.sz.width) {
                hx = this.sz.width - 1;
            }
            if (ly < 0) {
                ly = 0;
            }
            if (hy >= this.sz.height) {
                hy = this.sz.height - 1;
            }
            for (int y = ly; y <= hy; ++y) {
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    this.opaqueData[baseIndex + x] = this.backgroundValue;
                }
            }
        }
    }

    public Image composite(Rectangle bounds) {
        if (this.numLayerBitMapsCreated > 0) {
            boolean dimmedTransparentLayers = false;
            Iterator<Layer> it = this.curTech.getLayers();
            while (it.hasNext()) {
                Layer layer = it.next();
                if (!this.highlightingLayers || lv.isHighlighted(layer) || gp.getGraphics(layer).getTransparentLayer() == 0) continue;
                dimmedTransparentLayers = true;
                break;
            }
            if (dimmedTransparentLayers) {
                Color[] newColorMap = new Color[this.trueColorMap.length];
                int numTransparents = this.curTech.getNumTransparentLayers();
                boolean[] dimLayer = new boolean[numTransparents];
                for (int i = 0; i < numTransparents; ++i) {
                    dimLayer[i] = true;
                }
                Iterator<Layer> it2 = this.curTech.getLayers();
                while (it2.hasNext()) {
                    int tIndex;
                    Layer layer = it2.next();
                    if (!lv.isHighlighted(layer) || (tIndex = gp.getGraphics(layer).getTransparentLayer()) == 0) continue;
                    dimLayer[tIndex - 1] = false;
                }
                for (int i = 0; i < this.trueColorMap.length; ++i) {
                    newColorMap[i] = this.trueColorMap[i];
                    if (i == 0) continue;
                    boolean dimThisEntry = true;
                    for (int j = 0; j < numTransparents; ++j) {
                        if ((i & 1 << j) == 0 || dimLayer[j]) continue;
                        dimThisEntry = false;
                        break;
                    }
                    newColorMap[i] = dimThisEntry ? new Color(this.dimColor(this.trueColorMap[i].getRGB())) : new Color(this.brightenColor(this.trueColorMap[i].getRGB()));
                }
                this.trueColorMap = newColorMap;
            }
            int lx = 0;
            int hx = this.sz.width - 1;
            int ly = 0;
            int hy = this.sz.height - 1;
            if (bounds != null) {
                lx = bounds.x;
                hx = lx + bounds.width;
                ly = bounds.y;
                hy = ly + bounds.height;
                if (lx < 0) {
                    lx = 0;
                }
                if (hx >= this.sz.width) {
                    hx = this.sz.width - 1;
                }
                if (ly < 0) {
                    ly = 0;
                }
                if (hy >= this.sz.height) {
                    hy = this.sz.height - 1;
                }
            }
            for (int y = ly; y <= hy; ++y) {
                for (int i = 0; i < this.numLayerBitMaps; ++i) {
                    byte[][] layerBitMap = this.layerBitMaps[i];
                    this.compositeRows[i] = (byte[])(layerBitMap == null ? null : layerBitMap[y]);
                }
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    int index2 = baseIndex + x;
                    int pixelValue = this.opaqueData[index2];
                    int alpha = pixelValue >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    int bits = 0;
                    int entry = x >> 3;
                    int maskBit = 1 << (x & 7);
                    for (int i = 0; i < this.numLayerBitMaps; ++i) {
                        byte byt;
                        if (this.compositeRows[i] == null || ((byt = this.compositeRows[i][entry]) & maskBit) == 0) continue;
                        bits |= 1 << i;
                    }
                    int newColor = this.backgroundColor;
                    if (bits != 0) {
                        newColor = this.trueColorMap[bits].getRGB() & 0xFFFFFF;
                    }
                    if (alpha != 255) {
                        newColor = this.alphaBlend(pixelValue, newColor, alpha);
                    }
                    this.opaqueData[index2] = newColor;
                }
            }
        } else if (bounds == null) {
            for (int i = 0; i < this.total; ++i) {
                int pixelValue = this.opaqueData[i];
                if (pixelValue == this.backgroundValue) {
                    this.opaqueData[i] = this.backgroundColor;
                    continue;
                }
                if ((pixelValue & 0xFF000000) == 0) continue;
                int alpha = pixelValue >> 24 & 0xFF;
                this.opaqueData[i] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
            }
        } else {
            int lx = bounds.x;
            int hx = lx + bounds.width;
            int ly = bounds.y;
            int hy = ly + bounds.height;
            if (lx < 0) {
                lx = 0;
            }
            if (hx >= this.sz.width) {
                hx = this.sz.width - 1;
            }
            if (ly < 0) {
                ly = 0;
            }
            if (hy >= this.sz.height) {
                hy = this.sz.height - 1;
            }
            for (int y = ly; y <= hy; ++y) {
                int baseIndex = y * this.sz.width;
                for (int x = lx; x <= hx; ++x) {
                    int index3 = baseIndex + x;
                    int pixelValue = this.opaqueData[index3];
                    if (pixelValue == this.backgroundValue) {
                        this.opaqueData[index3] = this.backgroundColor;
                        continue;
                    }
                    if ((pixelValue & 0xFF000000) == 0) continue;
                    int alpha = pixelValue >> 24 & 0xFF;
                    this.opaqueData[index3] = this.alphaBlend(pixelValue, this.backgroundColor, alpha);
                }
            }
        }
        return this.img;
    }

    private void drawGrid(EditWindow wnd, WindowFrame.DisplayAttributes da) {
        double spacingX = wnd.getGridXSpacing();
        double spacingY = wnd.getGridYSpacing();
        if (spacingX == 0.0 || spacingY == 0.0) {
            return;
        }
        double boldSpacingX = spacingX * PixelDrawing.dp.gridXBoldFrequency;
        double boldSpacingY = spacingY * PixelDrawing.dp.gridYBoldFrequency;
        double boldSpacingThreshX = spacingX / 4.0;
        double boldSpacingThreshY = spacingY / 4.0;
        Rectangle2D displayable = this.displayableBounds(da.getIntoCellTransform());
        double lX = displayable.getMinX();
        double lY = displayable.getMaxY();
        double hX = displayable.getMaxX();
        double hY = displayable.getMinY();
        double scaleX = (double)this.sz.width / (hX - lX);
        double scaleY = (double)this.sz.height / (lY - hY);
        double x1 = DBMath.toNearest(lX, spacingX);
        double y1 = DBMath.toNearest(lY, spacingY);
        boolean allBoldDots = false;
        if (spacingX * scaleX < 5.0 || spacingY * scaleY < 5.0) {
            x1 = DBMath.toNearest(x1, boldSpacingX);
            spacingX = boldSpacingX;
            y1 = DBMath.toNearest(y1, boldSpacingY);
            spacingY = boldSpacingY;
            if (spacingX * scaleX < 10.0 || spacingY * scaleY < 10.0) {
                wnd.printGridWarning();
                return;
            }
        } else if (spacingX * scaleX > 75.0 && spacingY * scaleY > 75.0) {
            allBoldDots = true;
        }
        Point2D.Double tmpPt = new Point2D.Double();
        AffineTransform outofCellTransform = da.getOutofCellTransform();
        int col = gp.getColor(User.ColorPrefType.GRID).getRGB() & 0xFFFFFF;
        for (double i = y1; i > hY; i -= spacingY) {
            double boldValueY = i;
            boldValueY = i < 0.0 ? (boldValueY -= boldSpacingThreshY / 2.0) : (boldValueY += boldSpacingThreshY / 2.0);
            boolean everyTenY = Math.abs(boldValueY) % boldSpacingY < boldSpacingThreshY;
            for (double j = x1; j < hX; j += spacingX) {
                boolean everyTenX;
                tmpPt.setLocation(j, i);
                outofCellTransform.transform(tmpPt, tmpPt);
                this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
                int x = this.tempPt1.x;
                int y = this.tempPt1.y;
                if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) continue;
                double boldValueX = j;
                boldValueX = j < 0.0 ? (boldValueX -= boldSpacingThreshX / 2.0) : (boldValueX += boldSpacingThreshX / 2.0);
                boolean bl = everyTenX = Math.abs(boldValueX) % boldSpacingX < boldSpacingThreshX;
                if (allBoldDots && everyTenX && everyTenY) {
                    int boxHY;
                    int boxLY;
                    int boxHX;
                    int boxLX = x - 2;
                    if (boxLX < 0) {
                        boxLX = 0;
                    }
                    if ((boxHX = x + 2) >= this.sz.width) {
                        boxHX = this.sz.width - 1;
                    }
                    if ((boxLY = y - 2) < 0) {
                        boxLY = 0;
                    }
                    if ((boxHY = y + 2) >= this.sz.height) {
                        boxHY = this.sz.height - 1;
                    }
                    this.drawBox(boxLX, boxHX, boxLY, boxHY, null, gridGraphics, false);
                    if (x > 1) {
                        this.opaqueData[y * this.sz.width + (x - 2)] = col;
                    }
                    if (x < this.sz.width - 2) {
                        this.opaqueData[y * this.sz.width + (x + 2)] = col;
                    }
                    if (y > 1) {
                        this.opaqueData[(y - 2) * this.sz.width + x] = col;
                    }
                    if (y >= this.sz.height - 2) continue;
                    this.opaqueData[(y + 2) * this.sz.width + x] = col;
                    continue;
                }
                if (allBoldDots || everyTenX && everyTenY) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    if (x > 0) {
                        this.opaqueData[y * this.sz.width + (x - 1)] = col;
                    }
                    if (x < this.sz.width - 1) {
                        this.opaqueData[y * this.sz.width + (x + 1)] = col;
                    }
                    if (y > 0) {
                        this.opaqueData[(y - 1) * this.sz.width + x] = col;
                    }
                    if (y >= this.sz.height - 1) continue;
                    this.opaqueData[(y + 1) * this.sz.width + x] = col;
                    continue;
                }
                this.opaqueData[y * this.sz.width + x] = col;
            }
        }
        if (PixelDrawing.dp.gridAxesShown) {
            tmpPt.setLocation(0.0, 0.0);
            outofCellTransform.transform(tmpPt, tmpPt);
            this.databaseToScreen(tmpPt.getX(), tmpPt.getY(), this.tempPt1);
            int x = this.tempPt1.x;
            int y = this.tempPt1.y;
            if (x >= 0 && x < this.sz.width) {
                this.drawSolidLine(x, 0, x, this.sz.height - 1, null, col);
            }
            if (y >= 0 && y < this.sz.height) {
                this.drawSolidLine(0, y, this.sz.width - 1, y, null, col);
            }
        }
    }

    private Rectangle2D displayableBounds(AffineTransform intoCellTransform) {
        Point2D.Double low = new Point2D.Double();
        this.screenToDatabase(0, 0, low);
        intoCellTransform.transform(low, low);
        Point2D.Double high = new Point2D.Double();
        this.screenToDatabase(this.sz.width - 1, this.sz.height - 1, high);
        intoCellTransform.transform(high, high);
        double lowX = Math.min(((Point2D)low).getX(), ((Point2D)high).getX());
        double lowY = Math.min(((Point2D)low).getY(), ((Point2D)high).getY());
        double sizeX = Math.abs(((Point2D)high).getX() - ((Point2D)low).getX());
        double sizeY = Math.abs(((Point2D)high).getY() - ((Point2D)low).getY());
        Rectangle2D.Double bounds = new Rectangle2D.Double(lowX, lowY, sizeX, sizeY);
        return bounds;
    }

    private void initForTechnology(Cell cell) {
        Technology tech = Technology.getCurrent();
        if (tech == null) {
            return;
        }
        int transLayers = gp.getNumTransparentLayers(tech);
        this.trueColorMap = gp.getColorMap(tech);
        if (cell != null && cell.isInTechnologyLibrary() && tech == Artwork.tech()) {
            Cell techLibFactors = null;
            Iterator<ElectricObject> it = cell.getLibrary().getCells();
            while (it.hasNext()) {
                Cell c = it.next();
                if (!c.getName().equals("factors")) continue;
                techLibFactors = c;
                break;
            }
            if (techLibFactors != null) {
                it = techLibFactors.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = (NodeInst)it.next();
                    Color[] teColors = GeneralInfo.getTransparentColors(ni);
                    if (teColors == null) continue;
                    this.trueColorMap = Technology.makeColorMap(teColors);
                    transLayers = teColors.length;
                    break;
                }
            }
        }
        if (tech == this.curTech && this.numLayerBitMaps == transLayers) {
            return;
        }
        this.curTech = tech;
        this.numLayerBitMaps = transLayers;
        this.layerBitMaps = new byte[this.numLayerBitMaps][][];
        this.compositeRows = new byte[this.numLayerBitMaps][];
        for (int i = 0; i < this.numLayerBitMaps; ++i) {
            this.layerBitMaps[i] = null;
        }
        this.numLayerBitMapsCreated = 0;
    }

    private void periodicRefresh() {
        if (this.periodicRefresh) {
            ++this.objectCount;
            if (this.objectCount > 100) {
                this.objectCount = 0;
                if (this.wnd instanceof EditWindow) {
                    EditWindow wndFull = (EditWindow)this.wnd;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.lastRefreshTime > 1000L) {
                        wndFull.repaint();
                    }
                }
            }
        }
    }

    private void drawCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform prevTrans, Cell topCell) {
        Rectangle2D.Double bounds;
        Rectangle2D curBounds;
        ++renderedCells;
        Iterator<ArcInst> arcs = cell.getArcs();
        while (arcs.hasNext()) {
            ArcInst ai = arcs.next();
            if (drawLimitBounds != null) {
                curBounds = ai.getBounds();
                bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                DBMath.transformRect(bounds, prevTrans);
                if (!DBMath.rectsIntersect(bounds, drawLimitBounds)) continue;
            }
            this.drawArc(ai, prevTrans, false);
        }
        Iterator<NodeInst> nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = nodes.next();
            if (drawLimitBounds != null) {
                curBounds = ni.getBounds();
                bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                DBMath.transformRect(bounds, prevTrans);
                if (!DBMath.rectsIntersect(bounds, drawLimitBounds)) continue;
            }
            this.drawNode(ni, orient, prevTrans, topCell, drawLimitBounds, fullInstantiate, false);
        }
        boolean topLevel = true;
        if (topCell != null) {
            boolean bl = topLevel = cell == topCell;
        }
        if (this.canDrawText && topLevel && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.CELL)) {
            Poly[] polys = cell.getDisplayableVariables(CENTERRECT, this.dummyWnd, true, gp.isShowTempNames());
            this.drawPolys(polys, prevTrans, false);
        }
    }

    private void drawNode(NodeInst ni, Orientation orient, AffineTransform trans, Cell topCell, Rectangle2D drawLimitBounds, boolean fullInstantiate, boolean forceVisible) {
        NodeProto np = ni.getProto();
        AffineTransform localTrans = ni.rotateOut(trans);
        boolean topLevel = true;
        if (topCell != null) {
            boolean bl = topLevel = ni.getParent() == topCell;
        }
        if (ni.isCellInstance()) {
            ++totalCells;
            Cell subCell = (Cell)np;
            Orientation subOrient = orient.concatenate(ni.getOrient());
            AffineTransform subTrans = ni.translateOut(localTrans);
            Rectangle2D cellBounds = subCell.getBounds();
            Poly poly = new Poly(cellBounds);
            poly.transform(subTrans);
            cellBounds = poly.getBounds2D();
            Rectangle screenBounds = this.databaseToScreen(cellBounds);
            if (screenBounds.width <= 0 || screenBounds.height <= 0) {
                ++tinyCells;
                return;
            }
            if (screenBounds.x >= this.sz.width || screenBounds.x + screenBounds.width <= 0) {
                return;
            }
            if (screenBounds.y >= this.sz.height || screenBounds.y + screenBounds.height <= 0) {
                return;
            }
            boolean expanded = ni.isExpanded();
            if (fullInstantiate) {
                expanded = true;
            }
            boolean onPathDown = false;
            if (!expanded && this.inPlaceNodePath != null) {
                for (int pathIndex = 0; pathIndex < this.inPlaceNodePath.size(); ++pathIndex) {
                    NodeInst niOnPath = this.inPlaceNodePath.get(pathIndex);
                    if (niOnPath.getProto() != subCell) continue;
                    expanded = true;
                    onPathDown = true;
                    break;
                }
            }
            if (expanded) {
                if (!this.expandedCellCached(subCell, subOrient, subTrans, topCell, drawLimitBounds, fullInstantiate)) {
                    ++cellsRendered;
                    this.varContext = this.varContext.push(ni);
                    this.drawCell(subCell, drawLimitBounds, fullInstantiate, subOrient, subTrans, topCell);
                    this.varContext = this.varContext.pop();
                }
            } else {
                this.drawUnexpandedCell(ni, poly);
            }
            if (this.canDrawText) {
                this.showCellPorts(ni, trans, expanded, onPathDown);
            }
            if (this.canDrawText && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE)) {
                Poly[] polys = ni.getDisplayableVariables(this.dummyWnd, gp.isShowTempNames());
                this.drawPolys(polys, localTrans, false);
            }
        } else if (topLevel || !ni.isVisInside() && np != Generic.tech().cellCenterNode) {
            Point2D ctr = ni.getTrueCenter();
            trans.transform(ctr, ctr);
            double halfWidth = Math.max(ni.getXSize(), ni.getYSize()) / 2.0;
            double ctrX = ctr.getX();
            double ctrY = ctr.getY();
            if (this.renderedWindow && this.drawBounds != null) {
                Rectangle2D databaseBounds = this.drawBounds;
                if (ctrX + halfWidth < databaseBounds.getMinX()) {
                    return;
                }
                if (ctrX - halfWidth > databaseBounds.getMaxX()) {
                    return;
                }
                if (ctrY + halfWidth < databaseBounds.getMinY()) {
                    return;
                }
                if (ctrY - halfWidth > databaseBounds.getMaxY()) {
                    return;
                }
            }
            PrimitiveNode prim = (PrimitiveNode)np;
            ++totalPrims;
            if (!prim.isCanBeZeroSize() && halfWidth < halfMaxObjectSize && !forceVisible) {
                ++tinyPrims;
                this.databaseToScreen(ctrX, ctrY, this.tempPt1);
                if (this.tempPt1.x >= 0 && this.tempPt1.x < this.sz.width && this.tempPt1.y >= 0 && this.tempPt1.y < this.sz.height) {
                    this.drawTinyLayers(prim.getLayerIterator(), this.tempPt1.x, this.tempPt1.y);
                }
                return;
            }
            EditWindow0 nodeWnd = this.dummyWnd;
            if (!(forceVisible || this.canDrawText && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.NODE))) {
                nodeWnd = null;
            }
            if (prim == Generic.tech().invisiblePinNode && !gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ANNOTATION)) {
                nodeWnd = null;
            }
            Technology tech = prim.getTechnology();
            this.drawPolys(tech.getShapeOfNode(ni, false, false, null), localTrans, forceVisible);
            this.drawPolys(ni.getDisplayableVariables(nodeWnd, gp.isShowTempNames()), localTrans, forceVisible);
        }
        if (this.canDrawText && topLevel && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.EXPORT)) {
            int exportDisplayLevel = PixelDrawing.gp.exportDisplayLevel;
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (np instanceof PrimitiveNode && !lv.isVisible((PrimitiveNode)np)) continue;
                Poly poly = e.getNamePoly();
                poly.transform(trans);
                Rectangle2D rect = (Rectangle2D)poly.getBounds2D().clone();
                if (exportDisplayLevel == 2) {
                    this.drawCross(poly, textGraphics, false);
                } else {
                    TextDescriptor descript = poly.getTextDescriptor();
                    Poly.Type type = descript.getPos().getPolyType();
                    String portName = e.getName();
                    if (exportDisplayLevel == 1) {
                        portName = e.getShortName();
                    }
                    this.databaseToScreen(poly.getCenterX(), poly.getCenterY(), this.tempPt1);
                    Rectangle textRect = new Rectangle(this.tempPt1);
                    type = Poly.rotateType(type, ni);
                    this.drawText(textRect, type, descript, portName, null, textGraphics, false);
                }
                Poly[] polys = e.getDisplayableVariables(rect, this.dummyWnd, true, gp.isShowTempNames());
                this.drawPolys(polys, localTrans, false);
            }
        }
    }

    private void drawArc(ArcInst ai, AffineTransform trans, boolean forceVisible) {
        Rectangle2D arcBounds = ai.getBounds();
        double arcSize = Math.max(arcBounds.getWidth(), arcBounds.getHeight());
        ++totalArcs;
        if (!forceVisible) {
            if (arcSize < maxObjectSize) {
                ++tinyArcs;
                return;
            }
            if (ai.getGridFullWidth() > 0L && (arcSize = Math.min(arcBounds.getWidth(), arcBounds.getHeight())) < maxObjectSize) {
                ++linedArcs;
                Point2D.Double headEnd = new Point2D.Double(ai.getHeadLocation().getX(), ai.getHeadLocation().getY());
                trans.transform(headEnd, headEnd);
                this.databaseToScreen(((Point2D)headEnd).getX(), ((Point2D)headEnd).getY(), this.tempPt1);
                Point2D.Double tailEnd = new Point2D.Double(ai.getTailLocation().getX(), ai.getTailLocation().getY());
                trans.transform(tailEnd, tailEnd);
                this.databaseToScreen(((Point2D)tailEnd).getX(), ((Point2D)tailEnd).getY(), this.tempPt2);
                ArcProto prim = ai.getProto();
                this.drawTinyArc(prim.getLayerIterator(), this.tempPt1, this.tempPt2);
                return;
            }
        }
        Rectangle2D dbBounds = new Rectangle2D.Double(arcBounds.getX(), arcBounds.getY(), arcBounds.getWidth(), arcBounds.getHeight());
        Poly p = new Poly(dbBounds);
        p.transform(trans);
        dbBounds = p.getBounds2D();
        if (this.drawBounds != null && !DBMath.rectsIntersect(this.drawBounds, dbBounds)) {
            return;
        }
        ArcProto ap = ai.getProto();
        Technology tech = ap.getTechnology();
        this.drawPolys(tech.getShapeOfArc(ai), trans, forceVisible);
        if (this.canDrawText && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.ARC)) {
            this.drawPolys(ai.getDisplayableVariables(this.dummyWnd, gp.isShowTempNames()), trans, forceVisible);
        }
    }

    private void showCellPorts(NodeInst ni, AffineTransform trans, boolean expanded, boolean onPathDown) {
        Export e;
        PortInst pi;
        int numPorts = ni.getProto().getNumPorts();
        boolean[] shownPorts = new boolean[numPorts];
        Iterator<Object> it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = it.next();
            pi = con.getPortInst();
            e = (Export)pi.getPortProto();
            if (e.isAlwaysDrawn()) continue;
            shownPorts[pi.getPortIndex()] = true;
        }
        it = ni.getExports();
        while (it.hasNext()) {
            Export exp = (Export)it.next();
            pi = exp.getOriginalPort();
            e = (Export)pi.getPortProto();
            if (e.isAlwaysDrawn()) continue;
            shownPorts[pi.getPortIndex()] = true;
        }
        int portDisplayLevel = PixelDrawing.gp.portDisplayLevel;
        for (int i = 0; i < numPorts; ++i) {
            EGraphics portGraphics;
            Export pp;
            Poly portPoly;
            if (!onPathDown && shownPorts[i] || (portPoly = ni.getShapeOfPort(pp = (Export)ni.getProto().getPort(i))) == null) continue;
            portPoly.transform(trans);
            EGraphics eGraphics = portGraphics = expanded ? textGraphics : this.getPortGraphics(pp.getBasePort());
            if (portDisplayLevel == 2) {
                this.drawCross(portPoly, portGraphics, false);
                continue;
            }
            if (!gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.PORT)) continue;
            TextDescriptor descript = pp.getNamePoly().getTextDescriptor();
            TextDescriptor portDescript = pp.getTextDescriptor(Export.EXPORT_NAME).withColorIndex(descript.getColorIndex());
            Poly.Type type = descript.getPos().getPolyType();
            String portName = pp.getName();
            if (portDisplayLevel == 1) {
                portName = pp.getShortName();
            }
            this.databaseToScreen(portPoly.getCenterX(), portPoly.getCenterY(), this.tempPt1);
            Rectangle rect = new Rectangle(this.tempPt1);
            this.drawText(rect, type, portDescript, portName, null, portGraphics, false);
        }
    }

    private void drawUnexpandedCell(NodeInst ni, Poly poly) {
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            Point2D lastPt = points[lastI];
            Point2D thisPt = points[i];
            this.databaseToScreen(lastPt.getX(), lastPt.getY(), this.tempPt1);
            this.databaseToScreen(thisPt.getX(), thisPt.getY(), this.tempPt2);
            this.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
        }
        if (this.canDrawText && gp.isTextVisibilityOn(AbstractTextDescriptor.TextType.INSTANCE)) {
            Rectangle2D bounds = poly.getBounds2D();
            Rectangle rect = this.databaseToScreen(bounds);
            TextDescriptor descript = ni.getTextDescriptor(NodeInst.NODE_PROTO);
            NodeProto np = ni.getProto();
            this.drawText(rect, Poly.Type.TEXTBOX, descript, np.describe(false), null, textGraphics, false);
        }
    }

    private void drawTinyLayers(Iterator<Layer> layerIterator, int x, int y) {
        Iterator<Layer> it = layerIterator;
        while (it.hasNext()) {
            Layer layer = it.next();
            if (layer == null) continue;
            byte[][] layerBitMap = null;
            int col = 0;
            EGraphics graphics = gp.getGraphics(layer);
            if (graphics != null) {
                int pat;
                int[] pattern;
                if ((this.nowPrinting != 0 ? graphics.isPatternedOnPrinter() : graphics.isPatternedOnDisplay()) && (pattern = graphics.getPattern()) != null && ((pat = pattern[y & 0xF]) == 0 || (pat & 32768 >> (x & 0xF)) == 0)) continue;
                int layerNum = graphics.getTransparentLayer() - 1;
                if (layerNum < this.numLayerBitMaps) {
                    layerBitMap = this.getLayerBitMap(layerNum);
                }
                col = graphics.getRGB();
            }
            if (layerBitMap == null) {
                int index2 = y * this.sz.width + x;
                int alpha = this.opaqueData[index2] >> 24 & 0xFF;
                if (alpha != 255) continue;
                this.opaqueData[index2] = col;
                continue;
            }
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawTinyArc(Iterator<Layer> layerIterator, Point head2, Point tail2) {
        Iterator<Layer> it = layerIterator;
        while (it.hasNext()) {
            int layerNum;
            Layer layer = it.next();
            if (layer == null) continue;
            EGraphics graphics = gp.getGraphics(layer);
            byte[][] layerBitMap = null;
            if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.numLayerBitMaps) {
                layerBitMap = this.getLayerBitMap(layerNum);
            }
            this.drawLine(head2, tail2, layerBitMap, graphics, 0, !lv.isHighlighted(layer));
        }
    }

    private boolean expandedCellCached(Cell subCell, Orientation orient, AffineTransform origTrans, Cell topCell, Rectangle2D drawLimitBounds, boolean fullInstantiate) {
        if (expandedCells == null) {
            return false;
        }
        if (subCell.isIcon()) {
            return false;
        }
        ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, orient);
        ExpandedCellInfo expandedCellCount = expandedCells.get(expansionKey);
        if (expandedCellCount != null && expandedCellCount.singleton && expandedCellCount.instanceCount < 2 && expandedCellCount.offscreen == null) {
            if (numberToReconcile > 0) {
                --numberToReconcile;
                expandedCellCount.singleton = false;
            } else {
                return false;
            }
        }
        if (expandedCellCount == null || expandedCellCount.offscreen == null) {
            Rectangle2D.Double cellBounds = new Rectangle2D.Double();
            ((Rectangle2D)cellBounds).setRect(subCell.getBounds());
            Rectangle2D textBounds = subCell.getTextBounds(this.dummyWnd);
            if (textBounds != null) {
                cellBounds.add(textBounds);
            }
            AffineTransform rotTrans = orient.pureRotate();
            DBMath.transformRect(cellBounds, rotTrans);
            int lX = (int)Math.floor(cellBounds.getMinX() * this.scale);
            int hX = (int)Math.ceil(cellBounds.getMaxX() * this.scale);
            int lY = (int)Math.floor(cellBounds.getMinY() * this.scale);
            int hY = (int)Math.ceil(cellBounds.getMaxY() * this.scale);
            Rectangle screenBounds = new Rectangle(lX, lY, hX - lX, hY - lY);
            if (screenBounds.width <= 0 || screenBounds.height <= 0) {
                return true;
            }
            if (screenBounds.width >= PixelDrawing.topSz.width / 2 && screenBounds.height >= PixelDrawing.topSz.height / 2) {
                return false;
            }
            if (expandedCellCount == null) {
                expandedCellCount = new ExpandedCellInfo();
                expandedCells.put(expansionKey, expandedCellCount);
            }
            expandedCellCount.offscreen = new PixelDrawing(this.scale, screenBounds);
            expandedCellCount.offscreen.drawCell(subCell, null, fullInstantiate, orient, rotTrans, topCell);
            ++offscreensCreated;
            offscreenPixelsCreated += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        }
        this.databaseToScreen(origTrans.getTranslateX(), origTrans.getTranslateY(), this.tempPt1);
        this.copyBits(expandedCellCount.offscreen, this.tempPt1.x, this.tempPt1.y);
        ++offscreensUsed;
        offscreenPixelsUsed += ((ExpandedCellInfo)expandedCellCount).offscreen.total;
        return true;
    }

    private void countCell(Cell cell, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform prevTrans) {
        Iterator<NodeInst> nodes = cell.getNodes();
        while (nodes.hasNext()) {
            NodeInst ni = nodes.next();
            if (!ni.isCellInstance()) continue;
            if (drawLimitBounds != null) {
                Rectangle2D curBounds = ni.getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(curBounds.getX(), curBounds.getY(), curBounds.getWidth(), curBounds.getHeight());
                DBMath.transformRect(bounds, prevTrans);
                if (!DBMath.rectsIntersect(bounds, drawLimitBounds)) {
                    return;
                }
            }
            this.countNode(ni, drawLimitBounds, fullInstantiate, orient, prevTrans);
        }
    }

    private void countNode(NodeInst ni, Rectangle2D drawLimitBounds, boolean fullInstantiate, Orientation orient, AffineTransform trans) {
        double objWidth = Math.max(ni.getXSize(), ni.getYSize());
        if (objWidth < maxObjectSize) {
            return;
        }
        Orientation subOrient = orient.concatenate(ni.getOrient());
        AffineTransform subTrans = ni.transformOut(trans);
        NodeProto np = ni.getProto();
        Cell subCell = (Cell)np;
        Rectangle2D cellBounds = subCell.getBounds();
        Poly poly = new Poly(cellBounds);
        poly.transform(subTrans);
        cellBounds = poly.getBounds2D();
        Rectangle screenBounds = this.databaseToScreen(cellBounds);
        if (screenBounds.width <= 0 || screenBounds.height <= 0) {
            return;
        }
        if (screenBounds.x > this.sz.width || screenBounds.x + screenBounds.width < 0) {
            return;
        }
        if (screenBounds.y > this.sz.height || screenBounds.y + screenBounds.height < 0) {
            return;
        }
        boolean expanded = ni.isExpanded();
        if (fullInstantiate) {
            expanded = true;
        }
        if (!expanded && this.inPlaceNodePath != null) {
            for (int pathIndex = 0; pathIndex < this.inPlaceNodePath.size(); ++pathIndex) {
                NodeInst niOnPath = this.inPlaceNodePath.get(pathIndex);
                if (niOnPath.getProto() != subCell) continue;
                expanded = true;
                break;
            }
        }
        if (!expanded) {
            return;
        }
        if (screenBounds.width < this.sz.width / 2 || screenBounds.height <= this.sz.height / 2) {
            ExpandedCellKey expansionKey = new ExpandedCellKey(subCell, subOrient);
            ExpandedCellInfo expansionCount = expandedCells.get(expansionKey);
            if (expansionCount == null) {
                expansionCount = new ExpandedCellInfo();
                expansionCount.instanceCount = 1;
                expandedCells.put(expansionKey, expansionCount);
            } else {
                expansionCount.instanceCount++;
                if (expansionCount.instanceCount > 1) {
                    return;
                }
            }
        }
        this.countCell(subCell, null, fullInstantiate, subOrient, subTrans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceRedraw(Cell cell) {
        Set<CellId> set = changedCells;
        synchronized (set) {
            changedCells.add(cell.getId());
        }
    }

    private static void forceRedraw(Set<CellId> changedCells) {
        if (expandedCells == null) {
            return;
        }
        ArrayList<ExpandedCellKey> keys = new ArrayList<ExpandedCellKey>();
        for (ExpandedCellKey eck : expandedCells.keySet()) {
            keys.add(eck);
        }
        for (ExpandedCellKey expansionKey : keys) {
            if (!changedCells.contains(expansionKey.cell.getId())) continue;
            expandedCells.remove(expansionKey);
        }
    }

    private void copyBits(PixelDrawing srcOffscreen, int centerX, int centerY) {
        if (srcOffscreen == null) {
            return;
        }
        Dimension dim = srcOffscreen.sz;
        int cornerX = centerX - (int)srcOffscreen.originX;
        int cornerY = centerY - (int)srcOffscreen.originY;
        int minSrcX = Math.max(0, this.clipLX - cornerX);
        int maxSrcX = Math.min(dim.width - 1, this.clipHX - cornerX);
        int minSrcY = Math.max(0, this.clipLY - cornerY);
        int maxSrcY = Math.min(dim.height - 1, this.clipHY - cornerY);
        if (minSrcX > maxSrcX || minSrcY > maxSrcY) {
            return;
        }
        if (Job.getDebug() && this.numLayerBitMaps != srcOffscreen.numLayerBitMaps) {
            System.out.println("Possible mixture of technologies in PixelDrawing.copyBits");
        }
        for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
            int destY = srcY + cornerY;
            assert (destY >= this.clipLY && destY <= this.clipHY);
            if (destY < 0 || destY >= this.sz.height) continue;
            int srcBase = srcY * dim.width;
            int destBase = destY * this.sz.width;
            for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                int srcColor;
                int destX = srcX + cornerX;
                assert (destX >= this.clipLX && destX <= this.clipHX);
                if (destX < 0 || destX >= this.sz.width || (srcColor = srcOffscreen.opaqueData[srcBase + srcX]) == this.backgroundValue) continue;
                this.opaqueData[destBase + destX] = srcColor;
            }
        }
        for (int i = 0; i < this.numLayerBitMaps && i < srcOffscreen.numLayerBitMaps; ++i) {
            byte[][] srcLayerBitMap = srcOffscreen.layerBitMaps[i];
            if (srcLayerBitMap == null) continue;
            byte[][] destLayerBitMap = this.getLayerBitMap(i);
            for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                int destY = srcY + cornerY;
                assert (destY >= this.clipLY && destY <= this.clipHY);
                if (destY < 0 || destY >= this.sz.height) continue;
                byte[] srcRow = srcLayerBitMap[srcY];
                byte[] destRow = destLayerBitMap[destY];
                for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                    int destX = srcX + cornerX;
                    assert (destX >= this.clipLX && destX <= this.clipHX);
                    if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
        for (Layer layer : srcOffscreen.patternedOpaqueLayers.keySet()) {
            PatternedOpaqueLayer polSrc = srcOffscreen.patternedOpaqueLayers.get(layer);
            byte[][] srcLayerBitMap = polSrc.layerBitMap;
            if (srcLayerBitMap == null) continue;
            if (this.renderedWindow) {
                EGraphics desc = gp.getGraphics(layer);
                int col = desc.getRGB();
                int[] pattern = desc.getPattern();
                for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                    int destY = srcY + cornerY;
                    assert (destY >= this.clipLY && destY <= this.clipHY);
                    if (destY < 0 || destY >= this.sz.height) continue;
                    int destBase = destY * this.sz.width;
                    int pat = pattern[destY & 0xF];
                    if (pat == 0) continue;
                    byte[] srcRow = srcLayerBitMap[srcY];
                    for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                        int destX = srcX + cornerX;
                        assert (destX >= this.clipLX && destX <= this.clipHX);
                        if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0 || (pat & 32768 >> (destX & 0xF)) == 0) continue;
                        this.opaqueData[destBase + destX] = col;
                    }
                }
                continue;
            }
            PatternedOpaqueLayer polDest = this.patternedOpaqueLayers.get(layer);
            if (polDest == null) {
                polDest = new PatternedOpaqueLayer(this.sz.height, this.numBytesPerRow);
                this.patternedOpaqueLayers.put(layer, polDest);
            }
            byte[][] destLayerBitMap = polDest.layerBitMap;
            for (int srcY = minSrcY; srcY <= maxSrcY; ++srcY) {
                int destY = srcY + cornerY;
                assert (destY >= this.clipLY && destY <= this.clipHY);
                if (destY < 0 || destY >= this.sz.height) continue;
                byte[] srcRow = srcLayerBitMap[srcY];
                byte[] destRow = destLayerBitMap[destY];
                for (int srcX = minSrcX; srcX <= maxSrcX; ++srcX) {
                    int destX = srcX + cornerX;
                    assert (destX >= this.clipLX && destX <= this.clipHX);
                    if (destX < 0 || destX >= this.sz.width || (srcRow[srcX >> 3] & 1 << (srcX & 7)) == 0) continue;
                    int n = destX >> 3;
                    destRow[n] = (byte)(destRow[n] | 1 << (destX & 7));
                }
            }
        }
    }

    private void drawPolys(Poly[] polys, AffineTransform trans, boolean forceVisible) {
        if (polys == null) {
            return;
        }
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            if (poly == null) continue;
            Layer layer = poly.getLayer();
            EGraphics graphics = poly.getGraphicsOverride();
            if (graphics == null && layer != null) {
                graphics = gp.getGraphics(layer);
            }
            boolean dimmed = false;
            if (layer != null) {
                if (!forceVisible && !lv.isVisible(layer)) continue;
                dimmed = !lv.isHighlighted(layer);
            }
            poly.transform(trans);
            this.renderPoly(poly, graphics, dimmed);
            this.periodicRefresh();
        }
    }

    byte[][] getLayerBitMap(int layerNum) {
        if (layerNum < 0) {
            return null;
        }
        byte[][] layerBitMap = this.layerBitMaps[layerNum];
        if (layerBitMap != null) {
            return layerBitMap;
        }
        return this.newLayerBitMap(layerNum);
    }

    private byte[][] newLayerBitMap(int layerNum) {
        byte[][] layerBitMap = new byte[this.sz.height][];
        for (int y = 0; y < this.sz.height; ++y) {
            byte[] row = new byte[this.numBytesPerRow];
            for (int x = 0; x < this.numBytesPerRow; ++x) {
                row[x] = 0;
            }
            layerBitMap[y] = row;
        }
        this.layerBitMaps[layerNum] = layerBitMap;
        ++this.numLayerBitMapsCreated;
        return layerBitMap;
    }

    private void renderPoly(Poly poly, EGraphics graphics, boolean dimmed) {
        Point2D center;
        Rectangle2D bounds;
        int layerNum;
        byte[][] layerBitMap = null;
        if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.numLayerBitMaps) {
            layerBitMap = this.getLayerBitMap(layerNum);
        }
        Poly.Type style = poly.getStyle();
        if (!this.renderedWindow && (style == Poly.Type.FILLED || style == Poly.Type.DISC) && layerBitMap == null && (this.nowPrinting != 0 ? graphics.isPatternedOnPrinter() : graphics.isPatternedOnDisplay())) {
            Layer layer = poly.getLayer();
            PatternedOpaqueLayer pol = this.patternedOpaqueLayers.get(layer);
            if (pol == null) {
                pol = new PatternedOpaqueLayer(this.sz.height, this.numBytesPerRow);
                this.patternedOpaqueLayers.put(layer, pol);
            }
            layerBitMap = pol.layerBitMap;
            graphics = null;
        }
        Point2D[] points = poly.getPoints();
        if (style == Poly.Type.FILLED) {
            bounds = poly.getBox();
            if (bounds != null) {
                this.databaseToScreen(bounds.getMinX(), bounds.getMinY(), this.tempPt1);
                this.databaseToScreen(bounds.getMaxX(), bounds.getMaxY(), this.tempPt2);
                int lX = Math.min(this.tempPt1.x, this.tempPt2.x);
                int hX = Math.max(this.tempPt1.x, this.tempPt2.x);
                int lY = Math.min(this.tempPt1.y, this.tempPt2.y);
                int hY = Math.max(this.tempPt1.y, this.tempPt2.y);
                if (lX < 0) {
                    lX = 0;
                }
                if (hX >= this.sz.width) {
                    hX = this.sz.width - 1;
                }
                if (lY < 0) {
                    lY = 0;
                }
                if (hY >= this.sz.height) {
                    hY = this.sz.height - 1;
                }
                this.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                return;
            }
            Point[] intPoints = new Point[points.length];
            for (int i = 0; i < points.length; ++i) {
                intPoints[i] = new Point();
                this.databaseToScreen(points[i].getX(), points[i].getY(), intPoints[i]);
            }
            Point[] clippedPoints = GenMath.clipPoly(intPoints, 0, this.sz.width - 1, 0, this.sz.height - 1);
            this.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSSED) {
            this.databaseToScreen(points[0].getX(), points[0].getY(), this.tempPt1);
            this.databaseToScreen(points[1].getX(), points[1].getY(), this.tempPt2);
            this.databaseToScreen(points[2].getX(), points[2].getY(), this.tempPt3);
            this.databaseToScreen(points[3].getX(), points[3].getY(), this.tempPt4);
            this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt2, this.tempPt3, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt3, this.tempPt4, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt4, this.tempPt1, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt1, this.tempPt3, layerBitMap, graphics, 0, dimmed);
            this.drawLine(this.tempPt2, this.tempPt4, layerBitMap, graphics, 0, dimmed);
            return;
        }
        if (style.isText()) {
            bounds = poly.getBounds2D();
            Rectangle rect = this.databaseToScreen(bounds);
            TextDescriptor descript = poly.getTextDescriptor();
            String str = poly.getString();
            this.drawText(rect, style, descript, str, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CLOSED || style == Poly.Type.OPENED || style == Poly.Type.OPENEDT1 || style == Poly.Type.OPENEDT2 || style == Poly.Type.OPENEDT3) {
            int lineType = 0;
            if (style == Poly.Type.OPENEDT1) {
                lineType = 1;
            } else if (style == Poly.Type.OPENEDT2) {
                lineType = 2;
            } else if (style == Poly.Type.OPENEDT3) {
                lineType = 3;
            }
            for (int j = 1; j < points.length; ++j) {
                Point2D oldPt = points[j - 1];
                Point2D newPt = points[j];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt.getX(), newPt.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, lineType, dimmed);
            }
            if (style == Poly.Type.CLOSED) {
                Point2D oldPt = points[points.length - 1];
                Point2D newPt = points[0];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt.getX(), newPt.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, lineType, dimmed);
            }
            return;
        }
        if (style == Poly.Type.VECTORS) {
            for (int j = 0; j < points.length; j += 2) {
                Point2D oldPt = points[j];
                Point2D newPt = points[j + 1];
                this.databaseToScreen(oldPt.getX(), oldPt.getY(), this.tempPt1);
                this.databaseToScreen(newPt.getX(), newPt.getY(), this.tempPt2);
                this.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, 0, dimmed);
            }
            return;
        }
        if (style == Poly.Type.CIRCLE) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.THICKCIRCLE) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawThickCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.DISC) {
            center = points[0];
            Point2D edge = points[1];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge.getX(), edge.getY(), this.tempPt2);
            this.drawDisc(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CIRCLEARC || style == Poly.Type.THICKCIRCLEARC) {
            center = points[0];
            Point2D edge1 = points[1];
            Point2D edge2 = points[2];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            this.databaseToScreen(edge1.getX(), edge1.getY(), this.tempPt2);
            this.databaseToScreen(edge2.getX(), edge2.getY(), this.tempPt3);
            int startAngle = GenMath.figureAngle(center, edge1);
            int endAngle = GenMath.figureAngle(center, edge2);
            if (startAngle < endAngle) {
                startAngle += 3600;
            }
            boolean bigArc = startAngle - endAngle > 1800;
            this.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, style == Poly.Type.THICKCIRCLEARC, bigArc, layerBitMap, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.CROSS) {
            this.drawCross(poly, graphics, dimmed);
            return;
        }
        if (style == Poly.Type.BIGCROSS) {
            center = points[0];
            this.databaseToScreen(center.getX(), center.getY(), this.tempPt1);
            int size2 = 5;
            this.drawLine(new Point(this.tempPt1.x - size2, this.tempPt1.y), new Point(this.tempPt1.x + size2, this.tempPt1.y), layerBitMap, graphics, 0, dimmed);
            this.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size2), new Point(this.tempPt1.x, this.tempPt1.y + size2), layerBitMap, graphics, 0, dimmed);
            return;
        }
    }

    EGraphics getPortGraphics(PrimitivePort basePort) {
        Color graColor;
        EGraphics portGraphics = this.portGraphicsCache.get(basePort);
        if (portGraphics == null && (graColor = basePort.getPortColor(gp)) != null) {
            portGraphics = textGraphics.withColor(graColor);
            this.portGraphicsCache.put(basePort, portGraphics);
        }
        return portGraphics;
    }

    int getTheColor(EGraphics desc, boolean dimmed) {
        if (this.nowPrinting == 2) {
            return 0;
        }
        int col = desc.getRGB();
        if (this.highlightingLayers) {
            col = dimmed ? this.dimColor(col) : this.brightenColor(col);
        }
        return col;
    }

    private int dimColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 0.2;
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private int brightenColor(int col) {
        int r = col & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col >> 16 & 0xFF;
        this.fromRGBtoHSV(r, g, b, this.hsvTempArray);
        this.hsvTempArray[1] = this.hsvTempArray[1] * 1.5;
        if (this.hsvTempArray[1] > 1.0) {
            this.hsvTempArray[1] = 1.0;
        }
        col = this.fromHSVtoRGB(this.hsvTempArray[0], this.hsvTempArray[1], this.hsvTempArray[2]);
        return col;
    }

    private void fromRGBtoHSV(int ir, int ig, int ib, double[] hsi) {
        double r = (float)ir / 255.0f;
        double g = (float)ig / 255.0f;
        double b = (float)ib / 255.0f;
        hsi[2] = Math.max(Math.max(r, g), b);
        double x = Math.min(Math.min(r, g), b);
        hsi[1] = hsi[2] == 0.0 ? 0.0 : (hsi[2] - x) / hsi[2];
        hsi[0] = 0.0;
        if (hsi[1] != 0.0) {
            double rdot = (hsi[2] - r) / (hsi[2] - x);
            double gdot = (hsi[2] - g) / (hsi[2] - x);
            double bdot = (hsi[2] - b) / (hsi[2] - x);
            if (b == x && r == hsi[2]) {
                hsi[0] = (1.0 - gdot) / 6.0;
            } else if (b == x && g == hsi[2]) {
                hsi[0] = (1.0 + rdot) / 6.0;
            } else if (r == x && g == hsi[2]) {
                hsi[0] = (3.0 - bdot) / 6.0;
            } else if (r == x && b == hsi[2]) {
                hsi[0] = (3.0 + gdot) / 6.0;
            } else if (g == x && b == hsi[2]) {
                hsi[0] = (5.0 - rdot) / 6.0;
            } else if (g == x && r == hsi[2]) {
                hsi[0] = (5.0 + bdot) / 6.0;
            } else {
                System.out.println("Cannot convert (" + ir + "," + ig + "," + ib + "), for x=" + x + " i=" + hsi[2] + " s=" + hsi[1]);
            }
        }
    }

    private int fromHSVtoRGB(double h, double s, double v) {
        int i = (int)(h *= 6.0);
        double f = h - (double)i;
        double m = v * (1.0 - s);
        double n = v * (1.0 - s * f);
        double k = v * (1.0 - s * (1.0 - f));
        int r = 0;
        int g = 0;
        int b = 0;
        switch (i) {
            case 0: {
                r = (int)(v * 255.0);
                g = (int)(k * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 1: {
                r = (int)(n * 255.0);
                g = (int)(v * 255.0);
                b = (int)(m * 255.0);
                break;
            }
            case 2: {
                r = (int)(m * 255.0);
                g = (int)(v * 255.0);
                b = (int)(k * 255.0);
                break;
            }
            case 3: {
                r = (int)(m * 255.0);
                g = (int)(n * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 4: {
                r = (int)(k * 255.0);
                g = (int)(m * 255.0);
                b = (int)(v * 255.0);
                break;
            }
            case 5: {
                r = (int)(v * 255.0);
                g = (int)(m * 255.0);
                b = (int)(n * 255.0);
            }
        }
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            System.out.println("(" + h + "," + s + "," + v + ") -> (" + r + "," + g + "," + b + ") (i=" + i + ")");
            if (r < 0) {
                r = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (b > 255) {
                b = 255;
            }
        }
        return b << 16 | g << 8 | r;
    }

    void drawBox(int lX, int hX, int lY, int hY, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        block20: {
            EGraphics.Outline o;
            int x;
            int pat;
            int y;
            int[] pattern;
            int col;
            block19: {
                col = 0;
                pattern = null;
                if (desc != null) {
                    col = this.getTheColor(desc, dimmed);
                    if (this.nowPrinting != 0 ? desc.isPatternedOnPrinter() : desc.isPatternedOnDisplay()) {
                        pattern = desc.getPattern();
                    }
                }
                if (pattern != null) break block19;
                if (layerBitMap == null) {
                    for (int y2 = lY; y2 <= hY; ++y2) {
                        int baseIndex = y2 * this.sz.width + lX;
                        for (int x2 = lX; x2 <= hX; ++x2) {
                            int index2;
                            int alpha;
                            if ((alpha = this.opaqueData[index2 = baseIndex++] >> 24 & 0xFF) != 255) continue;
                            this.opaqueData[index2] = col;
                        }
                    }
                } else {
                    for (int y3 = lY; y3 <= hY; ++y3) {
                        byte[] row = layerBitMap[y3];
                        for (int x3 = lX; x3 <= hX; ++x3) {
                            int n = x3 >> 3;
                            row[n] = (byte)(row[n] | 1 << (x3 & 7));
                        }
                    }
                }
                break block20;
            }
            if (layerBitMap == null) {
                for (y = lY; y <= hY; ++y) {
                    pat = pattern[y & 0xF];
                    if (pat == 0) continue;
                    int baseIndex = y * this.sz.width;
                    for (x = lX; x <= hX; ++x) {
                        if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                }
            } else {
                for (y = lY; y <= hY; ++y) {
                    pat = pattern[y & 0xF];
                    if (pat == 0) continue;
                    byte[] row = layerBitMap[y];
                    for (x = lX; x <= hX; ++x) {
                        if ((pat & 32768 >> (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
            }
            if ((o = desc.getOutlined()) == EGraphics.Outline.NOPAT) break block20;
            this.drawOutline(lX, lY, lX, hY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawOutline(lX, hY, hX, hY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawOutline(hX, hY, hX, lY, layerBitMap, col, o.getPattern(), o.getLen());
            this.drawOutline(hX, lY, lX, lY, layerBitMap, col, o.getPattern(), o.getLen());
            if (o.getThickness() != 1) {
                for (int i = 1; i < o.getThickness(); ++i) {
                    if (lX + i < this.sz.width) {
                        this.drawOutline(lX + i, lY, lX + i, hY, layerBitMap, col, o.getPattern(), o.getLen());
                    }
                    if (hY - i >= 0) {
                        this.drawOutline(lX, hY - i, hX, hY - i, layerBitMap, col, o.getPattern(), o.getLen());
                    }
                    if (hX - i >= 0) {
                        this.drawOutline(hX - i, hY, hX - i, lY, layerBitMap, col, o.getPattern(), o.getLen());
                    }
                    if (lY + i >= this.sz.height) continue;
                    this.drawOutline(hX, lY + i, lX, lY + i, layerBitMap, col, o.getPattern(), o.getLen());
                }
            }
        }
    }

    void drawLine(Point pt1, Point pt2, byte[][] layerBitMap, EGraphics desc, int texture, boolean dimmed) {
        if (GenMath.clipLine(pt1, pt2, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        switch (texture) {
            case 0: {
                this.drawSolidLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col);
                break;
            }
            case 1: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col, 136, 8);
                break;
            }
            case 2: {
                this.drawPatLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col, 231, 8);
                break;
            }
            case 3: {
                this.drawThickLine(pt1.x, pt1.y, pt2.x, pt2.y, layerBitMap, col);
            }
        }
    }

    private void drawCross(Poly poly, EGraphics graphics, boolean dimmed) {
        Point2D[] points = poly.getPoints();
        this.databaseToScreen(points[0].getX(), points[0].getY(), this.tempPt1);
        int size2 = 3;
        this.drawLine(new Point(this.tempPt1.x - size2, this.tempPt1.y), new Point(this.tempPt1.x + size2, this.tempPt1.y), null, graphics, 0, dimmed);
        this.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size2), new Point(this.tempPt1.x, this.tempPt1.y + size2), null, graphics, 0, dimmed);
    }

    private void drawSolidLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawOutline(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col, int pattern, int len) {
        this.tempPt3.x = x1;
        this.tempPt3.y = y1;
        this.tempPt4.x = x2;
        this.tempPt4.y = y2;
        if (GenMath.clipLine(this.tempPt3, this.tempPt4, 0, this.sz.width - 1, 0, this.sz.height - 1)) {
            return;
        }
        this.drawPatLine(this.tempPt3.x, this.tempPt3.y, this.tempPt4.x, this.tempPt4.y, layerBitMap, col, pattern, len);
    }

    private void drawPatLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col, int pattern, int len) {
        int dy;
        int i = 0;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            if (layerBitMap == null) {
                this.opaqueData[y * this.sz.width + x] = col;
            } else {
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                if (++i == len) {
                    i = 0;
                }
                if ((pattern & 1 << i) == 0) continue;
                if (layerBitMap == null) {
                    this.opaqueData[y * this.sz.width + x] = col;
                    continue;
                }
                byte[] byArray = layerBitMap[y];
                int n = x >> 3;
                byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            }
        }
    }

    private void drawThickLine(int x1, int y1, int x2, int y2, byte[][] layerBitMap, int col) {
        int dy;
        int dx = Math.abs(x2 - x1);
        if (dx > (dy = Math.abs(y2 - y1))) {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dy;
            int d = incr2 = 2 * (dy - dx);
            if (x1 > x2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int yincr = yend < y ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (x < xend) {
                ++x;
                if (d < 0) {
                    d += incr1;
                } else {
                    y += yincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        } else {
            int yend;
            int xend;
            int y;
            int x;
            int incr2;
            int incr1 = 2 * dx;
            int d = incr2 = 2 * (dx - dy);
            if (y1 > y2) {
                x = x2;
                y = y2;
                xend = x1;
                yend = y1;
            } else {
                x = x1;
                y = y1;
                xend = x2;
                yend = y2;
            }
            int xincr = xend < x ? -1 : 1;
            this.drawThickPoint(x, y, layerBitMap, col);
            while (y < yend) {
                ++y;
                if (d < 0) {
                    d += incr1;
                } else {
                    x += xincr;
                    d += incr2;
                }
                this.drawThickPoint(x, y, layerBitMap, col);
            }
        }
    }

    void drawPolygon(Point[] points, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        EGraphics.Outline o;
        int i;
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (this.nowPrinting != 0 ? desc.isPatternedOnPrinter() : desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
            }
        }
        PolySeg edgelist = null;
        PolySeg[] polySegs = new PolySeg[points.length];
        for (i = 0; i < points.length; ++i) {
            polySegs[i] = new PolySeg();
            if (i == 0) {
                polySegs[i].fx = points[points.length - 1].x;
                polySegs[i].fy = points[points.length - 1].y;
            } else {
                polySegs[i].fx = points[i - 1].x;
                polySegs[i].fy = points[i - 1].y;
            }
            polySegs[i].tx = points[i].x;
            polySegs[i].ty = points[i].y;
        }
        block1: for (i = 0; i < points.length; ++i) {
            int j = polySegs[i].ty - polySegs[i].fy;
            if (j > 0) {
                polySegs[i].direction = 1;
            } else if (j < 0) {
                polySegs[i].direction = -1;
            } else {
                polySegs[i].direction = 0;
            }
            if (j == 0) {
                polySegs[i].increment = 0;
            } else {
                polySegs[i].increment = polySegs[i].tx - polySegs[i].fx;
                if (polySegs[i].increment != 0) {
                    polySegs[i].increment = (polySegs[i].increment * 65536 - j + 1) / j;
                }
            }
            polySegs[i].tx <<= 16;
            polySegs[i].fx <<= 16;
            if (polySegs[i].fy > polySegs[i].ty) {
                j = polySegs[i].tx;
                polySegs[i].tx = polySegs[i].fx;
                polySegs[i].fx = j;
                j = polySegs[i].ty;
                polySegs[i].ty = polySegs[i].fy;
                polySegs[i].fy = j;
            }
            if (edgelist == null) {
                edgelist = polySegs[i];
                polySegs[i].nextedge = null;
                continue;
            }
            if (edgelist.fy > polySegs[i].fy) {
                polySegs[i].nextedge = edgelist;
                edgelist = polySegs[i];
                continue;
            }
            PolySeg a = edgelist;
            while (a != null) {
                if (a.nextedge == null || a.nextedge.fy > polySegs[i].fy) {
                    polySegs[i].nextedge = a.nextedge;
                    a.nextedge = polySegs[i];
                    continue block1;
                }
                a = a.nextedge;
            }
        }
        int ycur = 0;
        PolySeg active = null;
        while (active != null || edgelist != null) {
            if (active == null) {
                active = edgelist;
                active.nextactive = null;
                edgelist = edgelist.nextedge;
                ycur = active.fy;
            }
            block4: while (edgelist != null && edgelist.fy <= ycur) {
                if (active.fx > edgelist.fx || active.fx == edgelist.fx && active.increment > edgelist.increment) {
                    edgelist.nextactive = active;
                    active = edgelist;
                    edgelist = edgelist.nextedge;
                    continue;
                }
                PolySeg a = active;
                while (a != null) {
                    if (a.nextactive == null || a.nextactive.fx > edgelist.fx || a.nextactive.fx == edgelist.fx && a.nextactive.increment > edgelist.increment) {
                        edgelist.nextactive = a.nextactive;
                        a.nextactive = edgelist;
                        edgelist = edgelist.nextedge;
                        continue block4;
                    }
                    a = a.nextactive;
                }
            }
            int wrap2 = 0;
            PolySeg left = active;
            PolySeg edge = active;
            while (edge != null) {
                if ((wrap2 += edge.direction) == 0) {
                    int x;
                    int j = left.fx + 32768 >> 16;
                    int k = edge.fx + 32768 >> 16;
                    if (pattern != null) {
                        int pat = pattern[ycur & 0xF];
                        if (pat != 0) {
                            int x2;
                            if (layerBitMap == null) {
                                int baseIndex = ycur * this.sz.width;
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int index2 = baseIndex + x2;
                                    this.opaqueData[index2] = col;
                                }
                            } else {
                                byte[] row = layerBitMap[ycur];
                                for (x2 = j; x2 <= k; ++x2) {
                                    if ((pat & 1 << 15 - (x2 & 0xF)) == 0) continue;
                                    int n = x2 >> 3;
                                    row[n] = (byte)(row[n] | 1 << (x2 & 7));
                                }
                            }
                        }
                    } else if (layerBitMap == null) {
                        int baseIndex = ycur * this.sz.width;
                        for (x = j; x <= k; ++x) {
                            this.opaqueData[baseIndex + x] = col;
                        }
                    } else {
                        byte[] row = layerBitMap[ycur];
                        for (x = j; x <= k; ++x) {
                            int n = x >> 3;
                            row[n] = (byte)(row[n] | 1 << (x & 7));
                        }
                    }
                    left = edge.nextactive;
                }
                edge = edge.nextactive;
            }
            ++ycur;
            PolySeg lastedge = null;
            PolySeg edge2 = active;
            while (edge2 != null) {
                if (ycur >= edge2.ty) {
                    if (lastedge == null) {
                        active = edge2.nextactive;
                    } else {
                        lastedge.nextactive = edge2.nextactive;
                    }
                } else {
                    edge2.fx += edge2.increment;
                    lastedge = edge2;
                }
                edge2 = edge2.nextactive;
            }
        }
        if (pattern != null && (o = desc.getOutlined()) != EGraphics.Outline.NOPAT) {
            for (int i2 = 0; i2 < points.length; ++i2) {
                int last2 = i2 - 1;
                if (last2 < 0) {
                    last2 = points.length - 1;
                }
                int fX = points[last2].x;
                int fY = points[last2].y;
                int tX = points[i2].x;
                int tY = points[i2].y;
                this.drawOutline(fX, fY, tX, tY, layerBitMap, col, o.getPattern(), o.getLen());
                if (o.getThickness() == 1) continue;
                int ang = GenMath.figureAngle(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY));
                double sin = DBMath.sin(ang + 900);
                double cos = DBMath.cos(ang + 900);
                for (int t = 1; t < o.getThickness(); ++t) {
                    int dX = (int)(cos * (double)t + 0.5);
                    int dY = (int)(sin * (double)t + 0.5);
                    this.drawOutline(fX + dX, fY + dY, tX + dX, tY + dY, layerBitMap, col, o.getPattern(), o.getLen());
                }
            }
        }
    }

    public void drawText(Rectangle rect, Poly.Type style, TextDescriptor descript, String s, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len == 0) {
            return;
        }
        int col = gp.getColor(User.ColorPrefType.TEXT).getRGB() & 0xFFFFFF;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int size2 = EditWindow.getDefaultFontSize();
        String fontName = PixelDrawing.gp.defaultFont;
        boolean italic = false;
        boolean bold = false;
        boolean underline = false;
        int rotation = 0;
        int greekScale = 0;
        int shiftUp = 0;
        if (descript != null) {
            AbstractTextDescriptor.ActiveFont af;
            double dSize;
            Color full;
            rotation = descript.getRotation().getIndex();
            int colorIndex = descript.getColorIndex();
            if (colorIndex != 0 && (full = EGraphics.getColorFromIndex(colorIndex, null)) != null) {
                col = full.getRGB() & 0xFFFFFF;
            }
            if ((size2 = (int)(dSize = descript.getTrueSize(this.scale, this.wnd))) < 5) {
                greekScale = 2;
                while ((size2 = (int)(dSize * (double)greekScale)) < 5) {
                    greekScale *= 2;
                }
            }
            while (size2 > 100) {
                size2 /= 2;
                ++shiftUp;
            }
            italic = descript.isItalic();
            bold = descript.isBold();
            underline = descript.isUnderline();
            int fontIndex = descript.getFace();
            if (fontIndex != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont(fontIndex)) != null) {
                fontName = af.getName();
            }
        }
        if (style == Poly.Type.TEXTBOX && (rect.x >= this.sz.width || rect.x + rect.width < 0 || rect.y >= this.sz.height || rect.y + rect.height < 0)) {
            return;
        }
        RenderTextInfo renderInfo = new RenderTextInfo();
        if (!renderInfo.buildInfo(s, fontName, size2, italic, bold, underline, rect, style, rotation, shiftUp)) {
            return;
        }
        if (greekScale != 0) {
            int lY;
            int width = (int)renderInfo.bounds.getWidth() / greekScale;
            int sizeIndent = (size2 / greekScale + 1) / 4;
            Point pt = PixelDrawing.getTextCorner(width, size2 / greekScale, style, rect, rotation);
            int lX = pt.x;
            int hX = lX + width;
            int hY = lY = pt.y + sizeIndent;
            if (lX < 0) {
                lX = 0;
            }
            if (hX >= this.sz.width) {
                hX = this.sz.width - 1;
            }
            if (lY < 0) {
                lY = 0;
            }
            if (hY >= this.sz.height) {
                hY = this.sz.height - 1;
            }
            this.drawBox(lX, hX, lY, hY, layerBitMap, desc, dimmed);
            return;
        }
        if (renderInfo.bounds.getMinX() >= (double)this.sz.width || renderInfo.bounds.getMaxX() < 0.0 || renderInfo.bounds.getMinY() >= (double)this.sz.height || renderInfo.bounds.getMaxY() < 0.0) {
            return;
        }
        Raster ras = this.renderText(renderInfo);
        if (ras == null) {
            return;
        }
        int rasWidth = (int)renderInfo.rasBounds.getWidth() << shiftUp;
        int rasHeight = (int)renderInfo.rasBounds.getHeight() << shiftUp;
        Point pt = PixelDrawing.getTextCorner(rasWidth, rasHeight, style, rect, rotation);
        int atX = pt.x;
        int atY = pt.y;
        DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
        byte[] samples = dbb.getData();
        switch (rotation) {
            case 0: {
                int sx = Math.max(0, -atX);
                int ex = Math.min(rasWidth, this.sz.width - atX);
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    int samp = (y >> shiftUp) * this.textImageWidth;
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[samp + (x >> shiftUp)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 1: {
                int sx = Math.max(0, -atX);
                int ex = Math.min(rasHeight, this.sz.width - atX);
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY - y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int alpha = samples[(x >> shiftUp) * this.textImageWidth + (y >> shiftUp)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 2: {
                atY -= rasHeight;
                int sx = Math.max(0, -(atX -= rasWidth));
                int ex = Math.min(rasWidth, this.sz.width - atX);
                for (int y = 0; y < rasHeight; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX + x;
                        int index2 = (rasHeight - y - 1 >> shiftUp) * this.textImageWidth + (rasWidth - x - 1 >> shiftUp);
                        int alpha = samples[index2] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
            case 3: {
                int sx = Math.max(0, atX - this.sz.width + 1);
                int ex = Math.min(rasHeight, atX + 1);
                for (int y = 0; y < rasWidth; ++y) {
                    int trueY = atY + y;
                    if (trueY < 0 || trueY >= this.sz.height) continue;
                    byte[] row = null;
                    int baseIndex = 0;
                    if (layerBitMap == null) {
                        baseIndex = trueY * this.sz.width;
                    } else {
                        row = layerBitMap[trueY];
                    }
                    for (int x = sx; x < ex; ++x) {
                        int trueX = atX - x;
                        int alpha = samples[(x >> shiftUp) * this.textImageWidth + (y >> shiftUp)] & 0xFF;
                        if (alpha == 0) continue;
                        if (layerBitMap == null) {
                            int fullIndex = baseIndex + trueX;
                            int pixelValue = this.opaqueData[fullIndex];
                            int oldAlpha = pixelValue >> 24 & 0xFF;
                            int color = col;
                            if (oldAlpha == 0) {
                                if (alpha != 255) {
                                    color = this.alphaBlend(color, pixelValue, alpha);
                                }
                            } else if (oldAlpha == 255 && alpha < 255) {
                                color = color & 0xFFFFFF | alpha << 24;
                            }
                            this.opaqueData[fullIndex] = color;
                            continue;
                        }
                        if (alpha < 128) continue;
                        int n = trueX >> 3;
                        row[n] = (byte)(row[n] | 1 << (trueX & 7));
                    }
                }
                break;
            }
        }
    }

    private int alphaBlend(int color, int backgroundColor, int alpha) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int inverseAlpha = 254 - alpha;
        int redBack = backgroundColor >> 16 & 0xFF;
        int greenBack = backgroundColor >> 8 & 0xFF;
        int blueBack = backgroundColor & 0xFF;
        red = (red * alpha + redBack * inverseAlpha) / 255;
        green = (green * alpha + greenBack * inverseAlpha) / 255;
        blue = (blue * alpha + blueBack * inverseAlpha) / 255;
        color = red << 16 | (green << 8) + blue;
        return color;
    }

    private static Point getTextCorner(int rasterWidth, int rasterHeight, Poly.Type style, Rectangle rect, int rotation) {
        int textWidth = rasterWidth;
        int textHeight = rasterHeight;
        int offX = 0;
        int offY = 0;
        if (style == Poly.Type.TEXTCENT) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTTOP) {
            offX = -textWidth / 2;
        } else if (style == Poly.Type.TEXTBOT) {
            offX = -textWidth / 2;
            offY = -textHeight;
        } else if (style == Poly.Type.TEXTLEFT) {
            offY = -textHeight / 2;
        } else if (style == Poly.Type.TEXTRIGHT) {
            offX = -textWidth;
            offY = -textHeight / 2;
        } else if (style != Poly.Type.TEXTTOPLEFT) {
            if (style == Poly.Type.TEXTBOTLEFT) {
                offY = -textHeight;
            } else if (style == Poly.Type.TEXTTOPRIGHT) {
                offX = -textWidth;
            } else if (style == Poly.Type.TEXTBOTRIGHT) {
                offX = -textWidth;
                offY = -textHeight;
            }
        }
        if (style == Poly.Type.TEXTBOX) {
            offX = -textWidth / 2;
            offY = -textHeight / 2;
        }
        if (rotation != 0) {
            int saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = offY;
                    offY = -saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = -offY;
                    offY = saveOffX;
                }
            }
        }
        int cX = (int)rect.getCenterX() + offX;
        int cY = (int)rect.getCenterY() + offY;
        return new Point(cX, cY);
    }

    private Raster renderText(RenderTextInfo renderInfo) {
        Font theFont = renderInfo.font;
        if (theFont == null) {
            return null;
        }
        int width = (int)renderInfo.rasBounds.getWidth();
        int height = (int)renderInfo.rasBounds.getHeight();
        GlyphVector gv = renderInfo.gv;
        LineMetrics lm = renderInfo.lm;
        if (width <= 0 || height <= 0) {
            return null;
        }
        if (width > this.textImageWidth || height > this.textImageHeight) {
            this.textImage = null;
        }
        if (this.textImage == null) {
            this.textImageWidth = width;
            this.textImageHeight = height;
            this.textImage = new BufferedImage(width, height, 10);
            this.textImageGraphics = this.textImage.createGraphics();
        } else {
            this.textImageGraphics.setColor(Color.BLACK);
            this.textImageGraphics.fillRect(0, 0, width, height);
        }
        Graphics2D g2 = (Graphics2D)this.textImage.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(new Color(255, 255, 255));
        g2.drawGlyphVector(gv, (float)(-renderInfo.rasBounds.getX()), lm.getAscent() - lm.getLeading());
        if (renderInfo.underline) {
            g2.drawLine(0, height - 1, width - 1, height - 1);
        }
        return this.textImage.getData();
    }

    public static Font getFont(String msg, String font, int tSize, boolean italic, boolean bold, boolean underline) {
        Font theFont;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(font, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        return theFont;
    }

    void drawCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int x;
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        int y = radius;
        int d = 3 - 2 * radius;
        if (left >= 0 && right < this.sz.width && top >= 0 && bottom < this.sz.height) {
            for (x = 0; x <= y; ++x) {
                if (layerBitMap == null) {
                    int baseIndex = (center.y + y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y - y) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + x)] = col;
                    this.opaqueData[baseIndex + (center.x - x)] = col;
                    baseIndex = (center.y + x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                    baseIndex = (center.y - x) * this.sz.width;
                    this.opaqueData[baseIndex + (center.x + y)] = col;
                    this.opaqueData[baseIndex + (center.x - y)] = col;
                } else {
                    byte[] row = layerBitMap[center.y + y];
                    int n = center.x + x >> 3;
                    row[n] = (byte)(row[n] | 1 << (center.x + x & 7));
                    int n2 = center.x - x >> 3;
                    row[n2] = (byte)(row[n2] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y - y];
                    int n3 = center.x + x >> 3;
                    row[n3] = (byte)(row[n3] | 1 << (center.x + x & 7));
                    int n4 = center.x - x >> 3;
                    row[n4] = (byte)(row[n4] | 1 << (center.x - x & 7));
                    row = layerBitMap[center.y + x];
                    int n5 = center.x + y >> 3;
                    row[n5] = (byte)(row[n5] | 1 << (center.x + y & 7));
                    int n6 = center.x - y >> 3;
                    row[n6] = (byte)(row[n6] | 1 << (center.x - y & 7));
                    row = layerBitMap[center.y - x];
                    int n7 = center.x + y >> 3;
                    row[n7] = (byte)(row[n7] | 1 << (center.x + y & 7));
                    int n8 = center.x - y >> 3;
                    row[n8] = (byte)(row[n8] | 1 << (center.x - y & 7));
                }
                if (d < 0) {
                    d += 4 * x + 6;
                    continue;
                }
                d += 4 * (x - y) + 10;
                --y;
            }
        } else {
            while (x <= y) {
                int thisx;
                int thisy = center.y + y;
                if (thisy >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + x;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                    thisx = center.x + y;
                    if (thisx >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                    if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                        this.drawPoint(thisx, thisy, layerBitMap, col);
                    }
                }
                if (d < 0) {
                    d += 4 * x + 6;
                } else {
                    d += 4 * (x - y) + 10;
                    --y;
                }
                ++x;
            }
        }
    }

    void drawThickCircle(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            int thisx;
            int thisy = center.y + y;
            if (thisy >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - y) >= 0 && thisy < this.sz.height) {
                thisx = center.x + x;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - x) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y + x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if ((thisy = center.y - x) >= 0 && thisy < this.sz.height) {
                thisx = center.x + y;
                if (thisx >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
                if ((thisx = center.x - y) >= 0 && thisx < this.sz.width) {
                    this.drawThickPoint(thisx, thisy, layerBitMap, col);
                }
            }
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private void drawDiscRow(int thisy, int startx, int endx, byte[][] layerBitMap, int col, int[] pattern) {
        block12: {
            block11: {
                if (thisy < 0 || thisy >= this.sz.height) {
                    return;
                }
                if (startx < 0) {
                    startx = 0;
                }
                if (endx >= this.sz.width) {
                    endx = this.sz.width - 1;
                }
                if (pattern == null) break block11;
                int pat = pattern[thisy & 0xF];
                if (pat == 0) break block12;
                if (layerBitMap == null) {
                    int baseIndex = thisy * this.sz.width;
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        this.opaqueData[baseIndex + x] = col;
                    }
                } else {
                    byte[] row = layerBitMap[thisy];
                    for (int x = startx; x <= endx; ++x) {
                        if ((pat & 1 << 15 - (x & 0xF)) == 0) continue;
                        int n = x >> 3;
                        row[n] = (byte)(row[n] | 1 << (x & 7));
                    }
                }
                break block12;
            }
            if (layerBitMap == null) {
                int baseIndex = thisy * this.sz.width;
                for (int x = startx; x <= endx; ++x) {
                    int index2 = baseIndex + x;
                    int alpha = this.opaqueData[index2] >> 24 & 0xFF;
                    if (alpha != 255) continue;
                    this.opaqueData[index2] = col;
                }
            } else {
                byte[] row = layerBitMap[thisy];
                for (int x = startx; x <= endx; ++x) {
                    int n = x >> 3;
                    row[n] = (byte)(row[n] | 1 << (x & 7));
                }
            }
        }
    }

    void drawDisc(Point center, Point edge, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        int radius = (int)center.distance(edge);
        int col = 0;
        int[] pattern = null;
        if (desc != null) {
            col = this.getTheColor(desc, dimmed);
            if (this.nowPrinting != 0 ? desc.isPatternedOnPrinter() : desc.isPatternedOnDisplay()) {
                pattern = desc.getPattern();
                if (desc.getOutlined() != EGraphics.Outline.NOPAT) {
                    this.drawCircle(center, edge, layerBitMap, desc, dimmed);
                }
            }
        }
        int left = center.x - radius;
        int right = center.x + radius + 1;
        int top = center.y - radius;
        int bottom = center.y + radius + 1;
        if (radius == 1) {
            if (left < 0) {
                left = 0;
            }
            if (right >= this.sz.width) {
                right = this.sz.width - 1;
            }
            for (int y = top; y < bottom; ++y) {
                if (y < 0 || y >= this.sz.height) continue;
                for (int x = left; x < right; ++x) {
                    this.drawPoint(x, y, layerBitMap, col);
                }
            }
            return;
        }
        int y = radius;
        int d = 3 - 2 * radius;
        for (int x = 0; x <= y; ++x) {
            this.drawDiscRow(center.y + y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - y, center.x - x, center.x + x, layerBitMap, col, pattern);
            this.drawDiscRow(center.y + x, center.x - y, center.x + y, layerBitMap, col, pattern);
            this.drawDiscRow(center.y - x, center.x - y, center.x + y, layerBitMap, col, pattern);
            if (d < 0) {
                d += 4 * x + 6;
                continue;
            }
            d += 4 * (x - y) + 10;
            --y;
        }
    }

    private int arcFindOctant(int x, int y) {
        if (x > 0) {
            if (y >= 0) {
                if (y >= x) {
                    return 7;
                }
                return 8;
            }
            if (x >= -y) {
                return 1;
            }
            return 2;
        }
        if (y > 0) {
            if (y > -x) {
                return 6;
            }
            return 5;
        }
        if (y > x) {
            return 4;
        }
        return 3;
    }

    private Point arcXformOctant(int x, int y, int oct) {
        switch (oct) {
            case 1: {
                return new Point(-y, x);
            }
            case 2: {
                return new Point(x, -y);
            }
            case 3: {
                return new Point(-x, -y);
            }
            case 4: {
                return new Point(-y, -x);
            }
            case 5: {
                return new Point(y, -x);
            }
            case 6: {
                return new Point(-x, y);
            }
            case 7: {
                return new Point(x, y);
            }
            case 8: {
                return new Point(y, x);
            }
        }
        return null;
    }

    private void arcDoPixel(int x, int y) {
        if (x < 0 || x >= this.sz.width || y < 0 || y >= this.sz.height) {
            return;
        }
        if (this.arcThick) {
            this.drawThickPoint(x, y, this.arcLayerBitMap, this.arcCol);
        } else {
            this.drawPoint(x, y, this.arcLayerBitMap, this.arcCol);
        }
    }

    private void arcOutXform(int x, int y) {
        if (this.arcOctTable[1]) {
            this.arcDoPixel(y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[2]) {
            this.arcDoPixel(x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[3]) {
            this.arcDoPixel(-x + this.arcCenter.x, -y + this.arcCenter.y);
        }
        if (this.arcOctTable[4]) {
            this.arcDoPixel(-y + this.arcCenter.x, -x + this.arcCenter.y);
        }
        if (this.arcOctTable[5]) {
            this.arcDoPixel(-y + this.arcCenter.x, x + this.arcCenter.y);
        }
        if (this.arcOctTable[6]) {
            this.arcDoPixel(-x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[7]) {
            this.arcDoPixel(x + this.arcCenter.x, y + this.arcCenter.y);
        }
        if (this.arcOctTable[8]) {
            this.arcDoPixel(y + this.arcCenter.x, x + this.arcCenter.y);
        }
    }

    private void arcBresCW(Point pt, Point pt1) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt1.x && pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        while (pt.x < pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.x;
        }
        while (pt.y > pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            --pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    private void arcBresMidCW(Point pt) {
        int d = 3 - 2 * pt.y + 4 * pt.x;
        while (pt.x < pt.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d < 0) {
                d += 4 * pt.x + 6;
            } else {
                d += 4 * (pt.x - pt.y) + 10;
                --pt.y;
            }
            ++pt.x;
        }
        if (pt.x == pt.y) {
            this.arcOutXform(pt.x, pt.y);
        }
    }

    private void arcBresMidCCW(Point pt) {
        int d = 3 + 2 * pt.y - 4 * pt.x;
        while (pt.x > 0) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        this.arcOutXform(0, this.arcRadius);
    }

    private void arcBresCCW(Point pt, Point pt1) {
        int d = 3 + 2 * pt.y + 4 * pt.x;
        while (pt.x > pt1.x && pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            if (d > 0) {
                d += 6 - 4 * pt.x;
            } else {
                d += 4 * (pt.y - pt.x) + 10;
                ++pt.y;
            }
            --pt.x;
        }
        while (pt.x > pt1.x) {
            this.arcOutXform(pt.x, pt.y);
            --pt.x;
        }
        while (pt.y < pt1.y) {
            this.arcOutXform(pt.x, pt.y);
            ++pt.y;
        }
        this.arcOutXform(pt1.x, pt1.y);
    }

    void drawCircleArc(Point center, Point p1, Point p2, boolean thick, boolean bigArc, byte[][] layerBitMap, EGraphics desc, boolean dimmed) {
        if (p1.x == p2.x && p1.y == p2.y) {
            return;
        }
        this.arcLayerBitMap = layerBitMap;
        this.arcCol = 0;
        if (desc != null) {
            this.arcCol = this.getTheColor(desc, dimmed);
        }
        this.arcCenter = center;
        int pa_x = p2.x - this.arcCenter.x;
        int pa_y = p2.y - this.arcCenter.y;
        int pb_x = p1.x - this.arcCenter.x;
        int pb_y = p1.y - this.arcCenter.y;
        this.arcRadius = (int)this.arcCenter.distance(p2);
        int alternate = (int)this.arcCenter.distance(p1);
        int start_oct = this.arcFindOctant(pa_x, pa_y);
        int end_oct = this.arcFindOctant(pb_x, pb_y);
        this.arcThick = thick;
        if (this.arcRadius != alternate) {
            int diff2 = this.arcRadius - alternate;
            switch (end_oct) {
                case 6: 
                case 7: {
                    pb_y += diff2;
                    break;
                }
                case 1: 
                case 8: {
                    pb_x += diff2;
                    break;
                }
                case 2: 
                case 3: {
                    pb_y -= diff2;
                    break;
                }
                case 4: 
                case 5: {
                    pb_x -= diff2;
                }
            }
        }
        for (int i = 1; i < 9; ++i) {
            this.arcOctTable[i] = false;
        }
        if (start_oct == end_oct && !bigArc) {
            this.arcOctTable[start_oct] = true;
            Point pa = this.arcXformOctant(pa_x, pa_y, start_oct);
            Point pb = this.arcXformOctant(pb_x, pb_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresCW(pa, pb);
            } else {
                this.arcBresCCW(pa, pb);
            }
            this.arcOctTable[start_oct] = false;
        } else {
            this.arcOctTable[start_oct] = true;
            Point pt = this.arcXformOctant(pa_x, pa_y, start_oct);
            if ((start_oct & 1) != 0) {
                this.arcBresMidCW(pt);
            } else {
                this.arcBresMidCCW(pt);
            }
            this.arcOctTable[start_oct] = false;
            this.arcOctTable[end_oct] = true;
            pt = this.arcXformOctant(pb_x, pb_y, end_oct);
            if ((end_oct & 1) != 0) {
                this.arcBresMidCCW(pt);
            } else {
                this.arcBresMidCW(pt);
            }
            this.arcOctTable[end_oct] = false;
            if (this.MODP(start_oct + 1) != end_oct) {
                if (this.MODP(start_oct + 1) == this.MODM(end_oct - 1)) {
                    this.arcOctTable[this.MODP((int)(start_oct + 1))] = true;
                } else {
                    int i = this.MODP(start_oct + 1);
                    while (i != end_oct) {
                        this.arcOctTable[i] = true;
                        i = this.MODP(i + 1);
                    }
                }
                this.arcBresMidCW(new Point(0, this.arcRadius));
            }
        }
    }

    private int MODM(int x) {
        return x < 1 ? x + 8 : x;
    }

    private int MODP(int x) {
        return x > 8 ? x - 8 : x;
    }

    void drawPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            this.opaqueData[y * this.sz.width + x] = col;
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
        }
    }

    private void drawThickPoint(int x, int y, byte[][] layerBitMap, int col) {
        if (layerBitMap == null) {
            int baseIndex = y * this.sz.width + x;
            this.opaqueData[baseIndex] = col;
            if (x > 0) {
                this.opaqueData[baseIndex - 1] = col;
            }
            if (x < this.sz.width - 1) {
                this.opaqueData[baseIndex + 1] = col;
            }
            if (y > 0) {
                this.opaqueData[baseIndex - this.sz.width] = col;
            }
            if (y < this.sz.height - 1) {
                this.opaqueData[baseIndex + this.sz.width] = col;
            }
        } else {
            byte[] byArray = layerBitMap[y];
            int n = x >> 3;
            byArray[n] = (byte)(byArray[n] | 1 << (x & 7));
            if (x > 0) {
                byte[] byArray2 = layerBitMap[y];
                int n2 = x - 1 >> 3;
                byArray2[n2] = (byte)(byArray2[n2] | 1 << (x - 1 & 7));
            }
            if (x < this.sz.width - 1) {
                byte[] byArray3 = layerBitMap[y];
                int n3 = x + 1 >> 3;
                byArray3[n3] = (byte)(byArray3[n3] | 1 << (x + 1 & 7));
            }
            if (y > 0) {
                byte[] byArray4 = layerBitMap[y - 1];
                int n4 = x >> 3;
                byArray4[n4] = (byte)(byArray4[n4] | 1 << (x & 7));
            }
            if (y < this.sz.height - 1) {
                byte[] byArray5 = layerBitMap[y + 1];
                int n5 = x >> 3;
                byArray5[n5] = (byte)(byArray5[n5] | 1 << (x & 7));
            }
        }
    }

    private void databaseToScreen(double dbX, double dbY, Point result2) {
        double scrX = this.originX + dbX * this.scale;
        double scrY = this.originY - dbY * this.scale;
        result2.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result2.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private void screenToDatabase(int x, int y, Point2D result2) {
        result2.setLocation(((double)x - this.originX) / this.scale, (this.originY - (double)y) / this.scale);
    }

    private Rectangle databaseToScreen(Rectangle2D db) {
        int swap;
        Point llPt = this.tempPt1;
        Point urPt = this.tempPt2;
        this.databaseToScreen(db.getMinX(), db.getMinY(), llPt);
        this.databaseToScreen(db.getMaxX(), db.getMaxY(), urPt);
        int screenLX = llPt.x;
        int screenHX = urPt.x;
        int screenLY = llPt.y;
        int screenHY = urPt.y;
        if (screenHX < screenLX) {
            swap = screenHX;
            screenHX = screenLX;
            screenLX = swap;
        }
        if (screenHY < screenLY) {
            swap = screenHY;
            screenHY = screenLY;
            screenLY = swap;
        }
        return new Rectangle(screenLX, screenLY, screenHX - screenLX + 1, screenHY - screenLY + 1);
    }

    static {
        expandedCells = null;
        changedCells = new HashSet<CellId>();
        expandedScale = 0.0;
        CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        gridGraphics = textGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceGraphics = textGraphics;
    }

    private static class RenderTextInfo {
        private Font font;
        private GlyphVector gv;
        private LineMetrics lm;
        private Point2D anchorPoint;
        private Rectangle2D rasBounds;
        private Rectangle2D bounds;
        private boolean underline;

        private RenderTextInfo() {
        }

        private boolean buildInfo(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline, Rectangle probableBoxedBounds, Poly.Type style, int rotation, int shiftUp) {
            this.font = PixelDrawing.getFont(msg, fontName, tSize, italic, bold, underline);
            this.underline = underline;
            FontRenderContext frc = new FontRenderContext(null, true, true);
            this.gv = this.font.createGlyphVector(frc, msg);
            this.lm = this.font.getLineMetrics(msg, frc);
            Rectangle2D rasRect = this.gv.getLogicalBounds();
            int width = (int)rasRect.getWidth();
            int height = (int)((double)this.lm.getHeight() + 0.5);
            if (width <= 0 || height <= 0) {
                return false;
            }
            int fontStyle = this.font.getStyle();
            int boxedWidth = (int)probableBoxedBounds.getWidth() >> shiftUp;
            int boxedHeight = (int)probableBoxedBounds.getHeight() >> shiftUp;
            if (boxedWidth > 1 && boxedHeight > 1 && (width > boxedWidth || height > boxedHeight)) {
                double scale = Math.min((double)boxedWidth / (double)width, (double)boxedHeight / (double)height);
                this.font = new Font(fontName, fontStyle, (int)((double)tSize * scale));
                if (this.font != null) {
                    this.gv = this.font.createGlyphVector(frc, msg);
                    this.lm = this.font.getLineMetrics(msg, frc);
                    rasRect = this.gv.getLogicalBounds();
                    height = (int)((double)this.lm.getHeight() + 0.5);
                    if (height <= 0) {
                        return false;
                    }
                    width = (int)rasRect.getWidth();
                }
            }
            if (underline) {
                ++height;
            }
            this.rasBounds = new Rectangle2D.Double(0.0, this.lm.getAscent() - this.lm.getLeading(), width, height);
            this.anchorPoint = PixelDrawing.getTextCorner(width, height, style, probableBoxedBounds, rotation);
            this.bounds = rotation == 1 || rotation == 3 ? new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), height, width) : new Rectangle2D.Double(this.anchorPoint.getX(), this.anchorPoint.getY(), width, height);
            return true;
        }
    }

    static interface ERaster {
        public void fillBox(int var1, int var2, int var3, int var4);

        public void fillHorLine(int var1, int var2, int var3);

        public void fillVerLine(int var1, int var2, int var3);

        public void fillPoint(int var1, int var2);

        public void drawHorLine(int var1, int var2, int var3);

        public void drawVerLine(int var1, int var2, int var3);

        public void drawPoint(int var1, int var2);

        public EGraphics.Outline getOutline();
    }

    static class Drawing
    extends AbstractDrawing {
        private final int displayAlgorithm = User.getDisplayAlgorithm();
        private final boolean useCellGreekingImages = User.isUseCellGreekingImages();
        private final double greekSizeLimit = User.getGreekSizeLimit();
        private final double greekCellSizeLimit = User.getGreekCellSizeLimit();
        private final VectorDrawing vd = new VectorDrawing(this.useCellGreekingImages);
        private volatile PixelDrawing offscreen;

        Drawing(EditWindow wnd) {
            super(wnd);
        }

        public boolean paintComponent(Graphics2D g, LayerVisibility lv, Dimension sz) {
            assert (SwingUtilities.isEventDispatchThread());
            assert (sz.equals(this.wnd.getSize()));
            PixelDrawing offscreen = this.offscreen;
            if (offscreen == null || !offscreen.getSize().equals(sz)) {
                return false;
            }
            g.drawImage((Image)offscreen.getBufferedImage(), 0, 0, this.wnd);
            return true;
        }

        public void render(Dimension sz, WindowFrame.DisplayAttributes da, GraphicsPreferences gp, AbstractDrawing.DrawingPreferences dp, boolean fullInstantiate, Rectangle2D bounds) {
            PixelDrawing.gp = gp;
            PixelDrawing.dp = dp;
            PixelDrawing offscreen_ = this.offscreen;
            if (offscreen_ == null || !offscreen_.getSize().equals(sz)) {
                this.offscreen = offscreen_ = new PixelDrawing(sz);
            }
            this.da = da;
            boolean isPixelDrawing = this.displayAlgorithm == 0;
            offscreen_.drawImage(this, fullInstantiate, bounds, isPixelDrawing, this.greekSizeLimit, this.greekCellSizeLimit);
        }

        public void abortRendering() {
            if (this.displayAlgorithm > 0) {
                this.vd.abortRendering();
            }
        }
    }

    private static class PatternedOpaqueLayer {
        private byte[][] layerBitMap;

        PatternedOpaqueLayer(int height, int numBytesPerRow) {
            this.layerBitMap = new byte[height][numBytesPerRow];
        }
    }

    private static class ExpandedCellInfo {
        private boolean singleton = true;
        private int instanceCount;
        private PixelDrawing offscreen = null;

        ExpandedCellInfo() {
        }
    }

    private static class ExpandedCellKey {
        private Cell cell;
        private Orientation orient;

        private ExpandedCellKey(Cell cell, Orientation orient) {
            this.cell = cell;
            this.orient = orient;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExpandedCellKey) {
                ExpandedCellKey that = (ExpandedCellKey)obj;
                return this.cell == that.cell && this.orient.equals(that.orient);
            }
            return false;
        }

        public int hashCode() {
            return this.cell.hashCode() ^ this.orient.hashCode();
        }
    }

    private static class PolySeg {
        private int fx;
        private int fy;
        private int tx;
        private int ty;
        private int direction;
        private int increment;
        private PolySeg nextedge;
        private PolySeg nextactive;

        private PolySeg() {
        }
    }
}

