/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterThreadV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.RegionDirection;
import com.sun.electric.tool.routing.experimentalLeeMoore2.Vector2i;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DemandTemplateHandler {
    GlobalRouterThreadV3 grt;
    int max_demand_estimate = 8;

    public DemandTemplateHandler(GlobalRouterThreadV3 gr_thread) {
        this.grt = gr_thread;
    }

    public void AddDemandEstimate(Vector2i start, Vector2i end) {
        ArrayList<DemandEstimationJob> template = this.CalcDemandTemplate(start, end);
        this.ApplyDemandTemplate(template, true);
    }

    public void DecrementDemandEstimate(Vector2i start, Vector2i end) {
        ArrayList<DemandEstimationJob> template = this.CalcDemandTemplate(start, end);
        this.ApplyDemandTemplate(template, false);
    }

    private ArrayList<DemandEstimationJob> CalcDemandTemplate(Vector2i start, Vector2i end) {
        RegionDirection dir;
        Vector2i pos;
        int dist;
        int e_dist;
        int s_dist;
        ArrayList<DemandEstimationJob> demand_job_queue = new ArrayList<DemandEstimationJob>();
        int hor_dir = end.x - start.x >= 0 ? 1 : -1;
        int ver_dir = end.y - start.y >= 0 ? 1 : -1;
        RegionDirection curr_dir = hor_dir == 1 ? RegionDirection.rd_right : RegionDirection.rd_left;
        Vector2i it = new Vector2i(start.x, start.y);
        while (it.x != end.x) {
            s_dist = this.max_demand_estimate - Math.abs(it.x - start.x) + 1;
            s_dist = s_dist >= 0 ? s_dist : 0;
            e_dist = this.max_demand_estimate - Math.abs(it.x - end.x) + 1;
            e_dist = e_dist >= 0 ? e_dist : 0;
            dist = e_dist + s_dist;
            pos = new Vector2i(it);
            dir = curr_dir;
            demand_job_queue.add(new DemandEstimationJob(pos, dir, dist));
            it.x += hor_dir;
        }
        RegionDirection regionDirection = curr_dir = ver_dir == 1 ? RegionDirection.rd_up : RegionDirection.rd_down;
        while (it.y != end.y) {
            s_dist = this.max_demand_estimate - Math.abs(it.y - start.y) + 1;
            s_dist = s_dist >= 0 ? s_dist : 0;
            e_dist = this.max_demand_estimate - Math.abs(it.y - end.y) + 1;
            e_dist = e_dist >= 0 ? e_dist : 0;
            dist = e_dist + s_dist;
            pos = new Vector2i(it);
            dir = curr_dir;
            demand_job_queue.add(new DemandEstimationJob(pos, dir, dist));
            it.y += ver_dir;
        }
        hor_dir -= 2 * hor_dir;
        ver_dir -= 2 * ver_dir;
        RegionDirection regionDirection2 = curr_dir = hor_dir == 1 ? RegionDirection.rd_right : RegionDirection.rd_left;
        while (it.x != start.x) {
            s_dist = this.max_demand_estimate - Math.abs(it.x - start.x) + 1;
            s_dist = s_dist >= 0 ? s_dist : 0;
            e_dist = this.max_demand_estimate - Math.abs(it.x - end.x) + 1;
            e_dist = e_dist >= 0 ? e_dist : 0;
            dist = e_dist + s_dist;
            pos = new Vector2i(it);
            dir = curr_dir;
            demand_job_queue.add(new DemandEstimationJob(pos, dir, dist));
            it.x += hor_dir;
        }
        RegionDirection regionDirection3 = curr_dir = ver_dir == 1 ? RegionDirection.rd_up : RegionDirection.rd_down;
        while (it.y != start.y) {
            s_dist = this.max_demand_estimate - Math.abs(it.y - start.y) + 1;
            s_dist = s_dist >= 0 ? s_dist : 0;
            e_dist = this.max_demand_estimate - Math.abs(it.y - end.y) + 1;
            e_dist = e_dist >= 0 ? e_dist : 0;
            dist = e_dist + s_dist;
            pos = new Vector2i(it);
            dir = curr_dir;
            demand_job_queue.add(new DemandEstimationJob(pos, dir, dist));
            it.y += ver_dir;
        }
        return demand_job_queue;
    }

    private void ApplyDemandTemplate(ArrayList<DemandEstimationJob> template, boolean is_inc) {
        for (DemandEstimationJob job : template) {
            if (is_inc) {
                this.grt.rm.RegionAt(job.pos.x, job.pos.y).GetRegionBorder(job.dir).IncDemand();
                continue;
            }
            this.grt.rm.RegionAt(job.pos.x, job.pos.y).GetRegionBorder(job.dir).DecDemand();
        }
    }

    class DemandEstimationJob {
        public Vector2i pos;
        public RegionDirection dir;
        public int demand_increment;

        public DemandEstimationJob(Vector2i pos, RegionDirection dir, int demand_inc) {
            this.pos = pos;
            this.dir = dir;
            this.demand_increment = demand_inc;
        }
    }
}

