/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar3.map;

import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar3.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar3.memorymanager.ObjectPool;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashedInfiniteMap<T extends AStarNodeBase<T>>
extends AStarMapBase<T> {
    protected ObjectPool<T> nodePool;
    private int initialCapacity = 100;
    private HashMap<String, T> map = new HashMap(this.initialCapacity);
    protected HashMap<String, Boolean> blockedMap = new HashMap(this.initialCapacity);

    public HashedInfiniteMap(ObjectPool<T> nodePool) {
        this.nodePool = nodePool;
    }

    @Override
    public boolean isTileBlocked(int x, int y, int z) {
        Boolean result2 = this.blockedMap.get(this.calcKey(x, y, z));
        if (result2 == null) {
            return false;
        }
        return result2;
    }

    @Override
    public void setTileBlocked(int x, int y, int z, boolean blockedStatus) {
        this.blockedMap.put(this.calcKey(x, y, z), blockedStatus);
    }

    @Override
    public T nodeAt(int x, int y, int z) {
        String hash = this.calcKey(x, y, z);
        AStarNodeBase node = (AStarNodeBase)this.map.get(hash);
        if (node == null) {
            node = (AStarNodeBase)this.nodePool.acquire();
            node.initialize(null, 0, 0, 0, x, y, z);
            this.map.put(hash, node);
        }
        return (T)node;
    }

    private String calcKey(int x, int y, int z) {
        return x + "," + y + "," + z;
    }

    @Override
    public void clearMapKeepBlocks() {
        this.map.clear();
    }

    @Override
    public AStarMapBase<T> clone() {
        HashedInfiniteMap<T> newMap = new HashedInfiniteMap<T>(this.nodePool);
        newMap.blockedMap = (HashMap)this.blockedMap.clone();
        return newMap;
    }

    @Override
    public void visitNeighboursOf(T origin, AStarMapVisitorBase<T> visitor) {
        this.visitNeighboursOf4(origin, visitor);
    }

    @Override
    public int getMaxXNodes() {
        return 0;
    }

    @Override
    public int getMaxYNodes() {
        return 0;
    }

    @Override
    public int getMaxZNodes() {
        return 0;
    }
}

