/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand2LT {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inaY = -4.0;
    private static final double inbY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        Job.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        int i2;
        double totWid;
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        String nm = "nand2LT";
        sz = stdCell.checkMinStrength(sz, 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * 3.0 * 2.0, 2);
        Nand2LT.error(fwP == null, "can't make nand2 this small: " + sz);
        int nbStacked = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbStacked;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2LT.error(fwN == null, "can't make nand2LT this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double mosX = inaX + 2.0 + 3.0 + 2.0;
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, nbStacked, fwN.gateWid, nand, tech);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[fwP.nbFolds / 2];
        for (int i3 = 0; i3 < pmoss.length; ++i3) {
            double pmosPitch = 26.0;
            double pmosX = mosX + pmosPitch * (double)i3;
            pmoss[i3] = new FoldedPmos(pmosX, pmosY, 2, 1, fwP.gateWid, nand, tech);
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        double inbX = StdCellParams.getRightDiffX(nmos, pmoss) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, nand);
        inb.connect(nand.findExport("inb"));
        for (i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                inb.connect(nmos.getGate(i2 + 1, 'T'), tech.getPolyLShapeOffset());
                continue;
            }
            inb.connect(nmos.getGate(i2, 'T'), -6.5);
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            inb.connect(pmoss[i2].getGate(1, 'B'), -tech.getPolyLShapeOffset());
        }
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        TrackRouterH inA = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nand);
        inA.connect(nand.findExport("ina"));
        for (i = 0; i < nmos.nbGates(); i += 2) {
            if (i / 2 % 2 == 0) {
                inA.connect(nmos.getGate(i, 'T'), -tech.getPolyLShapeOffset());
                continue;
            }
            double offset = 6.5;
            PortInst g = nmos.getGate(i + 1, 'T');
            double contX = LayoutLib.roundCenterX(g) + offset;
            if (inbX - contX < 7.0) {
                offset -= 7.0 - (inbX - contX);
            }
            ((TrackRouter)inA).connect(g, offset, -tech.getPolyLShapeOffset());
        }
        for (i = 0; i < pmoss.length; ++i) {
            inA.connect(pmoss[i].getGate(0, 'B'), -tech.getPolyLShapeOffset());
        }
        double outX = inbX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, nand);
        outHi.connect(nand.findExport("out"));
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            outHi.connect(pmoss[i4].getSrcDrn(1));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nand);
        outLo.connect(nand.findExport("out"));
        for (int i5 = 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

