/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetlistShorted
extends Netlist {
    private Netlist baseNetlist;
    private int[] thisNetHead;
    private int[] baseNetNext;
    private BitSet isUsernamed = new BitSet();
    private BitSet isExported = new BitSet();
    private String[] firstNames;

    NetlistShorted(Netlist baseNetlist, Netlist.ShortResistors shortResistors, int[] netMap) {
        super(baseNetlist.netCell, shortResistors, baseNetlist.numExternalEntries, netMap);
        this.baseNetlist = baseNetlist;
        this.expectedSnapshot = baseNetlist.expectedSnapshot;
        this.expectedCellTree = baseNetlist.expectedCellTree;
        assert (this.nm_net.length == baseNetlist.nm_net.length);
        int[] baseNetToThisNet = new int[baseNetlist.getNumNetworks()];
        Arrays.fill(baseNetToThisNet, -1);
        for (int mapOffset = 0; mapOffset < this.nm_net.length; ++mapOffset) {
            int baseNetIndex = baseNetlist.nm_net[mapOffset];
            int thisNetIndex = this.nm_net[mapOffset];
            if (baseNetToThisNet[baseNetIndex] < 0) {
                baseNetToThisNet[baseNetIndex] = thisNetIndex;
                continue;
            }
            assert (baseNetToThisNet[baseNetIndex] == thisNetIndex);
        }
        for (int thisNet : baseNetToThisNet) {
            assert (thisNet >= 0);
        }
        this.thisNetHead = new int[this.getNumNetworks()];
        Arrays.fill(this.thisNetHead, -1);
        this.baseNetNext = new int[baseNetlist.getNumNetworks()];
        Arrays.fill(this.baseNetNext, -1);
        for (int baseNetIndex = baseNetlist.getNumNetworks() - 1; baseNetIndex >= 0; --baseNetIndex) {
            int thisNetIndex = baseNetToThisNet[baseNetIndex];
            this.baseNetNext[baseNetIndex] = this.thisNetHead[thisNetIndex];
            this.thisNetHead[thisNetIndex] = baseNetIndex;
            if (!baseNetlist.isUsernamed(baseNetIndex)) continue;
            this.isUsernamed.set(thisNetIndex);
        }
        for (int thisHead : this.thisNetHead) {
            assert (thisHead >= 0);
        }
        this.firstNames = new String[this.getNumNetworks()];
        for (int thisNetIndex = 0; thisNetIndex < this.getNumNetworks(); ++thisNetIndex) {
            this.makeName(thisNetIndex);
        }
    }

    @Override
    String getName(int netIndex) {
        String name = this.firstNames[netIndex];
        if (name != null) {
            return name;
        }
        return this.makeName(netIndex);
    }

    private String makeName(int thisNetIndex) {
        int baseIndexLimit = this.isExported(thisNetIndex) ? this.baseNetlist.getNumExternalNetworks() : this.baseNetlist.getNumNetworks();
        String firstName = null;
        if (this.isUsernamed(thisNetIndex)) {
            int baseNetIndex = this.thisNetHead[thisNetIndex];
            while (baseNetIndex >= 0 && baseNetIndex < baseIndexLimit) {
                if (this.baseNetlist.isUsernamed(baseNetIndex)) {
                    String name = this.baseNetlist.getName(baseNetIndex);
                    if (firstName == null || TextUtils.STRING_NUMBER_ORDER.compare(name, firstName) < 0) {
                        firstName = name;
                    }
                }
                baseNetIndex = this.baseNetNext[baseNetIndex];
            }
        } else {
            firstName = this.baseNetlist.getName(this.thisNetHead[thisNetIndex]);
        }
        this.firstNames[thisNetIndex] = firstName;
        return firstName;
    }

    @Override
    Iterator<String> getNames(int netIndex) {
        if (this.isUsernamed(netIndex)) {
            TreeSet<String> exportedNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
            TreeSet<String> privateNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
            this.fillNames(netIndex, exportedNames, privateNames);
            ArrayList<String> allNames = new ArrayList<String>(exportedNames);
            for (String name : privateNames) {
                if (exportedNames.contains(name)) continue;
                allNames.add(name);
            }
            return allNames.iterator();
        }
        return Collections.singleton(this.getName(netIndex)).iterator();
    }

    @Override
    Iterator<String> getExportedNames(int netIndex) {
        if (this.isExported(netIndex)) {
            TreeSet<String> exportedNames = new TreeSet<String>(TextUtils.STRING_NUMBER_ORDER);
            this.fillNames(netIndex, exportedNames, null);
            return exportedNames.iterator();
        }
        return ArrayIterator.emptyIterator();
    }

    @Override
    boolean hasName(int netIndex, String nm) {
        if (this.isUsernamed(netIndex)) {
            int baseNetIndex = this.thisNetHead[netIndex];
            while (baseNetIndex >= 0) {
                if (this.baseNetlist.hasName(baseNetIndex, nm)) {
                    return true;
                }
                baseNetIndex = this.baseNetNext[baseNetIndex];
            }
            return false;
        }
        return nm.equals(this.getName(netIndex));
    }

    @Override
    void fillNames(int netIndex, Collection<String> exportedNames, Collection<String> privateNames) {
        if (!this.isUsernamed(netIndex)) {
            return;
        }
        int baseNetIndex = this.thisNetHead[netIndex];
        while (baseNetIndex >= 0) {
            this.baseNetlist.fillNames(baseNetIndex, exportedNames, privateNames);
            baseNetIndex = this.baseNetNext[baseNetIndex];
        }
    }

    @Override
    boolean isUsernamed(int netIndex) {
        return this.isUsernamed.get(netIndex);
    }

    @Override
    int getEquivPortIndexByNetIndex(int netIndex) {
        return this.baseNetlist.getEquivPortIndexByNetIndex(this.thisNetHead[netIndex]);
    }
}

