/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitiveNodeSize;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.XMLRules;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.drc.Schematic;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRC
extends Listener {
    protected static DRC tool = new DRC();
    private static Map<Technology, Pref> prefDRCOverride = new HashMap<Technology, Pref>();
    private static Map<Cell, Set<Geometric>> cellsToCheck = new HashMap<Cell, Set<Geometric>>();
    private static Map<Cell, StoreDRCInfo> storedSpacingDRCDate = new HashMap<Cell, StoreDRCInfo>();
    private static Map<Cell, StoreDRCInfo> storedAreaDRCDate = new HashMap<Cell, StoreDRCInfo>();
    private static ErrorLogger errorLoggerIncremental = ErrorLogger.newInstance("DRC (incremental)", true);
    static final double TINYDELTA = DBMath.getEpsilon() * 1.1;
    static final Variable.Key DRC_ANNOTATION_KEY = Variable.newKey("ATTR_DRC");
    private static boolean incrementalRunning = false;
    private static final int DRC_BIT_EXTENSION = 2;
    private static final int DRC_BIT_ST_FOUNDRY = 4;
    private static final int DRC_BIT_TSMC_FOUNDRY = 8;
    private static final int DRC_BIT_MOSIS_FOUNDRY = 16;
    private static Technology currentTechnology = null;
    private static Pref cacheIncrementalDRCOn = Pref.makeBooleanPref("IncrementalDRCOn", DRC.tool.prefs, false);
    private static Pref cacheInteractiveDRCDragOn = Pref.makeBooleanPref("InteractiveDRCDrag", DRC.tool.prefs, true);
    private static Pref cacheErrorLoggingType = Pref.makeStringPref("ErrorLoggingType", DRC.tool.prefs, DRCCheckLogging.DRC_LOG_PER_CELL.name());
    private static Pref cacheErrorCheckLevel = Pref.makeIntPref("ErrorCheckLevel", DRC.tool.prefs, DRCCheckMode.ERROR_CHECK_DEFAULT.mode());
    private static Pref cacheIgnoreCenterCuts = Pref.makeBooleanPref("IgnoreCenterCuts", DRC.tool.prefs, false);
    private static Pref cacheIgnoreAreaChecking = Pref.makeBooleanPref("IgnoreAreaCheck", DRC.tool.prefs, false);
    private static Pref cacheIgnoreExtensionRuleChecking = Pref.makeBooleanPref("IgnoreExtensionRuleCheck", DRC.tool.prefs, false);
    private static Pref cacheStoreDatesInMemory = Pref.makeBooleanPref("StoreDatesInMemory", DRC.tool.prefs, false);
    private static Pref cacheInteractiveLog = Pref.makeBooleanPref("InteractiveLog", DRC.tool.prefs, false);
    private static Pref cacheMinAreaAlgo = Pref.makeStringPref("MinAreaAlgorithm", DRC.tool.prefs, DRCCheckMinArea.AREA_LOCAL.name());
    private static Pref cacheMultiThread = Pref.makeBooleanPref("MinMultiThread", DRC.tool.prefs, false);

    static Layer.Function.Set getMultiLayersSet(Layer layer) {
        Layer.Function.Set thisLayerFunction = layer.getFunction().isPoly() ? new Layer.Function.Set(Layer.Function.POLY1, Layer.Function.GATE) : new Layer.Function.Set(layer.getFunction(), layer.getFunctionExtras());
        return thisLayerFunction;
    }

    static void cropActiveArc(ArcInst ai, boolean ignoreCenterCuts, Poly[] pList) {
        int tot = pList.length;
        int diffPoly = -1;
        for (int j = 0; j < tot; ++j) {
            Layer.Function fun;
            Poly poly = pList[j];
            Layer layer = poly.getLayer();
            if (layer == null || !(fun = layer.getFunction()).isDiff()) continue;
            diffPoly = j;
            break;
        }
        if (diffPoly < 0) {
            return;
        }
        Poly poly = pList[diffPoly];
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        boolean cropped = false;
        boolean halved = false;
        for (int i = 0; i < 2; ++i) {
            PortInst pi = ai.getPortInst(i);
            NodeInst ni = pi.getNodeInst();
            if (!ni.getFunction().isFET()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            for (Poly nPoly : tech.getShapeOfNode(ni, false, ignoreCenterCuts, null)) {
                int result;
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int n = result = halved ? Poly.cropBox(polyBounds, nPolyBounds) : Poly.halfCropBox(polyBounds, nPolyBounds);
                if (result == 1) {
                    poly.setLayer(null);
                    return;
                }
                cropped = true;
                halved = true;
            }
        }
        if (cropped) {
            Poly.Type style = poly.getStyle();
            Layer layer = poly.getLayer();
            poly = new Poly(polyBounds);
            poly.setStyle(style);
            poly.setLayer(layer);
            pList[diffPoly] = poly;
        }
    }

    static boolean lookForLayerCoverage(Geometric geo1, Poly poly1, Geometric geo2, Poly poly2, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound, boolean overlap, Layer.Function.Set layerFunction, boolean ignoreSameGeometry, boolean ignoreCenterCuts) {
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator<RTBounds> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            RTBounds g = it.next();
            if (ignoreSameGeometry && (g == geo1 || g == geo2)) continue;
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!DRC.lookForLayerCoverage(geo1, poly1, geo2, poly2, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound, overlap, layerFunction, false, ignoreCenterCuts)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, false, ignoreCenterCuts, layerFunction)) {
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(bound);
                    if (poly1 != null && !overlap && poly.polySame(poly1) || poly2 != null && !overlap && poly.polySame(poly2)) continue;
                    if (!pointsFound[0] && poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (!pointsFound[1] && poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && !pointsFound[2] && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, layerFunction)) {
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (!pointsFound[0] && poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (!pointsFound[1] && poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && !pointsFound[2] && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    if (j == pointsFound.length) {
                        return true;
                    }
                    break;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            assert (false);
            return true;
        }
        return false;
    }

    static boolean checkExtensionWithNeighbors(Cell cell, Geometric geom, Poly poly, Layer layer, Rectangle2D bounds, DRCTemplate minWidthRule, int dir, boolean onlyOne, boolean reportError, Layer.Function.Set layerFunction, ReportInfo reportInfo) {
        Point2D.Double right3;
        Point2D.Double right2;
        Point2D.Double right1;
        Point2D.Double left3;
        Point2D.Double left2;
        Point2D.Double left1;
        double actual = 0.0;
        String msg = "";
        if (dir == 0) {
            actual = bounds.getWidth();
            msg = "(X axis)";
            double leftW = bounds.getMinX() - TINYDELTA;
            left1 = new Point2D.Double(leftW, bounds.getMinY());
            left2 = new Point2D.Double(leftW, bounds.getMaxY());
            left3 = new Point2D.Double(leftW, bounds.getCenterY());
            double rightW = bounds.getMaxX() + TINYDELTA;
            right1 = new Point2D.Double(rightW, bounds.getMinY());
            right2 = new Point2D.Double(rightW, bounds.getMaxY());
            right3 = new Point2D.Double(rightW, bounds.getCenterY());
        } else {
            actual = bounds.getHeight();
            msg = "(Y axis)";
            double leftH = bounds.getMinY() - TINYDELTA;
            left1 = new Point2D.Double(bounds.getMinX(), leftH);
            left2 = new Point2D.Double(bounds.getMaxX(), leftH);
            left3 = new Point2D.Double(bounds.getCenterX(), leftH);
            double rightH = bounds.getMaxY() + TINYDELTA;
            right1 = new Point2D.Double(bounds.getMinX(), rightH);
            right2 = new Point2D.Double(bounds.getMaxX(), rightH);
            right3 = new Point2D.Double(bounds.getCenterX(), rightH);
        }
        boolean[] pointsFound = new boolean[3];
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        Rectangle2D.Double newBounds = new Rectangle2D.Double(bounds.getMinX() - TINYDELTA, bounds.getMinY() - TINYDELTA, bounds.getWidth() + TINYDELTA * 2.0, bounds.getHeight() + TINYDELTA * 2.0);
        boolean zeroWide = bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0;
        boolean overlapLayer = DRC.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, left1, left2, left3, pointsFound, layerFunction, reportInfo.ignoreCenterCuts);
        if (overlapLayer) {
            return false;
        }
        pointsFound[2] = false;
        pointsFound[1] = false;
        pointsFound[0] = false;
        overlapLayer = DRC.lookForLayer(poly, cell, layer, DBMath.MATID, newBounds, right1, right2, right3, pointsFound, layerFunction, reportInfo.ignoreCenterCuts);
        if (overlapLayer) {
            return false;
        }
        DRCErrorType errorType = DRCErrorType.MINWIDTHERROR;
        String extraMsg = msg;
        String rule = minWidthRule.ruleName;
        if (zeroWide && overlapLayer) {
            extraMsg = " but covered by other layer";
            errorType = DRCErrorType.ZEROLENGTHARCWARN;
            rule = null;
        }
        if (reportError) {
            DRC.createDRCErrorLogger(reportInfo, errorType, extraMsg, cell, minWidthRule.getValue(0), actual, rule, onlyOne ? null : poly, geom, layer, null, null, null);
        }
        return !overlapLayer;
    }

    static boolean lookForLayer(Poly thisPoly, Cell cell, Layer layer, AffineTransform moreTrans, Rectangle2D bounds, Point2D pt1, Point2D pt2, Point2D pt3, boolean[] pointsFound, Layer.Function.Set layerFunction, boolean ignoreCenterCuts) {
        boolean skip = false;
        Rectangle2D.Double newBounds = new Rectangle2D.Double();
        Iterator<RTBounds> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            int j;
            RTBounds g = it.next();
            if (g instanceof NodeInst) {
                NodeInst ni = (NodeInst)g;
                if (NodeInst.isSpecialNode(ni)) continue;
                if (ni.isCellInstance()) {
                    AffineTransform rotI = ni.rotateIn();
                    AffineTransform transI = ni.translateIn();
                    rotI.preConcatenate(transI);
                    ((Rectangle2D)newBounds).setRect(bounds);
                    DBMath.transformRect(newBounds, rotI);
                    AffineTransform trans = ni.translateOut(ni.rotateOut());
                    trans.preConcatenate(moreTrans);
                    if (!DRC.lookForLayer(thisPoly, (Cell)ni.getProto(), layer, trans, newBounds, pt1, pt2, pt3, pointsFound, layerFunction, ignoreCenterCuts)) continue;
                    return true;
                }
                AffineTransform bound = ni.rotateOut();
                bound.preConcatenate(moreTrans);
                Technology tech = ni.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, false, ignoreCenterCuts, layerFunction)) {
                    boolean newR;
                    if (!tech.sameLayer(poly.getLayer(), layer) || thisPoly != null && poly.polySame(thisPoly)) continue;
                    poly.transform(bound);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            } else {
                ArcInst ai = (ArcInst)g;
                Technology tech = ai.getProto().getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, layerFunction)) {
                    boolean newR;
                    if (!tech.sameLayer(poly.getLayer(), layer)) continue;
                    poly.transform(moreTrans);
                    if (poly.isInside(pt1)) {
                        pointsFound[0] = true;
                    }
                    if (poly.isInside(pt2)) {
                        pointsFound[1] = true;
                    }
                    if (pt3 != null && poly.isInside(pt3)) {
                        pointsFound[2] = true;
                    }
                    for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
                    }
                    boolean bl = newR = j == pointsFound.length;
                    if (!newR) continue;
                    return true;
                }
            }
            for (j = 0; j < pointsFound.length && pointsFound[j]; ++j) {
            }
            if (j != pointsFound.length) continue;
            System.out.println("When?");
            return true;
        }
        if (skip) {
            System.out.println("This case in lookForLayerNew antes");
        }
        return false;
    }

    static boolean checkMinWidthInternal(Geometric geom, Layer layer, Poly poly, boolean onlyOne, DRCTemplate minWidthRule, boolean reportError, Layer.Function.Set layerFunction, ReportInfo reportInfo) {
        boolean flatPoly;
        Cell cell = geom.getParent();
        if (minWidthRule == null) {
            return false;
        }
        double minWidthValue = minWidthRule.getValue(0);
        Rectangle2D bounds = poly.getBox();
        boolean bl = flatPoly = bounds == null && GenMath.doublesEqual(poly.getArea(), 0.0);
        if (flatPoly) {
            Point2D to;
            Point2D[] points = poly.getPoints();
            Point2D from = points[0];
            if (DBMath.areEquals(from, to = points[1])) {
                boolean found = false;
                for (int i = 2; i < points.length; ++i) {
                    if (DBMath.areEquals(from, points[i])) continue;
                    to = points[i];
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            Point2D.Double center = new Point2D.Double((from.getX() + to.getX()) / 2.0, (from.getY() + to.getY()) / 2.0);
            boolean[] pointsFound = new boolean[3];
            pointsFound[2] = false;
            pointsFound[1] = false;
            pointsFound[0] = false;
            boolean found = DRC.lookForLayerCoverage(geom, poly, null, null, cell, layer, DBMath.MATID, poly.getBounds2D(), from, to, center, pointsFound, true, null, true, reportInfo.ignoreCenterCuts);
            if (found) {
                return false;
            }
            if (reportError) {
                DRC.createDRCErrorLogger(reportInfo, DRCErrorType.MINWIDTHERROR, null, cell, minWidthValue, 0.0, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, null, null, null);
            }
            return true;
        }
        if (bounds != null) {
            boolean tooSmallWidth = DBMath.isGreaterThan(minWidthValue, bounds.getWidth());
            boolean tooSmallHeight = DBMath.isGreaterThan(minWidthValue, bounds.getHeight());
            if (!tooSmallWidth && !tooSmallHeight) {
                return false;
            }
            boolean foundError = false;
            if (tooSmallWidth && DRC.checkExtensionWithNeighbors(cell, geom, poly, layer, bounds, minWidthRule, 0, onlyOne, reportError, layerFunction, reportInfo)) {
                foundError = true;
            }
            if (tooSmallHeight && DRC.checkExtensionWithNeighbors(cell, geom, poly, layer, bounds, minWidthRule, 1, onlyOne, reportError, layerFunction, reportInfo)) {
                foundError = true;
            }
            return foundError;
        }
        Poly.Type style = poly.getStyle();
        if (style != Poly.Type.FILLED && style != Poly.Type.CLOSED && style != Poly.Type.CROSSED && style != Poly.Type.OPENED && style != Poly.Type.OPENEDT1 && style != Poly.Type.OPENEDT2 && style != Poly.Type.OPENEDT3 && style != Poly.Type.VECTORS) {
            return false;
        }
        bounds = poly.getBounds2D();
        double actual = Math.min(bounds.getWidth(), bounds.getHeight());
        if (actual < minWidthValue) {
            if (reportError) {
                DRC.createDRCErrorLogger(reportInfo, DRCErrorType.MINWIDTHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, null, null, null);
            }
            return true;
        }
        Point2D[] points = poly.getPoints();
        int count = points.length;
        for (int i = 0; i < count; ++i) {
            Point2D to;
            Point2D from = i == 0 ? points[count - 1] : points[i - 1];
            if (from.equals(to = points[i])) continue;
            double ang = DBMath.figureAngleRadians(from, to);
            Point2D.Double center = new Point2D.Double((from.getX() + to.getX()) / 2.0, (from.getY() + to.getY()) / 2.0);
            double perpang = ang + 1.5707963267948966;
            for (int j = 0; j < count; ++j) {
                double fdy;
                double fdx;
                Point2D inter;
                double rOAng;
                double rAng;
                Point2D oTo;
                Point2D oFrom;
                if (j == i || (oFrom = j == 0 ? points[count - 1] : points[j - 1]).equals(oTo = points[j])) continue;
                double oAng = DBMath.figureAngleRadians(oFrom, oTo);
                for (rAng = ang; rAng > Math.PI; rAng -= Math.PI) {
                }
                for (rOAng = oAng; rOAng > Math.PI; rOAng -= Math.PI) {
                }
                if (DBMath.doublesEqual(rAng, rOAng) && (DBMath.isOnLine(from, to, oFrom) || DBMath.isOnLine(from, to, oTo) || DBMath.isOnLine(oFrom, oTo, from) || DBMath.isOnLine(oFrom, oTo, to)) || (inter = DBMath.intersectRadians(center, perpang, oFrom, oAng)) == null || inter.getX() < Math.min(oFrom.getX(), oTo.getX()) || inter.getX() > Math.max(oFrom.getX(), oTo.getX()) || inter.getY() < Math.min(oFrom.getY(), oTo.getY()) || inter.getY() > Math.max(oFrom.getY(), oTo.getY()) || !((actual = DBMath.round(Math.sqrt((fdx = ((Point2D)center).getX() - inter.getX()) * fdx + (fdy = ((Point2D)center).getY() - inter.getY()) * fdy))) < minWidthValue)) continue;
                if (reportError) {
                    if (poly.isInside(new Point2D.Double((((Point2D)center).getX() + inter.getX()) / 2.0, (((Point2D)center).getY() + inter.getY()) / 2.0))) {
                        DRC.createDRCErrorLogger(reportInfo, DRCErrorType.MINWIDTHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, null, null, null);
                    } else {
                        DRC.createDRCErrorLogger(reportInfo, DRCErrorType.NOTCHERROR, null, cell, minWidthValue, actual, minWidthRule.ruleName, onlyOne ? null : poly, geom, layer, poly, geom, layer);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static boolean mayTouch(Technology tech, boolean con, Layer layer1, Layer layer2) {
        boolean maytouch = false;
        if (tech.sameLayer(layer1, layer2)) {
            Layer.Function fun = layer1.getFunction();
            if (con) {
                if (!fun.isContact()) {
                    maytouch = true;
                }
            } else if (fun.isSubstrate()) {
                maytouch = true;
            } else {
                int funExtras = layer1.getFunctionExtras();
                if (fun.isDiff() && (funExtras & 0x800000) != 0) {
                    if (Job.LOCALDEBUGFLAG) {
                        System.out.println("Thick active found in Quick.checkDist");
                    }
                    maytouch = true;
                }
            }
        }
        return maytouch;
    }

    static boolean checkNodeAgainstCombinationRules(NodeInst ni, ReportInfo reportInfo) {
        DRCTemplate forbidRule;
        Cell cell = ni.getParent();
        NodeProto np = ni.getProto();
        Technology tech = np.getTechnology();
        if (np instanceof PrimitiveNode && (forbidRule = DRC.isForbiddenNode(((PrimitiveNode)np).getPrimNodeIndexInTech(), -1, DRCTemplate.DRCRuleType.FORBIDDEN, tech)) != null) {
            DRC.createDRCErrorLogger(reportInfo, DRCErrorType.FORBIDDEN, " is not allowed by selected foundry", cell, -1.0, -1.0, forbidRule.ruleName, null, ni, null, null, null, null);
            return true;
        }
        return false;
    }

    static boolean checkOD2Combination(Technology tech, NodeInst ni, Layer layer, Map<Layer, NodeInst> od2Layers, ReportInfo reportInfo) {
        int funExtras = layer.getFunctionExtras();
        boolean notOk = false;
        if (layer.getFunction().isImplant() && (funExtras & 0x800000) != 0) {
            od2Layers.put(layer, ni);
            if (od2Layers.size() != 1) {
                for (Map.Entry<Layer, NodeInst> e : od2Layers.entrySet()) {
                    DRCTemplate rule;
                    Layer lay1 = e.getKey();
                    if (lay1 == layer || (rule = DRC.isForbiddenNode(lay1.getIndex(), layer.getIndex(), DRCTemplate.DRCRuleType.FORBIDDEN, tech)) == null) continue;
                    NodeInst node = e.getValue();
                    String message = "- combination of layers '" + layer.getName() + "' and '" + lay1.getName() + "' (in '" + node.getParent().getName() + ":" + node.getName() + "') not allowed by selected foundry";
                    DRC.createDRCErrorLogger(reportInfo, DRCErrorType.FORBIDDEN, message, ni.getParent(), -1.0, -1.0, rule.ruleName, null, ni, null, null, node, null);
                    return true;
                }
            }
        }
        return notOk;
    }

    public static void createDRCErrorLogger(ReportInfo reportInfo, DRCErrorType errorType, String msg, Cell cell, double limit, double actual, String rule, PolyBase poly1, Geometric geom1, Layer layer1, PolyBase poly2, Geometric geom2, Layer layer2) {
        boolean onlyWarning;
        ErrorLogger errorLogger = reportInfo.errorLogger;
        if (errorLogger == null) {
            return;
        }
        StringBuffer DRCexclusionMsg = new StringBuffer();
        if (reportInfo.exclusionMap != null && reportInfo.exclusionMap.get(cell) != null) {
            boolean found;
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>(2);
            ArrayList<Geometric> geomList = new ArrayList<Geometric>(2);
            polyList.add(poly1);
            geomList.add(geom1);
            if (poly2 != null) {
                polyList.add(poly2);
                geomList.add(geom2);
            }
            if (found = DRC.checkExclusionMap(reportInfo.exclusionMap, cell, polyList, geomList, DRCexclusionMsg)) {
                return;
            }
        }
        Cell np1 = geom1 != null ? geom1.getParent() : null;
        Cell np2 = geom2 != null ? geom2.getParent() : null;
        boolean bl = onlyWarning = errorType == DRCErrorType.ZEROLENGTHARCWARN || errorType == DRCErrorType.TECHMIXWARN;
        if (geom2 != null && reportInfo.errorTypeSearch != DRCCheckMode.ERROR_CHECK_EXHAUSTIVE && errorLogger.findMessage(cell, geom1, geom2.getParent(), geom2, !onlyWarning)) {
            return;
        }
        StringBuffer errorMessage = new StringBuffer();
        DRCCheckLogging loggingType = DRC.getErrorLoggingType();
        int sortKey = cell.hashCode();
        if (errorType == DRCErrorType.SPACINGERROR || errorType == DRCErrorType.NOTCHERROR || errorType == DRCErrorType.SURROUNDERROR) {
            if (errorType == DRCErrorType.SPACINGERROR) {
                errorMessage.append("Spacing");
            } else if (errorType == DRCErrorType.SURROUNDERROR) {
                errorMessage.append("Surround");
            } else {
                errorMessage.append("Notch");
            }
            if (layer1 == layer2) {
                errorMessage.append(" (layer '" + layer1.getName() + "')");
            }
            errorMessage.append(": ");
            if (np1 != np2) {
                errorMessage.append(np1 + ", ");
            } else if (np1 != cell && np1 != null) {
                errorMessage.append("[in " + np1 + "] ");
            }
            if (geom1 != null) {
                errorMessage.append(geom1);
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer1.getName() + "'");
            }
            if (actual < 0.0) {
                errorMessage.append(" OVERLAPS (BY " + TextUtils.formatDouble(limit - actual) + ") ");
            } else if (actual == 0.0) {
                errorMessage.append(" TOUCHES ");
            } else {
                errorMessage.append(" LESS (BY " + TextUtils.formatDouble(limit - actual) + ") THAN " + TextUtils.formatDouble(limit) + (geom2 != null ? " TO " : ""));
            }
            if (np1 != np2 && np2 != null) {
                errorMessage.append(np2 + ", ");
            }
            if (geom2 != null) {
                errorMessage.append(geom2);
            }
            if (layer1 != layer2) {
                errorMessage.append(", layer '" + layer2.getName() + "'");
            }
            if (msg != null) {
                errorMessage.append("; " + msg);
            }
        } else {
            StringBuffer errorMessagePart2 = null;
            switch (errorType) {
                case CROOKEDERROR: {
                    errorMessage.append("Crooked error:");
                    errorMessagePart2 = new StringBuffer(" is not horizontal nor vertical");
                    break;
                }
                case RESOLUTION: {
                    errorMessage.append("Resolution error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case FORBIDDEN: {
                    errorMessage.append("Forbidden error:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case SLOTSIZEERROR: {
                    errorMessage.append("Slot size error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " IN LENGTH (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINAREAERROR: {
                    errorMessage.append("Minimum area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case ENCLOSEDAREAERROR: {
                    errorMessage.append("Enclosed area error:");
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " IN AREA (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case TECHMIXWARN: {
                    errorMessage.append("Technology mixture warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case ZEROLENGTHARCWARN: {
                    errorMessage.append("Zero width warning:");
                    errorMessagePart2 = new StringBuffer(msg);
                    break;
                }
                case CUTERROR: {
                    errorMessage.append("Maximum cut error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" BIGGER THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINWIDTHERROR: {
                    errorMessage.append("Minimum width/height error" + (msg != null ? "(" + msg + "):" : ""));
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    errorMessagePart2.append(" LESS THAN " + TextUtils.formatDouble(limit) + " WIDE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case MINSIZEERROR: {
                    errorMessage.append("Minimum size error on " + msg + ":");
                    errorMessagePart2 = new StringBuffer(" LESS THAN " + TextUtils.formatDouble(limit) + " IN SIZE (IS " + TextUtils.formatDouble(actual) + ")");
                    break;
                }
                case BADLAYERERROR: {
                    errorMessage.append("Invalid layer ('" + layer1.getName() + "'):");
                    break;
                }
                case LAYERSURROUNDERROR: {
                    errorMessage.append("Layer surround error: " + msg);
                    errorMessagePart2 = new StringBuffer(", layer '" + layer1.getName() + "'");
                    String layerName = layer2 != null ? layer2.getName() : "Select";
                    errorMessagePart2.append(" NEEDS SURROUND OF LAYER '" + layerName + "' BY " + limit);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            errorMessage.append(" " + cell + " ");
            if (geom1 != null) {
                errorMessage.append(geom1);
            }
            if (layer1 != null && loggingType == DRCCheckLogging.DRC_LOG_FLAT) {
                sortKey = layer1.getIndex();
            }
            errorMessage.append(errorMessagePart2);
        }
        if (rule != null && rule.length() > 0) {
            errorMessage.append(" [rule '" + rule + "']");
        }
        errorMessage.append(DRCexclusionMsg);
        ArrayList<Geometric> geomList = new ArrayList<Geometric>();
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        if (poly1 != null) {
            polyList.add(poly1);
        } else if (geom1 != null) {
            geomList.add(geom1);
        }
        if (poly2 != null) {
            polyList.add(poly2);
        } else if (geom2 != null) {
            geomList.add(geom2);
        }
        switch (loggingType) {
            case DRC_LOG_PER_CELL: {
                errorLogger.setGroupName(sortKey, cell.getName());
                break;
            }
            case DRC_LOG_PER_RULE: {
                String theRuleName = rule;
                if (theRuleName == null) {
                    theRuleName = errorType.name();
                }
                if (errorLogger.getGroupName(sortKey = theRuleName.hashCode()) != null) break;
                errorLogger.setGroupName(sortKey, theRuleName);
            }
        }
        if (onlyWarning) {
            errorLogger.logWarning(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortKey);
        } else {
            errorLogger.logError(errorMessage.toString(), geomList, null, null, null, polyList, cell, sortKey);
        }
        if (reportInfo.interactiveLogger) {
            Job.getUserInterface().termLogging(errorLogger, false, false);
        }
    }

    private static boolean checkExclusionMap(Map<Cell, Area> exclusionMap, Cell cell, List<PolyBase> polyList, List<Geometric> geomList, StringBuffer DRCexclusionMsg) {
        Area area = exclusionMap.get(cell);
        if (area == null) {
            return false;
        }
        int count = 0;
        int i = -1;
        for (PolyBase thisPoly : polyList) {
            ++i;
            if (thisPoly == null) continue;
            boolean found = area.contains(thisPoly.getBounds2D());
            if (found) {
                ++count;
                continue;
            }
            Rectangle2D rect = geomList.get(i) != null ? geomList.get(i).getBounds() : thisPoly.getBounds2D();
            DRCexclusionMsg.append("\n\t(DRC Exclusion in '" + cell.getName() + "' does not completely contain element (" + rect.getMinX() + "," + rect.getMinY() + ") (" + rect.getMaxX() + "," + rect.getMaxY() + "))");
        }
        return count >= 1;
    }

    private DRC() {
        super("drc");
    }

    @Override
    public void init() {
        this.setOn();
    }

    public static DRC getDRCTool() {
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void includeGeometric(Geometric geom) {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        Cell cell = geom.getParent();
        Map<Cell, Set<Geometric>> map = cellsToCheck;
        synchronized (map) {
            Set<Geometric> cellSet = cellsToCheck.get(cell);
            if (cellSet == null) {
                cellSet = new HashSet<Geometric>();
                cellsToCheck.put(cell, cellSet);
            }
            cellSet.add(geom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doIncrementalDRCTask() {
        if (!DRC.isIncrementalDRCOn()) {
            return;
        }
        if (incrementalRunning) {
            return;
        }
        Library curLib = Library.getCurrent();
        if (curLib == null) {
            return;
        }
        Cell cellToCheck = Job.getUserInterface().getCurrentCell(curLib);
        Set<Geometric> cellSet = null;
        Map<Cell, Set<Geometric>> map = cellsToCheck;
        synchronized (map) {
            if (cellToCheck != null) {
                cellSet = cellsToCheck.get(cellToCheck);
            }
            if (cellSet == null && cellsToCheck.size() > 0) {
                cellToCheck = cellsToCheck.keySet().iterator().next();
                cellSet = cellsToCheck.get(cellToCheck);
            }
            if (cellSet != null) {
                cellsToCheck.remove(cellToCheck);
            }
        }
        if (cellToCheck == null) {
            return;
        }
        if (!cellToCheck.isLinked()) {
            return;
        }
        if (cellToCheck.getLibrary().isHidden()) {
            return;
        }
        if (cellSet != null) {
            Geometric[] objectsToCheck = new Geometric[cellSet.size()];
            int i = 0;
            for (Geometric geom : cellSet) {
                objectsToCheck[i++] = geom;
            }
            for (Geometric geo : objectsToCheck) {
                Cell c = geo.getParent();
                ArrayList<ErrorLogger.MessageLog> getAllLogs = errorLoggerIncremental.getAllLogs(c);
                Job.updateIncrementalDRCErrors(c, null, getAllLogs);
            }
            new CheckDRCIncrementally(cellToCheck, objectsToCheck, cellToCheck.getTechnology().isScaleRelevant());
        }
    }

    @Override
    public void endBatch(Snapshot oldSnapshot, Snapshot newSnapshot, boolean undoRedo) {
        for (CellId cellId : newSnapshot.getChangedCells(oldSnapshot)) {
            ImmutableElectricObject d;
            Cell cell = Cell.inCurrentThread(cellId);
            if (cell == null) continue;
            CellBackup oldBackup = oldSnapshot.getCell(cellId);
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                d = ni.getD();
                if (oldBackup != null && oldBackup.cellRevision.getNode(d.nodeId) == d) continue;
                DRC.includeGeometric(ni);
            }
            it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                d = ai.getD();
                if (oldBackup != null && oldBackup.cellRevision.getArc(((ImmutableArcInst)d).arcId) == d) continue;
                DRC.includeGeometric(ai);
            }
        }
        DRC.doIncrementalDRCTask();
    }

    public static ErrorLogger getDRCErrorLogger(boolean layout, boolean incremental, String extraMsg) {
        String title;
        ErrorLogger errorLogger = null;
        String string = title = layout ? "Layout " : "Schematic ";
        errorLogger = incremental ? errorLoggerIncremental : ErrorLogger.newInstance(title + "DRC (full)" + (extraMsg != null ? extraMsg : ""));
        return errorLogger;
    }

    public static ErrorLogger getDRCIncrementalLogger() {
        return errorLoggerIncremental;
    }

    public static void checkDRCHierarchically(Cell cell, List<Geometric> objs, Rectangle2D bounds, GeometryHandler.GHMode mode, boolean onlyArea) {
        if (cell == null) {
            return;
        }
        boolean isLayout = true;
        if (cell.isSchematic() || cell.getTechnology() == Schematics.tech() || cell.isIcon() || cell.getTechnology() == Artwork.tech()) {
            isLayout = false;
        }
        if (mode == null) {
            mode = GeometryHandler.GHMode.ALGO_SWEEP;
        }
        new CheckDRCHierarchically(cell, isLayout, objs, bounds, mode, onlyArea);
    }

    public static DRCRules getRules(Technology tech) {
        XMLRules currentRules = tech.getCachedRules();
        if (currentRules != null && tech == currentTechnology) {
            return currentRules;
        }
        currentRules = tech.getFactoryDesignRules();
        if (currentRules != null) {
            StringBuffer override = DRC.getDRCOverrides(tech);
            currentRules.applyDRCOverrides(override.toString(), tech);
        }
        currentTechnology = tech;
        tech.setCachedRules(currentRules);
        return currentRules;
    }

    public static void setRules(Technology tech, DRCRules newRules) {
        XMLRules factoryRules = tech.getFactoryDesignRules();
        StringBuffer changes = Technology.getRuleDifferences(factoryRules, newRules);
        if (Job.LOCALDEBUGFLAG) {
            System.out.println("This function needs attention");
        }
        StringBuffer override = DRC.getDRCOverrides(tech);
        if (changes.toString().equals(override.toString())) {
            return;
        }
        DRC.setDRCOverrides(changes, tech);
        tech.setRuleVariables(newRules);
        if (currentTechnology == tech) {
            currentTechnology = null;
        }
    }

    public static double getWorstSpacingDistance(Technology tech, int lastMetal) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return 0.0;
        }
        return rules.getWorstSpacingDistance(lastMetal);
    }

    public static double getMaxSurround(Layer layer, double maxSize) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return -1.0;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return -1.0;
        }
        return rules.getMaxSurround(layer, maxSize);
    }

    public static DRCTemplate getEdgeRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getEdgeRule(layer1, layer2);
    }

    public static DRCTemplate getSpacingRule(Layer layer1, Geometric geo1, Layer layer2, Geometric geo2, boolean connected, int multiCut, double wideS, double length) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getSpacingRule(layer1, geo1, layer2, geo2, connected, multiCut, wideS, length);
    }

    public static List<DRCTemplate> getRules(Layer layer1, DRCTemplate.DRCRuleType type) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getRules(layer1, type);
    }

    public static DRCTemplate getExtensionRule(Layer layer1, Layer layer2, boolean isGateExtension) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getExtensionRule(layer1, layer2, isGateExtension);
    }

    public static boolean isAnySpacingRule(Layer layer1, Layer layer2) {
        Technology tech = layer1.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return false;
        }
        return rules.isAnySpacingRule(layer1, layer2);
    }

    public static DRCTemplate getMinValue(Layer layer, DRCTemplate.DRCRuleType type) {
        Technology tech = layer.getTechnology();
        if (tech == null) {
            return null;
        }
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return rules.getMinValue(layer, type);
    }

    public static DRCTemplate isForbiddenNode(int index1, int index2, DRCTemplate.DRCRuleType type, Technology tech) {
        DRCRules rules = DRC.getRules(tech);
        if (rules == null) {
            return null;
        }
        return DRC.isForbiddenNode(rules, index1, index2, type);
    }

    public static DRCTemplate isForbiddenNode(DRCRules rules, int index1, int index2, DRCTemplate.DRCRuleType type) {
        int index = index1;
        index = index2 != -1 ? rules.getRuleIndex(index1, index2) : (index += rules.getTechnology().getNumLayers());
        return rules.isForbiddenNode(index, type);
    }

    public static PrimitiveNode.NodeSizeRule getMinSize(NodeProto np) {
        if (np instanceof Cell) {
            return null;
        }
        PrimitiveNode pnp = (PrimitiveNode)np;
        return pnp.getMinSizeRule();
    }

    private static StringBuffer getDRCOverrides(Technology tech) {
        Pref pref = prefDRCOverride.get(tech);
        if (pref == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pref.getString());
        return sb;
    }

    private static void setDRCOverrides(StringBuffer sb, Technology tech) {
        Pref pref;
        if (sb.length() >= 8192) {
            System.out.println("Warning: Design rule overrides are too complex to be saved (are " + sb.length() + " long which is more than the limit of " + 8192 + ")");
        }
        if ((pref = prefDRCOverride.get(tech)) == null) {
            pref = Pref.makeStringPref("DRCOverridesFor" + tech.getTechName(), DRC.tool.prefs, "");
            prefDRCOverride.put(tech, pref);
        }
        pref.setString(sb.toString());
    }

    public static void cleanCellsDueToFoundryChanges(Technology tech, Foundry f) {
        System.out.println("Cleaning good DRC dates in cells using '" + f.getType().getName() + "' in '" + tech.getTechName() + "'");
        HashSet<Cell> cleanSpacingDRCDate = new HashSet<Cell>();
        HashSet<Cell> cleanAreaDRCDate = new HashSet<Cell>();
        int bit = f.getType().getBit();
        boolean inMemory = DRC.isDatesStoredInMemory();
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            Iterator<Cell> itC = lib.getCells();
            while (itC.hasNext()) {
                Cell cell = itC.next();
                if (cell.getTechnology() != tech) continue;
                StoreDRCInfo data = DRC.getCellGoodDRCDateAndBits(cell, true, !inMemory);
                if (data != null && (data.bits & bit) != 0) {
                    cleanSpacingDRCDate.add(cell);
                }
                if ((data = DRC.getCellGoodDRCDateAndBits(cell, false, !inMemory)) == null || (data.bits & bit) == 0) continue;
                cleanAreaDRCDate.add(cell);
            }
        }
        DRC.addDRCUpdate(0, null, cleanSpacingDRCDate, null, cleanAreaDRCDate, null);
    }

    private static boolean getDateStored(Cell cell, Variable.Key key, GenMath.MutableLong date) {
        long lastDRCDateInMilliseconds;
        Long lastDRCDateAsLong = cell.getVarValue(key, Long.class);
        if (lastDRCDateAsLong != null) {
            lastDRCDateInMilliseconds = lastDRCDateAsLong;
        } else {
            Integer[] lastDRCDateAsInts = cell.getVarValue(key, Integer[].class);
            if (lastDRCDateAsInts == null) {
                return false;
            }
            long lastDRCDateInSecondsHigh = lastDRCDateAsInts[0].intValue();
            long lastDRCDateInSecondsLow = lastDRCDateAsInts[1].intValue();
            lastDRCDateInMilliseconds = lastDRCDateInSecondsHigh << 32 | lastDRCDateInSecondsLow & 0xFFFFFFFFL;
        }
        date.setValue(lastDRCDateInMilliseconds);
        return true;
    }

    private static StoreDRCInfo getCellGoodDRCDateAndBits(Cell cell, boolean spacingCheck, boolean fromDisk) {
        Map<Cell, StoreDRCInfo> storedDRCDate = storedSpacingDRCDate;
        Variable.Key dateKey = Layout.DRC_LAST_GOOD_DATE_SPACING;
        Variable.Key bitKey = Layout.DRC_LAST_GOOD_BIT_SPACING;
        if (!spacingCheck) {
            storedDRCDate = storedAreaDRCDate;
            dateKey = Layout.DRC_LAST_GOOD_DATE_AREA;
            bitKey = null;
        }
        StoreDRCInfo data = storedDRCDate.get(cell);
        boolean firstTime = false;
        if (data == null) {
            boolean validVersion = true;
            Version version = cell.getLibrary().getVersion();
            if (version != null) {
                validVersion = version.compareTo(Version.getVersion()) >= 0;
            }
            data = new StoreDRCInfo(-1L, -1);
            storedDRCDate.put(cell, data);
            firstTime = true;
            if (!validVersion) {
                return null;
            }
        }
        if (fromDisk || !fromDisk && firstTime) {
            GenMath.MutableLong lastDRCDateInMilliseconds = new GenMath.MutableLong(0L);
            if (!DRC.getDateStored(cell, dateKey, lastDRCDateInMilliseconds)) {
                return null;
            }
            int thisByte = -1;
            if (bitKey != null) {
                Integer varBitsAsInt = cell.getVarValue(bitKey, Integer.class);
                if (varBitsAsInt != null) {
                    thisByte = varBitsAsInt;
                } else {
                    Byte varBitsAsByte = cell.getVarValue(bitKey, Byte.class);
                    if (varBitsAsByte != null) {
                        thisByte = varBitsAsByte.byteValue();
                    } else {
                        System.out.println("No valid bit associated to DRC data was found as cell variable");
                    }
                }
            }
            data.bits = thisByte;
            data.date = lastDRCDateInMilliseconds.longValue();
        } else {
            data = storedDRCDate.get(cell);
        }
        return data;
    }

    public static boolean isCellDRCDateGood(Cell cell, Date date) {
        Date lastChangeDate;
        return date != null && date.after(lastChangeDate = cell.getRevisionDate());
    }

    public static Date getLastDRCDateBasedOnBits(Cell cell, boolean spacingCheck, int activeBits, boolean fromDisk) {
        Date revisionDate;
        Date lastDRCDate;
        StoreDRCInfo data = DRC.getCellGoodDRCDateAndBits(cell, spacingCheck, fromDisk);
        if (data == null) {
            return null;
        }
        int thisByte = data.bits;
        if (fromDisk && spacingCheck) assert (thisByte != 0);
        if (activeBits != -1) {
            boolean sameManufacturer;
            boolean extension = (thisByte & 2) == (activeBits & 2);
            boolean bl = sameManufacturer = (thisByte & 8) == (activeBits & 8) && (thisByte & 4) == (activeBits & 4) && (thisByte & 0x10) == (activeBits & 0x10);
            assert (activeBits != 0);
            if (!(activeBits == 0 || extension && sameManufacturer)) {
                return null;
            }
        }
        return (lastDRCDate = new Date(data.date)).after(revisionDate = cell.getRevisionDate()) ? lastDRCDate : null;
    }

    private static void cleanDRCDateAndBits(Cell cell, Variable.Key key) {
        if (key == Layout.DRC_LAST_GOOD_DATE_SPACING) {
            cell.delVar(Layout.DRC_LAST_GOOD_DATE_SPACING);
            cell.delVar(Layout.DRC_LAST_GOOD_BIT_SPACING);
        } else {
            cell.delVar(Layout.DRC_LAST_GOOD_DATE_AREA);
        }
    }

    public static String explainBits(int bits) {
        boolean on = !DRC.isIgnoreAreaChecking();
        String msg = "area bit ";
        msg = msg + (on ? "on" : "off");
        on = (bits & 2) != 0;
        msg = msg + ", extension bit ";
        msg = msg + (on ? "on" : "off");
        if ((bits & 8) != 0) {
            msg = msg + ", TSMC bit";
        } else if ((bits & 4) != 0) {
            msg = msg + ", ST bit";
        } else if ((bits & 0x10) != 0) {
            msg = msg + ", Mosis bit";
        }
        return msg;
    }

    public static int getActiveBits(Technology tech) {
        Foundry foundry;
        int bits = 0;
        if (!DRC.isIgnoreExtensionRuleChecking()) {
            bits |= 2;
        }
        if ((foundry = tech.getSelectedFoundry()) != null) {
            bits |= foundry.getType().getBit();
        }
        return bits;
    }

    private static void checkNetworks(ErrorLogger errorLog, Cell cell, boolean isLayout) {
        String msg;
        boolean errorSortNetworks = false;
        boolean errorSortNodes = true;
        HashMap<NodeProto, ArrayList<NodeInst>> strangeNodes = null;
        HashMap<NodeProto, ArrayList<NodeInst>> unconnectedPins = null;
        int numNodes = cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            ArrayList<NodeInst> nodesOfType;
            boolean isSchematicNode;
            String msg2;
            NodeInst ni = cell.getNode(i);
            NodeProto np = ni.getProto();
            if (!cell.isIcon()) {
                if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech().simProbeNode || np == Generic.tech().invisiblePinNode) {
                    if (ni.hasConnections()) {
                        msg2 = "Network: " + cell + " has connections on " + ni;
                        System.out.println(msg2);
                        errorLog.logError(msg2, ni, cell, null, 1);
                    }
                } else if (np.getFunction() == PrimitiveNode.Function.PIN && cell.getTechnology().isLayout() && !ni.hasConnections()) {
                    ArrayList<NodeInst> pinsOfType;
                    if (unconnectedPins == null) {
                        unconnectedPins = new HashMap<NodeProto, ArrayList<NodeInst>>();
                    }
                    if ((pinsOfType = (ArrayList<NodeInst>)unconnectedPins.get(np)) == null) {
                        pinsOfType = new ArrayList<NodeInst>();
                        unconnectedPins.put(np, pinsOfType);
                    }
                    pinsOfType.add(ni);
                }
            }
            if (!isLayout) continue;
            if (ni.getNameKey().isBus()) {
                msg2 = "Network: Layout " + cell + " has arrayed " + ni;
                System.out.println(msg2);
                errorLog.logError(msg2, ni, cell, null, 0);
            }
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)np;
                isSchematicNode = subCell.isIcon() || subCell.isSchematic();
            } else {
                boolean bl = isSchematicNode = np == Generic.tech().universalPinNode || np.getTechnology() == Schematics.tech();
            }
            if (!isSchematicNode) continue;
            if (strangeNodes == null) {
                strangeNodes = new HashMap<NodeProto, ArrayList<NodeInst>>();
            }
            if ((nodesOfType = (ArrayList<NodeInst>)strangeNodes.get(np)) == null) {
                nodesOfType = new ArrayList<NodeInst>();
                strangeNodes.put(np, nodesOfType);
            }
            nodesOfType.add(ni);
        }
        if (unconnectedPins != null) {
            for (NodeProto np : unconnectedPins.keySet()) {
                ArrayList pinsOfType = (ArrayList)unconnectedPins.get(np);
                msg = "Network: " + cell + " has " + pinsOfType.size() + " unconnected pins " + np;
                System.out.println(msg);
                errorLog.logWarning(msg, Collections.unmodifiableList(pinsOfType), null, null, null, null, cell, 1);
            }
        }
        if (strangeNodes != null) {
            for (NodeProto np : strangeNodes.keySet()) {
                ArrayList nodesOfType = (ArrayList)strangeNodes.get(np);
                msg = "Network: Layout " + cell + " has " + nodesOfType.size() + " " + np.describe(true) + " nodes";
                System.out.println(msg);
                errorLog.logError(msg, Collections.unmodifiableList(nodesOfType), null, cell, 0);
            }
        }
    }

    static boolean checkNodeSize(NodeInst ni, Cell cell, ReportInfo reportInfo) {
        PrimitiveNodeSize npSize;
        List<PrimitiveNode.NodeSizeRule.NodeSizeRuleError> errorsList;
        boolean errorsFound = false;
        NodeProto np = ni.getProto();
        PrimitiveNode.NodeSizeRule sizeRule = DRC.getMinSize(np);
        if (sizeRule != null && (errorsList = sizeRule.checkSize(npSize = ni.getNodeInstSize(null))) != null) {
            for (PrimitiveNode.NodeSizeRule.NodeSizeRuleError e : errorsList) {
                DRC.createDRCErrorLogger(reportInfo, DRCErrorType.MINSIZEERROR, e.message, cell, e.minSize, e.actual, sizeRule.getRuleName(), null, ni, null, null, null, null);
                errorsFound = true;
            }
        }
        return errorsFound;
    }

    public static boolean isIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBoolean();
    }

    public static void setIncrementalDRCOn(boolean on) {
        cacheIncrementalDRCOn.setBoolean(on);
    }

    public static boolean isFactoryIncrementalDRCOn() {
        return cacheIncrementalDRCOn.getBooleanFactoryValue();
    }

    public static boolean isInteractiveDRCDragOn() {
        return cacheInteractiveDRCDragOn.getBoolean();
    }

    public static void setInteractiveDRCDragOn(boolean on) {
        cacheInteractiveDRCDragOn.setBoolean(on);
    }

    public static boolean isFactoryInteractiveDRCDragOn() {
        return cacheInteractiveDRCDragOn.getBooleanFactoryValue();
    }

    public static DRCCheckLogging getErrorLoggingType() {
        return DRCCheckLogging.valueOf(cacheErrorLoggingType.getString());
    }

    public static void setErrorLoggingType(DRCCheckLogging type) {
        cacheErrorLoggingType.setString(type.name());
    }

    public static DRCCheckLogging getFactoryErrorLoggingType() {
        return DRCCheckLogging.valueOf(cacheErrorLoggingType.getStringFactoryValue());
    }

    public static DRCCheckMode getErrorType() {
        int val = cacheErrorCheckLevel.getInt();
        for (DRCCheckMode p : DRCCheckMode.values()) {
            if (p.mode() != val) continue;
            return p;
        }
        return null;
    }

    public static void setErrorType(DRCCheckMode type) {
        cacheErrorCheckLevel.setInt(type.mode());
    }

    public static DRCCheckMode getFactoryErrorType() {
        int val = cacheErrorCheckLevel.getIntFactoryValue();
        for (DRCCheckMode p : DRCCheckMode.values()) {
            if (p.mode() != val) continue;
            return p;
        }
        return null;
    }

    public static boolean isIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBoolean();
    }

    public static void setIgnoreCenterCuts(boolean on) {
        cacheIgnoreCenterCuts.setBoolean(on);
    }

    public static boolean isFactoryIgnoreCenterCuts() {
        return cacheIgnoreCenterCuts.getBooleanFactoryValue();
    }

    public static boolean isIgnoreAreaChecking() {
        return cacheIgnoreAreaChecking.getBoolean();
    }

    public static void setIgnoreAreaChecking(boolean on) {
        cacheIgnoreAreaChecking.setBoolean(on);
    }

    public static boolean isFactoryIgnoreAreaChecking() {
        return cacheIgnoreAreaChecking.getBooleanFactoryValue();
    }

    public static boolean isIgnoreExtensionRuleChecking() {
        return cacheIgnoreExtensionRuleChecking.getBoolean();
    }

    public static void setIgnoreExtensionRuleChecking(boolean on) {
        cacheIgnoreExtensionRuleChecking.setBoolean(on);
    }

    public static boolean isFactoryIgnoreExtensionRuleChecking() {
        return cacheIgnoreExtensionRuleChecking.getBooleanFactoryValue();
    }

    public static boolean isDatesStoredInMemory() {
        return cacheStoreDatesInMemory.getBoolean();
    }

    public static void setDatesStoredInMemory(boolean on) {
        cacheStoreDatesInMemory.setBoolean(on);
    }

    public static boolean isFactoryDatesStoredInMemory() {
        return cacheStoreDatesInMemory.getBooleanFactoryValue();
    }

    public static boolean isInteractiveLoggingOn() {
        return cacheInteractiveLog.getBoolean();
    }

    public static void setInteractiveLogging(boolean on) {
        cacheInteractiveLog.setBoolean(on);
    }

    public static boolean isFactoryInteractiveLoggingOn() {
        return cacheInteractiveLog.getBooleanFactoryValue();
    }

    public static DRCCheckMinArea getMinAreaAlgoOption() {
        return DRCCheckMinArea.valueOf(cacheMinAreaAlgo.getString());
    }

    public static void setMinAreaAlgoOption(DRCCheckMinArea mode) {
        cacheMinAreaAlgo.setString(mode.name());
    }

    public static DRCCheckMinArea getFactoryMinAreaAlgoOption() {
        return DRCCheckMinArea.valueOf(cacheMinAreaAlgo.getStringFactoryValue());
    }

    public static boolean isMultiThreaded() {
        return cacheMultiThread.getBoolean();
    }

    public static void setMultiThreaded(boolean mode) {
        cacheMultiThread.setBoolean(mode);
    }

    public static boolean isFactoryMultiThreaded() {
        return cacheMultiThread.getBooleanFactoryValue();
    }

    static void addDRCUpdate(int spacingBits, Set<Cell> goodSpacingDRCDate, Set<Cell> cleanSpacingDRCDate, Set<Cell> goodAreaDRCDate, Set<Cell> cleanAreaDRCDate, Map<Geometric, List<Variable>> newVariables) {
        boolean vars;
        boolean goodSpace = goodSpacingDRCDate != null && goodSpacingDRCDate.size() > 0;
        boolean cleanSpace = cleanSpacingDRCDate != null && cleanSpacingDRCDate.size() > 0;
        boolean goodArea = goodAreaDRCDate != null && goodAreaDRCDate.size() > 0;
        boolean cleanArea = cleanAreaDRCDate != null && cleanAreaDRCDate.size() > 0;
        boolean bl = vars = newVariables != null && newVariables.size() > 0;
        if (!(goodSpace || cleanSpace || vars || goodArea || cleanArea)) {
            return;
        }
        new DRCUpdate(spacingBits, goodSpacingDRCDate, cleanSpacingDRCDate, goodAreaDRCDate, cleanAreaDRCDate, newVariables);
    }

    public static void resetDRCDates(boolean startJob) {
        new DRCReset(startJob);
    }

    public static boolean testAll() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DRCUpdate
    extends Job {
        Set<Cell> goodSpacingDRCDate;
        Set<Cell> cleanSpacingDRCDate;
        Set<Cell> goodAreaDRCDate;
        Set<Cell> cleanAreaDRCDate;
        Map<Geometric, List<Variable>> newVariables;
        int activeBits = -1;

        public DRCUpdate(int bits, Set<Cell> goodSpacingDRCD, Set<Cell> cleanSpacingDRCD, Set<Cell> goodAreaDRCD, Set<Cell> cleanAreaDRCD, Map<Geometric, List<Variable>> newVars) {
            super("Update DRC data", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.goodSpacingDRCDate = goodSpacingDRCD;
            this.cleanSpacingDRCDate = cleanSpacingDRCD;
            this.goodAreaDRCDate = goodAreaDRCD;
            this.cleanAreaDRCDate = cleanAreaDRCD;
            this.newVariables = newVars;
            this.activeBits = bits;
            if (DRC.isDatesStoredInMemory() && (newVars == null || newVars.isEmpty())) {
                try {
                    this.doIt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                this.startJob();
            }
        }

        private static void setInformation(Map<Cell, StoreDRCInfo> storedDRCDate, Set<Cell> goodDRCDate, Set<Cell> cleanDRCDate, Variable.Key key, int bits, boolean inMemory) {
            HashSet<Cell> goodDRCCells = new HashSet<Cell>();
            long time = System.currentTimeMillis();
            if (goodDRCDate != null) {
                for (Cell cell : goodDRCDate) {
                    if (!cell.isLinked()) {
                        new JobException("Cell '" + cell + "' is invalid to clean DRC date");
                        continue;
                    }
                    if (inMemory) {
                        storedDRCDate.put(cell, new StoreDRCInfo(time, bits));
                        continue;
                    }
                    goodDRCCells.add(cell);
                }
            }
            if (!goodDRCCells.isEmpty()) {
                Layout.setGoodDRCCells(goodDRCCells, key, bits, inMemory);
            }
            if (cleanDRCDate != null) {
                for (Cell cell : cleanDRCDate) {
                    if (!cell.isLinked()) {
                        new JobException("Cell '" + cell + "' is invalid to clean DRC date");
                        continue;
                    }
                    StoreDRCInfo data = storedDRCDate.get(cell);
                    assert (data != null);
                    data.date = -1L;
                    data.bits = -1;
                    if (inMemory) continue;
                    DRC.cleanDRCDateAndBits(cell, key);
                }
            }
        }

        @Override
        public boolean doIt() throws JobException {
            boolean inMemory = DRC.isDatesStoredInMemory();
            DRCUpdate.setInformation(storedSpacingDRCDate, this.goodSpacingDRCDate, this.cleanSpacingDRCDate, Layout.DRC_LAST_GOOD_DATE_SPACING, this.activeBits, inMemory);
            DRCUpdate.setInformation(storedAreaDRCDate, this.goodAreaDRCDate, this.cleanAreaDRCDate, Layout.DRC_LAST_GOOD_DATE_AREA, -1, inMemory);
            if (this.newVariables != null) {
                assert (!inMemory);
                for (Map.Entry<Geometric, List<Variable>> e : this.newVariables.entrySet()) {
                    Geometric ni = e.getKey();
                    for (Variable var : e.getValue()) {
                        if (ni.isParam(var.getKey())) {
                            ((NodeInst)ni).addParameter(var);
                            continue;
                        }
                        ni.addVar(var);
                    }
                }
            }
            return true;
        }
    }

    private static class DRCReset
    extends Job {
        DRCReset(boolean startJob) {
            super("Resetting DRC Dates", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            if (startJob) {
                this.startJob();
            } else {
                this.doIt();
            }
        }

        public boolean doIt() {
            storedSpacingDRCDate.clear();
            storedAreaDRCDate.clear();
            Iterator<Library> it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = it.next();
                Iterator<Cell> cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell cell = cIt.next();
                    DRC.cleanDRCDateAndBits(cell, Layout.DRC_LAST_GOOD_DATE_SPACING);
                    DRC.cleanDRCDateAndBits(cell, Layout.DRC_LAST_GOOD_DATE_AREA);
                }
            }
            return true;
        }
    }

    private static class CheckDRCIncrementally
    extends CheckDRCJob {
        Geometric[] objectsToCheck;

        protected CheckDRCIncrementally(Cell cell, Geometric[] objectsToCheck, boolean layout) {
            super(cell, tool, Job.Priority.ANALYSIS, layout);
            this.objectsToCheck = objectsToCheck;
            this.startJob();
        }

        public boolean doIt() {
            incrementalRunning = true;
            ErrorLogger errorLog = DRC.getDRCErrorLogger(this.isLayout, true, null);
            errorLog = this.isLayout ? Quick.checkDesignRules(errorLog, this.cell, this.objectsToCheck, null, null) : Schematic.doCheck(errorLog, this.cell, this.objectsToCheck);
            int errorsFound = errorLog.getNumErrors();
            if (errorsFound > 0) {
                System.out.println("Incremental DRC found " + errorsFound + " errors/warnings in " + this.cell);
            }
            incrementalRunning = false;
            DRC.doIncrementalDRCTask();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CheckDRCHierarchically
    extends CheckDRCJob {
        Rectangle2D bounds;
        private GeometryHandler.GHMode mergeMode;
        private boolean onlyArea;
        private Geometric[] geoms;

        protected CheckDRCHierarchically(Cell cell, boolean layout, List<Geometric> objs, Rectangle2D bounds, GeometryHandler.GHMode mode, boolean onlyA) {
            super(cell, tool, Job.Priority.USER, layout);
            this.bounds = bounds;
            this.mergeMode = mode;
            this.onlyArea = onlyA;
            if (objs != null) {
                this.geoms = new Geometric[objs.size()];
                objs.toArray(this.geoms);
            }
            this.startJob();
        }

        @Override
        public boolean doIt() {
            long startTime = System.currentTimeMillis();
            ErrorLogger errorLog = DRC.getDRCErrorLogger(this.isLayout, false, null);
            DRC.checkNetworks(errorLog, this.cell, this.isLayout);
            if (this.isLayout) {
                Quick.checkDesignRules(errorLog, this.cell, this.geoms, null, this.bounds, this, this.mergeMode, this.onlyArea);
            } else {
                Schematic.doCheck(errorLog, this.cell, this.geoms);
            }
            long endTime = System.currentTimeMillis();
            int errorCount = errorLog.getNumErrors();
            int warnCount = errorLog.getNumWarnings();
            System.out.println(errorCount + " errors and " + warnCount + " warnings found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            if (this.onlyArea) {
                Job.getUserInterface().termLogging(errorLog, false, false);
            }
            return true;
        }
    }

    public static class CheckDRCJob
    extends Job {
        Cell cell;
        boolean isLayout;

        private static String getJobName(Cell cell) {
            return "Design-Rule Check " + cell;
        }

        protected CheckDRCJob(Cell cell, Listener tool, Job.Priority priority, boolean layout) {
            super(CheckDRCJob.getJobName(cell), tool, Job.Type.EXAMINE, null, null, priority);
            this.cell = cell;
            this.isLayout = layout;
        }

        public boolean doIt() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckMode {
        ERROR_CHECK_DEFAULT(0),
        ERROR_CHECK_CELL(1),
        ERROR_CHECK_EXHAUSTIVE(2);

        private final int mode;

        private DRCCheckMode(int m) {
            this.mode = m;
        }

        public int mode() {
            return this.mode;
        }

        public String toString() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckLogging {
        DRC_LOG_FLAT("Flat"),
        DRC_LOG_PER_CELL("By Cell"),
        DRC_LOG_PER_RULE("By Rule");

        private final String name;

        private DRCCheckLogging(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCCheckMinArea {
        AREA_BASIC("Simple"),
        AREA_LOCAL("Local");

        private final String name;

        private DRCCheckMinArea(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class StoreDRCInfo {
        long date;
        int bits;

        StoreDRCInfo(long d, int b) {
            this.date = d;
            this.bits = b;
        }
    }

    public static class ReportInfo {
        DRCCheckMode errorTypeSearch;
        double minAllowedResolution;
        boolean ignoreCenterCuts = DRC.isIgnoreCenterCuts();
        double worstInteractionDistance;
        int checkTimeStamp;
        int checkNetNumber;
        int totalSpacingMsgFound;
        ErrorLogger errorLogger;
        boolean interactiveLogger = DRC.isInteractiveLoggingOn();
        int activeSpacingBits = 0;
        Map<Cell, Area> exclusionMap = new HashMap<Cell, Area>();
        boolean inMemory = DRC.isDatesStoredInMemory();

        public ReportInfo(ErrorLogger eL, Technology tech, boolean specificGeoms) {
            this.errorLogger = eL;
            this.activeSpacingBits = DRC.getActiveBits(tech);
            this.worstInteractionDistance = DRC.getWorstSpacingDistance(tech, -1);
            this.minAllowedResolution = tech.getResolution();
            this.errorTypeSearch = DRC.getErrorType();
            if (specificGeoms) {
                this.errorTypeSearch = DRCCheckMode.ERROR_CHECK_CELL;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DRCErrorType {
        SPACINGERROR,
        MINWIDTHERROR,
        NOTCHERROR,
        MINSIZEERROR,
        BADLAYERERROR,
        LAYERSURROUNDERROR,
        MINAREAERROR,
        ENCLOSEDAREAERROR,
        SURROUNDERROR,
        FORBIDDEN,
        RESOLUTION,
        CUTERROR,
        SLOTSIZEERROR,
        CROOKEDERROR,
        ZEROLENGTHARCWARN,
        TECHMIXWARN;

    }
}

