/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.technology.Technology;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class TechId
implements Serializable {
    public static final TechId[] NULL_ARRAY = new TechId[0];
    public final IdManager idManager;
    public final String techName;
    public final int techIndex;
    final ArrayList<ArcProtoId> arcProtoIds = new ArrayList();
    private final HashMap<String, ArcProtoId> arcProtoIdsByName = new HashMap();
    final ArrayList<PrimitiveNodeId> primitiveNodeIds = new ArrayList();
    private final HashMap<String, PrimitiveNodeId> primitiveNodeIdsByName = new HashMap();
    volatile int modCount;

    TechId(IdManager idManager, String techName, int techIndex) {
        if (techName == null) {
            throw new NullPointerException();
        }
        if (techName.length() == 0 || !TechId.jelibSafeName(techName)) {
            throw new IllegalArgumentException(techName);
        }
        this.idManager = idManager;
        this.techName = techName;
        this.techIndex = techIndex;
    }

    private Object writeReplace() {
        return new TechIdKey(this);
    }

    synchronized int numArcProtoIds() {
        return this.arcProtoIds.size();
    }

    synchronized ArcProtoId getArcProtoId(int chronIndex) {
        return this.arcProtoIds.get(chronIndex);
    }

    public synchronized ArcProtoId newArcProtoId(String arcProtoName) {
        ArcProtoId arcProtoId = this.arcProtoIdsByName.get(arcProtoName);
        return arcProtoId != null ? arcProtoId : this.newArcProtoIdInternal(arcProtoName);
    }

    private ArcProtoId newArcProtoIdInternal(String arcProtoName) {
        int chronIndex = this.arcProtoIds.size();
        ArcProtoId arcProtoId = new ArcProtoId(this, arcProtoName, this.arcProtoIds.size());
        this.arcProtoIds.add(arcProtoId);
        this.arcProtoIdsByName.put(arcProtoName, arcProtoId);
        assert (this.arcProtoIds.size() == this.arcProtoIdsByName.size());
        ++this.modCount;
        return arcProtoId;
    }

    synchronized int numPrimitiveNodeIds() {
        return this.primitiveNodeIds.size();
    }

    synchronized PrimitiveNodeId getPrimitiveNodeId(int chronIndex) {
        return this.primitiveNodeIds.get(chronIndex);
    }

    public synchronized PrimitiveNodeId newPrimitiveNodeId(String primitiveNodeName) {
        PrimitiveNodeId primitiveNodeId = this.primitiveNodeIdsByName.get(primitiveNodeName);
        return primitiveNodeId != null ? primitiveNodeId : this.newPrimitiveNodeIdInternal(primitiveNodeName);
    }

    private PrimitiveNodeId newPrimitiveNodeIdInternal(String primitiveNodeName) {
        int chronIndex = this.primitiveNodeIds.size();
        PrimitiveNodeId primitiveNodeId = new PrimitiveNodeId(this, primitiveNodeName, this.primitiveNodeIds.size());
        this.primitiveNodeIds.add(primitiveNodeId);
        this.primitiveNodeIdsByName.put(primitiveNodeName, primitiveNodeId);
        assert (this.primitiveNodeIds.size() == this.primitiveNodeIdsByName.size());
        ++this.modCount;
        return primitiveNodeId;
    }

    public Technology inDatabase(EDatabase database) {
        return database.getTech(this);
    }

    public String toString() {
        return this.techName;
    }

    void check() {
        assert (this == this.idManager.getTechId(this.techIndex));
        assert (this.techName.length() > 0 && TechId.jelibSafeName(this.techName));
        for (Map.Entry<String, ArcProtoId> entry : this.arcProtoIdsByName.entrySet()) {
            ArcProtoId arcProtoId = entry.getValue();
            assert (arcProtoId.techId == this);
            assert (arcProtoId.name == entry.getKey());
            arcProtoId.check();
        }
        for (int chronIndex = 0; chronIndex < this.arcProtoIds.size(); ++chronIndex) {
            ArcProtoId arcProtoId = this.arcProtoIds.get(chronIndex);
            arcProtoId.check();
            assert (this.arcProtoIdsByName.get(arcProtoId.name) == arcProtoId);
        }
        for (Map.Entry<String, PrimitiveNodeId> entry : this.primitiveNodeIdsByName.entrySet()) {
            PrimitiveNodeId primitiveNodeId = entry.getValue();
            assert (primitiveNodeId.techId == this);
            assert (primitiveNodeId.name == entry.getKey());
            primitiveNodeId.check();
        }
        for (int chronIndex = 0; chronIndex < this.primitiveNodeIds.size(); ++chronIndex) {
            PrimitiveNodeId primitiveNodeId = this.primitiveNodeIds.get(chronIndex);
            primitiveNodeId.check();
            assert (this.primitiveNodeIdsByName.get(primitiveNodeId.name) == primitiveNodeId);
        }
    }

    public static boolean jelibSafeName(String str) {
        return TechId.jelibSafeName(str, false);
    }

    static boolean jelibSafeName(String str, boolean allowSpace) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == ':' || ch == '|' || ch == '^' || ch == '\\' || ch == '\"') {
                return false;
            }
            if (!Character.isWhitespace(ch) || allowSpace && ch == ' ') continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TechIdKey
    extends EObjectInputStream.Key<TechId> {
        public TechIdKey() {
        }

        private TechIdKey(TechId techId) {
            super(techId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, TechId techId) throws IOException {
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(techId + " from other IdManager");
            }
            out.writeInt(techId.techIndex);
        }

        @Override
        public TechId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            return in.getIdManager().getTechId(techIndex);
        }
    }
}

