/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.redisplay;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.PixelDrawing;
import com.sun.electric.tool.user.redisplay.VectorCache;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VectorDrawing {
    private static final boolean TAKE_STATS = false;
    private static final boolean DEBUGIMAGES = false;
    private static final int MAXGREEKSIZE = 25;
    private static final int SCALE_SH = 20;
    private PixelDrawing offscreen;
    private float scale;
    private float scale_;
    private float factorX;
    private float factorY;
    private int factorX_;
    private int factorY_;
    private int scale_int;
    private boolean fullInstantiate;
    private List<NodeInst> inPlaceNodePath;
    private Cell inPlaceCurrent;
    private long startTime;
    private boolean takingLongTime;
    private boolean stopRendering;
    private int szHalfWidth;
    private int szHalfHeight;
    private int screenLX;
    private int screenHX;
    private int screenLY;
    private int screenHY;
    private int boxCount;
    private int tinyBoxCount;
    private int lineBoxCount;
    private int lineCount;
    private int polygonCount;
    private int crossCount;
    private int textCount;
    private int circleCount;
    private int arcCount;
    private int subCellCount;
    private int tinySubCellCount;
    private float maxObjectSize;
    private float maxTextSize;
    private float maxCellSize;
    private Point tempPt1 = new Point();
    private Point tempPt2 = new Point();
    private Point tempPt3 = new Point();
    private Rectangle tempRect = new Rectangle();
    private Color textColor;
    private static VectorDrawing topVD;
    private static int debugXP;
    private static int debugYP;
    private static EGraphics textGraphics;
    private static EGraphics instanceGraphics;
    private static EGraphics portGraphics;

    public void render(PixelDrawing offscreen, double scale, Point2D offset, Cell cell, boolean fullInstantiate, List<NodeInst> inPlaceNodePath, Cell inPlaceCurrent, Rectangle screenLimit, VarContext context) {
        textGraphics.setColor(new Color(User.getColor(User.ColorPrefType.TEXT)));
        instanceGraphics.setColor(new Color(User.getColor(User.ColorPrefType.INSTANCE)));
        this.textColor = new Color(User.getColor(User.ColorPrefType.TEXT) & 0xFFFFFF);
        this.offscreen = offscreen;
        offscreen.highlightingLayers = false;
        Iterator<Layer> it = Technology.getCurrent().getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!layer.isDimmed()) continue;
            offscreen.highlightingLayers = true;
            break;
        }
        Dimension sz = offscreen.getSize();
        this.scale = (float)scale;
        this.scale_ = (float)(scale / 400.0);
        this.maxObjectSize = (float)User.getGreekSizeLimit() / this.scale;
        this.maxTextSize = this.maxObjectSize / (float)User.getGlobalTextScale();
        double screenArea = sz.getWidth() / scale * sz.getHeight() / scale;
        this.maxCellSize = (float)(User.getGreekCellSizeLimit() * screenArea);
        this.startTime = System.currentTimeMillis();
        long initialUsed = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.takingLongTime = false;
        this.polygonCount = 0;
        this.lineCount = 0;
        this.lineBoxCount = 0;
        this.tinyBoxCount = 0;
        this.boxCount = 0;
        this.arcCount = 0;
        this.circleCount = 0;
        this.textCount = 0;
        this.crossCount = 0;
        this.tinySubCellCount = 0;
        this.subCellCount = 0;
        this.fullInstantiate = fullInstantiate;
        this.inPlaceNodePath = inPlaceNodePath;
        this.inPlaceCurrent = inPlaceCurrent;
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.screenLX = 0;
        this.screenHX = sz.width;
        this.screenLY = 0;
        this.screenHY = sz.height;
        this.factorX = (float)(offset.getX() * 400.0 - (double)((float)this.szHalfWidth / this.scale_));
        this.factorY = (float)(offset.getY() * 400.0 + (double)((float)this.szHalfHeight / this.scale_));
        this.factorX_ = (int)this.factorX;
        this.factorY_ = (int)this.factorY;
        this.scale_int = (int)(this.scale_ * 1048576.0f);
        if (screenLimit != null) {
            this.screenLX = screenLimit.x;
            if (this.screenLX < 0) {
                this.screenLX = 0;
            }
            this.screenHX = screenLimit.x + screenLimit.width;
            if (this.screenHX >= sz.width) {
                this.screenHX = sz.width - 1;
            }
            this.screenLY = screenLimit.y;
            if (this.screenLY < 0) {
                this.screenLY = 0;
            }
            this.screenHY = screenLimit.y + screenLimit.height;
            if (this.screenHY >= sz.height) {
                this.screenHY = sz.height - 1;
            }
        }
        this.stopRendering = false;
        try {
            VectorCache.VectorCell topVC = this.drawCell(cell, Orientation.IDENT, context);
            topVD = this;
            this.render(topVC, 0, 0, context, 0);
            this.drawList(0, 0, topVC.getTopOnlyShapes(), 0, false);
        }
        catch (AbortRenderingException e) {
            // empty catch block
        }
        topVD = null;
        if (this.takingLongTime) {
            TopLevel.setBusyCursor(false);
            System.out.println("Done");
        }
    }

    public void render(PixelDrawing offscreen, double scale, Point2D offset, VectorCache.VectorBase[] shapes, boolean forceVisible) {
        textGraphics.setColor(new Color(User.getColor(User.ColorPrefType.TEXT)));
        this.textColor = new Color(User.getColor(User.ColorPrefType.TEXT) & 0xFFFFFF);
        this.offscreen = offscreen;
        Dimension sz = offscreen.getSize();
        this.scale = (float)scale;
        this.scale_ = (float)(scale / 400.0);
        this.szHalfWidth = sz.width / 2;
        this.szHalfHeight = sz.height / 2;
        this.screenLX = 0;
        this.screenHX = sz.width;
        this.screenLY = 0;
        this.screenHY = sz.height;
        this.factorX = (float)(offset.getX() * 400.0 - (double)((float)this.szHalfWidth / this.scale_));
        this.factorY = (float)(offset.getY() * 400.0 + (double)((float)this.szHalfHeight / this.scale_));
        this.factorX_ = (int)this.factorX;
        this.factorY_ = (int)this.factorY;
        this.scale_int = (int)(this.scale_ * 1048576.0f);
        try {
            List<VectorCache.VectorBase> shapeList = Arrays.asList(shapes);
            this.drawList(0, 0, shapeList, 0, forceVisible);
        }
        catch (AbortRenderingException e) {
            // empty catch block
        }
    }

    public void abortRendering() {
        this.stopRendering = true;
    }

    private void render(VectorCache.VectorCell vc, int oX, int oY, VarContext context, int level) throws AbortRenderingException {
        this.drawList(oX, oY, vc.filledShapes, level, false);
        this.drawList(oX, oY, vc.shapes, level, false);
        Cell cell = VectorCache.theCache.database.getCell(vc.vcg.cellId);
        for (VectorCache.VectorSubCell vsc : vc.subCells) {
            boolean expanded;
            if (this.stopRendering) {
                throw new AbortRenderingException();
            }
            NodeInst ni = cell.getNodeById(vsc.n.nodeId);
            Cell subCell = (Cell)ni.getProto();
            ++this.subCellCount;
            int soX = vsc.offsetX + oX;
            int soY = vsc.offsetY + oY;
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.subCellId, vc.orient.concatenate(vsc.n.orient));
            this.gridToScreen(subVC.lX + soX, subVC.hY + soY, this.tempPt1);
            this.gridToScreen(subVC.hX + soX, subVC.lY + soY, this.tempPt2);
            int lX = this.tempPt1.x;
            int lY = this.tempPt1.y;
            int hX = this.tempPt2.x;
            int hY = this.tempPt2.y;
            if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
            if (subVC.vcg.cellMinSize < this.maxObjectSize) {
                Orientation thisOrient = vsc.n.orient;
                Orientation recurseTrans = vc.orient.concatenate(thisOrient);
                VarContext subContext = context.push(ni);
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext);
                assert (subVC_ == subVC);
                this.makeGreekedImage(subVC);
                int fadeColor = this.getFadeColor(subVC, subContext);
                this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                ++this.tinySubCellCount;
                continue;
            }
            boolean onPathDown = false;
            if (this.inPlaceNodePath != null) {
                for (NodeInst niOnPath : this.inPlaceNodePath) {
                    if (niOnPath.getProto().getId() != vsc.subCellId) continue;
                    onPathDown = true;
                    break;
                }
            }
            boolean bl = expanded = ni.isExpanded() || this.fullInstantiate;
            if (!expanded && onPathDown) {
                expanded = true;
            }
            if (expanded) {
                int subLevel;
                Orientation thisOrient = vsc.n.orient;
                Orientation recurseTrans = vc.orient.concatenate(thisOrient);
                VarContext subContext = context.push(ni);
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext);
                assert (subVC_ == subVC);
                if (!subCell.isIcon()) {
                    boolean smallerThanGreek;
                    boolean allFeaturesTiny = subVC.maxFeatureSize > 0.0f && subVC.maxFeatureSize < this.maxObjectSize && subVC.vcg.cellArea < this.maxCellSize && this.isContentsTiny(subCell, subVC, recurseTrans, context);
                    boolean bl2 = smallerThanGreek = User.isUseCellGreekingImages() && hX - lX <= 25 && hY - lY <= 25;
                    if (allFeaturesTiny || smallerThanGreek) {
                        this.makeGreekedImage(subVC);
                        int fadeColor = this.getFadeColor(subVC, context);
                        this.drawTinyBox(lX, hX, lY, hY, fadeColor, subVC);
                        ++this.tinySubCellCount;
                        continue;
                    }
                }
                if ((subLevel = level) == 0) {
                    subLevel = 1;
                }
                this.render(subVC, soX, soY, subContext, subLevel);
            } else {
                int[] op = subVC.outlinePoints;
                int p1x = op[0] + soX;
                int p1y = op[1] + soY;
                int p2x = op[2] + soX;
                int p2y = op[3] + soY;
                int p3x = op[4] + soX;
                int p3y = op[5] + soY;
                int p4x = op[6] + soX;
                int p4y = op[7] + soY;
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p2x, p2y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.gridToScreen(p2x, p2y, this.tempPt1);
                this.gridToScreen(p3x, p3y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.gridToScreen(p3x, p3y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                this.gridToScreen(p1x, p1y, this.tempPt1);
                this.gridToScreen(p4x, p4y, this.tempPt2);
                this.offscreen.drawLine(this.tempPt1, this.tempPt2, null, instanceGraphics, 0, false);
                if (User.isTextVisibilityOnInstance()) {
                    this.tempRect.setBounds(lX, lY, hX - lX, hY - lY);
                    TextDescriptor descript = vsc.n.protoDescriptor;
                    this.offscreen.drawText(this.tempRect, Poly.Type.TEXTBOX, descript, subCell.describe(false), null, textGraphics, false);
                }
            }
            if (level != 0 && !onPathDown && this.inPlaceCurrent != cell) continue;
            this.drawPortList(vsc, subVC, soX, soY, ni.isExpanded());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawList(int oX, int oY, List<VectorCache.VectorBase> shapes, int level, boolean forceVisible) throws AbortRenderingException {
        for (k = shapes.size() - 1; k >= 0; --k) {
            block46: {
                vb = shapes.get(k);
                if (this.stopRendering) {
                    throw new AbortRenderingException();
                }
                layer = vb.layer;
                dimmed = false;
                if (layer != null) {
                    if (level < 0 && ((fun = layer.getFunction()).isContact() || fun.isWell() || fun.isSubstrate()) || !forceVisible && !layer.isVisible()) continue;
                    dimmed = layer.isDimmed();
                }
                layerBitMap = null;
                graphics = vb.graphics;
                if (graphics != null && (layerNum = graphics.getTransparentLayer() - 1) < this.offscreen.numLayerBitMaps) {
                    layerBitMap = this.offscreen.getLayerBitMap(layerNum);
                }
                if (vb instanceof VectorCache.VectorManhattan) {
                    ++this.boxCount;
                    vm = (VectorCache.VectorManhattan)vb;
                    maxSize = (double)this.maxObjectSize * 400.0;
                    fadeCol = -1;
                    if (layer != null) {
                        fun = layer.getFunction();
                        if (fun.isImplant() || fun.isSubstrate()) {
                            if (!vm.pureLayer) {
                                maxSize *= 10.0;
                            }
                        } else if (vm.graphics != null) {
                            fadeCol = vm.graphics.getRGB();
                        }
                    }
                    for (i = 0; i < vm.coords.length; i += 4) {
                        c1X = vm.coords[i];
                        c1Y = vm.coords[i + 1];
                        c2X = vm.coords[i + 2];
                        c2Y = vm.coords[i + 3];
                        dX = c2X - c1X;
                        dY = c2Y - c1Y;
                        if ((double)dX < maxSize || (double)dY < maxSize) {
                            if (fadeCol < 0) continue;
                            if ((double)dX < maxSize && (double)dY < maxSize) {
                                this.gridToScreen(c1X + oX, c1Y + oY, this.tempPt1);
                                x = this.tempPt1.x;
                                y = this.tempPt1.y;
                                if (x < this.screenLX || x >= this.screenHX || y < this.screenLY || y >= this.screenHY) continue;
                                this.offscreen.drawPoint(x, y, null, fadeCol);
                                ++this.tinyBoxCount;
                                continue;
                            }
                            this.gridToScreen(c1X + oX, c2Y + oY, this.tempPt1);
                            this.gridToScreen(c2X + oX, c1Y + oY, this.tempPt2);
                            if (!(VectorDrawing.$assertionsDisabled || this.tempPt1.x <= this.tempPt2.x && this.tempPt1.y <= this.tempPt2.y)) {
                                throw new AssertionError();
                            }
                            lX = this.tempPt1.x;
                            hX = this.tempPt2.x;
                            lY = this.tempPt1.y;
                            hY = this.tempPt2.y;
                            if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
                            this.drawTinyBox(lX, hX, lY, hY, fadeCol, null);
                            ++this.lineBoxCount;
                            continue;
                        }
                        this.gridToScreen(c1X + oX, c2Y + oY, this.tempPt1);
                        this.gridToScreen(c2X + oX, c1Y + oY, this.tempPt2);
                        if (!(VectorDrawing.$assertionsDisabled || this.tempPt1.x <= this.tempPt2.x && this.tempPt1.y <= this.tempPt2.y)) {
                            throw new AssertionError();
                        }
                        lX = this.tempPt1.x;
                        hX = this.tempPt2.x;
                        lY = this.tempPt1.y;
                        hY = this.tempPt2.y;
                        if (hX < this.screenLX || lX >= this.screenHX || hY < this.screenLY || lY >= this.screenHY) continue;
                        if (lX < this.screenLX) {
                            lX = this.screenLX;
                        }
                        if (hX >= this.screenHX) {
                            hX = this.screenHX - 1;
                        }
                        if (lY < this.screenLY) {
                            lY = this.screenLY;
                        }
                        if (hY >= this.screenHY) {
                            hY = this.screenHY - 1;
                        }
                        this.offscreen.drawBox(lX, hX, lY, hY, layerBitMap, graphics, dimmed);
                    }
                    continue;
                }
                if (vb instanceof VectorCache.VectorLine) {
                    ++this.lineCount;
                    vl = (VectorCache.VectorLine)vb;
                    this.gridToScreen(vl.fX + oX, vl.fY + oY, this.tempPt1);
                    this.gridToScreen(vl.tX + oX, vl.tY + oY, this.tempPt2);
                    this.offscreen.drawLine(this.tempPt1, this.tempPt2, layerBitMap, graphics, vl.texture, dimmed);
                    continue;
                }
                if (vb instanceof VectorCache.VectorPolygon) {
                    ++this.polygonCount;
                    vp = (VectorCache.VectorPolygon)vb;
                    intPoints = new Point[vp.points.length];
                    for (i = 0; i < vp.points.length; ++i) {
                        intPoints[i] = new Point();
                        this.gridToScreen(vp.points[i].x + oX, vp.points[i].y + oY, intPoints[i]);
                    }
                    clippedPoints = GenMath.clipPoly(intPoints, this.screenLX, this.screenHX - 1, this.screenLY, this.screenHY - 1);
                    this.offscreen.drawPolygon(clippedPoints, layerBitMap, graphics, dimmed);
                    continue;
                }
                if (vb instanceof VectorCache.VectorCross) {
                    ++this.crossCount;
                    vcr = (VectorCache.VectorCross)vb;
                    this.gridToScreen(vcr.x + oX, vcr.y + oY, this.tempPt1);
                    size = 5;
                    if (vcr.small) {
                        size = 3;
                    }
                    this.offscreen.drawLine(new Point(this.tempPt1.x - size, this.tempPt1.y), new Point(this.tempPt1.x + size, this.tempPt1.y), null, graphics, 0, dimmed);
                    this.offscreen.drawLine(new Point(this.tempPt1.x, this.tempPt1.y - size), new Point(this.tempPt1.x, this.tempPt1.y + size), null, graphics, 0, dimmed);
                    continue;
                }
                if (!(vb instanceof VectorCache.VectorText)) break block46;
                vt = (VectorCache.VectorText)vb;
                switch (vt.textType) {
                    case 4: {
                        if (!User.isTextVisibilityOnArc()) {
                            break;
                        }
                        ** GOTO lbl129
                    }
                    case 3: {
                        if (!User.isTextVisibilityOnNode()) {
                            break;
                        }
                        ** GOTO lbl129
                    }
                    case 1: {
                        if (!User.isTextVisibilityOnCell()) {
                            break;
                        }
                        ** GOTO lbl129
                    }
                    case 2: {
                        if (!User.isTextVisibilityOnExport()) {
                            break;
                        }
                        ** GOTO lbl129
                    }
                    case 5: {
                        if (!User.isTextVisibilityOnAnnotation()) {
                            break;
                        }
                        ** GOTO lbl129
                    }
                    case 6: {
                        if (!User.isTextVisibilityOnInstance()) break;
                    }
lbl129:
                    // 7 sources

                    default: {
                        if (vt.height < this.maxTextSize) break;
                        drawString = vt.str;
                        lX = vt.bounds.x;
                        lY = vt.bounds.y;
                        hX = lX + vt.bounds.width;
                        hY = lY + vt.bounds.height;
                        this.gridToScreen(lX + oX, hY + oY, this.tempPt1);
                        this.gridToScreen(hX + oX, lY + oY, this.tempPt2);
                        lX = this.tempPt1.x;
                        lY = this.tempPt1.y;
                        hX = this.tempPt2.x;
                        hY = this.tempPt2.y;
                        if (vt.textType == 2 && vt.basePort != null) {
                            if (!vt.basePort.getParent().isVisible()) break;
                            exportDisplayLevel = User.getExportDisplayLevel();
                            if (exportDisplayLevel == 2) {
                                cX = (lX + hX) / 2;
                                cY = (lY + hY) / 2;
                                size = 3;
                                this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, VectorDrawing.textGraphics, 0, false);
                                this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, VectorDrawing.textGraphics, 0, false);
                                ++this.crossCount;
                                break;
                            }
                            if (exportDisplayLevel == 1) {
                                drawString = Export.getShortName(drawString);
                            }
                            graphics = VectorDrawing.textGraphics;
                            layerBitMap = null;
                        }
                        ++this.textCount;
                        this.tempRect.setBounds(lX, lY, hX - lX, hY - lY);
                        this.offscreen.drawText(this.tempRect, vt.style, vt.descript, drawString, layerBitMap, graphics, dimmed);
                        break;
                    }
                }
                continue;
            }
            if (vb instanceof VectorCache.VectorCircle) {
                ++this.circleCount;
                vci = (VectorCache.VectorCircle)vb;
                this.gridToScreen(vci.cX + oX, vci.cY + oY, this.tempPt1);
                this.gridToScreen(vci.eX + oX, vci.eY + oY, this.tempPt2);
                switch (vci.nature) {
                    case 0: {
                        this.offscreen.drawCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 1: {
                        this.offscreen.drawThickCircle(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                        break;
                    }
                    case 2: {
                        this.offscreen.drawDisc(this.tempPt1, this.tempPt2, layerBitMap, graphics, dimmed);
                    }
                }
                continue;
            }
            if (!(vb instanceof VectorCache.VectorCircleArc)) continue;
            ++this.arcCount;
            vca = (VectorCache.VectorCircleArc)vb;
            this.gridToScreen(vca.cX + oX, vca.cY + oY, this.tempPt1);
            this.gridToScreen(vca.eX1 + oX, vca.eY1 + oY, this.tempPt2);
            this.gridToScreen(vca.eX2 + oX, vca.eY2 + oY, this.tempPt3);
            this.offscreen.drawCircleArc(this.tempPt1, this.tempPt2, this.tempPt3, vca.thick, layerBitMap, graphics, dimmed);
        }
    }

    private void drawPortList(VectorCache.VectorSubCell vsc, VectorCache.VectorCell subVC_, int oX, int oY, boolean expanded) throws AbortRenderingException {
        if (!User.isTextVisibilityOnPort()) {
            return;
        }
        List<VectorCache.VectorCellExport> portShapes = subVC_.vcg.getPortShapes();
        int[] portCenters = subVC_.getPortCenters();
        assert (portShapes.size() * 2 == portCenters.length);
        for (int i = 0; i < portShapes.size(); ++i) {
            VectorCache.VectorCellExport vce = portShapes.get(i);
            if (this.stopRendering) {
                throw new AbortRenderingException();
            }
            if (vsc.shownPorts.get(vce.getChronIndex()) || vce.height < this.maxTextSize) continue;
            int cX = portCenters[i * 2];
            int cY = portCenters[i * 2 + 1];
            this.gridToScreen(cX + oX, cY + oY, this.tempPt1);
            cX = this.tempPt1.x;
            cY = this.tempPt1.y;
            int portDisplayLevel = User.getPortDisplayLevel();
            Color portColor = vce.getPortColor();
            if (expanded) {
                portColor = this.textColor;
            }
            if (portColor != null) {
                portGraphics.setColor(portColor);
            }
            if (portDisplayLevel == 2) {
                int size = 3;
                this.offscreen.drawLine(new Point(cX - size, cY), new Point(cX + size, cY), null, portGraphics, 0, false);
                this.offscreen.drawLine(new Point(cX, cY - size), new Point(cX, cY + size), null, portGraphics, 0, false);
                ++this.crossCount;
                continue;
            }
            boolean shortName = portDisplayLevel == 1;
            String drawString = vce.getName(shortName);
            ++this.textCount;
            this.tempRect.setBounds(cX, cY, 0, 0);
            this.offscreen.drawText(this.tempRect, vce.style, vce.descript, drawString, null, portGraphics, false);
        }
    }

    private void gridToScreen(int dbX, int dbY, Point result) {
        double scrX = ((float)dbX - this.factorX) * this.scale_;
        double scrY = (this.factorY - (float)dbY) * this.scale_;
        result.x = (int)(scrX >= 0.0 ? scrX + 0.5 : scrX - 0.5);
        result.y = (int)(scrY >= 0.0 ? scrY + 0.5 : scrY - 0.5);
    }

    private void drawTinyBox(int lX, int hX, int lY, int hY, int col, VectorCache.VectorCell greekedCell) {
        if (lX < this.screenLX) {
            lX = this.screenLX;
        }
        if (hX >= this.screenHX) {
            hX = this.screenHX - 1;
        }
        if (lY < this.screenLY) {
            lY = this.screenLY;
        }
        if (hY >= this.screenHY) {
            hY = this.screenHY - 1;
        }
        if (User.isUseCellGreekingImages() && greekedCell != null && greekedCell.fadeImageColors != null) {
            int backgroundColor = User.getColor(User.ColorPrefType.BACKGROUND);
            int backgroundRed = backgroundColor >> 16 & 0xFF;
            int backgroundGreen = backgroundColor >> 8 & 0xFF;
            int backgroundBlue = backgroundColor & 0xFF;
            int greekWid = greekedCell.fadeImageWid;
            int greekHei = greekedCell.fadeImageHei;
            int wid = hX - lX;
            int hei = hY - lY;
            float xInc = (float)greekWid / (float)wid;
            float yInc = (float)greekHei / (float)hei;
            float yPos = 0.0f;
            for (int y = 0; y < hei; ++y) {
                float yEndPos = yPos + yInc;
                int yS = (int)yPos;
                int yE = (int)yEndPos;
                float xPos = 0.0f;
                for (int x = 0; x < wid; ++x) {
                    float xEndPos = xPos + xInc;
                    int xS = (int)xPos;
                    int xE = (int)xEndPos;
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    float totalArea = 0.0f;
                    for (int yGrab = yS; yGrab <= yE; ++yGrab) {
                        if (yGrab >= greekHei) continue;
                        float yArea = 1.0f;
                        if (yGrab == yS) {
                            yArea = 1.0f - (yPos - (float)yS);
                        }
                        if (yGrab == yE) {
                            yArea *= yEndPos - (float)yE;
                        }
                        for (int xGrab = xS; xGrab <= xE; ++xGrab) {
                            if (xGrab >= greekWid) continue;
                            int index = xGrab + yGrab * greekedCell.fadeImageWid;
                            if (greekedCell.fadeImageColors == null || index >= greekedCell.fadeImageColors.length) continue;
                            int value = greekedCell.fadeImageColors[index];
                            int red = value >> 16 & 0xFF;
                            int green = value >> 8 & 0xFF;
                            int blue = value & 0xFF;
                            float area = yArea;
                            if (xGrab == xS) {
                                area *= 1.0f - (xPos - (float)xS);
                            }
                            if (xGrab == xE) {
                                area *= xEndPos - (float)xE;
                            }
                            if (area <= 0.0f) continue;
                            r += (float)red * area;
                            g += (float)green * area;
                            b += (float)blue * area;
                            totalArea += area;
                        }
                    }
                    if (totalArea > 0.0f) {
                        int blue;
                        int green;
                        int red = (int)(r / totalArea);
                        if (red > 255) {
                            red = 255;
                        }
                        if ((green = (int)(g / totalArea)) > 255) {
                            green = 255;
                        }
                        if ((blue = (int)(b / totalArea)) > 255) {
                            blue = 255;
                        }
                        if (Math.abs(backgroundRed - red) > 2 || Math.abs(backgroundGreen - green) > 2 || Math.abs(backgroundBlue - blue) > 2) {
                            this.offscreen.drawPoint(lX + x, lY + y, null, red << 16 | green << 8 | blue);
                        }
                    }
                    xPos = xEndPos;
                }
                yPos = yEndPos;
            }
            return;
        }
        for (int y = lY; y <= hY; ++y) {
            for (int x = lX; x <= hX; ++x) {
                this.offscreen.drawPoint(x, y, null, col);
            }
        }
    }

    private boolean isContentsTiny(Cell cell, VectorCache.VectorCell vc, Orientation trans, VarContext context) throws AbortRenderingException {
        if (vc.maxFeatureSize > this.maxObjectSize) {
            return false;
        }
        for (VectorCache.VectorSubCell vsc : vc.subCells) {
            NodeInst ni = cell.getNodeById(vsc.n.nodeId);
            VectorCache.VectorCell subVC = VectorCache.theCache.findVectorCell(vsc.subCellId, vc.orient.concatenate(vsc.n.orient));
            if (ni.isExpanded() || this.fullInstantiate) {
                Orientation thisOrient = ni.getOrient();
                Orientation recurseTrans = trans.concatenate(thisOrient);
                VarContext subContext = context.push(ni);
                Cell subCell = (Cell)ni.getProto();
                VectorCache.VectorCell subVC_ = this.drawCell(subCell, recurseTrans, subContext);
                assert (subVC_ == subVC);
                boolean subCellTiny = this.isContentsTiny(subCell, subVC, recurseTrans, subContext);
                if (subCellTiny) continue;
                return false;
            }
            if (!(subVC.vcg.cellMinSize > this.maxObjectSize)) continue;
            return false;
        }
        return true;
    }

    private void makeGreekedImage(VectorCache.VectorCell subVC) throws AbortRenderingException {
        if (subVC.fadeImage) {
            return;
        }
        if (!User.isUseCellGreekingImages()) {
            return;
        }
        ERectangle cellBounds = subVC.vcg.bounds;
        Rectangle2D.Double ownBounds = new Rectangle2D.Double(cellBounds.getMinX(), cellBounds.getMinY(), ((RectangularShape)cellBounds).getWidth(), ((RectangularShape)cellBounds).getHeight());
        AffineTransform trans = subVC.orient.rotateAbout(0.0, 0.0);
        DBMath.transformRect(ownBounds, trans);
        double greekScale = 25.0 / ((RectangularShape)ownBounds).getHeight();
        if (((RectangularShape)ownBounds).getWidth() > ((RectangularShape)ownBounds).getHeight()) {
            greekScale = 25.0 / ((RectangularShape)ownBounds).getWidth();
        }
        int lX = (int)Math.floor(cellBounds.getMinX() * greekScale);
        int hX = (int)Math.ceil(((RectangularShape)cellBounds).getMaxX() * greekScale);
        int lY = (int)Math.floor(cellBounds.getMinY() * greekScale);
        int hY = (int)Math.ceil(((RectangularShape)cellBounds).getMaxY() * greekScale);
        if (hX <= lX) {
            hX = lX + 1;
        }
        int greekWid = hX - lX;
        if (hY <= lY) {
            hY = lY + 1;
        }
        int greekHei = hY - lY;
        Rectangle screenBounds = new Rectangle(lX, lY, greekWid, greekHei);
        PixelDrawing offscreen = new PixelDrawing(greekScale, screenBounds);
        Point2D.Double cellCtr = new Point2D.Double(ownBounds.getCenterX(), ownBounds.getCenterY());
        VectorDrawing subVD = new VectorDrawing();
        subVC.fadeOffsetX = debugXP;
        subVC.fadeOffsetY = debugYP;
        if (topVD != null && (debugXP += 30) + 25 + 2 >= VectorDrawing.topVD.offscreen.getSize().width) {
            debugXP = 0;
            debugYP += 30;
        }
        subVD.offscreen = offscreen;
        subVD.screenLX = 0;
        subVD.screenHX = greekWid;
        subVD.screenLY = 0;
        subVD.screenHY = greekHei;
        subVD.szHalfWidth = greekWid / 2;
        subVD.szHalfHeight = greekHei / 2;
        subVD.maxObjectSize = 0.0f;
        subVD.maxTextSize = 0.0f;
        subVD.scale = (float)greekScale;
        subVD.scale_ = (float)(greekScale / 400.0);
        subVD.factorX = (float)(((Point2D)cellCtr).getX() * 400.0 - (double)((float)subVD.szHalfWidth / subVD.scale_));
        subVD.factorY = (float)(((Point2D)cellCtr).getY() * 400.0 + (double)((float)subVD.szHalfHeight / subVD.scale_));
        subVD.factorX_ = (int)subVD.factorX;
        subVD.factorY_ = (int)subVD.factorY;
        subVD.scale_int = (int)(subVD.scale_ * 1048576.0f);
        subVD.fullInstantiate = true;
        subVD.takingLongTime = true;
        subVD.offscreen.clearImage(null);
        subVD.render(subVC, 0, 0, VarContext.globalContext, -1);
        subVD.offscreen.composite(null);
        int[] img = offscreen.getOpaqueData();
        subVC.fadeImageWid = greekWid;
        subVC.fadeImageHei = greekHei;
        subVC.fadeImageColors = new int[subVC.fadeImageWid * subVC.fadeImageHei];
        int i = 0;
        for (int y = 0; y < subVC.fadeImageHei; ++y) {
            for (int x = 0; x < subVC.fadeImageWid; ++x) {
                int value = img[i];
                subVC.fadeImageColors[i++] = value & 0xFFFFFF;
            }
        }
        subVC.fadeImage = true;
    }

    private int getFadeColor(VectorCache.VectorCell vc, VarContext context) throws AbortRenderingException {
        if (vc.hasFadeColor) {
            return vc.fadeColor;
        }
        HashMap<Layer, GenMath.MutableDouble> layerAreas = new HashMap<Layer, GenMath.MutableDouble>();
        this.gatherContents(vc, layerAreas, context);
        Set keys = layerAreas.keySet();
        double totalArea = 0.0;
        for (Layer layer : keys) {
            GenMath.MutableDouble md = (GenMath.MutableDouble)layerAreas.get(layer);
            totalArea += md.doubleValue();
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        if (totalArea != 0.0) {
            for (Layer layer : keys) {
                GenMath.MutableDouble md = (GenMath.MutableDouble)layerAreas.get(layer);
                double portion = md.doubleValue() / totalArea;
                EGraphics desc = layer.getGraphics();
                Color col = desc.getColor();
                r += (double)col.getRed() * portion;
                g += (double)col.getGreen() * portion;
                b += (double)col.getBlue() * portion;
            }
        }
        if (r < 0.0) {
            r = 0.0;
        }
        if (r > 255.0) {
            r = 255.0;
        }
        if (g < 0.0) {
            g = 0.0;
        }
        if (g > 255.0) {
            g = 255.0;
        }
        if (b < 0.0) {
            b = 0.0;
        }
        if (b > 255.0) {
            b = 255.0;
        }
        vc.fadeColor = (int)r << 16 | (int)g << 8 | (int)b;
        vc.hasFadeColor = true;
        return vc.fadeColor;
    }

    private void gatherContents(VectorCache.VectorCell vc, Map<Layer, GenMath.MutableDouble> layerAreas, VarContext context) throws AbortRenderingException {
        for (VectorCache.VectorBase vb : vc.filledShapes) {
            Layer.Function fun;
            Layer layer = vb.layer;
            if (layer == null || (fun = layer.getFunction()).isImplant() || fun.isSubstrate()) continue;
            double area = 0.0;
            if (vb instanceof VectorCache.VectorManhattan) {
                VectorCache.VectorManhattan vm = (VectorCache.VectorManhattan)vb;
                for (int i = 0; i < vm.coords.length; i += 4) {
                    double c1X = vm.coords[i];
                    double c1Y = vm.coords[i + 1];
                    double c2X = vm.coords[i + 2];
                    double c2Y = vm.coords[i + 3];
                    area += (c1X - c2X) * (c1Y - c2Y);
                }
            } else if (vb instanceof VectorCache.VectorPolygon) {
                VectorCache.VectorPolygon vp = (VectorCache.VectorPolygon)vb;
                area = GenMath.getAreaOfPoints(vp.points);
            } else if (vb instanceof VectorCache.VectorCircle) {
                VectorCache.VectorCircle vci = (VectorCache.VectorCircle)vb;
                double radius = new Point2D.Double(vci.cX, vci.cY).distance(new Point2D.Double(vci.eX, vci.eY));
                area = radius * radius * Math.PI;
            }
            if (area == 0.0) continue;
            GenMath.MutableDouble md = layerAreas.get(layer);
            if (md == null) {
                md = new GenMath.MutableDouble(0.0);
                layerAreas.put(layer, md);
            }
            md.setValue(md.doubleValue() + area);
        }
        Cell cell = VectorCache.theCache.database.getCell(vc.vcg.cellId);
        for (VectorCache.VectorSubCell vsc : vc.subCells) {
            VectorCache.VectorCellGroup vcg = VectorCache.theCache.findCellGroup(vsc.subCellId);
            VectorCache.VectorCell subVC = vcg.getAnyCell();
            NodeInst ni = cell.getNodeById(vsc.n.nodeId);
            VarContext subContext = context.push(ni);
            if (subVC == null) {
                subVC = this.drawCell((Cell)ni.getProto(), Orientation.IDENT, subContext);
            }
            this.gatherContents(subVC, layerAreas, subContext);
        }
    }

    private VectorCache.VectorCell drawCell(Cell cell, Orientation prevTrans, VarContext context) throws AbortRenderingException {
        long currentTime;
        if (this.stopRendering) {
            throw new AbortRenderingException();
        }
        if (!this.takingLongTime && (currentTime = System.currentTimeMillis()) - this.startTime > 1000L) {
            System.out.print("Display caching, please wait...");
            TopLevel.setBusyCursor(true);
            this.takingLongTime = true;
        }
        return VectorCache.theCache.drawCell(cell.getId(), prevTrans, context, this.scale);
    }

    static {
        textGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        instanceGraphics = new EGraphics(false, false, null, 0, 0, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        portGraphics = new EGraphics(false, false, null, 0, 255, 0, 0, 1.0, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    class AbortRenderingException
    extends Exception {
        AbortRenderingException() {
        }
    }
}

