/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.generator.sclibrary.SCLibraryGen;
import com.sun.electric.tool.io.input.verilog.VerilogData;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Verilog
extends Topology {
    private static HashSet<String> reservedWords = new HashSet();
    private static final int MAXDECLARATIONWIDTH = 80;
    private static final String IMPLICITINVERTERNODENAME = "Imp";
    private static final String IMPLICITINVERTERSIGNAME = "ImpInv";
    public static final Variable.Key VERILOG_CODE_KEY;
    public static final Variable.Key VERILOG_DECLARATION_KEY;
    public static final Variable.Key WIRE_TYPE_KEY;
    public static final Variable.Key VERILOG_TEMPLATE_KEY;
    public static final Variable.Key VERILOG_BEHAVE_FILE_KEY;
    private HashSet<Cell> modelOverrides = new HashSet();
    private HashMap<String, String> definedModules = new HashMap();
    private HashMap<Cell, VerilogData.VerilogModule> definedPrimitives = new HashMap();
    private StringBuffer sim_verDeclarationLine;
    private int sim_verdeclarationprefix;
    private static final String[] verilogGates;

    public static void writeVerilogFile(Cell cell, VarContext context, String filePath) {
        Verilog out = new Verilog();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    Verilog() {
    }

    @Override
    protected void start() {
        this.setOutputWidth(80, false);
        this.setContinuationString("      ");
        this.printWriter.print("/* Verilog for " + this.topCell + " from " + this.topCell.getLibrary() + " */\n");
        this.emitCopyright("/* ", " */");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.print("/* Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + " */\n");
            this.printWriter.print("/* Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + " */\n");
            this.printWriter.print("/* Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " */\n");
        } else {
            this.printWriter.print("/* Written by Electric VLSI Design System */\n");
        }
    }

    @Override
    protected void done() {
        Simulation.setVerilogStopAtStandardCells(false);
    }

    @Override
    protected boolean skipCellAndSubcells(Cell cell) {
        if (cell.getVar(VERILOG_TEMPLATE_KEY) != null) {
            return true;
        }
        if (CellModelPrefs.verilogModelPrefs.isUseModelFromFile(cell)) {
            VerilogReader reader = new VerilogReader();
            String fileName = CellModelPrefs.verilogModelPrefs.getModelFile(cell);
            VerilogData data = reader.parseVerilog(fileName);
            if (data == null) {
                System.out.println("Error reading include file: " + fileName);
                return false;
            }
            if (!this.checkIncludedData(data, cell, fileName)) {
                return false;
            }
            if (!this.modelOverrides.contains(cell)) {
                this.printWriter.print("`include \"" + fileName + "\"\n");
                this.modelOverrides.add(cell);
            }
            return true;
        }
        Cell verViewCell = cell.otherView(View.VERILOG);
        if (verViewCell != null) {
            String[] stringArray = verViewCell.getTextViewContents();
            if (stringArray != null) {
                String line;
                if (stringArray.length > 0 && (line = stringArray[0].toLowerCase()).startsWith("do not use")) {
                    return false;
                }
                VerilogReader reader = new VerilogReader();
                VerilogData data = reader.parseVerilog(stringArray, cell.getLibrary().getName());
                if (data == null) {
                    System.out.println("Error parsing Verilog View for cell " + cell.describe(false));
                    return false;
                }
                if (!this.checkIncludedData(data, cell, null)) {
                    return false;
                }
                System.out.println("Info: Netlisting Verilog view of " + cell.describe(false));
                this.printWriter.println();
                this.printWriter.println("/* Verilog view of " + verViewCell.libDescribe() + " */");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.printWriter.println(stringArray[i]);
                }
            }
            return true;
        }
        return Simulation.getVerilogStopAtStandardCells() && SCLibraryGen.isStandardCell(cell);
    }

    @Override
    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context, Topology.MyCellInfo info) {
        Topology.CellAggregateSignal cas;
        if (cell == this.topCell) {
            Global global;
            int i;
            Netlist netList = cni.getNetList();
            Global.Set globals = netList.getGlobals();
            int globalSize = globals.size();
            ArrayList<Global> globalsToWrite = new ArrayList<Global>();
            for (i = 0; i < globalSize; ++i) {
                global = globals.get(i);
                if (global == Global.power || global == Global.ground) continue;
                globalsToWrite.add(global);
            }
            if (globalsToWrite.size() > 0) {
                this.printWriter.print("\nmodule glbl();\n");
                for (i = 0; i < globalsToWrite.size(); ++i) {
                    global = (Global)globalsToWrite.get(i);
                    if (Simulation.getVerilogUseTrireg()) {
                        this.printWriter.print("    trireg " + global.getName() + ";\n");
                        continue;
                    }
                    this.printWriter.print("    wire " + global.getName() + ";\n");
                }
                this.printWriter.print("endmodule\n");
            }
        }
        HashMap<ArcInst, Integer> implicitHeadInverters = new HashMap<ArcInst, Integer>();
        HashMap<ArcInst, Integer> implicitTailInverters = new HashMap<ArcInst, Integer>();
        int impInvCount = 0;
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            for (int e = 0; e < 2; ++e) {
                PortInst pi;
                NodeInst ni;
                if (!ai.isNegated(e) || ((ni = (pi = ai.getPortInst(e)).getNodeInst()).getProto() == Schematics.tech.bufferNode || ni.getProto() == Schematics.tech.andNode || ni.getProto() == Schematics.tech.orNode || ni.getProto() == Schematics.tech.xorNode) && (Simulation.getVerilogUseAssign() || pi.getPortProto().getName().equals("y"))) continue;
                if (e == 1) {
                    implicitHeadInverters.put(ai, new Integer(impInvCount));
                } else {
                    implicitTailInverters.put(ai, new Integer(impInvCount));
                }
                if (ai.getProto() != Schematics.tech.bus_arc) {
                    ++impInvCount;
                    continue;
                }
                int wid = cni.getNetList().getBusWidth(ai);
                impInvCount += wid;
            }
        }
        Netlist netList = cni.getNetList();
        this.printWriter.print("\n");
        StringBuffer sb = new StringBuffer();
        sb.append("module " + cni.getParameterizedName() + "(");
        boolean first = true;
        Iterator<Object> it2 = cni.getCellAggregateSignals();
        while (it2.hasNext()) {
            cas = it2.next();
            if (cas.getExport() == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cas.getName());
            first = false;
        }
        sb.append(");\n");
        this.writeWidthLimited(sb.toString());
        this.definedModules.put(cni.getParameterizedName(), "Cell " + cell.libDescribe());
        it2 = cell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            Variable var = ai.getVar(WIRE_TYPE_KEY);
            if (var == null) continue;
            String wireType = var.getObject().toString();
            int overrideValue = 0;
            if (wireType.equalsIgnoreCase("wire")) {
                overrideValue = 1;
            } else if (wireType.equalsIgnoreCase("trireg")) {
                overrideValue = 2;
            }
            int busWidth = netList.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                Network net = netList.getNetwork(ai, i);
                Topology.CellSignal cs = cni.getCellSignal(net);
                if (cs == null) continue;
                cs.getAggregateSignal().setFlags(overrideValue);
            }
        }
        first = true;
        it2 = cni.getCellAggregateSignals();
        while (it2.hasNext()) {
            cas = (Topology.CellAggregateSignal)it2.next();
            Export pp = cas.getExport();
            if (pp == null) continue;
            String portType = "input";
            if (pp.getCharacteristic() == PortCharacteristic.OUT) {
                portType = "output";
            }
            this.printWriter.print("  " + portType);
            if (cas.getLowIndex() > cas.getHighIndex()) {
                this.printWriter.print(" " + cas.getName() + ";");
            } else {
                int low = cas.getLowIndex();
                int high = cas.getHighIndex();
                if (cas.isDescending()) {
                    low = cas.getHighIndex();
                    high = cas.getLowIndex();
                }
                this.printWriter.print(" [" + low + ":" + high + "] " + cas.getName() + ";");
            }
            if (cas.getFlags() != 0) {
                if (cas.getFlags() == 1) {
                    this.printWriter.print("  wire");
                } else {
                    this.printWriter.print("  trireg");
                }
                this.printWriter.print(" " + cas.getName() + ";");
            }
            this.printWriter.print("\n");
            first = false;
        }
        if (!first) {
            this.printWriter.print("\n");
        }
        if (cni.getPowerNet() != null) {
            this.printWriter.print("  supply1 vdd;\n");
        }
        if (cni.getGroundNet() != null) {
            this.printWriter.print("  supply0 gnd;\n");
        }
        String wireType = "wire";
        if (Simulation.getVerilogUseTrireg()) {
            wireType = "trireg";
        }
        int localWires = 0;
        for (int wt = 0; wt < 2; ++wt) {
            first = true;
            Iterator<Topology.CellAggregateSignal> it3 = cni.getCellAggregateSignals();
            while (it3.hasNext()) {
                Topology.CellAggregateSignal cas2 = it3.next();
                if (cas2.getExport() != null || cas2.isSupply() || cas2.getLowIndex() <= cas2.getHighIndex() || cas2.isGlobal()) continue;
                String impSigName = wireType;
                if (cas2.getFlags() != 0) {
                    impSigName = cas2.getFlags() == 1 ? "wire" : "trireg";
                }
                if (!(wt == 0 ^ !wireType.equals(impSigName))) continue;
                if (first) {
                    this.initDeclaration("  " + impSigName);
                }
                this.addDeclaration(cas2.getName());
                ++localWires;
                first = false;
            }
            if (first) continue;
            this.termDeclaration();
        }
        Iterator<Topology.CellAggregateSignal> it4 = cni.getCellAggregateSignals();
        while (it4.hasNext()) {
            Topology.CellAggregateSignal cas3 = it4.next();
            if (cas3.getExport() != null || cas3.isSupply() || cas3.getLowIndex() > cas3.getHighIndex() || cas3.isGlobal()) continue;
            if (cas3.isDescending()) {
                this.printWriter.print("  " + wireType + " [" + cas3.getHighIndex() + ":" + cas3.getLowIndex() + "] " + cas3.getName() + ";\n");
            } else {
                this.printWriter.print("  " + wireType + " [" + cas3.getLowIndex() + ":" + cas3.getHighIndex() + "] " + cas3.getName() + ";\n");
            }
            ++localWires;
        }
        if (localWires != 0) {
            this.printWriter.print("\n");
        }
        if (impInvCount > 0) {
            this.initDeclaration("  " + wireType);
            for (int i = 0; i < impInvCount; ++i) {
                String impsigname = IMPLICITINVERTERSIGNAME + i;
                this.addDeclaration(impsigname);
            }
            this.termDeclaration();
        }
        first = this.includeTypedCode(cell, VERILOG_DECLARATION_KEY, "declarations");
        if (!(first |= this.includeTypedCode(cell, VERILOG_CODE_KEY, "code"))) {
            this.printWriter.print("  /* automatically generated Verilog */\n");
        }
        Iterator<Nodable> nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Variable varTemplate;
            Nodable no = nIt.next();
            NodeProto niProto = no.getProto();
            PrimitiveNode.Function nodeType = PrimitiveNode.Function.UNKNOWN;
            if (!no.isCellInstance()) {
                NodeInst ni = (NodeInst)no;
                Iterator<PortInst> pIt = ni.getPortInsts();
                if (pIt.hasNext()) {
                    boolean allConnected = true;
                    PortInst firstPi = pIt.next();
                    Network firstNet = netList.getNetwork(firstPi);
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        Network thisNet = netList.getNetwork(pi);
                        if (thisNet == firstNet) continue;
                        allConnected = false;
                        break;
                    }
                    if (allConnected) continue;
                }
                if ((nodeType = ni.getFunction()).isResistor() || nodeType.isCapacitor() || nodeType == PrimitiveNode.Function.INDUCT || nodeType == PrimitiveNode.Function.DIODE || nodeType == PrimitiveNode.Function.DIODEZ) continue;
            }
            if (no.isCellInstance() && (varTemplate = ((Cell)niProto).getVar(VERILOG_TEMPLATE_KEY)) != null) {
                if (varTemplate.getObject() instanceof String[]) {
                    String[] lines = (String[])varTemplate.getObject();
                    this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                    for (int i = 0; i < lines.length; ++i) {
                        this.writeTemplate(lines[i], no, cni, context);
                    }
                    this.writeWidthLimited("  // end Verilog_template\n");
                    continue;
                }
                if (((String)varTemplate.getObject()).equals("//")) continue;
                this.writeWidthLimited("  /* begin Verilog_template for " + no.getProto().describe(false) + "*/\n");
                this.writeTemplate((String)varTemplate.getObject(), no, cni, context);
                this.writeWidthLimited("  // end Verilog_template\n");
                continue;
            }
            if (Simulation.getVerilogUseAssign() && (nodeType == PrimitiveNode.Function.GATEAND || nodeType == PrimitiveNode.Function.GATEOR || nodeType == PrimitiveNode.Function.GATEXOR || nodeType == PrimitiveNode.Function.BUFFER)) {
                String op = "";
                if (nodeType == PrimitiveNode.Function.GATEAND) {
                    op = " & ";
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    op = " | ";
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    op = " ^ ";
                }
                StringBuffer infstr = new StringBuffer();
                boolean wholeNegated = false;
                first = true;
                NodeInst ni = (NodeInst)no;
                block21: for (int i = 0; i < 2; ++i) {
                    Iterator<Connection> cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = cIt.next();
                        PortInst pi = con.getPortInst();
                        if (i == 0 ? !pi.getPortProto().getName().equals("y") : !pi.getPortProto().getName().equals("a")) continue;
                        ArcInst ai = con.getArc();
                        Network net = netList.getNetwork(ai, 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = cs.getName();
                        boolean isNegated = false;
                        if (ai.isTailNegated() || ai.isHeadNegated()) {
                            isNegated = true;
                        }
                        if (i == 0) {
                            infstr.append("assign " + sigName + " = ");
                            if (!isNegated) continue block21;
                            infstr.append("~(");
                            wholeNegated = true;
                            continue block21;
                        }
                        if (!first) {
                            infstr.append(op);
                        }
                        first = false;
                        if (isNegated) {
                            infstr.append("~");
                        }
                        infstr.append(sigName);
                    }
                }
                if (wholeNegated) {
                    infstr.append(")");
                }
                infstr.append(";\n");
                this.writeWidthLimited(infstr.toString());
                continue;
            }
            int implicitPorts = 0;
            boolean dropBias = false;
            String nodeName = "";
            if (no.isCellInstance()) {
                if (((Cell)niProto).getView() == View.ICON) continue;
                nodeName = this.parameterizedName(no, context);
                if (this.definedPrimitives.containsKey((Cell)niProto)) {
                    implicitPorts = 3;
                }
            } else {
                Variable varWeakNode;
                if (nodeType == PrimitiveNode.Function.TRA4NMOS) {
                    nodeType = PrimitiveNode.Function.TRANMOS;
                    dropBias = true;
                } else if (nodeType == PrimitiveNode.Function.TRA4PMOS) {
                    nodeType = PrimitiveNode.Function.TRAPMOS;
                    dropBias = true;
                }
                if (nodeType == PrimitiveNode.Function.TRANMOS) {
                    implicitPorts = 2;
                    nodeName = "tranif1";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif1";
                    }
                } else if (nodeType == PrimitiveNode.Function.TRAPMOS) {
                    implicitPorts = 2;
                    nodeName = "tranif0";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif0";
                    }
                } else if (nodeType == PrimitiveNode.Function.GATEAND) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "and", "nand");
                } else if (nodeType == PrimitiveNode.Function.GATEOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "or", "nor");
                } else if (nodeType == PrimitiveNode.Function.GATEXOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "xor", "xnor");
                } else if (nodeType == PrimitiveNode.Function.BUFFER) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "buf", "not");
                }
            }
            if (nodeName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("  " + nodeName + " " + this.nameNoIndices(no.getName()) + "(");
            first = true;
            NodeInst ni = null;
            switch (implicitPorts) {
                case 0: {
                    Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                    Iterator<Topology.CellAggregateSignal> sIt = subCni.getCellAggregateSignals();
                    while (sIt.hasNext()) {
                        Topology.CellAggregateSignal cas4 = sIt.next();
                        Export pp = cas4.getExport();
                        if (pp == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        int low = cas4.getLowIndex();
                        int high = cas4.getHighIndex();
                        if (low > high) {
                            infstr.append("." + cas4.getName() + "(");
                            Network net = netList.getNetwork(no, pp, cas4.getExportIndex());
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            infstr.append(cs.getName());
                            infstr.append(")");
                            continue;
                        }
                        int total = high - low + 1;
                        Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                        for (int j = low; j <= high; ++j) {
                            Topology.CellSignal cInnerSig = cas4.getSignal(j - low);
                            Network net = netList.getNetwork(no, cas4.getExport(), cInnerSig.getExportIndex());
                            outerSignalList[j - low] = cni.getCellSignal(net);
                        }
                        this.writeBus(outerSignalList, low, high, cas4.isDescending(), cas4.getName(), cni.getPowerNet(), cni.getGroundNet(), infstr);
                    }
                    infstr.append(");");
                    break;
                }
                case 1: {
                    Network net;
                    ni = (NodeInst)no;
                    for (int i = 0; i < 2; ++i) {
                        Iterator<Connection> cIt = ni.getConnections();
                        while (cIt.hasNext()) {
                            Integer invIndex;
                            Connection con = cIt.next();
                            PortInst pi = con.getPortInst();
                            if (i != 0 ? !pi.getPortProto().getName().equals("a") : !pi.getPortProto().getName().equals("y")) continue;
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            ArcInst ai = con.getArc();
                            net = netList.getNetwork(ai, 0);
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            if (cs == null) continue;
                            String sigName = cs.getName();
                            if (i != 0 && con.isNegated() && (invIndex = con.getEndIndex() == 1 ? (Integer)implicitHeadInverters.get(ai) : (Integer)implicitTailInverters.get(ai)) != null) {
                                String invSigName = IMPLICITINVERTERSIGNAME + invIndex;
                                this.printWriter.print("  inv Imp" + invIndex + " (" + invSigName + ", " + sigName + ");\n");
                                sigName = invSigName;
                            }
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 2: {
                    Network net;
                    ni = (NodeInst)no;
                    Network gateNet = netList.getNetwork(ni.getTransistorGatePort());
                    for (int i = 0; i < 2; ++i) {
                        boolean didGate = false;
                        Iterator<PortInst> pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst pi = pIt.next();
                            net = netList.getNetwork(pi);
                            if (dropBias && pi.getPortProto().getName().equals("b")) continue;
                            if (i == 0) {
                                if (net == gateNet) {
                                    continue;
                                }
                            } else {
                                if (net != gateNet || didGate) continue;
                                didGate = true;
                            }
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            String sigName = cs.getName();
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 3: {
                    ni = no.getNodeInst();
                    VerilogData.VerilogModule module = this.definedPrimitives.get((Cell)niProto);
                    if (module == null) break;
                    System.out.print(cell.getName() + " ports: ");
                    for (VerilogData.VerilogPort port : module.getPorts()) {
                        List<String> portnames = port.getPinNames();
                        if (portnames.size() == 0) continue;
                        if (portnames.size() > 1) {
                            System.out.println("Error: bussed ports not allowed on Verilog primitives: " + niProto.getName());
                            continue;
                        }
                        String portname = portnames.get(0);
                        PortInst pi = ni.findPortInst(portname);
                        Network net = netList.getNetwork(no, pi.getProtoEquivalent(), 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = cs.getName();
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        infstr.append(sigName);
                        System.out.print(portname + " ");
                    }
                    System.out.println();
                    infstr.append(");");
                }
            }
            infstr.append("\n");
            this.writeWidthLimited(infstr.toString());
        }
        this.printWriter.print("endmodule   /* " + cni.getParameterizedName() + " */\n");
    }

    private String chooseNodeName(NodeInst ni, String positive, String negative) {
        Iterator<Connection> aIt = ni.getConnections();
        while (aIt.hasNext()) {
            Connection con = aIt.next();
            if (!con.isNegated() || !con.getPortInst().getPortProto().getName().equals("y")) continue;
            return negative;
        }
        return positive;
    }

    private void writeTemplate(String line, Nodable no, Topology.CellNetInfo cni, VarContext context) {
        Netlist netList = cni.getNetList();
        StringBuffer infstr = new StringBuffer();
        infstr.append("  ");
        for (int pt = 0; pt < line.length(); ++pt) {
            Iterator<Object> it;
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            PortProto pp = no.getProto().findPortProto(paramName);
            String nodeName = this.parameterizedName(no, context);
            Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
            Topology.CellAggregateSignal cas = null;
            Topology.CellSignal netcs = null;
            if (pp != null) {
                it = subCni.getCellAggregateSignals();
                while (it.hasNext()) {
                    Topology.CellAggregateSignal cas2 = (Topology.CellAggregateSignal)it.next();
                    if (cas2.getExport() == pp) {
                        cas = cas2;
                    } else {
                        if (!netList.sameNetwork(no, pp, no, cas2.getExport())) continue;
                        cas = cas2;
                    }
                    break;
                }
            } else {
                it = no.getProto().getPorts();
                block3: while (it.hasNext()) {
                    PortProto ppcheck = (PortProto)it.next();
                    for (int i = 0; i < ppcheck.getNameKey().busWidth(); ++i) {
                        if (!paramName.equals(ppcheck.getNameKey().subname(i).toString())) continue;
                        Network net = netList.getNetwork(no, ppcheck, i);
                        netcs = cni.getCellSignal(net);
                        continue block3;
                    }
                }
            }
            if (cas != null) {
                int high;
                int low = cas.getLowIndex();
                if (low > (high = cas.getHighIndex())) {
                    Network net = netList.getNetwork(no, pp, cas.getExportIndex());
                    Topology.CellSignal cs = cni.getCellSignal(net);
                    infstr.append(cs.getName());
                    continue;
                }
                int total = high - low + 1;
                Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                for (int j = low; j <= high; ++j) {
                    Topology.CellSignal cInnerSig = cas.getSignal(j - low);
                    Network net = netList.getNetwork(no, cas.getExport(), cInnerSig.getExportIndex());
                    outerSignalList[j - low] = cni.getCellSignal(net);
                }
                this.writeBus(outerSignalList, low, high, cas.isDescending(), null, cni.getPowerNet(), cni.getGroundNet(), infstr);
                continue;
            }
            if (netcs != null) {
                infstr.append(netcs.getName());
                continue;
            }
            if (paramName.equalsIgnoreCase("node_name")) {
                infstr.append(this.getSafeNetName(no.getName(), true));
                continue;
            }
            Variable var = null;
            Variable.Key varKey = Variable.findKey("ATTR_" + paramName);
            if (varKey != null && (var = no.getVar(varKey)) == null) {
                var = no.getParameter(varKey);
            }
            if (var == null) {
                infstr.append("??");
                continue;
            }
            infstr.append(context.evalVar(var));
        }
        infstr.append("\n");
        this.writeWidthLimited(infstr.toString());
    }

    private void writeBus(Topology.CellSignal[] outerSignalList, int lowIndex, int highIndex, boolean descending, String name, Network pwrNet, Network gndNet, StringBuffer infstr) {
        Topology.CellSignal cs;
        int j;
        boolean breakBus = false;
        int numExported = 0;
        int numInternal = 0;
        for (j = lowIndex; j <= highIndex; ++j) {
            cs = outerSignalList[j - lowIndex];
            if (cs.isPower() || cs.isGround()) {
                breakBus = true;
                break;
            }
            if (cs.isExported()) {
                ++numExported;
                continue;
            }
            ++numInternal;
        }
        if (numExported > 0 && numInternal > 0) {
            breakBus = true;
        }
        if (!breakBus) {
            for (j = lowIndex + 1; j <= highIndex; ++j) {
                Topology.CellSignal oCs;
                int k;
                cs = outerSignalList[j - lowIndex];
                for (k = lowIndex; k < j && cs != (oCs = outerSignalList[k - lowIndex]); ++k) {
                }
                if (k < j) break;
            }
            if (j <= highIndex) {
                breakBus = true;
            } else {
                String lastnetname = null;
                for (j = lowIndex; j <= highIndex; ++j) {
                    int openSquare;
                    Topology.CellSignal wl = outerSignalList[j - lowIndex];
                    String thisnetname = wl.getName();
                    if ((!wl.isDescending() ? descending : !descending) || (openSquare = thisnetname.indexOf(91)) < 0) break;
                    if (j > lowIndex) {
                        int lastIndex;
                        int thisIndex;
                        int li;
                        for (li = 0; li < lastnetname.length() && thisnetname.charAt(li) == lastnetname.charAt(li) && lastnetname.charAt(li) != '['; ++li) {
                        }
                        if (lastnetname.charAt(li) != '[' || thisnetname.charAt(li) != '[' || (thisIndex = TextUtils.atoi(thisnetname.substring(li + 1))) != (lastIndex = TextUtils.atoi(lastnetname.substring(li + 1))) + 1) break;
                    }
                    lastnetname = thisnetname;
                }
                if (j <= highIndex) {
                    breakBus = true;
                }
            }
        }
        if (name != null) {
            infstr.append("." + name + "(");
        }
        if (breakBus) {
            infstr.append("{");
            int start = lowIndex;
            int end = highIndex;
            int order = 1;
            if (descending) {
                start = highIndex;
                end = lowIndex;
                order = -1;
            }
            int j2 = start;
            while (true) {
                if (j2 != start) {
                    infstr.append(", ");
                }
                Topology.CellSignal cs2 = outerSignalList[j2 - lowIndex];
                infstr.append(cs2.getName());
                if (j2 == end) break;
                j2 += order;
            }
            infstr.append("}");
        } else {
            int second;
            int first;
            int i;
            Topology.CellSignal lastCs = outerSignalList[0];
            String lastNetName = lastCs.getName();
            int openSquare = lastNetName.indexOf(91);
            Topology.CellSignal cs3 = outerSignalList[highIndex - lowIndex];
            String netName = cs3.getName();
            for (i = 0; i < netName.length() && netName.charAt(i) != '['; ++i) {
                infstr.append(netName.charAt(i));
            }
            if (descending) {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + first + ":" + second + "]");
            } else {
                first = TextUtils.atoi(netName.substring(i + 1));
                second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + second + ":" + first + "]");
            }
        }
        if (name != null) {
            infstr.append(")");
        }
    }

    private boolean includeTypedCode(Cell cell, Variable.Key verilogkey, String descript) {
        boolean first = true;
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            Object obj;
            Variable var;
            NodeInst ni = it.next();
            if (ni.getProto() != Generic.tech.invisiblePinNode || (var = ni.getVar(verilogkey)) == null || !var.isDisplay() || !((obj = var.getObject()) instanceof String) && !(obj instanceof String[])) continue;
            if (first) {
                first = false;
                this.printWriter.print("  /* user-specified Verilog " + descript + " */\n");
            }
            if (obj instanceof String) {
                this.printWriter.print("  " + (String)obj + "\n");
                continue;
            }
            String[] stringArray = (String[])obj;
            int len = stringArray.length;
            for (int i = 0; i < len; ++i) {
                this.printWriter.print("  " + stringArray[i] + "\n");
            }
        }
        if (!first) {
            this.printWriter.print("\n");
        }
        return first;
    }

    private void initDeclaration(String header) {
        this.sim_verDeclarationLine = new StringBuffer();
        this.sim_verDeclarationLine.append(header);
        this.sim_verdeclarationprefix = header.length();
    }

    private void addDeclaration(String signame) {
        if (this.sim_verDeclarationLine.length() + signame.length() + 3 > 80) {
            this.printWriter.print(this.sim_verDeclarationLine.toString() + ";\n");
            this.sim_verDeclarationLine.delete(this.sim_verdeclarationprefix, this.sim_verDeclarationLine.length());
        }
        if (this.sim_verDeclarationLine.length() != this.sim_verdeclarationprefix) {
            this.sim_verDeclarationLine.append(",");
        }
        this.sim_verDeclarationLine.append(" " + signame);
    }

    private void termDeclaration() {
        this.printWriter.print(this.sim_verDeclarationLine.toString() + ";\n");
    }

    private String nameNoIndices(String p) {
        StringBuffer sb = new StringBuffer();
        if (TextUtils.isDigit(p.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < p.length(); ++i) {
            int chr = p.charAt(i);
            if (!TextUtils.isLetterOrDigit((char)chr) && chr != 95 && chr != 36) {
                chr = 95;
            }
            sb.append((char)chr);
        }
        return sb.toString();
    }

    @Override
    protected String getSafeCellName(String name) {
        String n = this.getSafeNetName(name, false);
        return n.replaceAll("[\\[\\]]", "_");
    }

    @Override
    protected String getPowerName(Network net) {
        return "vdd";
    }

    @Override
    protected String getGroundName(Network net) {
        return "gnd";
    }

    @Override
    protected String getGlobalName(Global glob) {
        return "glbl." + glob.getName();
    }

    @Override
    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    @Override
    protected boolean isLibraryNameAlwaysAddedToCellName() {
        return true;
    }

    @Override
    protected boolean isAggregateNamesSupported() {
        return true;
    }

    @Override
    protected boolean isSeparateInputAndOutput() {
        return true;
    }

    @Override
    protected String getSafeNetName(String name, boolean bus) {
        boolean allAlnum = true;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        int openSquareCount = 0;
        int openSquarePos = 0;
        for (int i = 0; i < len; ++i) {
            char chr = name.charAt(i);
            if (chr == '[') {
                ++openSquareCount;
                openSquarePos = i;
            }
            if (!TextUtils.isLetterOrDigit(chr)) {
                allAlnum = false;
            }
            if (i != 0 || !TextUtils.isDigit(chr)) continue;
            allAlnum = false;
        }
        if (!allAlnum || !Character.isLetter(name.charAt(0))) {
            if (!(openSquareCount != 1 || openSquarePos + 1 < name.length() && Character.isDigit(name.charAt(openSquarePos + 1)))) {
                openSquareCount = 0;
            }
            if (bus) {
                openSquareCount = 0;
            }
            StringBuffer sb = new StringBuffer();
            for (int t = 0; t < name.length(); ++t) {
                char chr = name.charAt(t);
                if (chr == '[' || chr == ']') {
                    if (openSquareCount == 1) {
                        sb.append(chr);
                        continue;
                    }
                    sb.append('_');
                    if (t + 1 >= name.length() || chr != ']' || name.charAt(t + 1) != '[') continue;
                    ++t;
                    continue;
                }
                if (t == 0 && TextUtils.isDigit(chr)) {
                    sb.append('_');
                }
                if (TextUtils.isLetterOrDigit(chr) || chr == '$') {
                    sb.append(chr);
                    continue;
                }
                sb.append('_');
            }
            name = sb.toString();
        }
        if (reservedWords.contains(name)) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    protected boolean isShortResistors() {
        return true;
    }

    @Override
    protected boolean isShortExplicitResistors() {
        return true;
    }

    @Override
    protected boolean canParameterizeNames() {
        return !Simulation.getVerilogStopAtStandardCells();
    }

    private boolean checkIncludedData(VerilogData data, Cell cell, String includeFile) {
        Collection<VerilogData.VerilogModule> modules = data.getModules();
        VerilogData.VerilogModule main = null;
        VerilogData.VerilogModule alternative = null;
        for (VerilogData.VerilogModule mod : modules) {
            if (mod.getName().equals(Verilog.getVerilogName(cell))) {
                main = mod;
                continue;
            }
            Cell.CellGroup grp = cell.getCellGroup();
            if (grp == null || !mod.getName().equals(grp.getName())) continue;
            alternative = mod;
        }
        if (main == null) {
            main = alternative;
        }
        if (main == null) {
            System.out.println("Error! Expected Verilog module definition '" + Verilog.getVerilogName(cell) + " in Verilog View: " + cell.libDescribe());
            return false;
        }
        this.definedPrimitives.put(cell, main);
        String source = includeFile == null ? "Verilog View for " + cell.libDescribe() : "Include file: " + includeFile;
        for (VerilogData.VerilogModule mod : modules) {
            String prevSource = this.definedModules.get(mod.getName());
            if (!mod.isValid()) continue;
            if (prevSource != null) {
                System.out.println("Error, module " + mod.getName() + " already defined from: " + prevSource);
                continue;
            }
            this.definedModules.put(mod.getName(), source);
        }
        for (VerilogData.VerilogModule mod : modules) {
            for (VerilogData.VerilogInstance inst : mod.getInstances()) {
                String moduleName;
                String found;
                VerilogData.VerilogModule instMod = inst.getModule();
                if (instMod.isValid()) continue;
                boolean primitiveGate = false;
                for (String s : verilogGates) {
                    if (!s.equals(instMod.getName().toLowerCase())) continue;
                    primitiveGate = true;
                    break;
                }
                if (primitiveGate || (found = this.definedModules.get(moduleName = instMod.getName())) != null || includeFile != null) continue;
                Cell missingCell = Verilog.findCell(moduleName, View.VERILOG);
                if (missingCell == null) {
                    System.out.println("Error: Undefined reference to module " + moduleName + ", and no matching cell found");
                    continue;
                }
                System.out.println("Info: Netlisting cell " + missingCell.libDescribe() + " as instanced in: " + source);
                HierarchyEnumerator.enumerateCell(missingCell, VarContext.globalContext, new Topology.Visitor(this), this.isShortResistors(), this.isShortExplicitResistors(), this.isShortResistors(), false);
            }
        }
        return true;
    }

    public static String getVerilogName(Cell cell) {
        Verilog v = new Verilog();
        return cell.getLibrary().getName() + "__" + v.getSafeCellName(cell.getName());
    }

    public static Cell findCell(String verilogName, View preferredView) {
        Cell cell;
        String[] parts = verilogName.split("__");
        if (parts.length != 2) {
            return null;
        }
        Library lib = Library.findLibrary(parts[0]);
        if (lib == null) {
            System.out.println("Cannot find library " + parts[0] + " for Verilog-style module name: " + verilogName);
            return null;
        }
        if (preferredView == null) {
            preferredView = View.SCHEMATIC;
        }
        if ((cell = lib.findNodeProto(parts[1])) == null) {
            System.out.println("Cannot find Cell " + parts[1] + " in Library " + parts[0] + " for Verilog-style module name: " + verilogName);
            return null;
        }
        Cell preferred = cell.otherView(preferredView);
        if (preferred != null) {
            return preferred;
        }
        preferred = cell.getCellGroup().getMainSchematics();
        if (preferred != null) {
            return preferred;
        }
        return cell;
    }

    static {
        reservedWords.add("always");
        reservedWords.add("and");
        reservedWords.add("assign");
        reservedWords.add("attribute");
        reservedWords.add("begin");
        reservedWords.add("buf");
        reservedWords.add("bufif0");
        reservedWords.add("bufif1");
        reservedWords.add("case");
        reservedWords.add("casex");
        reservedWords.add("casez");
        reservedWords.add("cmos");
        reservedWords.add("deassign");
        reservedWords.add("default");
        reservedWords.add("defpram");
        reservedWords.add("disable");
        reservedWords.add("edge");
        reservedWords.add("else");
        reservedWords.add("end");
        reservedWords.add("endattribute");
        reservedWords.add("endcase");
        reservedWords.add("endfunction");
        reservedWords.add("endmodule");
        reservedWords.add("endprimitive");
        reservedWords.add("endspecify");
        reservedWords.add("endtable");
        reservedWords.add("endtask");
        reservedWords.add("event");
        reservedWords.add("for");
        reservedWords.add("force");
        reservedWords.add("forever");
        reservedWords.add("fork");
        reservedWords.add("function");
        reservedWords.add("highz0");
        reservedWords.add("highz1");
        reservedWords.add("if");
        reservedWords.add("initial");
        reservedWords.add("inout");
        reservedWords.add("input");
        reservedWords.add("integer");
        reservedWords.add("join");
        reservedWords.add("large");
        reservedWords.add("macromodule");
        reservedWords.add("meduim");
        reservedWords.add("module");
        reservedWords.add("nand");
        reservedWords.add("negedge");
        reservedWords.add("nmos");
        reservedWords.add("nor");
        reservedWords.add("not");
        reservedWords.add("notif0");
        reservedWords.add("notif1");
        reservedWords.add("or");
        reservedWords.add("output");
        reservedWords.add("parameter");
        reservedWords.add("pmos");
        reservedWords.add("posedge");
        reservedWords.add("primitive");
        reservedWords.add("pull0");
        reservedWords.add("pull1");
        reservedWords.add("pulldown");
        reservedWords.add("pullup");
        reservedWords.add("rcmos");
        reservedWords.add("real");
        reservedWords.add("realtime");
        reservedWords.add("reg");
        reservedWords.add("release");
        reservedWords.add("repeat");
        reservedWords.add("rtranif1");
        reservedWords.add("scalared");
        reservedWords.add("signed");
        reservedWords.add("small");
        reservedWords.add("specify");
        reservedWords.add("specpram");
        reservedWords.add("strength");
        reservedWords.add("strong0");
        reservedWords.add("strong1");
        reservedWords.add("supply0");
        reservedWords.add("supply1");
        reservedWords.add("table");
        reservedWords.add("task");
        reservedWords.add("time");
        reservedWords.add("tran");
        reservedWords.add("tranif0");
        reservedWords.add("tranif1");
        reservedWords.add("tri");
        reservedWords.add("tri0");
        reservedWords.add("tri1");
        reservedWords.add("triand");
        reservedWords.add("trior");
        reservedWords.add("trireg");
        reservedWords.add("unsigned");
        reservedWords.add("vectored");
        reservedWords.add("wait");
        reservedWords.add("wand");
        reservedWords.add("weak0");
        reservedWords.add("weak1");
        reservedWords.add("while");
        reservedWords.add("wire");
        reservedWords.add("wor");
        reservedWords.add("xnor");
        reservedWords.add("xor");
        VERILOG_CODE_KEY = Variable.newKey("VERILOG_code");
        VERILOG_DECLARATION_KEY = Variable.newKey("VERILOG_declaration");
        WIRE_TYPE_KEY = Variable.newKey("SIM_verilog_wire_type");
        VERILOG_TEMPLATE_KEY = Variable.newKey("ATTR_verilog_template");
        VERILOG_BEHAVE_FILE_KEY = Variable.newKey("SIM_verilog_behave_file");
        verilogGates = new String[]{"and", "nand", "or", "nor", "xor", "xnor", "buf", "bufif0", "bufif1", "not", "notif0", "notif1", "pulldown", "pullup", "nmos", "rnmos", "pmos", "rpmos", "cmos", "rcmos", "tran", "rtran", "tranif0", "rtranif0", "tranif1", "rtranif1"};
    }
}

