/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.fill.CapCell;
import com.sun.electric.tool.generator.layout.fill.CapFloorplan;
import com.sun.electric.tool.generator.layout.fill.G;

class CapCellMosis
extends CapCell {
    private final double POLY_CONT_WIDTH = 10.0;
    private final String TOP_DIFF = "n-trans-diff-top";
    private final String BOT_DIFF = "n-trans-diff-bottom";
    private final String LEFT_POLY = "n-trans-poly-left";
    private final String RIGHT_POLY = "n-trans-poly-right";
    private final ProtoPlan plan;

    private PortInst[] diffCont(double y, ProtoPlan plan, Cell cell, StdCellParams stdCell) {
        PortInst[] conts = new PortInst[plan.numMosX];
        double x = (double)(-plan.numMosX) * plan.mosPitchX / 2.0;
        PortInst wellCont = LayoutLib.newNodeInst(Tech.pwm1(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        Export e = Export.newInstance(cell, wellCont, stdCell.getGndExportName() + "_" + this.gndNum++);
        e.setCharacteristic(stdCell.getGndExportRole());
        for (int i = 0; i < plan.numMosX; ++i) {
            conts[i] = LayoutLib.newNodeInst(Tech.ndm1(), x += plan.mosPitchX / 2.0, y, plan.gateWidth, 5.0, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(Tech.m1(), plan.gndWidth, wellCont, conts[i]);
            wellCont = LayoutLib.newNodeInst(Tech.pwm1(), x += plan.mosPitchX / 2.0, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
            LayoutLib.newArcInst(Tech.m1(), plan.gndWidth, conts[i], wellCont);
        }
        x = -plan.protoWidth / 2.0 + plan.gndWidth / 2.0;
        PortInst pi = LayoutLib.newNodeInst(Tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(Tech.m1(), plan.gndWidth, pi, conts[0]);
        x = plan.protoWidth / 2.0 - plan.gndWidth / 2.0;
        pi = LayoutLib.newNodeInst(Tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(Tech.m1(), plan.gndWidth, pi, conts[conts.length - 1]);
        return conts;
    }

    private void mos(PortInst[] botDiffs, PortInst[] topDiffs, double y, ProtoPlan plan, Cell cell, StdCellParams stdCell) {
        PortInst poly;
        double POLY_CONT_HEIGHT = plan.vddWidth + 1.0;
        double x = plan.leftWellContX;
        PortInst leftCont = poly = LayoutLib.newNodeInst(Tech.p1m1(), x, y, 10.0, POLY_CONT_HEIGHT, 0.0, cell).getOnlyPortInst();
        Export e = Export.newInstance(cell, poly, stdCell.getVddExportName() + "_" + this.vddNum++);
        e.setCharacteristic(stdCell.getVddExportRole());
        for (int i = 0; i < plan.numMosX; ++i) {
            NodeInst mos = LayoutLib.newNodeInst(Tech.nmos(), x += plan.mosPitchX / 2.0, y, plan.gateWidth, plan.gateLength, 0.0, cell);
            G.noExtendArc(Tech.p1(), POLY_CONT_HEIGHT, poly, mos.findPortInst("n-trans-poly-left"));
            PortInst polyR = LayoutLib.newNodeInst(Tech.p1m1(), x += plan.mosPitchX / 2.0, y, 10.0, POLY_CONT_HEIGHT, 0.0, cell).getOnlyPortInst();
            G.noExtendArc(Tech.m1(), plan.vddWidth, poly, polyR);
            poly = polyR;
            G.noExtendArc(Tech.p1(), POLY_CONT_HEIGHT, poly, mos.findPortInst("n-trans-poly-right"));
            botDiffs[i] = mos.findPortInst("n-trans-diff-bottom");
            topDiffs[i] = mos.findPortInst("n-trans-diff-top");
        }
        PortInst rightCont = poly;
        x = -plan.protoWidth / 2.0 + plan.vddWidth / 2.0;
        PortInst pi = LayoutLib.newNodeInst(Tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(Tech.m1(), plan.vddWidth, pi, leftCont);
        x = plan.protoWidth / 2.0 - plan.vddWidth / 2.0;
        pi = LayoutLib.newNodeInst(Tech.m1pin(), x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, cell).getOnlyPortInst();
        LayoutLib.newArcInst(Tech.m1(), plan.vddWidth, pi, rightCont);
    }

    double roundToHalfLambda(double x) {
        return Math.rint(x * 2.0) / 2.0;
    }

    private void newDiffArc(PortInst p1, PortInst p2) {
        EPoint p1P = p1.getCenter();
        double x = p1P.getX();
        double y1 = this.roundToHalfLambda(p1P.getY());
        double y2 = this.roundToHalfLambda(LayoutLib.roundCenterY(p2));
        LayoutLib.newArcInst(Tech.ndiff(), Double.POSITIVE_INFINITY, p1, x, y1, p2, x, y2);
    }

    private void connectDiffs(PortInst[] a, PortInst[] b) {
        for (int i = 0; i < a.length; ++i) {
            this.newDiffArc(a[i], b[i]);
        }
    }

    public CapCellMosis(Library lib, CapFloorplan instPlan, StdCellParams stdCell) {
        this.plan = new ProtoPlan(instPlan);
        PortInst[] botDiffs = new PortInst[this.plan.numMosX];
        PortInst[] topDiffs = new PortInst[this.plan.numMosX];
        String nameExt = stdCell.getVddExportName().equals("vdd") ? "" : "_pwr";
        this.cell = Cell.newInstance(lib, "fillCap" + nameExt + "{lay}");
        double y = this.plan.botWellContY;
        PortInst[] lastCont = this.diffCont(y, this.plan, this.cell, stdCell);
        for (int i = 0; i < this.plan.numMosY; ++i) {
            this.mos(botDiffs, topDiffs, y += this.plan.mosPitchY / 2.0, this.plan, this.cell, stdCell);
            this.connectDiffs(lastCont, botDiffs);
            lastCont = this.diffCont(y += this.plan.mosPitchY / 2.0, this.plan, this.cell, stdCell);
            this.connectDiffs(topDiffs, lastCont);
        }
        LayoutLib.newNodeInst(Tech.pwell(), 0.0, 0.0, this.plan.protoWidth, this.plan.protoHeight, 0.0, this.cell);
    }

    @Override
    public int numVdd() {
        return this.plan.numMosY;
    }

    @Override
    public int numGnd() {
        return this.plan.numMosY + 1;
    }

    @Override
    public double getVddWidth() {
        return this.plan.vddWidth;
    }

    @Override
    public double getGndWidth() {
        return this.plan.gndWidth;
    }

    private static class ProtoPlan {
        private final double MAX_MOS_WIDTH = 40.0;
        private final double SEL_WIDTH_OF_NDM1 = Tech.getDiffContWidth() + Tech.selectSurroundDiffInActiveContact() * 2.0;
        private final double SEL_TO_MOS = Tech.selectSurroundDiffAlongGateInTrans();
        public final double protoWidth;
        public final double protoHeight;
        public final double vddWidth = 9.0;
        public final double gndWidth = 4.0;
        public final double vddGndSpace = 3.0;
        public final double gateWidth;
        public final int numMosX;
        public final double mosPitchX;
        public final double leftWellContX;
        public final double gateLength;
        public final int numMosY;
        public final double mosPitchY;
        public final double botWellContY;

        public ProtoPlan(CapFloorplan instPlan) {
            this.protoWidth = instPlan.horizontal ? instPlan.cellWidth : instPlan.cellHeight;
            this.protoHeight = instPlan.horizontal ? instPlan.cellHeight : instPlan.cellWidth;
            this.mosPitchY = 19.0;
            this.gateLength = this.mosPitchY - 4.0 - 2.0;
            this.numMosY = (int)Math.floor((this.protoHeight - Tech.getWellWidth()) / this.mosPitchY);
            this.botWellContY = (double)(-this.numMosY) * this.mosPitchY / 2.0;
            double cellEdgeToDiffContCenter = Tech.getWellSurroundDiff() + Tech.getDiffContWidth() / 2.0;
            double polyContWidth = Math.floor(this.gateLength / Tech.getP1M1Width()) * Tech.getP1M1Width();
            double cellEdgeToPolyContCenter = Tech.getP1ToP1Space() / 2.0 + polyContWidth / 2.0;
            double cellEdgeToContCenter = Math.max(cellEdgeToDiffContCenter, cellEdgeToPolyContCenter);
            double availForCap = this.protoWidth - 2.0 * cellEdgeToContCenter;
            double numMosD = availForCap / (40.0 + this.SEL_WIDTH_OF_NDM1 + 2.0 * this.SEL_TO_MOS);
            this.numMosX = (int)Math.ceil(numMosD);
            double mosWidth1 = availForCap / (double)this.numMosX - this.SEL_WIDTH_OF_NDM1 - 2.0 * this.SEL_TO_MOS;
            this.gateWidth = Math.floor(mosWidth1);
            this.mosPitchX = this.gateWidth + this.SEL_WIDTH_OF_NDM1 + 2.0 * this.SEL_TO_MOS;
            this.leftWellContX = (double)(-this.numMosX) * this.mosPitchX / 2.0;
        }
    }
}

