/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.infinity;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import java.util.ArrayList;
import java.util.Collection;

public class Stages {
    private Collection<Cell> stages = new ArrayList<Cell>();
    private boolean someCellMissing = false;
    public Cell branch;
    public Cell cross;
    public Cell drain;
    public Cell fill;
    public Cell merge;
    public Cell plain;

    private void prln(String msg) {
        System.out.println(msg);
    }

    private Cell findStage(Library lib, String stageNm) {
        Cell stage = lib.findNodeProto(stageNm);
        if (stage == null) {
            this.prln("Can't find stage: " + stageNm);
            this.someCellMissing = true;
        } else {
            this.stages.add(stage);
        }
        return stage;
    }

    public Stages(Library lib) {
        if (lib == null) {
            return;
        }
        this.branch = this.findStage(lib, "aBranchStage{lay}");
        this.cross = this.findStage(lib, "aCrossStage{lay}");
        this.drain = this.findStage(lib, "aDrainStage{lay}");
        this.fill = this.findStage(lib, "aFillStage{lay}");
        this.merge = this.findStage(lib, "aMergeStage{lay}");
        this.plain = this.findStage(lib, "aPlainStage{lay}");
    }

    public Collection<Cell> getStages() {
        return new ArrayList<Cell>(this.stages);
    }

    public boolean someStageIsMissing() {
        return this.someCellMissing;
    }
}

