/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.topology.RTBounds;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class RTNode {
    private static final int MINRTNODESIZE = 4;
    private static final int MAXRTNODESIZE = 8;
    private Rectangle2D bounds;
    private int total;
    private Object[] pointers = new Object[8];
    private boolean flag;
    private RTNode parent;
    private static int branchCount;

    private RTNode() {
        this.bounds = new Rectangle2D.Double();
    }

    public int getTotal() {
        return this.total;
    }

    private void setTotal(int total) {
        this.total = total;
    }

    private RTNode getParent() {
        return this.parent;
    }

    private void setParent(RTNode parent) {
        this.parent = parent;
    }

    public Object getChild(int index) {
        return this.pointers[index];
    }

    private void setChild(int index, Object obj) {
        this.pointers[index] = obj;
    }

    public boolean getFlag() {
        return this.flag;
    }

    private void setFlag(boolean flag) {
        this.flag = flag;
    }

    private Rectangle2D getBounds() {
        return this.bounds;
    }

    private void setBounds(Rectangle2D bounds) {
        this.bounds.setRect(bounds);
    }

    private void unionBounds(Rectangle2D bounds) {
        Rectangle2D.union(this.bounds, bounds, this.bounds);
    }

    public static RTNode makeTopLevel() {
        RTNode top = new RTNode();
        top.total = 0;
        top.flag = true;
        top.parent = null;
        return top;
    }

    public static RTNode linkGeom(Object env, RTNode root, RTBounds geom) {
        if (root == null) {
            return null;
        }
        RTNode rtn = root;
        while (!rtn.getFlag()) {
            double bestExpand = 0.0;
            int bestSubNode = 0;
            for (int i = 0; i < rtn.getTotal(); ++i) {
                RTNode subrtn = (RTNode)rtn.getChild(i);
                Rectangle2D bounds = subrtn.getBounds();
                double area = bounds.getWidth() * bounds.getHeight();
                Rectangle2D.Double newUnion = new Rectangle2D.Double();
                Rectangle2D.union(geom.getBounds(), bounds, newUnion);
                double newArea = ((RectangularShape)newUnion).getWidth() * ((RectangularShape)newUnion).getHeight();
                double expand = newArea - area;
                if (i != 0 && expand > bestExpand) continue;
                bestExpand = expand;
                bestSubNode = i;
            }
            rtn = (RTNode)rtn.getChild(bestSubNode);
        }
        return rtn.addToRTNode(geom, env, root);
    }

    public static RTNode unLinkGeom(Object env, RTNode root, RTBounds geom) {
        RTNode whichRTN = null;
        int whichInd = 0;
        if (root == null) {
            return null;
        }
        Object[] result = root.findGeom(geom);
        if (result != null) {
            whichRTN = (RTNode)result[0];
            whichInd = (Integer)result[1];
        } else {
            result = root.findGeomAnywhere(geom);
            whichRTN = (RTNode)result[0];
            whichInd = (Integer)result[1];
            System.out.println("Internal warning: " + geom + " not in proper R-Tree location in " + env);
        }
        return whichRTN.removeRTNode(whichInd, env, root);
    }

    public void printRTree(int indent) {
        if (indent == 0) {
            branchCount = 0;
        }
        StringBuffer line = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            line.append(" ");
        }
        line.append("RTNode");
        if (this.flag) {
            line.append(" NUMBER " + ++branchCount);
        }
        line.append(" X(" + this.bounds.getMinX() + "-" + this.bounds.getMaxX() + ") Y(" + this.bounds.getMinY() + "-" + this.bounds.getMaxY() + ") has " + this.total + " children:");
        System.out.println(line);
        for (int j = 0; j < this.total; ++j) {
            if (this.flag) {
                line = new StringBuffer();
                for (int i = 0; i < indent + 3; ++i) {
                    line.append(" ");
                }
                RTBounds child = (RTBounds)this.getChild(j);
                Rectangle2D childBounds = child.getBounds();
                line.append("Child X(" + childBounds.getMinX() + "-" + childBounds.getMaxX() + ") Y(" + childBounds.getMinY() + "-" + childBounds.getMaxY() + ") is " + child);
                System.out.println(line);
                continue;
            }
            ((RTNode)this.getChild(j)).printRTree(indent + 3);
        }
    }

    public void checkRTree(int level, Object env) {
        int i;
        Rectangle2D.Double localBounds = new Rectangle2D.Double();
        if (this.total == 0) {
            ((Rectangle2D)localBounds).setRect(0.0, 0.0, 0.0, 0.0);
        } else {
            ((Rectangle2D)localBounds).setRect(this.getBBox(0));
            for (i = 1; i < this.total; ++i) {
                Rectangle2D.union(localBounds, this.getBBox(i), localBounds);
            }
        }
        if (!localBounds.equals(this.bounds) && (Math.abs(localBounds.getMinX() - this.bounds.getMinX()) >= DBMath.getEpsilon() || Math.abs(localBounds.getMinY() - this.bounds.getMinY()) >= DBMath.getEpsilon() || Math.abs(((RectangularShape)localBounds).getWidth() - this.bounds.getWidth()) >= DBMath.getEpsilon() || Math.abs(((RectangularShape)localBounds).getHeight() - this.bounds.getHeight()) >= DBMath.getEpsilon())) {
            System.out.println("Tree of " + env + " at level " + level + " has bounds " + localBounds + " but stored bounds are " + this.bounds);
            for (i = 0; i < this.total; ++i) {
                System.out.println("  ---Child " + i + " is " + this.getBBox(i));
            }
        }
        if (!this.flag) {
            for (int j = 0; j < this.total; ++j) {
                ((RTNode)this.getChild(j)).checkRTree(level + 1, env);
            }
        }
    }

    private Rectangle2D getBBox(int child) {
        if (this.flag) {
            RTBounds geom = (RTBounds)this.pointers[child];
            return geom.getBounds();
        }
        RTNode subrtn = (RTNode)this.pointers[child];
        return subrtn.getBounds();
    }

    private void figBounds() {
        if (this.total == 0) {
            this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        this.bounds.setRect(this.getBBox(0));
        for (int i = 1; i < this.total; ++i) {
            this.unionBounds(this.getBBox(i));
        }
    }

    private RTNode addToRTNode(Object rtnInsert, Object env, RTNode root) {
        Rectangle2D bounds;
        if (this.getTotal() >= 8) {
            RTNode temp = new RTNode();
            temp.setTotal(this.getTotal());
            temp.setFlag(this.getFlag());
            for (int i = 0; i < this.getTotal(); ++i) {
                temp.setChild(i, this.getChild(i));
            }
            if (rtnInsert instanceof RTBounds) {
                RTBounds geom = (RTBounds)rtnInsert;
                bounds = geom.getBounds();
            } else {
                RTNode subrtn = (RTNode)rtnInsert;
                bounds = subrtn.getBounds();
            }
            Point2D.Double thisCenter = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            double newDist = 0.0;
            int newN = 0;
            for (int i = 0; i < temp.getTotal(); ++i) {
                Rectangle2D thisv = temp.getBBox(i);
                double dist = thisCenter.distance(thisv.getCenterX(), thisv.getCenterY());
                if (!(dist >= newDist)) continue;
                newDist = dist;
                newN = i;
            }
            bounds = temp.getBBox(newN);
            thisCenter = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            double oldDist = 0.0;
            int oldN = 0;
            if (oldN == newN) {
                ++oldN;
            }
            for (int i = 0; i < temp.getTotal(); ++i) {
                Rectangle2D thisv;
                double dist;
                if (i == newN || !((dist = thisCenter.distance((thisv = temp.getBBox(i)).getCenterX(), thisv.getCenterY())) >= oldDist)) continue;
                oldDist = dist;
                oldN = i;
            }
            RTNode newrtn = new RTNode();
            newrtn.setFlag(this.getFlag());
            newrtn.setParent(this.getParent());
            Object obj = temp.getChild(newN);
            temp.setChild(newN, null);
            newrtn.setChild(0, obj);
            newrtn.setTotal(1);
            if (!newrtn.getFlag()) {
                ((RTNode)obj).setParent(newrtn);
            }
            Rectangle2D newBounds = newrtn.getBBox(0);
            newrtn.setBounds(newBounds);
            double newArea = newBounds.getWidth() * newBounds.getHeight();
            obj = temp.getChild(oldN);
            temp.setChild(oldN, null);
            this.setChild(0, obj);
            for (int i = 1; i < this.getTotal(); ++i) {
                this.setChild(i, null);
            }
            this.setTotal(1);
            if (!this.getFlag()) {
                ((RTNode)obj).setParent(this);
            }
            Rectangle2D oldBounds = this.getBBox(0);
            this.setBounds(oldBounds);
            double oldArea = oldBounds.getWidth() * oldBounds.getHeight();
            while (true) {
                int curPos;
                int i;
                int bestNewNode = -1;
                int bestOldNode = -1;
                double bestNewExpand = 0.0;
                double bestOldExpand = 0.0;
                for (i = 0; i < temp.getTotal(); ++i) {
                    obj = temp.getChild(i);
                    if (obj == null) continue;
                    bounds = temp.getBBox(i);
                    Rectangle2D.Double newUnion = new Rectangle2D.Double();
                    Rectangle2D.Double oldUnion = new Rectangle2D.Double();
                    Rectangle2D.union(newBounds, bounds, newUnion);
                    Rectangle2D.union(oldBounds, bounds, oldUnion);
                    double newAreaPlus = ((RectangularShape)newUnion).getWidth() * ((RectangularShape)newUnion).getHeight();
                    double oldAreaPlus = ((RectangularShape)oldUnion).getWidth() * ((RectangularShape)oldUnion).getHeight();
                    if (bestNewNode < 0 || newAreaPlus - newArea < bestNewExpand) {
                        bestNewExpand = newAreaPlus - newArea;
                        bestNewNode = i;
                    }
                    if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                    bestOldExpand = oldAreaPlus - oldArea;
                    bestOldNode = i;
                }
                if (bestNewNode == -1 && bestOldNode == -1) break;
                if (bestNewNode == bestOldNode) {
                    bestOldNode = -1;
                    for (i = 0; i < temp.getTotal(); ++i) {
                        if (i == bestNewNode || (obj = temp.getChild(i)) == null) continue;
                        bounds = temp.getBBox(i);
                        Rectangle2D.Double oldUnion = new Rectangle2D.Double();
                        Rectangle2D.union(oldBounds, bounds, oldUnion);
                        double oldAreaPlus = ((RectangularShape)oldUnion).getWidth() * ((RectangularShape)oldUnion).getHeight();
                        if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                        bestOldExpand = oldAreaPlus - oldArea;
                        bestOldNode = i;
                    }
                }
                if (bestOldNode != -1) {
                    obj = temp.getChild(bestOldNode);
                    temp.setChild(bestOldNode, null);
                    curPos = this.getTotal();
                    this.setChild(curPos, obj);
                    this.setTotal(curPos + 1);
                    if (!this.getFlag()) {
                        ((RTNode)obj).setParent(this);
                    }
                    this.unionBounds(this.getBBox(curPos));
                    oldBounds = this.getBounds();
                    oldArea = oldBounds.getWidth() * oldBounds.getHeight();
                }
                if (bestNewNode == -1) continue;
                obj = temp.getChild(bestNewNode);
                temp.setChild(bestNewNode, null);
                curPos = newrtn.getTotal();
                newrtn.setChild(curPos, obj);
                newrtn.setTotal(curPos + 1);
                if (!newrtn.getFlag()) {
                    ((RTNode)obj).setParent(newrtn);
                }
                newrtn.unionBounds(newrtn.getBBox(curPos));
                newBounds = newrtn.getBounds();
                newArea = newBounds.getWidth() * newBounds.getHeight();
            }
            if (temp.getTotal() != this.getTotal() + newrtn.getTotal()) {
                System.out.println("R-trees: " + temp.getTotal() + " nodes split to " + this.getTotal() + " and " + newrtn.getTotal() + "!");
            }
            if (this.getParent() == null) {
                assert (root == this);
                RTNode newroot = new RTNode();
                newroot.setTotal(2);
                newroot.setChild(0, this);
                newroot.setChild(1, newrtn);
                newroot.setFlag(false);
                newroot.setParent(null);
                this.setParent(newroot);
                newrtn.setParent(newroot);
                newroot.figBounds();
                root = newroot;
            } else {
                for (RTNode r = this.getParent(); r != null; r = r.getParent()) {
                    r.figBounds();
                }
                root = this.getParent().addToRTNode(newrtn, env, root);
            }
        }
        int curPos = this.getTotal();
        this.setChild(curPos, rtnInsert);
        this.setTotal(curPos + 1);
        bounds = this.getBBox(curPos);
        if (this.getTotal() == 1 && this.getParent() == null) {
            this.setBounds(bounds);
            return root;
        }
        RTNode climb = this;
        while (true) {
            climb.unionBounds(bounds);
            if (climb.getParent() == null) break;
            climb = climb.getParent();
        }
        return root;
    }

    private RTNode removeRTNode(int ind, Object env, RTNode root) {
        int j = 0;
        for (int i = 0; i < this.getTotal(); ++i) {
            if (i == ind) continue;
            this.setChild(j++, this.getChild(i));
        }
        this.setTotal(j);
        if (this.getTotal() < 4) {
            RTNode prtn = this.getParent();
            if (prtn == null) {
                int i;
                if (this.getFlag()) {
                    this.figBounds();
                    return root;
                }
                RTNode temp = new RTNode();
                temp.setTotal(this.getTotal());
                temp.setFlag(true);
                for (i = 0; i < this.getTotal(); ++i) {
                    temp.setChild(i, this.getChild(i));
                }
                this.setTotal(0);
                this.setFlag(true);
                for (i = 0; i < temp.getTotal(); ++i) {
                    root = ((RTNode)temp.getChild(i)).reInsert(env, root);
                }
                return root;
            }
            int found = -1;
            for (int i = 0; i < prtn.getTotal(); ++i) {
                if (prtn.getChild(i) != this) continue;
                found = i;
                break;
            }
            if (found < 0) {
                System.out.println("R-trees: cannot find entry in parent");
            }
            root = prtn.removeRTNode(found, env, root);
            return this.reInsert(env, root);
        }
        RTNode climb = this;
        while (true) {
            climb.figBounds();
            if (climb.getParent() == null) break;
            climb = climb.getParent();
        }
        return root;
    }

    private RTNode reInsert(Object env, RTNode root) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                root = RTNode.linkGeom(env, root, (RTBounds)this.getChild(i));
            }
        } else {
            for (int i = 0; i < this.getTotal(); ++i) {
                root = ((RTNode)this.getChild(i)).reInsert(env, root);
            }
        }
        return root;
    }

    private Object[] findGeom(RTBounds geom) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                if (this.getChild(i) != geom) continue;
                Object[] retObj = new Object[]{this, new Integer(i)};
                return retObj;
            }
            return null;
        }
        Rectangle2D geomBounds = geom.getBounds();
        for (int i = 0; i < this.getTotal(); ++i) {
            Object[] subRet;
            Rectangle2D bounds = this.getBBox(i);
            if (bounds.getMaxX() < geomBounds.getMinX() - DBMath.getEpsilon() || bounds.getMinX() > geomBounds.getMaxX() + DBMath.getEpsilon() || bounds.getMaxY() < geomBounds.getMinY() - DBMath.getEpsilon() || bounds.getMinY() > geomBounds.getMaxY() + DBMath.getEpsilon() || (subRet = ((RTNode)this.getChild(i)).findGeom(geom)) == null) continue;
            return subRet;
        }
        return null;
    }

    private Object[] findGeomAnywhere(RTBounds geom) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                if (this.getChild(i) != geom) continue;
                Object[] retVal = new Object[]{this, new Integer(i)};
                return retVal;
            }
            return null;
        }
        for (int i = 0; i < this.getTotal(); ++i) {
            Object[] retVal = ((RTNode)this.getChild(i)).findGeomAnywhere(geom);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public static class Search
    implements Iterator<RTBounds> {
        private static final int MAXDEPTH = 100;
        private int depth = 0;
        private RTNode[] rtn = new RTNode[100];
        private int[] position = new int[100];
        private Rectangle2D searchBounds;
        private RTBounds nextObj;
        private boolean includeEdges;

        public Search(Rectangle2D bounds, RTNode root, boolean includeEdges) {
            this.rtn[0] = root;
            this.searchBounds = new Rectangle2D.Double();
            this.searchBounds.setRect(bounds);
            this.includeEdges = includeEdges;
            this.nextObj = null;
        }

        private RTBounds nextObject() {
            while (true) {
                int i;
                RTNode rtnode = this.rtn[this.depth];
                int n = this.depth;
                this.position[n] = this.position[n] + 1;
                if (i < rtnode.getTotal()) {
                    Rectangle2D nodeBounds = rtnode.getBBox(i);
                    if (!this.includeEdges ? nodeBounds.getMaxX() <= this.searchBounds.getMinX() || nodeBounds.getMinX() >= this.searchBounds.getMaxX() || nodeBounds.getMaxY() <= this.searchBounds.getMinY() || nodeBounds.getMinY() >= this.searchBounds.getMaxY() : nodeBounds.getMaxX() < this.searchBounds.getMinX() || nodeBounds.getMinX() > this.searchBounds.getMaxX() || nodeBounds.getMaxY() < this.searchBounds.getMinY() || nodeBounds.getMinY() > this.searchBounds.getMaxY()) continue;
                    if (rtnode.getFlag()) {
                        return (RTBounds)rtnode.getChild(i);
                    }
                    if (this.depth >= 99) {
                        System.out.println("R-trees: search too deep");
                        continue;
                    }
                    ++this.depth;
                    this.rtn[this.depth] = (RTNode)rtnode.getChild(i);
                    this.position[this.depth] = 0;
                    continue;
                }
                if (this.depth == 0) break;
                --this.depth;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextObj == null) {
                this.nextObj = this.nextObject();
            }
            return this.nextObj != null;
        }

        @Override
        public RTBounds next() {
            if (this.nextObj != null) {
                RTBounds ret = this.nextObj;
                this.nextObj = null;
                return ret;
            }
            return this.nextObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Search.remove()");
        }
    }
}

