/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Name
implements Comparable<Name> {
    private static final boolean INTERN = true;
    private final String ns;
    private final String canonicString;
    private Name[] subnames;
    private final Name basename;
    private final int numSuffix;
    private int flags;
    private static volatile Name[] allNames = new Name[1];
    private static int allNamesCount = 0;
    private static final HashMap<String, Name> canonicNames = new HashMap();
    private static final int ERROR = 1;
    private static final int LIST = 2;
    private static final int BUS = 4;
    private static final int SIMPLE = 8;
    private static final int TEMP = 16;
    private static final int DUPLICATES = 32;
    private static final int HAS_EMPTIES = 64;

    public static final Name findName(String ns) {
        String ts;
        if (ns == null) {
            return null;
        }
        return Name.newTrimmedName(ts, (ts = Name.trim(ns)) == ns);
    }

    public static String checkName(String ns) {
        try {
            int flags = Name.checkNameThrow(ns);
            if ((flags & 0x40) != 0) {
                return "has empty subnames";
            }
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public static void printStatistics() {
        int validNames = 0;
        int userNames = 0;
        int busCount = 0;
        int busWidth = 0;
        int lowerCase = 0;
        long length = 0L;
        HashSet<String> canonic = new HashSet<String>();
        for (Name n : allNames) {
            if (n == null) continue;
            length += (long)n.toString().length();
            if (n.isValid()) {
                ++validNames;
            }
            if (!n.isTempname()) {
                ++userNames;
            }
            if (n.subnames != null) {
                ++busCount;
                busWidth += n.subnames.length;
            }
            if (n.toString() == n.canonicString()) {
                ++lowerCase;
                continue;
            }
            canonic.add(n.canonicString());
        }
        for (Name n : allNames) {
            if (n == null) continue;
            canonic.remove(n.toString());
        }
        long canonicLength = 0L;
        for (String s : canonic) {
            canonicLength += (long)s.length();
        }
        System.out.println(allNamesCount + " Names " + length + " chars. " + validNames + " valid " + userNames + " usernames " + busCount + " buses with " + busWidth + " elements. " + lowerCase + " lowercase " + canonic.size() + " canonic strings with " + canonicLength + " chars.");
    }

    public final String toString() {
        return this.ns;
    }

    public final String canonicString() {
        return this.canonicString;
    }

    @Override
    public int compareTo(Name name) {
        if (this.canonicString == name.canonicString) {
            return 0;
        }
        return this.canonicString.compareTo(name.canonicString);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Name) {
            Name anotherName = (Name)anObject;
            return this.canonicString == anotherName.canonicString;
        }
        return false;
    }

    public int hashCode() {
        return this.canonicString.hashCode();
    }

    public final boolean isValid() {
        return (this.flags & 1) == 0;
    }

    public final boolean isTempname() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean hasDuplicates() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean hasEmptySubnames() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isList() {
        return (this.flags & 2) != 0;
    }

    public final boolean isBus() {
        return this.subnames != null;
    }

    public final Name subname(int i) {
        return this.subnames == null ? this : this.subnames[i];
    }

    public final int busWidth() {
        return this.subnames == null ? 1 : this.subnames.length;
    }

    public final Name getBasename() {
        return this.basename;
    }

    public final int getNumSuffix() {
        return this.numSuffix;
    }

    public final Name findSuffixed(int i) {
        if (i < 0 || this.basename == null) {
            return null;
        }
        String basenameString = this.basename.ns.substring(0, this.basename.ns.length() - 1);
        return Name.findName(basenameString + i);
    }

    private static Name newTrimmedName(String ns, boolean clone) {
        return Name.findTrimmedName(ns, true, clone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Name findTrimmedName(String ns, boolean create, boolean clone) {
        Name n;
        Name[] hash = allNames;
        int i = ns.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] != null) {
            n = hash[i];
            if (n.ns.equals(ns)) {
                return n;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        Class<Name> clazz = Name.class;
        synchronized (Name.class) {
            if (hash == allNames && allNames[i] == null) {
                if (!create) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return null;
                }
                if (allNamesCount * 2 <= hash.length - 3) {
                    n = new Name(ns);
                    if (hash != allNames || hash[i] != null) {
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return Name.newTrimmedName(ns, false);
                    }
                    hash[i] = n;
                    ++allNamesCount;
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return n;
                }
                Name.rehash();
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return Name.findTrimmedName(ns, create, clone);
        }
    }

    private static void rehash() {
        Name[] oldHash = allNames;
        int newSize = oldHash.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        Name[] newHash = new Name[GenMath.primeSince(newSize)];
        for (Name n : oldHash) {
            if (n == null) continue;
            int i = n.ns.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = n;
        }
        allNames = newHash;
    }

    private static String trim(String ns) {
        if (ns == null) {
            return null;
        }
        int len = ns.length();
        int newLen = 0;
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            ++newLen;
        }
        if (newLen == len) {
            return ns;
        }
        StringBuffer buf = new StringBuffer(newLen);
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            buf.append(ns.charAt(i));
        }
        return buf.toString();
    }

    private Name(String s) {
        s = s.intern();
        String canonic = TextUtils.canonicString(s);
        if (canonic != s) {
            canonic = canonic.intern();
        }
        this.ns = s;
        this.canonicString = canonic;
        int suffix = -1;
        Name base = null;
        try {
            this.flags = Name.checkNameThrow(this.ns);
        }
        catch (NumberFormatException e) {
            this.flags = 1;
        }
        if ((this.flags & 1) == 0 && (this.flags & 0x10) != 0) {
            int l;
            for (l = this.ns.length(); l > 0 && TextUtils.isDigit(this.ns.charAt(l - 1)); --l) {
            }
            if (l == this.ns.length() - 1 && this.ns.charAt(this.ns.length() - 1) == '0') {
                base = this;
                suffix = 0;
            } else {
                base = Name.newTrimmedName(this.ns.substring(0, l) + '0', false);
                suffix = Integer.parseInt(this.ns.substring(l));
            }
        }
        this.numSuffix = suffix;
        this.basename = base;
        if (this.flags == 1) {
            return;
        }
        if ((this.flags & 4) == 0) {
            return;
        }
        if (this.isList()) {
            this.makeListSubNames();
            return;
        }
        int split = this.ns.indexOf(91);
        if (split == 0) {
            split = this.ns.lastIndexOf(91);
        }
        if (split == 0) {
            this.makeBracketSubNames();
        } else {
            this.makeSplitSubNames(split);
        }
    }

    private void makeListSubNames() {
        ArrayList<Name> subs = new ArrayList<Name>();
        int beg = 0;
        while (beg <= this.ns.length()) {
            int end;
            for (end = beg; end < this.ns.length() && this.ns.charAt(end) != ','; ++end) {
                if (this.ns.charAt(end) != '[') continue;
                while (this.ns.charAt(end) != ']') {
                    ++end;
                }
            }
            Name nm = Name.newTrimmedName(this.ns.substring(beg, end), true);
            for (int j = 0; j < nm.busWidth(); ++j) {
                subs.add(nm.subname(j));
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void makeBracketSubNames() {
        ArrayList<Name> subs = new ArrayList<Name>();
        int beg = 1;
        while (beg < this.ns.length()) {
            int colon;
            int end = this.ns.indexOf(44, beg);
            if (end < 0) {
                end = this.ns.length() - 1;
            }
            if ((colon = this.ns.indexOf(58, beg)) < 0 || colon >= end) {
                Name nm = Name.newTrimmedName("[" + this.ns.substring(beg, end) + "]", false);
                subs.add(nm);
            } else {
                int i;
                int ind2;
                int ind1 = Integer.parseInt(this.ns.substring(beg, colon));
                if (ind1 < (ind2 = Integer.parseInt(this.ns.substring(colon + 1, end)))) {
                    for (i = ind1; i <= ind2; ++i) {
                        subs.add(Name.newTrimmedName("[" + i + "]", false));
                    }
                } else {
                    for (i = ind1; i >= ind2; --i) {
                        subs.add(Name.newTrimmedName("[" + i + "]", false));
                    }
                }
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void setSubnames(List<Name> subs) {
        this.subnames = new Name[subs.size()];
        subs.toArray(this.subnames);
        Object[] sorted = new Name[subs.size()];
        subs.toArray(sorted);
        Arrays.sort(sorted);
        for (int i = 1; i < sorted.length; ++i) {
            if (!((Name)sorted[i]).equals(sorted[i - 1])) continue;
            this.flags |= 0x20;
            break;
        }
    }

    private void makeSplitSubNames(int split) {
        if (split < 0 || split >= this.ns.length()) {
            System.out.println("HEY! string is '" + this.ns + "' but want index " + split);
            return;
        }
        Name baseName = Name.newTrimmedName(this.ns.substring(0, split), true);
        Name indexList = Name.newTrimmedName(this.ns.substring(split), true);
        this.subnames = new Name[baseName.busWidth() * indexList.busWidth()];
        for (int i = 0; i < baseName.busWidth(); ++i) {
            String bs = baseName.subname(i).toString();
            for (int j = 0; j < indexList.busWidth(); ++j) {
                String is = indexList.subname(j).toString();
                this.subnames[i * indexList.busWidth() + j] = Name.newTrimmedName(bs + is, false);
            }
        }
        if (baseName.hasDuplicates() || indexList.hasDuplicates()) {
            this.flags |= 0x20;
        }
    }

    private static int checkNameThrow(String ns) throws NumberFormatException {
        int flags = 8;
        int bracket = -1;
        boolean wasBrackets = false;
        int colon = -1;
        if (ns.length() == 0 || ns.charAt(ns.length() - 1) == ',') {
            flags |= 0x40;
        }
        for (int i = 0; i < ns.length(); ++i) {
            int j;
            char c = ns.charAt(i);
            if (bracket < 0) {
                colon = -1;
                if (c == ']') {
                    throw new NumberFormatException("unmatched ']' in name");
                }
                if (c == ':') {
                    throw new NumberFormatException("':' out of brackets");
                }
                if (c == '[') {
                    bracket = i;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = true;
                } else if (c == ',') {
                    flags |= 6;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = false;
                } else if (wasBrackets) {
                    throw new NumberFormatException("Wrong character after brackets");
                }
                if (c != '@') continue;
                for (j = i + 1; j < ns.length(); ++j) {
                    char cj = ns.charAt(j);
                    if (cj >= '0' && cj <= '9') continue;
                    throw new NumberFormatException("Wrong number suffix in temporary name");
                }
                if (i == ns.length() - 1 || ns.charAt(i + 1) == '0' && i != ns.length() - 2) {
                    throw new NumberFormatException("Wrong temporary name");
                }
                if ((flags & 8) == 0) {
                    throw new NumberFormatException("list of temporary names");
                }
                Integer.parseInt(ns.substring(i + 1));
                assert (flags == 8);
                return 24;
            }
            if (c == '[') {
                throw new NumberFormatException("nested bracket '[' in name");
            }
            if (c == ':') {
                if (colon >= 0) {
                    throw new NumberFormatException("too many ':' inside brackets");
                }
                if (i == bracket + 1) {
                    throw new NumberFormatException("has missing start of index range");
                }
                if (ns.charAt(bracket + 1) == '-') {
                    throw new NumberFormatException("has negative start of index range");
                }
                for (j = bracket + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric start of index range");
                }
                colon = i;
                flags |= 4;
            }
            if (colon >= 0 && (c == ']' || c == ',')) {
                if (i == colon + 1) {
                    throw new NumberFormatException("has missing end of index range");
                }
                if (ns.charAt(colon + 1) == '-') {
                    throw new NumberFormatException("has negative end of index range");
                }
                for (j = colon + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric end of index range");
                }
                if (Integer.parseInt(ns.substring(bracket + 1, colon)) == Integer.parseInt(ns.substring(colon + 1, i))) {
                    throw new NumberFormatException("has equal start and end indices");
                }
                colon = -1;
            }
            if (c == ']') {
                if (i == bracket + 1) {
                    flags |= 0x40;
                }
                bracket = -1;
            }
            if (c == ',') {
                if (i == bracket + 1) {
                    flags += 64;
                }
                bracket = i;
                flags |= 4;
            }
            if (c != '@') continue;
            throw new NumberFormatException("'@' in brackets");
        }
        if (bracket != -1) {
            throw new NumberFormatException("Unclosed bracket");
        }
        return flags;
    }
}

