/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextTab
extends PreferencePanel {
    private MutableTextDescriptor initialTextNodeDescriptor;
    private MutableTextDescriptor currentTextNodeDescriptor;
    private MutableTextDescriptor initialTextArcDescriptor;
    private MutableTextDescriptor currentTextArcDescriptor;
    private MutableTextDescriptor initialTextExportDescriptor;
    private MutableTextDescriptor currentTextExportDescriptor;
    private MutableTextDescriptor initialTextAnnotationDescriptor;
    private MutableTextDescriptor currentTextAnnotationDescriptor;
    private MutableTextDescriptor initialTextInstanceDescriptor;
    private MutableTextDescriptor currentTextInstanceDescriptor;
    private MutableTextDescriptor initialTextCellDescriptor;
    private MutableTextDescriptor currentTextCellDescriptor;
    private MutableTextDescriptor currentTextDescriptor;
    private boolean textValuesChanging = false;
    private JPanel globals;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel41;
    private JLabel jLabel42;
    private JLabel jLabel43;
    private JLabel jLabel44;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JSeparator jSeparator3;
    private JPanel text;
    private JComboBox textAnchor;
    private JRadioButton textAnnotation;
    private JRadioButton textArcs;
    private JCheckBox textBold;
    private JComboBox textCellFont;
    private JTextField textCellSize;
    private JRadioButton textCellText;
    private JPanel textCells;
    private JComboBox textDefaultFont;
    private JComboBox textFace;
    private JTextField textGlobalScale;
    private JRadioButton textInstances;
    private JCheckBox textItalic;
    private JCheckBox textNewVisibleInsideCell;
    private JRadioButton textNodes;
    private JTextField textPointSize;
    private JRadioButton textPoints;
    private JRadioButton textPorts;
    private ButtonGroup textSizeGroup;
    private ButtonGroup textTypeGroup;
    private JCheckBox textUnderline;
    private JTextField textUnitSize;
    private JRadioButton textUnits;
    private JPanel top;

    public TextTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.text;
    }

    public String getName() {
        return "Text";
    }

    public void init() {
        Iterator<AbstractTextDescriptor.Position> it = AbstractTextDescriptor.Position.getPositions();
        while (it.hasNext()) {
            AbstractTextDescriptor.Position pos = it.next();
            this.textAnchor.addItem(pos);
        }
        this.initialTextNodeDescriptor = MutableTextDescriptor.getNodeTextDescriptor();
        this.initialTextArcDescriptor = MutableTextDescriptor.getArcTextDescriptor();
        this.initialTextExportDescriptor = MutableTextDescriptor.getExportTextDescriptor();
        this.initialTextAnnotationDescriptor = MutableTextDescriptor.getAnnotationTextDescriptor();
        this.initialTextInstanceDescriptor = MutableTextDescriptor.getInstanceTextDescriptor();
        this.initialTextCellDescriptor = MutableTextDescriptor.getCellTextDescriptor();
        this.currentTextNodeDescriptor = MutableTextDescriptor.getNodeTextDescriptor();
        this.currentTextArcDescriptor = MutableTextDescriptor.getArcTextDescriptor();
        this.currentTextExportDescriptor = MutableTextDescriptor.getExportTextDescriptor();
        this.currentTextAnnotationDescriptor = MutableTextDescriptor.getAnnotationTextDescriptor();
        this.currentTextInstanceDescriptor = MutableTextDescriptor.getInstanceTextDescriptor();
        this.currentTextCellDescriptor = MutableTextDescriptor.getCellTextDescriptor();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.textFace.addItem("DEFAULT FONT");
        for (int i = 0; i < fontNames.length; ++i) {
            this.textDefaultFont.addItem(fontNames[i]);
            this.textFace.addItem(fontNames[i]);
            this.textCellFont.addItem(fontNames[i]);
        }
        this.textDefaultFont.setSelectedItem(User.getDefaultFont());
        this.textCellFont.setSelectedItem(User.getDefaultTextCellFont());
        this.textCellSize.setText(Integer.toString(User.getDefaultTextCellSize()));
        this.textGlobalScale.setText(TextUtils.formatDouble(User.getGlobalTextScale() * 100.0));
        this.textNodes.setSelected(true);
        this.textButtonChanged();
        this.textNodes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textArcs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPorts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textAnnotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textInstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textCellText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textButtonChanged();
            }
        });
        this.textPoints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textUnderline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textFace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textAnchor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textNewVisibleInsideCell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextTab.this.textValuesChanged();
            }
        });
        this.textPointSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
        this.textUnitSize.getDocument().addDocumentListener(new TextSizeDocumentListener(this));
    }

    private void textValuesChanged() {
        AbstractTextDescriptor.ActiveFont af;
        if (this.textValuesChanging) {
            return;
        }
        if (this.textPoints.isSelected()) {
            int size = TextUtils.atoi(this.textPointSize.getText());
            this.currentTextDescriptor.setAbsSize(size);
        } else {
            double size = TextUtils.atof(this.textUnitSize.getText());
            this.currentTextDescriptor.setRelSize(size);
        }
        this.currentTextDescriptor.setItalic(this.textItalic.isSelected());
        this.currentTextDescriptor.setBold(this.textBold.isSelected());
        this.currentTextDescriptor.setUnderline(this.textUnderline.isSelected());
        this.currentTextDescriptor.setPos((AbstractTextDescriptor.Position)this.textAnchor.getSelectedItem());
        this.currentTextDescriptor.setInterior(this.textNewVisibleInsideCell.isSelected());
        int face = 0;
        if (this.textFace.getSelectedIndex() != 0 && (af = AbstractTextDescriptor.ActiveFont.findActiveFont((String)this.textFace.getSelectedItem())) != null) {
            face = af.getIndex();
        }
        this.currentTextDescriptor.setFace(face);
    }

    private void textButtonChanged() {
        this.currentTextDescriptor = null;
        if (this.textNodes.isSelected()) {
            this.currentTextDescriptor = this.currentTextNodeDescriptor;
        } else if (this.textArcs.isSelected()) {
            this.currentTextDescriptor = this.currentTextArcDescriptor;
        } else if (this.textPorts.isSelected()) {
            this.currentTextDescriptor = this.currentTextExportDescriptor;
        } else if (this.textAnnotation.isSelected()) {
            this.currentTextDescriptor = this.currentTextAnnotationDescriptor;
        } else if (this.textInstances.isSelected()) {
            this.currentTextDescriptor = this.currentTextInstanceDescriptor;
        } else if (this.textCellText.isSelected()) {
            this.currentTextDescriptor = this.currentTextCellDescriptor;
        }
        this.loadCurrentDescriptorInfo();
    }

    private void loadCurrentDescriptorInfo() {
        this.textValuesChanging = true;
        AbstractTextDescriptor.Size size = this.currentTextDescriptor.getSize();
        if (size.isAbsolute()) {
            this.textPoints.setSelected(true);
            this.textPointSize.setText(Integer.toString((int)size.getSize()));
            this.textUnitSize.setText("");
        } else {
            this.textUnits.setSelected(true);
            this.textUnitSize.setText(TextUtils.formatDouble(size.getSize()));
            this.textPointSize.setText("");
        }
        this.textItalic.setSelected(this.currentTextDescriptor.isItalic());
        this.textBold.setSelected(this.currentTextDescriptor.isBold());
        this.textUnderline.setSelected(this.currentTextDescriptor.isUnderline());
        this.textAnchor.setSelectedItem(this.currentTextDescriptor.getPos());
        this.textValuesChanging = false;
        this.textNewVisibleInsideCell.setSelected(this.currentTextDescriptor.isInterior());
        int face = this.currentTextDescriptor.getFace();
        if (face == 0) {
            this.textFace.setSelectedIndex(0);
        } else {
            String fontName = AbstractTextDescriptor.ActiveFont.findActiveFont(face).getName();
            this.textFace.setSelectedItem(fontName);
        }
    }

    public void term() {
        double currentGlobalScale;
        int currInt;
        boolean editCellsChanged = false;
        boolean textCellsChanged = false;
        String currentFontName = (String)this.textDefaultFont.getSelectedItem();
        if (!currentFontName.equalsIgnoreCase(User.getDefaultFont())) {
            User.setDefaultFont(currentFontName);
            editCellsChanged = true;
        }
        if (!(currentFontName = (String)this.textCellFont.getSelectedItem()).equalsIgnoreCase(User.getDefaultTextCellFont())) {
            User.setDefaultTextCellFont(currentFontName);
            textCellsChanged = true;
        }
        if ((currInt = TextUtils.atoi(this.textCellSize.getText())) != User.getDefaultTextCellSize()) {
            User.setDefaultTextCellSize(currInt);
            textCellsChanged = true;
        }
        if (!this.currentTextNodeDescriptor.equals(this.initialTextNodeDescriptor)) {
            TextDescriptor.setNodeTextDescriptor(this.currentTextNodeDescriptor);
        }
        if (!this.currentTextArcDescriptor.equals(this.initialTextArcDescriptor)) {
            TextDescriptor.setArcTextDescriptor(this.currentTextArcDescriptor);
        }
        if (!this.currentTextExportDescriptor.equals(this.initialTextExportDescriptor)) {
            TextDescriptor.setExportTextDescriptor(this.currentTextExportDescriptor);
        }
        if (!this.currentTextAnnotationDescriptor.equals(this.initialTextAnnotationDescriptor)) {
            TextDescriptor.setAnnotationTextDescriptor(this.currentTextAnnotationDescriptor);
        }
        if (!this.currentTextInstanceDescriptor.equals(this.initialTextInstanceDescriptor)) {
            TextDescriptor.setInstanceTextDescriptor(this.currentTextInstanceDescriptor);
        }
        if (!this.currentTextCellDescriptor.equals(this.initialTextCellDescriptor)) {
            TextDescriptor.setCellTextDescriptor(this.currentTextCellDescriptor);
        }
        if ((currentGlobalScale = TextUtils.atof(this.textGlobalScale.getText()) / 100.0) != User.getGlobalTextScale()) {
            User.setGlobalTextScale(currentGlobalScale);
            editCellsChanged = true;
        }
        if (textCellsChanged || editCellsChanged) {
            Iterator<WindowFrame> it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = it.next();
                if (textCellsChanged && wf.getContent() instanceof TextWindow) {
                    TextWindow tw = (TextWindow)wf.getContent();
                    tw.updateFontInformation();
                }
                if (!editCellsChanged || !(wf.getContent() instanceof EditWindow)) continue;
                EditWindow wnd = (EditWindow)wf.getContent();
                wnd.repaintContents(null, false);
            }
        }
    }

    private void initComponents() {
        this.textSizeGroup = new ButtonGroup();
        this.textTypeGroup = new ButtonGroup();
        this.text = new JPanel();
        this.top = new JPanel();
        this.jLabel41 = new JLabel();
        this.textNodes = new JRadioButton();
        this.textArcs = new JRadioButton();
        this.textPorts = new JRadioButton();
        this.textAnnotation = new JRadioButton();
        this.textInstances = new JRadioButton();
        this.textCellText = new JRadioButton();
        this.jLabel42 = new JLabel();
        this.textPointSize = new JTextField();
        this.textUnitSize = new JTextField();
        this.jLabel43 = new JLabel();
        this.textFace = new JComboBox();
        this.textItalic = new JCheckBox();
        this.textBold = new JCheckBox();
        this.textUnderline = new JCheckBox();
        this.textPoints = new JRadioButton();
        this.textUnits = new JRadioButton();
        this.jSeparator3 = new JSeparator();
        this.jLabel6 = new JLabel();
        this.textAnchor = new JComboBox();
        this.textNewVisibleInsideCell = new JCheckBox();
        this.globals = new JPanel();
        this.jLabel44 = new JLabel();
        this.textDefaultFont = new JComboBox();
        this.jLabel1 = new JLabel();
        this.textGlobalScale = new JTextField();
        this.jLabel2 = new JLabel();
        this.textCells = new JPanel();
        this.jLabel7 = new JLabel();
        this.textCellFont = new JComboBox();
        this.jLabel3 = new JLabel();
        this.textCellSize = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TextTab.this.closeDialog(evt);
            }
        });
        this.text.setLayout(new GridBagLayout());
        this.top.setLayout(new GridBagLayout());
        this.top.setBorder(BorderFactory.createTitledBorder("Default Style for New Text"));
        this.jLabel41.setText("Which type of new text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.top.add((Component)this.jLabel41, gridBagConstraints);
        this.textTypeGroup.add(this.textNodes);
        this.textNodes.setText("Node text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textNodes, gridBagConstraints);
        this.textTypeGroup.add(this.textArcs);
        this.textArcs.setText("Arc text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textArcs, gridBagConstraints);
        this.textTypeGroup.add(this.textPorts);
        this.textPorts.setText("Exports/Ports");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textPorts, gridBagConstraints);
        this.textTypeGroup.add(this.textAnnotation);
        this.textAnnotation.setText("Annotation text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textAnnotation, gridBagConstraints);
        this.textTypeGroup.add(this.textInstances);
        this.textInstances.setText("Instance names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textInstances, gridBagConstraints);
        this.textTypeGroup.add(this.textCellText);
        this.textCellText.setText("Cell text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textCellText, gridBagConstraints);
        this.jLabel42.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel42, gridBagConstraints);
        this.textPointSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.top.add((Component)this.textPointSize, gridBagConstraints);
        this.textUnitSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.top.add((Component)this.textUnitSize, gridBagConstraints);
        this.jLabel43.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel43, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textFace, gridBagConstraints);
        this.textItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textItalic, gridBagConstraints);
        this.textBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textBold, gridBagConstraints);
        this.textUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.top.add((Component)this.textUnderline, gridBagConstraints);
        this.textSizeGroup.add(this.textPoints);
        this.textPoints.setText("Points (max 63)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.top.add((Component)this.textPoints, gridBagConstraints);
        this.textSizeGroup.add(this.textUnits);
        this.textUnits.setText("Units (max 127.75)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.top.add((Component)this.textUnits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 30, 4, 30);
        this.top.add((Component)this.jSeparator3, gridBagConstraints);
        this.jLabel6.setText("Anchor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.top.add((Component)this.textAnchor, gridBagConstraints);
        this.textNewVisibleInsideCell.setText("Invisible outside cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.top.add((Component)this.textNewVisibleInsideCell, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.top, gridBagConstraints);
        this.globals.setLayout(new GridBagLayout());
        this.globals.setBorder(BorderFactory.createTitledBorder("Everywhere:"));
        this.jLabel44.setText("Default font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globals.add((Component)this.jLabel44, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globals.add((Component)this.textDefaultFont, gridBagConstraints);
        this.jLabel1.setText("Global text scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globals.add((Component)this.jLabel1, gridBagConstraints);
        this.textGlobalScale.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.globals.add((Component)this.textGlobalScale, gridBagConstraints);
        this.jLabel2.setText("percent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.globals.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.globals, gridBagConstraints);
        this.textCells.setLayout(new GridBagLayout());
        this.textCells.setBorder(BorderFactory.createTitledBorder("For Textual Cells:"));
        this.jLabel7.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.textCells.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.textCells.add((Component)this.textCellFont, gridBagConstraints);
        this.jLabel3.setText("Size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.textCells.add((Component)this.jLabel3, gridBagConstraints);
        this.textCellSize.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.textCells.add((Component)this.textCellSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.text.add((Component)this.textCells, gridBagConstraints);
        this.getContentPane().add((Component)this.text, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class TextSizeDocumentListener
    implements DocumentListener {
        TextTab dialog;

        TextSizeDocumentListener(TextTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.textValuesChanged();
        }
    }
}

