/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.EditWindow0;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import java.awt.Font;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Poly
extends PolyBase {
    private String string;
    private TextDescriptor descript;
    private DisplayedText dt;

    public Poly(Point2D[] points) {
        super(points);
    }

    public Poly(double cX, double cY, double width, double height) {
        super(cX, cY, width, height);
    }

    public Poly(Rectangle2D rect) {
        super(rect);
    }

    public String getString() {
        return this.string;
    }

    public void setString(String string) {
        this.string = string;
    }

    public TextDescriptor getTextDescriptor() {
        return this.descript;
    }

    public void setTextDescriptor(TextDescriptor descript) {
        this.descript = descript;
    }

    public DisplayedText getDisplayedText() {
        return this.dt;
    }

    public void setDisplayedText(DisplayedText dt) {
        this.dt = dt;
    }

    public static Poly makeEndPointPoly(double len, double wid, int angle, Point2D endH, double extendH, Point2D endT, double extendT, Type style) {
        double temp;
        double w2 = wid / 2.0;
        double x1 = endH.getX();
        double y1 = endH.getY();
        double x2 = endT.getX();
        double y2 = endT.getY();
        Point2D[] points = null;
        if (angle == 900 || angle == 2700) {
            if (y1 > y2) {
                temp = y1;
                y1 = y2;
                y2 = temp;
                temp = extendH;
                extendH = extendT;
                extendT = temp;
            }
            points = new Point2D.Double[]{new Point2D.Double(x1 - w2, y1 - extendH), new Point2D.Double(x1 + w2, y1 - extendH), new Point2D.Double(x2 + w2, y2 + extendT), new Point2D.Double(x2 - w2, y2 + extendT)};
        } else if (angle == 0 || angle == 1800) {
            if (x1 > x2) {
                temp = x1;
                x1 = x2;
                x2 = temp;
                temp = extendH;
                extendH = extendT;
                extendT = temp;
            }
            points = new Point2D.Double[]{new Point2D.Double(x1 - extendH, y1 - w2), new Point2D.Double(x1 - extendH, y1 + w2), new Point2D.Double(x2 + extendT, y2 + w2), new Point2D.Double(x2 + extendT, y2 - w2)};
        } else {
            double yextra;
            double xextra;
            double ye2;
            double xe2;
            double ye1;
            double xe1;
            if (len == 0.0) {
                len = endH.distance(endT);
            }
            if (len == 0.0) {
                double sa = DBMath.sin(angle);
                double ca = DBMath.cos(angle);
                xe1 = x1 - ca * extendH;
                ye1 = y1 - sa * extendH;
                xe2 = x2 + ca * extendT;
                ye2 = y2 + sa * extendT;
                xextra = ca * w2;
                yextra = sa * w2;
            } else {
                xe1 = x1 - extendH * (x2 - x1) / len;
                ye1 = y1 - extendH * (y2 - y1) / len;
                xe2 = x2 + extendT * (x2 - x1) / len;
                ye2 = y2 + extendT * (y2 - y1) / len;
                xextra = w2 * (x2 - x1) / len;
                yextra = w2 * (y2 - y1) / len;
            }
            points = new Point2D.Double[]{new Point2D.Double(yextra + xe1, ye1 - xextra), new Point2D.Double(xe1 - yextra, xextra + ye1), new Point2D.Double(xe2 - yextra, xextra + ye2), new Point2D.Double(yextra + xe2, ye2 - xextra)};
        }
        if (wid != 0.0 && style.isOpened()) {
            points = new Point2D.Double[]{points[0], points[1], points[2], points[3], points[0]};
        }
        Poly poly = new Poly(points);
        poly.setStyle(style);
        return poly;
    }

    public boolean setExactTextBounds(EditWindow0 wnd, ElectricObject eObj) {
        Font font;
        Variable var;
        if (this.getString() == null) {
            return true;
        }
        String theString = this.getString().trim();
        if (theString.length() == 0) {
            return true;
        }
        int numLines = 1;
        if (this.dt != null && (var = this.dt.getVariable()) != null && (numLines = var.getLength()) > 1) {
            Object[] objList = (Object[])var.getObject();
            for (int i = 0; i < numLines; ++i) {
                String str;
                if (objList[i] == null || (str = objList[i].toString()).length() <= theString.length()) continue;
                theString = str;
            }
        }
        Type style = this.getStyle();
        style = Poly.rotateType(style, eObj);
        Font font2 = font = this.descript != null ? this.descript.getFont(wnd, 0) : TextDescriptor.getDefaultFont();
        if (font == null) {
            UserInterface ui = Job.getUserInterface();
            double size = ui.getDefaultTextSize();
            if (this.descript != null) {
                size = this.descript.getTrueSize(wnd);
            }
            if ((size /= wnd.getScale()) <= 0.0) {
                size = 1.0;
            }
            double cX = this.getBounds2D().getCenterX();
            double cY = this.getBounds2D().getCenterY();
            double sizeIndent = size / 4.0;
            double fakeWidth = (double)theString.length() * size * 0.75;
            Point2D pt = this.getTextCorner(style, cX, cY, fakeWidth, size);
            cX = pt.getX();
            cY = pt.getY();
            this.points = new Point2D.Double[]{new Point2D.Double(cX, cY + sizeIndent), new Point2D.Double(cX + fakeWidth, cY + sizeIndent), new Point2D.Double(cX + fakeWidth, cY + size - sizeIndent), new Point2D.Double(cX, cY + size - sizeIndent)};
            this.bounds = null;
            return false;
        }
        Rectangle2D bounds = this.getBounds2D();
        double lX = bounds.getMinX();
        double hX = bounds.getMaxX();
        double lY = bounds.getMinY();
        double hY = bounds.getMaxY();
        GlyphVector gv = TextDescriptor.getGlyphs(theString, font);
        Rectangle2D glyphBounds = gv.getVisualBounds();
        double textScale = this.getTextScale(wnd, gv, style, lX, hX, lY, hY);
        double textWidth = glyphBounds.getWidth();
        double textHeight = font.getSize();
        double scaledWidth = textWidth * textScale;
        double scaledHeight = textHeight * textScale;
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        Point2D corner = this.getTextCorner(style, cX, cY, scaledWidth, scaledHeight);
        cX = corner.getX();
        cY = corner.getY();
        double width = glyphBounds.getWidth() * textScale;
        double height = (double)font.getSize() * textScale * (double)numLines;
        switch (this.descript.getRotation().getIndex()) {
            case 1: {
                double saveWidth = width;
                width = -height;
                height = saveWidth;
                break;
            }
            case 2: {
                width = -width;
                height = -height;
                break;
            }
            case 3: {
                double saveHeight = height;
                height = -width;
                width = saveHeight;
            }
        }
        this.points = new Point2D.Double[]{new Point2D.Double(cX, cY), new Point2D.Double(cX + width, cY), new Point2D.Double(cX + width, cY + height), new Point2D.Double(cX, cY + height)};
        this.bounds = null;
        gv = null;
        return false;
    }

    private Point2D getTextCorner(Type style, double cX, double cY, double scaledWidth, double scaledHeight) {
        double offX = 0.0;
        double offY = 0.0;
        if (style == Type.TEXTCENT || style == Type.TEXTBOX) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOP) {
            offX = -scaledWidth / 2.0;
            offY = -scaledHeight;
        } else if (style == Type.TEXTBOT) {
            offX = -scaledWidth / 2.0;
        } else if (style == Type.TEXTLEFT) {
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTRIGHT) {
            offX = -scaledWidth;
            offY = -scaledHeight / 2.0;
        } else if (style == Type.TEXTTOPLEFT) {
            offY = -scaledHeight;
        } else if (style != Type.TEXTBOTLEFT) {
            if (style == Type.TEXTTOPRIGHT) {
                offX = -scaledWidth;
                offY = -scaledHeight;
            } else if (style == Type.TEXTBOTRIGHT) {
                offX = -scaledWidth;
            }
        }
        int rotation = this.getTextDescriptor().getRotation().getIndex();
        if (rotation != 0) {
            double saveOffX = offX;
            switch (rotation) {
                case 1: {
                    offX = -offY;
                    offY = saveOffX;
                    break;
                }
                case 2: {
                    offX = -offX;
                    offY = -offY;
                    break;
                }
                case 3: {
                    offX = offY;
                    offY = -saveOffX;
                }
            }
        }
        return new Point2D.Double(cX + offX, cY + offY);
    }

    public static class Type {
        private String name;
        private String constName;
        private boolean isText;
        public static final Type FILLED = new Type("filled", "FILLED", false);
        public static final Type CLOSED = new Type("closed", "CLOSED", false);
        public static final Type CROSSED = new Type("crossed", "CROSSED", false);
        public static final Type OPENED = new Type("opened", "OPENED", false);
        public static final Type OPENEDT1 = new Type("opened-dotted", "OPENEDT1", false);
        public static final Type OPENEDT2 = new Type("opened-dashed", "OPENEDT2", false);
        public static final Type OPENEDT3 = new Type("opened-thick", "OPENEDT3", false);
        public static final Type VECTORS = new Type("vectors", "VECTORS", false);
        public static final Type CIRCLE = new Type("circle", "CIRCLE", false);
        public static final Type THICKCIRCLE = new Type("thick-circle", "THICKCIRCLE", false);
        public static final Type DISC = new Type("disc", "DISC", false);
        public static final Type CIRCLEARC = new Type("circle-arc", "CIRCLEARC", false);
        public static final Type THICKCIRCLEARC = new Type("thick-circle-arc", "THICKCIRCLEARC", false);
        public static final Type TEXTCENT = new Type("text-center", "TEXTCENT", true);
        public static final Type TEXTTOP = new Type("text-top", "TEXTTOP", true);
        public static final Type TEXTBOT = new Type("text-bottom", "TEXTBOT", true);
        public static final Type TEXTLEFT = new Type("text-left", "TEXTLEFT", true);
        public static final Type TEXTRIGHT = new Type("text-right", "TEXTRIGHT", true);
        public static final Type TEXTTOPLEFT = new Type("text-topleft", "TEXTTOPLEFT", true);
        public static final Type TEXTBOTLEFT = new Type("text-botleft", "TEXTBOTLEFT", true);
        public static final Type TEXTTOPRIGHT = new Type("text-topright", "TEXTTOPRIGHT", true);
        public static final Type TEXTBOTRIGHT = new Type("text-botright", "TEXTBOTRIGHT", true);
        public static final Type TEXTBOX = new Type("text-box", "TEXTBOX", true);
        public static final Type CROSS = new Type("cross", "CROSS", false);
        public static final Type BIGCROSS = new Type("big-cross", "BIGCROSS", false);

        private Type(String name, String constName, boolean isText) {
            this.name = name;
            this.constName = constName;
            this.isText = isText;
        }

        public boolean isText() {
            return this.isText;
        }

        public String toString() {
            return "Poly.Type " + this.name;
        }

        public String getConstantName() {
            return this.constName;
        }

        public boolean isOpened() {
            return this == OPENED || this == OPENEDT1 || this == OPENEDT2 || this == OPENEDT3 || this == VECTORS;
        }

        public int getTextAngle() {
            if (this == TEXTLEFT) {
                return 0;
            }
            if (this == TEXTBOTLEFT) {
                return 450;
            }
            if (this == TEXTBOT) {
                return 900;
            }
            if (this == TEXTBOTRIGHT) {
                return 1350;
            }
            if (this == TEXTRIGHT) {
                return 1800;
            }
            if (this == TEXTTOPRIGHT) {
                return 2250;
            }
            if (this == TEXTTOP) {
                return 2700;
            }
            if (this == TEXTTOPLEFT) {
                return 3150;
            }
            return 0;
        }

        public static Type getTextTypeFromAngle(int angle) {
            switch (angle) {
                case 0: {
                    return TEXTLEFT;
                }
                case 450: {
                    return TEXTBOTLEFT;
                }
                case 900: {
                    return TEXTBOT;
                }
                case 1350: {
                    return TEXTBOTRIGHT;
                }
                case 1800: {
                    return TEXTRIGHT;
                }
                case 2250: {
                    return TEXTTOPRIGHT;
                }
                case 2700: {
                    return TEXTTOP;
                }
                case 3150: {
                    return TEXTTOPLEFT;
                }
            }
            return TEXTCENT;
        }
    }
}

