/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import java.io.IOException;

public class ImmutableArcInst
extends ImmutableElectricObject {
    private static final int FIXED = 1;
    private static final int FIXANG = 2;
    private static final int DISK_AANGLE = 16352;
    private static final int DISK_AANGLESH = 5;
    private static final int ISHEADNEGATED = 65536;
    private static final int DISK_NOEXTEND = 131072;
    private static final int ISTAILNEGATED = 262144;
    private static final int HEADARROW = 524288;
    private static final int DISK_ISDIRECTIONAL = 524288;
    private static final int TAILNOEXTEND = 0x100000;
    private static final int DISK_NOTEND0 = 0x100000;
    private static final int HEADNOEXTEND = 0x200000;
    private static final int DISK_NOTEND1 = 0x200000;
    private static final int DISK_REVERSEEND = 0x400000;
    private static final int CANTSLIDE = 0x800000;
    private static final int TAILARROW = 0x2000000;
    private static final int BODYARROW = 0x4000000;
    private static final int HARDSELECTA = Integer.MIN_VALUE;
    public static final Flag RIGID = new Flag(1);
    public static final Flag FIXED_ANGLE = new Flag(2);
    public static final Flag SLIDABLE = new FlagInv(0x800000);
    public static final Flag TAIL_ARROWED = new Flag(0x2000000);
    public static final Flag HEAD_ARROWED = new Flag(524288);
    public static final Flag BODY_ARROWED = new Flag(0x4000000);
    public static final Flag TAIL_EXTENDED = new FlagInv(0x100000);
    public static final Flag HEAD_EXTENDED = new FlagInv(0x200000);
    public static final Flag TAIL_NEGATED = new Flag(262144);
    public static final Flag HEAD_NEGATED = new Flag(65536);
    public static final Flag HARD_SELECT = new Flag(Integer.MIN_VALUE);
    private static int COMMON_BITS = -2139095037;
    private static final int DATABASE_FLAGS = COMMON_BITS | 0x4000000 | 0x40000 | 0x100000 | 0x2000000 | 0x10000 | 0x200000 | 0x80000;
    public static final Name BASENAME = Name.findName("net@0");
    public static final ImmutableArcInst[] NULL_ARRAY = new ImmutableArcInst[0];
    public static final ImmutableArrayList<ImmutableArcInst> EMPTY_LIST = new ImmutableArrayList<ImmutableArcInst>(NULL_ARRAY);
    public final int arcId;
    public final ArcProto protoType;
    public final Name name;
    public final TextDescriptor nameDescriptor;
    public final int tailNodeId;
    public final PortProtoId tailPortId;
    public final EPoint tailLocation;
    public final int headNodeId;
    public final PortProtoId headPortId;
    public final EPoint headLocation;
    public final double width;
    public final double length;
    public final short angle;

    ImmutableArcInst(int arcId, ArcProto protoType, Name name, TextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, double width, double length, short angle, int flags, Variable[] vars) {
        super(vars, flags);
        this.arcId = arcId;
        this.protoType = protoType;
        this.name = name;
        this.nameDescriptor = nameDescriptor;
        this.tailNodeId = tailNodeId;
        this.tailPortId = tailPortId;
        this.tailLocation = tailLocation;
        this.headNodeId = headNodeId;
        this.headPortId = headPortId;
        this.headLocation = headLocation;
        this.width = width;
        this.length = length;
        this.angle = angle;
    }

    public static ImmutableArcInst newInstance(int arcId, ArcProto protoType, Name name, TextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, double width, int angle, int flags) {
        if (arcId < 0) {
            throw new IllegalArgumentException("arcId");
        }
        if (protoType == null) {
            throw new NullPointerException("protoType");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.getBasename() != BASENAME) {
            throw new IllegalArgumentException("name");
        }
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if (tailNodeId < 0) {
            throw new IllegalArgumentException("tailNodeId");
        }
        if (tailPortId == null) {
            throw new NullPointerException("tailPortId");
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headNodeId < 0) {
            throw new IllegalArgumentException("headNodeId");
        }
        if (headPortId == null) {
            throw new NullPointerException("headPortId");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        if ((width = DBMath.round(width)) == -0.0) {
            width = 0.0;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        return new ImmutableArcInst(arcId, protoType, name, nameDescriptor, tailNodeId, tailPortId, tailLocation, headNodeId, headPortId, headLocation, width, tailLocation.distance(headLocation), ImmutableArcInst.updateAngle((short)angle, tailLocation, headLocation), flags &= DATABASE_FLAGS, Variable.NULL_ARRAY);
    }

    public ImmutableArcInst withName(Name name) {
        if (this.name.toString().equals(name.toString())) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.getBasename() != BASENAME) {
            throw new IllegalArgumentException("name");
        }
        return new ImmutableArcInst(this.arcId, this.protoType, name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withNameDescriptor(TextDescriptor nameDescriptor) {
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withLocations(EPoint tailLocation, EPoint headLocation) {
        if (this.tailLocation.equals(tailLocation) && this.headLocation.equals(headLocation)) {
            return this;
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, tailLocation, this.headNodeId, this.headPortId, headLocation, this.width, tailLocation.distance(headLocation), ImmutableArcInst.updateAngle(this.angle, tailLocation, headLocation), this.flags, this.getVars());
    }

    public ImmutableArcInst withWidth(double width) {
        if (this.width == width) {
            return this;
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if ((width = DBMath.round(width)) == -0.0) {
            width = 0.0;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, width, this.length, this.angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withAngle(int angle) {
        if (!this.tailLocation.equals(this.headLocation)) {
            return this;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        if (this.angle == angle) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, (short)angle, this.flags, this.getVars());
    }

    public ImmutableArcInst withFlags(int flags) {
        if (this.flags == (flags &= DATABASE_FLAGS)) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, flags, this.getVars());
    }

    public ImmutableArcInst withFlag(Flag flag, boolean value) {
        return this.withFlags(flag.set(this.flags, value));
    }

    public ImmutableArcInst withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags, vars);
    }

    public ImmutableArcInst withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags, vars);
    }

    ImmutableArcInst withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        PortProtoId tailPortId = this.tailPortId;
        PortProtoId headPortId = this.headPortId;
        if (tailPortId instanceof ExportId) {
            tailPortId = idMapper.get((ExportId)tailPortId);
        }
        if (headPortId instanceof ExportId) {
            headPortId = idMapper.get((ExportId)headPortId);
        }
        if (this.getVars() == vars && this.tailPortId == tailPortId && this.headPortId == headPortId) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.nameDescriptor, this.tailNodeId, tailPortId, this.tailLocation, this.headNodeId, headPortId, this.headLocation, this.width, this.length, this.angle, this.flags, vars);
    }

    private static short updateAngle(short angle, EPoint tailLocation, EPoint headLocation) {
        if (tailLocation.equals(headLocation)) {
            return angle;
        }
        return (short)DBMath.figureAngle(tailLocation, headLocation);
    }

    public boolean is(Flag flag) {
        return flag.is(this.flags);
    }

    void write(SnapshotWriter writer) throws IOException {
        writer.writeArcId(this.arcId);
        writer.writeArcProto(this.protoType);
        writer.writeNameKey(this.name);
        writer.writeTextDescriptor(this.nameDescriptor);
        writer.writeNodeId(this.tailNodeId);
        writer.writePortProtoId(this.tailPortId);
        writer.writePoint(this.tailLocation);
        writer.writeNodeId(this.headNodeId);
        writer.writePortProtoId(this.headPortId);
        writer.writePoint(this.headLocation);
        writer.writeCoord(this.width);
        writer.writeShort(this.angle);
        writer.writeInt(this.flags);
        super.write(writer);
    }

    static ImmutableArcInst read(SnapshotReader reader) throws IOException {
        int arcId = reader.readNodeId();
        ArcProto protoType = reader.readArcProto();
        Name name = reader.readNameKey();
        TextDescriptor nameDescriptor = reader.readTextDescriptor();
        int tailNodeId = reader.readNodeId();
        PortProtoId tailPortId = reader.readPortProtoId();
        EPoint tailLocation = reader.readPoint();
        int headNodeId = reader.readNodeId();
        PortProtoId headPortId = reader.readPortProtoId();
        EPoint headLocation = reader.readPoint();
        double width = reader.readCoord();
        short angle = reader.readShort();
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableArcInst.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableArcInst(arcId, protoType, name, nameDescriptor, tailNodeId, tailPortId, tailLocation, headNodeId, headPortId, headLocation, width, tailLocation.distance(headLocation), ImmutableArcInst.updateAngle(angle, tailLocation, headLocation), flags, vars);
    }

    public int hashCodeExceptVariables() {
        return this.arcId;
    }

    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableArcInst)) {
            return false;
        }
        ImmutableArcInst that = (ImmutableArcInst)o;
        return this.arcId == that.arcId && this.protoType == that.protoType && this.name == that.name && this.nameDescriptor == that.nameDescriptor && this.tailNodeId == that.tailNodeId && this.tailPortId == that.tailPortId && this.tailLocation == that.tailLocation && this.headNodeId == that.headNodeId && this.headPortId == that.headPortId && this.headLocation == that.headLocation && this.width == that.width && this.angle == that.angle && this.flags == that.flags;
    }

    public void check() {
        this.check(false);
        assert (this.arcId >= 0);
        assert (this.protoType != null);
        assert (this.name != null);
        assert (this.name.isValid() && !this.name.hasEmptySubnames());
        if (this.name.isTempname()) assert (this.name.getBasename() == BASENAME && !this.name.isBus());
        if (this.nameDescriptor != null) assert (this.nameDescriptor.isDisplay() && !this.nameDescriptor.isCode() && !this.nameDescriptor.isParam());
        assert (this.tailNodeId >= 0);
        assert (this.tailPortId != null);
        assert (this.tailLocation != null);
        assert (this.headNodeId >= 0);
        assert (this.headPortId != null);
        assert (this.headLocation != null);
        assert (this.width > 0.0 || this.width == 0.0 && 1.0 / this.width > 0.0);
        assert (DBMath.round(this.width) == this.width);
        assert ((this.flags & ~DATABASE_FLAGS) == 0);
        assert (0 <= this.angle && this.angle < 3600);
        assert (this.length == this.tailLocation.distance(this.headLocation));
    }

    public int getElibBits() {
        int elibAngle;
        boolean normalEnd;
        int elibBits = this.flags & COMMON_BITS;
        if (!HEAD_EXTENDED.is(this.flags) || !TAIL_EXTENDED.is(this.flags)) {
            elibBits |= 0x20000;
            if (HEAD_EXTENDED.is(this.flags) != TAIL_EXTENDED.is(this.flags)) {
                if (TAIL_EXTENDED.is(this.flags)) {
                    elibBits |= 0x100000;
                }
                if (HEAD_EXTENDED.is(this.flags)) {
                    elibBits |= 0x200000;
                }
            }
        }
        if (HEAD_ARROWED.is(this.flags) || TAIL_ARROWED.is(this.flags) || BODY_ARROWED.is(this.flags)) {
            elibBits |= 0x80000;
            if (TAIL_ARROWED.is(this.flags)) {
                elibBits |= 0x400000;
            }
            if (!HEAD_ARROWED.is(this.flags) && !TAIL_ARROWED.is(this.flags)) {
                elibBits |= 0x200000;
            }
        }
        boolean bl = normalEnd = (elibBits & 0x400000) == 0;
        if (TAIL_NEGATED.is(this.flags)) {
            elibBits |= normalEnd ? 262144 : 65536;
        }
        if (HEAD_NEGATED.is(this.flags)) {
            elibBits |= normalEnd ? 65536 : 262144;
        }
        if ((elibAngle = (this.angle + 5) / 10) >= 360) {
            elibAngle -= 360;
        }
        return elibBits | elibAngle << 5;
    }

    public static int flagsFromElib(int elibBits) {
        int newBits = elibBits & COMMON_BITS;
        if ((elibBits & 0x40000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? 262144 : 65536;
        }
        if ((elibBits & 0x10000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? 65536 : 262144;
        }
        if ((elibBits & 0x20000) != 0) {
            if ((elibBits & 0x100000) == 0) {
                newBits |= 0x100000;
            }
            if ((elibBits & 0x200000) == 0) {
                newBits |= 0x200000;
            }
        }
        if ((elibBits & 0x80000) != 0) {
            newBits |= 0x4000000;
            if ((elibBits & 0x400000) == 0) {
                if ((elibBits & 0x200000) == 0) {
                    newBits |= 0x80000;
                }
            } else if ((elibBits & 0x100000) == 0) {
                newBits |= 0x2000000;
            }
        }
        return newBits;
    }

    public static int angleFromElib(int elibBits) {
        int angle = (elibBits & 0x3FE0) >> 5;
        return angle % 360 * 10;
    }

    private static class FlagInv
    extends Flag {
        private FlagInv(int mask) {
            super(mask);
        }

        public boolean is(int userBits) {
            return !super.is(userBits);
        }

        public int set(int userBits, boolean value) {
            return super.set(userBits, !value);
        }
    }

    public static class Flag {
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value) {
            return value ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

