/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.CellLists;
import com.sun.electric.tool.user.dialogs.CellProperties;
import com.sun.electric.tool.user.dialogs.CrossLibCopy;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.MenuBar;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class CellMenu {
    protected static void addCellMenu(MenuBar menuBar) {
        int buckyBit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        MenuBar.Menu cellMenu = MenuBar.makeMenu("_Cell");
        menuBar.add(cellMenu);
        cellMenu.addMenuItem("Ne_w Cell...", KeyStroke.getKeyStroke(78, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.newCellCommand();
            }
        });
        cellMenu.addMenuItem("_Edit Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.editCell);
            }
        });
        cellMenu.addMenuItem("_Place Cell Instance...", KeyStroke.getKeyStroke(78, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.newInstance);
            }
        });
        cellMenu.addMenuItem("_Rename Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.renameCell);
            }
        });
        cellMenu.addMenuItem("Duplic_ate Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.duplicateCell);
            }
        });
        cellMenu.addMenuItem("De_lete Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellBrowserCommand(CellBrowser.DoAction.deleteCell);
            }
        });
        MenuBar.Menu multiPageSubMenu = MenuBar.makeMenu("_Multi-Page Cells");
        cellMenu.add(multiPageSubMenu);
        multiPageSubMenu.addMenuItem("_Make Cell Multi-Page", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.makeMultiPageCell();
            }
        });
        multiPageSubMenu.addMenuItem("_Create New Page", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.createNewMultiPage();
            }
        });
        multiPageSubMenu.addMenuItem("_Delete This Page", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.deleteThisMultiPage();
            }
        });
        multiPageSubMenu.addMenuItem("_Edit Next Page", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.editNextMultiPage();
            }
        });
        multiPageSubMenu.addMenuItem("Con_vert old-style Multi-Page Schematics", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewChanges.convertMultiPageViews();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("_Cross-Library Copy...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.crossLibraryCopyCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("_Down Hierarchy", KeyStroke.getKeyStroke(68, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.downHierCommand();
            }
        });
        cellMenu.addMenuItem("Down _Hierarchy In Place", KeyStroke.getKeyStroke(68, 0), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.downHierInPlaceCommand();
            }
        });
        cellMenu.addMenuItem("_Up Hierarchy", KeyStroke.getKeyStroke(85, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.upHierCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("New _Version of Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.newCellVersionCommand();
            }
        });
        cellMenu.addMenuItem("Duplicate Curre_nt Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.duplicateCellCommand();
            }
        });
        cellMenu.addMenuItem("Delete Unused _Old Versions", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.deleteOldCellVersionsCommand();
            }
        });
        cellMenu.addSeparator();
        MenuBar.Menu cellInfoSubMenu = MenuBar.makeMenu("Cell In_fo");
        cellMenu.add(cellInfoSubMenu);
        cellInfoSubMenu.addMenuItem("_Describe this Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.describeThisCellCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("_General Cell Lists...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.generalCellListsCommand();
            }
        });
        cellInfoSubMenu.addSeparator();
        cellInfoSubMenu.addMenuItem("List _Nodes in this Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listNodesInCellCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("List Cell _Instances", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listCellInstancesCommand();
            }
        });
        cellInfoSubMenu.addMenuItem("List Cell _Usage", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellLists.listCellUsageCommand();
            }
        });
        cellInfoSubMenu.addSeparator();
        cellInfoSubMenu.addMenuItem("Graphically, _Entire Library", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.graphCellsInLibrary();
            }
        });
        cellInfoSubMenu.addMenuItem("Graphically, _From Current Cell", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.graphCellsFromCell();
            }
        });
        cellMenu.addMenuItem("Cell Propertie_s...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellMenu.cellControlCommand();
            }
        });
        cellMenu.addSeparator();
        MenuBar.Menu expandListSubMenu = MenuBar.makeMenu("E_xpand Cell Instances");
        cellMenu.add(expandListSubMenu);
        expandListSubMenu.addMenuItem("_One Level Down", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandOneLevelDownCommand();
            }
        });
        expandListSubMenu.addMenuItem("_All the Way", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandFullCommand();
            }
        });
        expandListSubMenu.addMenuItem("_Specified Amount...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.expandSpecificCommand();
            }
        });
        MenuBar.Menu unExpandListSubMenu = MenuBar.makeMenu("Unexpand Cell Ins_tances");
        cellMenu.add(unExpandListSubMenu);
        unExpandListSubMenu.addMenuItem("_One Level Up", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandOneLevelUpCommand();
            }
        });
        unExpandListSubMenu.addMenuItem("_All the Way", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandFullCommand();
            }
        });
        unExpandListSubMenu.addMenuItem("_Specified Amount...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.unexpandSpecificCommand();
            }
        });
        cellMenu.addMenuItem("Loo_k Inside Highlighted", KeyStroke.getKeyStroke(80, buckyBit), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.peekCommand();
            }
        });
        cellMenu.addSeparator();
        cellMenu.addMenuItem("Packa_ge Into Cell...", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.packageIntoCell();
            }
        });
        cellMenu.addMenuItem("Extract Cell _Instance", null, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CircuitChanges.extractCells();
            }
        });
    }

    private static void cellControlCommand() {
        CellProperties dialog = new CellProperties((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void newCellCommand() {
        NewCell dialog = new NewCell((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    public static void cellBrowserCommand(CellBrowser.DoAction action) {
        CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), false, action);
        dialog.setVisible(true);
    }

    private static void makeMultiPageCell() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (cell.getView() != View.SCHEMATIC) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Only Schematic cells can be made multi-page", "Cannot make multipage design", 0);
            return;
        }
        SetMultiPageJob job = new SetMultiPageJob(cell, 1);
    }

    private static void createNewMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int numPages = cell.getNumMultiPages();
        SetMultiPageJob job = new SetMultiPageJob(cell, numPages + 1);
        wnd.setMultiPageNumber(numPages);
    }

    private static void deleteThisMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("This is not a multi-page schematic.  To delete this cell, use 'Cell / Delete Cell'");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        DeleteMultiPageJob job = new DeleteMultiPageJob(cell, curPage);
        int numPages = cell.getNumMultiPages();
        if (curPage >= numPages) {
            wnd.setMultiPageNumber(numPages - 1);
        }
    }

    private static void editNextMultiPage() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (!cell.isMultiPage()) {
            System.out.println("First turn this cell into a multi-page schematic");
            return;
        }
        int curPage = wnd.getMultiPageNumber();
        int numPages = cell.getNumMultiPages();
        wnd.setMultiPageNumber((curPage + 1) % numPages);
    }

    private static void crossLibraryCopyCommand() {
        CrossLibCopy dialog = new CrossLibCopy((Frame)TopLevel.getCurrentJFrame(), true);
        dialog.setVisible(true);
    }

    private static void downHierCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(false);
    }

    private static void downHierInPlaceCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.downHierarchy(true);
    }

    private static void upHierCommand() {
        EditWindow curEdit = EditWindow.needCurrent();
        if (curEdit == null) {
            return;
        }
        curEdit.upHierarchy();
    }

    private static void newCellVersionCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        CircuitChanges.newVersionOfCell(curCell);
    }

    private static void duplicateCellCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        String newName = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Name of duplicated cell", curCell.getName() + "NEW");
        if (newName == null) {
            return;
        }
        CircuitChanges.duplicateCell(curCell, newName);
    }

    private static void deleteOldCellVersionsCommand() {
        CircuitChanges.deleteUnusedOldVersions();
    }

    public static class DeleteMultiPageJob
    extends Job {
        private Cell cell;
        private int page;

        public DeleteMultiPageJob(Cell cell, int page) {
            super("Delete Page from Multi-Page Schematic", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.page = page;
            this.startJob();
        }

        public boolean doIt() {
            double lY = (double)this.page * 1000.0 - 500.0;
            double hY = lY + 1000.0;
            ArrayList<Geometric> deleteList = new ArrayList<Geometric>();
            Iterator it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (!(ni.getAnchorCenterY() > lY) || !(ni.getAnchorCenterY() < hY)) continue;
                deleteList.add(ni);
            }
            it = this.cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                double ctrY = ai.getBounds().getCenterY();
                if (!(ctrY > lY) || !(ctrY < hY)) continue;
                deleteList.add(ai);
            }
            CircuitChanges.eraseObjectsInList(this.cell, deleteList);
            int numPages = this.cell.getNumMultiPages();
            if (this.page + 1 < numPages) {
                CircuitChanges.spreadCircuitry(this.cell, null, 'u', -1000.0, 0.0, 0.0, lY, hY);
            }
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)new Integer(numPages - 1));
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                int wndPage;
                EditWindow wnd;
                WindowFrame wf = (WindowFrame)it2.next();
                if (!(wf.getContent() instanceof EditWindow) || (wnd = (EditWindow)wf.getContent()).getCell() != this.cell || (wndPage = wnd.getMultiPageNumber()) + 1 < numPages) continue;
                wnd.setMultiPageNumber(wndPage - 1);
            }
            return true;
        }
    }

    public static class SetMultiPageJob
    extends Job {
        private Cell cell;
        private int numPages;

        public SetMultiPageJob(Cell cell, int numPages) {
            super("Make Cell be Multi-Page", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.numPages = numPages;
            this.startJob();
        }

        public boolean doIt() {
            Dimension d = new Dimension(0, 0);
            if (Cell.FrameDescription.getCellFrameInfo(this.cell, d) != 0) {
                this.cell.newVar(User.FRAME_SIZE, (Object)"a");
                System.out.println("Multi-page schematics must have cell frames turned on.  Setting this to A-size.");
            }
            boolean wasMulti = this.cell.isMultiPage();
            this.cell.setMultiPage(true);
            this.cell.newVar(Cell.MULTIPAGE_COUNT_KEY, (Object)new Integer(this.numPages));
            if (!wasMulti) {
                System.out.println("Cell " + this.cell.describe(true) + " is now a multi-page schematic");
            }
            return true;
        }
    }
}

