/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HSpiceOut
extends Simulate {
    private boolean isTR0Binary;
    private boolean isTR0BinarySwapped;
    private String tr0Extension;
    private String pa0Extension;
    private int binaryTR0Size;
    private int binaryTR0Position;
    private boolean eofReached;
    private byte[] binaryTR0Buffer;

    HSpiceOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        List pa0List = this.readPA0File(fileURL);
        HSpiceOut.startProgressDialog("HSpice output", fileURL.getFile());
        Stimuli sd = this.readTR0File(fileURL, pa0List, cell);
        HSpiceOut.stopProgressDialog();
        return sd;
    }

    private List readPA0File(URL fileURL) throws IOException {
        String nextLine;
        String tr0File = fileURL.getFile();
        this.tr0Extension = "";
        this.pa0Extension = "";
        String pa0File = tr0File + ".pa0";
        int dotPos = tr0File.lastIndexOf(46);
        if (dotPos > 0) {
            this.tr0Extension = tr0File.substring(dotPos + 1);
            if (this.tr0Extension.length() > 2 && this.tr0Extension.startsWith("tr")) {
                this.pa0Extension = "pa" + this.tr0Extension.substring(2);
                pa0File = tr0File.substring(0, dotPos) + "." + this.pa0Extension;
            }
        }
        URL pa0URL = null;
        try {
            pa0URL = new URL(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPort(), pa0File);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (pa0URL == null) {
            return null;
        }
        if (!TextUtils.URLExists(pa0URL)) {
            return null;
        }
        if (this.openTextInput(pa0URL)) {
            return null;
        }
        ArrayList<PA0Line> pa0List = new ArrayList<PA0Line>();
        while ((nextLine = this.lineReader.readLine()) != null) {
            String trimLine = nextLine.trim();
            int spacePos = trimLine.indexOf(32);
            if (spacePos <= 0) continue;
            PA0Line pl = new PA0Line();
            pl.number = TextUtils.atoi(trimLine, 0, 10);
            pl.string = HSpiceOut.removeLeadingX(trimLine.substring(spacePos + 1).trim());
            pa0List.add(pl);
        }
        this.closeInput();
        return pa0List;
    }

    private Stimuli readTR0File(URL fileURL, List pa0List, Cell cell) throws IOException {
        int l;
        int j;
        int k;
        int j2;
        if (this.openBinaryInput(fileURL)) {
            return null;
        }
        int nodcnt = this.getHSpiceInt();
        int numnoi = this.getHSpiceInt();
        int cndcnt = this.getHSpiceInt();
        StringBuffer line = new StringBuffer();
        for (int j3 = 0; j3 < 4; ++j3) {
            line.append((char)this.getByteFromFile());
        }
        int multiplier = TextUtils.atoi(line.toString(), 0, 10);
        int numSignals = numnoi + (nodcnt += multiplier * 10000) - 1;
        int version = this.getHSpiceInt();
        if (version != 9007 && version != 9601) {
            System.out.println("Warning: may not be able to read HSpice files of type " + version);
        }
        for (j2 = 0; j2 < 76; ++j2) {
            k = this.getByteFromFile();
            if (this.isTR0Binary || k != 10) continue;
            --j2;
        }
        for (j2 = 0; j2 < 16; ++j2) {
            this.getByteFromFile();
        }
        for (j2 = 0; j2 < 72; ++j2) {
            k = this.getByteFromFile();
            if (this.isTR0Binary || k != 10) continue;
            --j2;
        }
        int sweepcnt = this.getHSpiceInt();
        if (cndcnt == 0) {
            sweepcnt = 0;
        }
        for (int j4 = 0; j4 < 76; ++j4) {
            int k2 = this.getByteFromFile();
            if (this.isTR0Binary || k2 != 10) continue;
            --j4;
        }
        String[] signalNames = new String[numSignals];
        int[] signalTypes = new int[numSignals];
        for (int k3 = 0; k3 <= numSignals; ++k3) {
            line = new StringBuffer();
            for (j = 0; j < 8; ++j) {
                l = this.getByteFromFile();
                line.append((char)l);
                if (this.isTR0Binary || l != 10) continue;
                --j;
            }
            if (k3 == 0) continue;
            int l2 = k3 - nodcnt;
            if (k3 < nodcnt) {
                l2 = k3 + numnoi - 1;
            }
            signalTypes[l2] = TextUtils.atoi(line.toString(), 0, 10);
        }
        boolean pa0MissingWarned = false;
        for (int k4 = 0; k4 <= numSignals; ++k4) {
            int lastDot;
            StringBuffer newSB;
            int l3;
            int j5 = 0;
            line = new StringBuffer();
            while (true) {
                if ((l3 = this.getByteFromFile()) == 10) {
                    continue;
                }
                if (l3 == 32) break;
                line.append((char)l3);
                if (version == 9007 && ++j5 >= 16) break;
            }
            l3 = (j5 + 16) / 16 * 16 - 1;
            if (version == 9007) {
                l3 = (j5 + 15) / 16 * 16 - 1;
            }
            while (j5 < l3) {
                int i = this.getByteFromFile();
                if (!this.isTR0Binary && i == 10) {
                    --j5;
                }
                ++j5;
            }
            if (k4 == 0) continue;
            int startPos = 0;
            int openPos = line.indexOf("(");
            if (openPos >= 0) {
                startPos = openPos + 1;
            }
            for (j5 = startPos; j5 < line.length() && line.charAt(j5) != ':' && TextUtils.isDigit(line.charAt(j5)); ++j5) {
            }
            if (j5 < line.length() && line.charAt(j5) == ':') {
                l3 = TextUtils.atoi(line.toString().substring(startPos), 0, 10);
                PA0Line foundPA0Line = null;
                if (pa0List == null) {
                    if (!pa0MissingWarned) {
                        System.out.println("ERROR: there should be a ." + this.pa0Extension + " file with extra signal names");
                    }
                    pa0MissingWarned = true;
                } else {
                    Iterator it = pa0List.iterator();
                    while (it.hasNext()) {
                        PA0Line pa0Line = (PA0Line)it.next();
                        if (pa0Line.number != l3) continue;
                        foundPA0Line = pa0Line;
                        break;
                    }
                }
                if (foundPA0Line != null) {
                    newSB = new StringBuffer();
                    newSB.append(line.substring(0, startPos));
                    newSB.append(foundPA0Line.string);
                    newSB.append(line.substring(j5 + 1));
                    line = newSB;
                }
            } else if (line.indexOf(".") >= 0) {
                String fixedLine = HSpiceOut.removeLeadingX(line.toString());
                line = new StringBuffer();
                line.append(fixedLine);
            }
            openPos = line.indexOf("(");
            if (openPos >= 0 && (lastDot = line.lastIndexOf(".")) >= 0) {
                newSB = new StringBuffer();
                newSB.append(line.substring(openPos + 1, lastDot + 1));
                newSB.append(line.substring(0, openPos + 1));
                newSB.append(line.substring(lastDot + 1));
                line = newSB;
            }
            l3 = k4 < nodcnt ? k4 + numnoi - 1 : k4 - nodcnt;
            signalNames[l3] = line.toString();
        }
        if (cndcnt != 0) {
            j = 0;
            line = new StringBuffer();
            while (true) {
                if ((l = this.getByteFromFile()) == 10) {
                    continue;
                }
                if (l == 32) break;
                line.append((char)l);
                if (++j >= 16) break;
            }
            l = (j + 15) / 16 * 16 - 1;
            while (j < l) {
                int i = this.getByteFromFile();
                if (!this.isTR0Binary && i == 10) {
                    --j;
                }
                ++j;
            }
        }
        line = new StringBuffer();
        if (!this.isTR0Binary) {
            j = 0;
            while ((l = this.getByteFromFile()) != 10) {
                if (j < 4) {
                    line.append(l);
                }
                ++j;
            }
        } else {
            for (j = 0; j < 4; ++j) {
                line.append((char)this.getByteFromFile());
            }
        }
        if (!line.toString().equals("$&%#")) {
            System.out.println("HSpice header improperly terminated (got " + line.toString() + ")");
            this.closeInput();
            return null;
        }
        this.resetBinaryTR0Reader();
        HSpiceStimuli sd = new HSpiceStimuli();
        sd.setCell(cell);
        for (int k5 = 0; k5 < numSignals; ++k5) {
            HSpiceAnalogSignal as = new HSpiceAnalogSignal(sd, k5);
            int lastDotPos = signalNames[k5].lastIndexOf(46);
            if (lastDotPos >= 0) {
                as.setSignalContext(signalNames[k5].substring(0, lastDotPos));
                as.setSignalName(signalNames[k5].substring(lastDotPos + 1));
                continue;
            }
            as.setSignalName(signalNames[k5]);
        }
        ArrayList theSweeps = new ArrayList();
        int sweepCounter = sweepcnt;
        while (true) {
            if (sweepcnt > 0) {
                float sweepValue = this.getHSpiceFloat();
                if (this.eofReached) break;
                sd.addSweep(new Double(sweepValue));
            }
            ArrayList<float[]> allTheData = new ArrayList<float[]>();
            while (true) {
                float[] oneSetOfData = new float[numSignals + 1];
                float time = this.getHSpiceFloat();
                if (this.eofReached) break;
                oneSetOfData[0] = time;
                for (int k6 = 0; k6 < numSignals; ++k6) {
                    float value = this.getHSpiceFloat();
                    if (this.eofReached) break;
                    oneSetOfData[(k6 + numnoi) % numSignals + 1] = value;
                }
                if (this.eofReached) break;
                allTheData.add(oneSetOfData);
            }
            theSweeps.add(allTheData);
            if (--sweepCounter <= 0) break;
            this.eofReached = false;
        }
        this.closeInput();
        sd.data = new float[theSweeps.size()][][];
        for (int i = 0; i < sd.data.length; ++i) {
            ArrayList allTheData = (ArrayList)theSweeps.get(i);
            float[][] d = new float[allTheData.size()][];
            for (int j6 = 0; j6 < d.length; ++j6) {
                d[j6] = (float[])allTheData.get(j6);
            }
            sd.data[i] = d;
        }
        return sd;
    }

    private void resetBinaryTR0Reader() {
        this.binaryTR0Size = 0;
        this.binaryTR0Position = 0;
    }

    private boolean readBinaryTR0Block(boolean firstbyteread) throws IOException {
        int amtread;
        int i;
        if (!firstbyteread && this.dataInputStream.read() == -1) {
            return true;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int blocks = 0;
        for (i = 0; i < 4; ++i) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            blocks = this.isTR0BinarySwapped ? blocks >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : blocks << 8 | uval;
        }
        this.updateProgressDialog(4);
        for (i = 0; i < 4; ++i) {
            if (this.dataInputStream.read() != -1) continue;
            return true;
        }
        this.updateProgressDialog(4);
        int bytes = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            bytes = this.isTR0BinarySwapped ? bytes >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : bytes << 8 | uval;
        }
        this.updateProgressDialog(4);
        if (bytes > 8192) {
            System.out.println("ERROR: block is " + bytes + " long, but limit is 8192");
            bytes = 8192;
        }
        if ((amtread = this.dataInputStream.read(this.binaryTR0Buffer, 0, bytes)) != bytes) {
            return true;
        }
        this.updateProgressDialog(bytes);
        int trailer = 0;
        for (int i4 = 0; i4 < 4; ++i4) {
            int uval = this.dataInputStream.read();
            if (uval == -1) {
                return true;
            }
            trailer = this.isTR0BinarySwapped ? trailer >> 8 & 0xFFFFFF | (uval & 0xFF) << 24 : trailer << 8 | uval;
        }
        if (trailer != bytes) {
            return true;
        }
        this.updateProgressDialog(4);
        this.binaryTR0Position = 0;
        this.binaryTR0Size = bytes;
        return false;
    }

    private int getByteFromFile() throws IOException {
        int i;
        if (this.byteCount == 0L) {
            i = this.dataInputStream.read();
            if (i == -1) {
                return i;
            }
            this.updateProgressDialog(1);
            if (i == 0 || i == 4) {
                this.isTR0Binary = true;
                this.isTR0BinarySwapped = false;
                if (i == 4) {
                    this.isTR0BinarySwapped = true;
                }
                this.binaryTR0Buffer = new byte[8192];
                if (this.readBinaryTR0Block(true)) {
                    return -1;
                }
            } else {
                this.isTR0Binary = false;
                return i;
            }
        }
        if (this.isTR0Binary) {
            if (this.binaryTR0Position >= this.binaryTR0Size && this.readBinaryTR0Block(false)) {
                return -1;
            }
            byte val = this.binaryTR0Buffer[this.binaryTR0Position];
            ++this.binaryTR0Position;
            return val & 0xFF;
        }
        i = this.dataInputStream.read();
        this.updateProgressDialog(1);
        return i;
    }

    private int getHSpiceInt() throws IOException {
        StringBuffer line = new StringBuffer();
        for (int j = 0; j < 4; ++j) {
            line.append((char)this.getByteFromFile());
        }
        return TextUtils.atoi(line.toString().trim(), 0, 10);
    }

    private float getHSpiceFloat() throws IOException {
        if (!this.isTR0Binary) {
            StringBuffer line = new StringBuffer();
            for (int j = 0; j < 11; ++j) {
                int l = this.getByteFromFile();
                if (l == -1) {
                    this.eofReached = true;
                    return 0.0f;
                }
                line.append((char)l);
                if (l != 10) continue;
                --j;
            }
            String result = line.toString();
            if (result.equals("0.10000E+31")) {
                this.eofReached = true;
                return 0.0f;
            }
            return (float)TextUtils.atof(result);
        }
        int fi0 = this.getByteFromFile();
        int fi1 = this.getByteFromFile();
        int fi2 = this.getByteFromFile();
        int fi3 = this.getByteFromFile();
        if (fi0 < 0 || fi1 < 0 || fi2 < 0 || fi3 < 0) {
            this.eofReached = true;
            return 0.0f;
        }
        int fi = 0;
        fi = this.isTR0BinarySwapped ? fi3 << 24 | fi2 << 16 | fi1 << 8 | fi0 : (fi0 &= 0xFF) << 24 | (fi1 &= 0xFF) << 16 | (fi2 &= 0xFF) << 8 | (fi3 &= 0xFF);
        float f = Float.intBitsToFloat(fi);
        if ((double)f > 1.0E30 && (double)f < 1.00000002E30) {
            this.eofReached = true;
            return 0.0f;
        }
        return f;
    }

    private static class HSpiceAnalogSignal
    extends AnalogSignal {
        int signalIndex;

        HSpiceAnalogSignal(Stimuli sd, int signalIndex) {
            super(sd);
            this.signalIndex = signalIndex;
        }

        public void getEvent(int sweep, int index, double[] result) {
            ((HSpiceStimuli)this.sd).getEvent(sweep, index, this.signalIndex, result);
        }

        public int getNumEvents(int sweep) {
            return ((HSpiceStimuli)this.sd).data[sweep].length;
        }

        public int getNumSweeps() {
            return ((HSpiceStimuli)this.sd).data.length;
        }
    }

    private static class HSpiceStimuli
    extends Stimuli {
        float[][][] data;

        private HSpiceStimuli() {
        }

        private void getEvent(int sweep, int index, int signalIndex, double[] result) {
            float[] d = this.data[sweep][index];
            result[0] = d[0];
            result[1] = result[2] = (double)d[signalIndex + 1];
        }
    }

    private static class PA0Line {
        int number;
        String string;

        private PA0Line() {
        }
    }
}

