/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.technology.Layer;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PolyMerge
extends GeometryHandler {
    public void add(Object key, Object value, boolean fasterAlgorithm) {
        Layer layer = (Layer)key;
        PolyBase poly = (PolyBase)value;
        this.addPolygon(layer, poly);
    }

    public void addPolygon(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            area = new Area();
            this.layers.put(layer, area);
        }
        Area additionalArea = new Area(poly);
        area.add(additionalArea);
    }

    public void subtract(Object layer, Object poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return;
        }
        Area subtractArea = new Area((PolyBase)poly);
        area.subtract(subtractArea);
    }

    public void addAll(GeometryHandler subMerge, AffineTransform trans) {
        PolyMerge other = (PolyMerge)subMerge;
        this.addMerge(other, trans);
    }

    public void addMerge(PolyMerge other, AffineTransform trans) {
        Iterator it = other.layers.keySet().iterator();
        while (it.hasNext()) {
            Layer subLayer = (Layer)it.next();
            Area subArea = (Area)other.layers.get(subLayer);
            Area area = (Area)this.layers.get(subLayer);
            if (area == null) {
                area = new Area();
                this.layers.put(subLayer, area);
            }
            Area newArea = subArea.createTransformedArea(trans);
            area.add(newArea);
        }
    }

    public boolean intersects(Layer layer, PolyBase poly) {
        Area layerArea = (Area)this.layers.get(layer);
        if (layerArea == null) {
            return false;
        }
        Rectangle2D box = poly.getBox();
        if (box != null) {
            return layerArea.intersects(box);
        }
        Area intersectArea = new Area(poly);
        intersectArea.intersect(layerArea);
        return !intersectArea.isEmpty();
    }

    public void intersectLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.intersect(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void subtractLayers(Layer sourceA, Layer sourceB, Layer dest) {
        Area sourceAreaB;
        Area destArea = null;
        Area sourceAreaA = (Area)this.layers.get(sourceA);
        if (sourceAreaA != null && (sourceAreaB = (Area)this.layers.get(sourceB)) != null) {
            destArea = new Area(sourceAreaA);
            destArea.subtract(sourceAreaB);
            if (destArea.isEmpty()) {
                destArea = null;
            }
        }
        if (destArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, destArea);
        }
    }

    public void insetLayer(Layer source, Layer dest, double amount) {
        Area sourceArea = (Area)this.layers.get(source);
        if (sourceArea == null) {
            this.layers.remove(dest);
        } else {
            this.layers.put(dest, sourceArea.clone());
            if (amount == 0.0) {
                return;
            }
            List orig = PolyMerge.getAreaPoints(sourceArea, source, true);
            Point2D[] subtractPoints = new Point2D[4];
            Iterator it = orig.iterator();
            while (it.hasNext()) {
                PolyBase poly = (PolyBase)it.next();
                Point2D[] points = poly.getPoints();
                for (int i = 0; i < points.length; ++i) {
                    Point2D thisPt;
                    Point2D lastPt;
                    int last = i - 1;
                    if (last < 0) {
                        last = points.length - 1;
                    }
                    if (DBMath.areEquals(lastPt = points[last], thisPt = points[i])) continue;
                    int angle = DBMath.figureAngle(lastPt, thisPt);
                    int perpAngle = (angle + 2700) % 3600;
                    double offsetX = DBMath.cos(perpAngle) * amount;
                    double offsetY = DBMath.sin(perpAngle) * amount;
                    Point2D.Double insetLastPt = new Point2D.Double(lastPt.getX() + offsetX, lastPt.getY() + offsetY);
                    Point2D.Double insetThisPt = new Point2D.Double(thisPt.getX() + offsetX, thisPt.getY() + offsetY);
                    subtractPoints[0] = lastPt;
                    subtractPoints[1] = thisPt;
                    subtractPoints[2] = insetThisPt;
                    subtractPoints[3] = insetLastPt;
                    PolyBase subtractPoly = new PolyBase(subtractPoints);
                    this.subtract(dest, subtractPoly);
                }
            }
        }
    }

    public void deleteLayer(Layer layer) {
        this.layers.remove(layer);
    }

    public boolean isEmpty(Layer layer) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return true;
        }
        return area.isEmpty();
    }

    public boolean contains(Layer layer, Rectangle2D rect) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        return area.contains(rect);
    }

    public boolean contains(Layer layer, PolyBase poly) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        Area polyArea = new Area(poly);
        polyArea.subtract(area);
        if (polyArea.isEmpty()) {
            return true;
        }
        double remainingArea = this.getAreaOfArea(polyArea);
        return DBMath.areEquals(remainingArea, 0.0);
    }

    private double getAreaOfArea(Area area) {
        List pointList = PolyMerge.getAreaPoints(area, null, true);
        double totalArea = 0.0;
        Iterator iit = pointList.iterator();
        while (iit.hasNext()) {
            PolyBase p = (PolyBase)iit.next();
            totalArea += p.getArea();
        }
        return totalArea;
    }

    public boolean contains(Layer layer, Point2D pt) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return false;
        }
        return area.contains(pt);
    }

    public Iterator getKeyIterator() {
        return this.layers.keySet().iterator();
    }

    public Collection getKeySet() {
        return this.layers.keySet();
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        return this.getMergedPoints((Layer)layer, simple);
    }

    public List getMergedPoints(Layer layer, boolean simple) {
        Area area = (Area)this.layers.get(layer);
        if (area == null) {
            return null;
        }
        return PolyMerge.getAreaPoints(area, layer, simple);
    }

    public static List getAreaPoints(Area area, Layer layer, boolean simple) {
        ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
        double[] coords = new double[6];
        ArrayList<Point2D> pointList = new ArrayList<Point2D>();
        Point2D.Double lastMoveTo = null;
        boolean isSingular = area.isSingular();
        ArrayList<PolyBase> toDelete = new ArrayList<PolyBase>();
        PathIterator pIt = area.getPathIterator(null);
        while (!pIt.isDone()) {
            int type = pIt.currentSegment(coords);
            if (type == 4) {
                if (lastMoveTo != null) {
                    pointList.add(lastMoveTo);
                }
                Point2D[] points = new Point2D[pointList.size()];
                int i = 0;
                Iterator it = pointList.iterator();
                while (it.hasNext()) {
                    points[i++] = (Point2D)it.next();
                }
                PolyBase poly = new PolyBase(points);
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                lastMoveTo = null;
                toDelete.clear();
                if (!simple && !isSingular) {
                    Iterator it2 = polyList.iterator();
                    while (it2.hasNext()) {
                        PolyBase pn = (PolyBase)it2.next();
                        if (!pn.contains((Point2D)pointList.get(0)) && !poly.contains(pn.getPoints()[0])) continue;
                        points = pn.getPoints();
                        for (i = 0; i < points.length; ++i) {
                            pointList.add(points[i]);
                        }
                        Point2D[] newPoints = new Point2D[pointList.size()];
                        System.arraycopy(pointList.toArray(), 0, newPoints, 0, pointList.size());
                        poly = new PolyBase(newPoints);
                        toDelete.add(pn);
                    }
                }
                if (poly != null) {
                    polyList.add(poly);
                }
                polyList.removeAll(toDelete);
                pointList.clear();
            } else if (type == 0 || type == 1) {
                Point2D.Double pt = new Point2D.Double(coords[0], coords[1]);
                pointList.add(pt);
                if (type == 0) {
                    lastMoveTo = pt;
                }
            }
            pIt.next();
        }
        if (Main.LOCALDEBUGFLAG) {
            List newList = PolyBase.getPointsInArea(area, layer, simple, true, null);
            if (newList.size() != polyList.size()) {
                System.out.println("Error in getPointsInArea");
            } else {
                boolean foundError = false;
                Iterator it = polyList.iterator();
                while (it.hasNext()) {
                    PolyBase poly = (PolyBase)it.next();
                    boolean found = false;
                    Iterator iter = polyList.iterator();
                    while (iter.hasNext()) {
                        PolyBase poly1 = (PolyBase)iter.next();
                        if (!poly1.polySame(poly)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundError = true;
                    break;
                }
                if (foundError) {
                    System.out.println("Error in getPointsInArea");
                }
            }
        }
        return polyList;
    }
}

