/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ToolBar;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class ClickAndDragListener
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    public static ClickAndDragListener theOne = new ClickAndDragListener();
    private int oldx;
    private int oldy;
    private boolean doingMotionDrag;
    private boolean invertSelection;

    private ClickAndDragListener() {
    }

    public void mousePressed(MouseEvent evt) {
        this.oldx = evt.getX();
        this.oldy = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        boolean another = (evt.getModifiers() & 2) != 0;
        this.invertSelection = (evt.getModifiers() & 1) != 0;
        boolean special = ToolBar.getSelectSpecial();
        if (evt.getClickCount() == 2 && !another && !this.invertSelection && Highlight.getNumHighlights() >= 1) {
            EditMenu.getInfoCommand();
            return;
        }
        this.doingMotionDrag = false;
        if (ToolBar.getSelectMode() == ToolBar.SelectMode.OBJECTS) {
            if (!another && !this.invertSelection && Highlight.overHighlighted(wnd, this.oldx, this.oldy)) {
                this.doingMotionDrag = true;
                return;
            }
            Point2D pt = wnd.screenToDatabase(this.oldx, this.oldy);
            int numFound = Highlight.findObject(pt, wnd, false, another, this.invertSelection, true, false, special, true);
            if (numFound == 0) {
                wnd.setStartDrag(this.oldx, this.oldy);
                wnd.setEndDrag(this.oldx, this.oldy);
                wnd.setDoingAreaDrag();
            }
        } else {
            wnd.setStartDrag(this.oldx, this.oldy);
            wnd.setEndDrag(this.oldx, this.oldy);
            wnd.setDoingAreaDrag();
        }
        wnd.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (wnd.isDoingAreaDrag()) {
            Point2D start = wnd.screenToDatabase((int)wnd.getStartDrag().getX(), (int)wnd.getStartDrag().getY());
            Point2D end = wnd.screenToDatabase((int)wnd.getEndDrag().getX(), (int)wnd.getEndDrag().getY());
            double minSelX = Math.min(start.getX(), end.getX());
            double maxSelX = Math.max(start.getX(), end.getX());
            double minSelY = Math.min(start.getY(), end.getY());
            double maxSelY = Math.max(start.getY(), end.getY());
            if (!this.invertSelection) {
                Highlight.clear();
            }
            if (ToolBar.getSelectMode() == ToolBar.SelectMode.OBJECTS) {
                Highlight.selectArea(wnd, minSelX, maxSelX, minSelY, maxSelY, this.invertSelection, ToolBar.getSelectSpecial());
            } else {
                Highlight.addArea(new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY), cell);
            }
            Highlight.finished();
            wnd.clearDoingAreaDrag();
            wnd.repaint();
        }
        if (this.doingMotionDrag) {
            this.doingMotionDrag = false;
            int newX = evt.getX();
            int newY = evt.getY();
            Point2D delta = wnd.deltaScreenToDatabase(newX - this.oldx, newY - this.oldy);
            EditWindow.gridAlign(delta);
            if (delta.getX() == 0.0 && delta.getY() == 0.0) {
                return;
            }
            Highlight.setHighlightOffset(0, 0);
            CircuitChanges.manyMove(delta.getX(), delta.getY());
            wnd.repaint();
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        int newX = evt.getX();
        int newY = evt.getY();
        EditWindow wnd = (EditWindow)evt.getSource();
        Point2D delta = wnd.deltaScreenToDatabase(newX - this.oldx, newY - this.oldy);
        EditWindow.gridAlign(delta);
        Point pt = wnd.deltaDatabaseToScreen(delta.getX(), delta.getY());
        newX = this.oldx + pt.x;
        newY = this.oldy + pt.y;
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (this.doingMotionDrag) {
            Highlight.setHighlightOffset(newX - this.oldx, newY - this.oldy);
            wnd.repaint();
            return;
        }
        if (wnd.isDoingAreaDrag()) {
            wnd.setEndDrag(newX, newY);
            wnd.repaint();
            return;
        }
        this.oldx = newX;
        this.oldy = newY;
        wnd.repaint();
    }

    public void mouseWheelMoved(MouseWheelEvent evt) {
        int clicks = evt.getWheelRotation();
        System.out.println("Mouse wheel rolled by " + clicks);
    }

    public void keyPressed(KeyEvent evt) {
        int chr = evt.getKeyCode();
        EditWindow wnd = (EditWindow)evt.getSource();
        Cell cell = wnd.getCell();
        if (cell == null) {
            return;
        }
        if (chr == 127 || chr == 8) {
            CircuitChanges.deleteSelected();
        } else if (chr == 37) {
            this.moveSelected(evt, -1.0, 0.0);
        } else if (chr == 39) {
            this.moveSelected(evt, 1.0, 0.0);
        } else if (chr == 38) {
            this.moveSelected(evt, 0.0, 1.0);
        } else if (chr == 40) {
            this.moveSelected(evt, 0.0, -1.0);
        }
        if (chr == 65 && this.doingMotionDrag) {
            this.doingMotionDrag = false;
            Highlight.setHighlightOffset(0, 0);
            wnd.repaint();
            System.out.println("Aborted");
        }
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    private void moveSelected(KeyEvent evt, double dX, double dY) {
        EditWindow wnd = (EditWindow)evt.getSource();
        double arrowDistance = ToolBar.getArrowDistance();
        dX *= arrowDistance;
        dY *= arrowDistance;
        int scale = User.getDefGridXBoldFrequency();
        if (evt.isShiftDown()) {
            dX *= (double)scale;
            dY *= (double)scale;
        }
        if (evt.isControlDown()) {
            dX *= (double)scale;
            dY *= (double)scale;
        }
        Highlight.setHighlightOffset(0, 0);
        CircuitChanges.manyMove(dX, dY);
        wnd.repaintContents(null);
    }
}

