/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LibraryTab
extends PreferencePanel {
    private int initialBackupState;
    private JRadioButton backupAll;
    private ButtonGroup backupGroup;
    private JRadioButton backupOneLevel;
    private JCheckBox checkAfterWrite;
    private JPanel library;
    private JRadioButton noBackup;

    public LibraryTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.library;
    }

    public String getName() {
        return "Library";
    }

    public void init() {
        this.initialBackupState = IOTool.getBackupRedundancy();
        switch (this.initialBackupState) {
            case 0: {
                this.noBackup.setSelected(true);
                break;
            }
            case 1: {
                this.backupOneLevel.setSelected(true);
                break;
            }
            case 2: {
                this.backupAll.setSelected(true);
            }
        }
        this.checkAfterWrite.setEnabled(false);
    }

    public void term() {
        int currentBackupState = 0;
        if (this.noBackup.isSelected()) {
            currentBackupState = 0;
        } else if (this.backupOneLevel.isSelected()) {
            currentBackupState = 1;
        } else if (this.backupAll.isSelected()) {
            currentBackupState = 2;
        }
        if (currentBackupState != this.initialBackupState) {
            IOTool.setBackupRedundancy(currentBackupState);
        }
    }

    private void initComponents() {
        this.backupGroup = new ButtonGroup();
        this.library = new JPanel();
        this.noBackup = new JRadioButton();
        this.backupOneLevel = new JRadioButton();
        this.backupAll = new JRadioButton();
        this.checkAfterWrite = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LibraryTab.this.closeDialog(evt);
            }
        });
        this.library.setLayout(new GridBagLayout());
        this.noBackup.setText("No backup of library files");
        this.backupGroup.add(this.noBackup);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.library.add((Component)this.noBackup, gridBagConstraints);
        this.backupOneLevel.setText("Backup of last library file");
        this.backupGroup.add(this.backupOneLevel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.library.add((Component)this.backupOneLevel, gridBagConstraints);
        this.backupAll.setText("Backup history of library files");
        this.backupGroup.add(this.backupAll);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.library.add((Component)this.backupAll, gridBagConstraints);
        this.checkAfterWrite.setText("Check database after write");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.library.add((Component)this.checkAfterWrite, gridBagConstraints);
        this.getContentPane().add((Component)this.library, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

