/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class Job
implements ActionListener,
Runnable {
    private static final boolean DEBUG = false;
    private static final int MIN_NUM_SECONDS = 60000;
    private static DatabaseChangesThread databaseChangesThread = new DatabaseChangesThread();
    private static Job changingJob;
    private DefaultMutableTreeNode myNode;
    private boolean deleteWhenDone;
    private boolean display;
    protected long startTime;
    protected long endTime;
    private boolean started;
    private boolean finished;
    private boolean aborted;
    private boolean scheduledToAbort;
    private boolean reportExecution = false;
    private String jobName;
    private Tool tool;
    private Type jobType;
    private Priority priority;
    private Cell upCell;
    private Cell downCell;
    private String status = null;
    private String progress = null;
    private List savedHighlights;
    private Point2D savedHighlightsOffset;

    public Job(String jobName, Tool tool, Type jobType, Cell upCell, Cell downCell, Priority priority) {
        if (downCell != null) {
            upCell = null;
        }
        this.jobName = jobName;
        this.tool = tool;
        this.jobType = jobType;
        this.priority = priority;
        this.upCell = upCell;
        this.downCell = downCell;
        this.endTime = 0L;
        this.startTime = 0L;
        this.scheduledToAbort = false;
        this.aborted = false;
        this.finished = false;
        this.started = false;
        this.myNode = null;
        this.savedHighlights = new ArrayList();
        if (jobType == Type.CHANGE || jobType == Type.UNDO) {
            this.saveHighlights();
        }
    }

    public void startJob() {
        this.startJob(true, true);
    }

    public void startJob(boolean display, boolean deleteWhenDone) {
        this.display = display;
        this.deleteWhenDone = deleteWhenDone;
        if (display) {
            this.myNode = new DefaultMutableTreeNode(this);
        }
        Job.databaseChangesThread.addJob(this);
    }

    public abstract boolean doIt();

    private void lockDatabase() {
    }

    private void unlockDatabase() {
    }

    protected void setReportExecutionFlag(boolean flag) {
        this.reportExecution = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block14: {
            block16: {
                block15: {
                    this.startTime = System.currentTimeMillis();
                    try {
                        block13: {
                            try {
                                if (this.jobType == Type.CHANGE) {
                                    Undo.startChanges(this.tool, this.jobName, this.upCell, this.savedHighlights, this.savedHighlightsOffset);
                                }
                                if (this.jobType != Type.EXAMINE) {
                                    changingJob = this;
                                }
                                this.doIt();
                                if (this.jobType != Type.CHANGE) break block13;
                                Undo.endChanges();
                            }
                            catch (Throwable e) {
                                this.endTime = System.currentTimeMillis();
                                String[] msg = new String[]{"Exception Caught!!!", "Job \"" + this.jobName + "\" generated the following Exception (see Messages Window):", e.toString()};
                                e.printStackTrace(System.out);
                                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), msg, "Exception in Job " + this.jobName, 0);
                                Object var4_2 = null;
                                if (this.jobType == Type.EXAMINE) {
                                    Job.databaseChangesThread.endExamine(this);
                                } else {
                                    changingJob = null;
                                    Library.clearChangeLocks();
                                }
                                this.endTime = System.currentTimeMillis();
                                break block14;
                            }
                        }
                        Object var4_1 = null;
                        if (this.jobType != Type.EXAMINE) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        if (this.jobType == Type.EXAMINE) {
                            Job.databaseChangesThread.endExamine(this);
                        } else {
                            changingJob = null;
                            Library.clearChangeLocks();
                        }
                        this.endTime = System.currentTimeMillis();
                        throw throwable;
                    }
                    Job.databaseChangesThread.endExamine(this);
                    break block16;
                }
                changingJob = null;
                Library.clearChangeLocks();
            }
            this.endTime = System.currentTimeMillis();
        }
        this.finished = true;
        WindowFrame.wantToRedoJobTree();
        if (this.reportExecution || this.endTime - this.startTime >= 60000L) {
            if (User.isBeepAfterLongJobs()) {
                Toolkit.getDefaultToolkit().beep();
            }
            System.out.println(this.getInfo());
        }
        if (this.deleteWhenDone) {
            Job.databaseChangesThread.removeJob(this);
        }
    }

    protected synchronized void setProgress(String progress) {
        this.progress = progress;
        WindowFrame.wantToRedoJobTree();
    }

    private synchronized String getProgress() {
        return this.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void abort() {
        if (this.aborted) {
            System.out.println("Job already aborted: " + this.getStatus());
            return;
        }
        this.scheduledToAbort = true;
        WindowFrame.wantToRedoJobTree();
    }

    private void saveHighlights() {
        this.savedHighlights.clear();
        Iterator it = Highlight.getHighlights();
        while (it.hasNext()) {
            this.savedHighlights.add(it.next());
        }
        this.savedHighlightsOffset = Highlight.getHighlightOffset();
    }

    protected synchronized void setAborted() {
        this.aborted = true;
        WindowFrame.wantToRedoJobTree();
    }

    protected synchronized boolean getScheduledToAbort() {
        return this.scheduledToAbort;
    }

    public synchronized boolean getAborted() {
        return this.aborted;
    }

    public boolean getDisplay() {
        return this.display;
    }

    public boolean getDeleteWhenDone() {
        return this.deleteWhenDone;
    }

    public static Iterator getAllJobs() {
        return databaseChangesThread.getAllJobs();
    }

    public String getStatus() {
        if (!this.started) {
            return "waiting";
        }
        if (this.finished) {
            return "done";
        }
        if (this.aborted) {
            return "aborted";
        }
        if (this.scheduledToAbort) {
            return "scheduled to abort";
        }
        if (this.getProgress() == null) {
            return "running";
        }
        return this.getProgress();
    }

    public static Thread getChangingThread() {
        return changingJob != null ? databaseChangesThread : null;
    }

    public static Cell getChangingCell() {
        return changingJob != null ? Job.changingJob.upCell : null;
    }

    public static void checkChanging() {
        if (changingJob == null) {
            System.out.println("Database is changing but no change job is running");
        } else if (Thread.currentThread() != databaseChangesThread) {
            System.out.println("Database is changing by other thread");
        } else if (Job.changingJob.upCell != null) {
            System.out.println("Database is changing which only up-tree of " + Job.changingJob.upCell + " is locked");
        }
    }

    public String toString() {
        return this.jobName + " (" + this.getStatus() + ")";
    }

    public static DefaultMutableTreeNode getExplorerTree() {
        return databaseChangesThread.getExplorerTree();
    }

    public JPopupMenu getPopupStatus() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem m = new JMenuItem("Get Info");
        m.addActionListener(this);
        popup.add(m);
        m = new JMenuItem("Abort");
        m.addActionListener(this);
        popup.add(m);
        m = new JMenuItem("Delete");
        m.addActionListener(this);
        popup.add(m);
        return popup;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals("Get Info")) {
            System.out.println(this.getInfo());
        }
        if (source.getText().equals("Abort")) {
            this.abort();
        }
        if (source.getText().equals("Delete")) {
            if (!this.finished && !this.aborted) {
                System.out.println("Cannot delete running jobs.  Wait till finished or abort");
                return;
            }
            Job.databaseChangesThread.removeJob(this);
        }
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString() + "\n");
        Date start = new Date(this.startTime);
        buf.append("  start time: " + start + "\n");
        if (this.finished) {
            Date end = new Date(this.endTime);
            buf.append("  end time: " + end + "\n");
            long time = this.endTime - this.startTime;
            buf.append("  time taken: " + TextUtils.getElapsedTime(time) + "\n");
        }
        return buf.toString();
    }

    private static class DatabaseChangesThread
    extends Thread {
        private static ArrayList allJobs = new ArrayList();
        private static int numStarted = 0;
        private static int numExamine = 0;
        private static String jobNode = "JOBS";

        DatabaseChangesThread() {
            super("Database");
            this.start();
        }

        public void run() {
            while (true) {
                Job job = this.waitChangeJob();
                job.run();
            }
        }

        private synchronized Job waitChangeJob() {
            while (true) {
                if (numStarted < allJobs.size()) {
                    Job job = (Job)allJobs.get(numStarted);
                    if (job.scheduledToAbort || job.aborted) {
                        this.removeJob(job);
                        continue;
                    }
                    if (job.jobType == Type.EXAMINE) {
                        job.started = true;
                        ++numStarted;
                        ++numExamine;
                        Thread t = new Thread((Runnable)job, job.jobName);
                        t.start();
                        continue;
                    }
                    if (numExamine == 0) {
                        job.started = true;
                        ++numStarted;
                        if (job.upCell != null) {
                            job.upCell.setChangeLock();
                        }
                        return job;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private synchronized void addJob(Job j) {
            if (numStarted == allJobs.size()) {
                this.notify();
            }
            allJobs.add(j);
            if (j.getDisplay()) {
                WindowFrame.wantToRedoJobTree();
            }
        }

        private synchronized void removeJob(Job j) {
            int index = allJobs.indexOf(j);
            if (index != -1) {
                allJobs.remove(index);
                if (index == numStarted) {
                    this.notify();
                }
                if (index < numStarted) {
                    --numStarted;
                }
            }
            if (j.getDisplay()) {
                WindowFrame.wantToRedoJobTree();
            }
        }

        public synchronized DefaultMutableTreeNode getExplorerTree() {
            DefaultMutableTreeNode explorerTree = new DefaultMutableTreeNode(jobNode);
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                Job j = (Job)it.next();
                if (!j.getDisplay()) continue;
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(j);
                j.myNode.setUserObject(null);
                j.myNode = node;
                explorerTree.add(node);
            }
            return explorerTree;
        }

        private synchronized void endExamine(Job j) {
            if (--numExamine == 0) {
                this.notify();
            }
        }

        public synchronized Iterator getAllJobs() {
            ArrayList jobsList = new ArrayList();
            Iterator it = allJobs.iterator();
            while (it.hasNext()) {
                jobsList.add(it.next());
            }
            return jobsList.iterator();
        }
    }

    public static class Priority {
        private final String name;
        private final int level;
        public static final Priority USER = new Priority("user", 1);
        public static final Priority VISCHANGES = new Priority("visible-changes", 2);
        public static final Priority INVISCHANGES = new Priority("invisble-changes", 3);
        public static final Priority ANALYSIS = new Priority("analysis", 4);

        private Priority(String name, int level) {
            this.name = name;
            this.level = level;
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static class Type {
        private final String name;
        public static final Type CHANGE = new Type("change");
        public static final Type UNDO = new Type("undo");
        public static final Type EXAMINE = new Type("examine");

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

