/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public abstract class Geometric
extends ElectricObject {
    private static final int MINRTNODESIZE = 4;
    private static final int MAXRTNODESIZE = 8;
    protected Cell parent;
    protected Name name;
    private TextDescriptor nameDescriptor = this instanceof NodeInst ? TextDescriptor.getNodeTextDescriptor(this) : TextDescriptor.getArcTextDescriptor(this);
    protected Rectangle2D visBounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private Object tempObj;
    private int tempInt;
    protected int userBits = 0;
    private int flagBits;
    private int changeClock;
    private Undo.Change change;
    private static FlagSet.Generator flagGenerator = new FlagSet.Generator("Geometric");

    protected void linkGeom(Cell parnt) {
        RTNode rtn = parnt.getRTree();
        while (!rtn.getFlag()) {
            double bestExpand = 0.0;
            int bestSubNode = 0;
            for (int i = 0; i < rtn.getTotal(); ++i) {
                RTNode subrtn = (RTNode)rtn.getChild(i);
                Rectangle2D bounds = subrtn.getBounds();
                double area = bounds.getWidth() * bounds.getHeight();
                Rectangle2D.Double newUnion = new Rectangle2D.Double();
                Rectangle2D.union(this.visBounds, bounds, newUnion);
                double newArea = ((RectangularShape)newUnion).getWidth() * ((RectangularShape)newUnion).getHeight();
                double expand = newArea - area;
                if (i != 0 && expand > bestExpand) continue;
                bestExpand = expand;
                bestSubNode = i;
            }
            rtn = (RTNode)rtn.getChild(bestSubNode);
        }
        rtn.addToRTNode(this, parnt);
    }

    protected void unLinkGeom(Cell parnt) {
        RTNode whichRTN = null;
        int whichInd = 0;
        Object[] result = parnt.getRTree().findGeom(this);
        if (result != null) {
            whichRTN = (RTNode)result[0];
            whichInd = (Integer)result[1];
        } else {
            result = parnt.getRTree().findGeomAnywhere(this);
            if (result == null) {
                System.out.println("Internal error: cannot find " + this.describe() + " in R-Tree of " + parnt.describe());
                return;
            }
            whichRTN = (RTNode)result[0];
            whichInd = (Integer)result[1];
            System.out.println("Internal warning: " + this.describe() + " not in proper R-Tree location in cell " + parnt.describe());
        }
        whichRTN.removeRTNode(whichInd, parnt);
    }

    protected Geometric() {
    }

    protected void setParent(Cell parent) {
        this.parent = parent;
    }

    public String describe() {
        return "?";
    }

    public void checkChanging() {
        if (this.parent != null) {
            this.parent.checkChanging();
        }
    }

    public Cell whichCell() {
        return this.parent;
    }

    protected boolean inDatabase() {
        return this.parent != null;
    }

    public void getInfo() {
        System.out.println(" Bounds: (" + this.visBounds.getCenterX() + "," + this.visBounds.getCenterY() + "), size: " + this.visBounds.getWidth() + "x" + this.visBounds.getHeight());
        System.out.println(" Parent cell: " + this.parent.describe());
        super.getInfo();
    }

    public Cell getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name != null ? this.name.toString() : null;
    }

    public Name getNameKey() {
        return this.name;
    }

    public boolean setName(String name) {
        Name key = null;
        if (name != null && name != "") {
            key = Name.findName(name);
        }
        return this.setNameKey(key);
    }

    public boolean setNameKey(Name name) {
        if (name == null) {
            if (!this.isLinked()) {
                this.name = null;
                return false;
            }
            name = this.parent.getAutoname(this.getBasename());
        }
        if (!name.isValid()) {
            System.out.println(this.parent + ": Invalid name \"" + name + "\" wasn't assigned to " + (this instanceof NodeInst ? "node" : "arc") + " :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isTempname() && name.isBus()) {
            System.out.println(this.parent + ": Temporary name \"" + name + "\" can't be bus");
            return true;
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(this.parent + ": Name \"" + name + "\" with empty subnames wasn't assigned to " + (this instanceof NodeInst ? "node" : "arc"));
            } else {
                System.out.println(this.parent + ": Cannot assign empty name \"" + name + "\" to " + this.describe());
            }
            return true;
        }
        if (this.isLinked() && this.parent.hasTempName(name)) {
            System.out.println(this.parent + " already has Geometric with temporary name \"" + name + "\"");
            return true;
        }
        if (this.isLinked()) {
            Name oldName = this.name;
            this.lowLevelSetNameKey(name);
            Undo.renameObject(this, oldName);
        } else {
            this.name = name;
        }
        return false;
    }

    public void lowLevelSetNameKey(Name name) {
        if (!this.isUsernamed()) {
            this.parent.removeTempName(this);
        }
        this.name = name;
        if (!this.isUsernamed()) {
            this.parent.addTempName(this);
        }
    }

    public abstract boolean isLinked();

    public abstract Name getBasename();

    public TextDescriptor getNameTextDescriptor() {
        return this.nameDescriptor;
    }

    public void setNameTextDescriptor(TextDescriptor descriptor) {
        this.nameDescriptor.copy(descriptor);
    }

    public boolean isUsernamed() {
        return this.name != null && !this.name.isTempname();
    }

    public Rectangle2D getBounds() {
        return this.visBounds;
    }

    public double getTrueCenterX() {
        return this.visBounds.getCenterX();
    }

    public double getTrueCenterY() {
        return this.visBounds.getCenterY();
    }

    public Point2D getTrueCenter() {
        return new Point2D.Double(this.visBounds.getCenterX(), this.visBounds.getCenterY());
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.userBits = userBits;
    }

    public void copyStateBits(Geometric geom) {
        this.userBits = geom.userBits;
    }

    public static FlagSet getFlagSet(int numBits) {
        return FlagSet.getFlagSet(flagGenerator, numBits);
    }

    public void setBit(FlagSet set) {
        this.flagBits |= set.getMask();
    }

    public void clearBit(FlagSet set) {
        this.flagBits &= set.getUnmask();
    }

    public void setFlagValue(FlagSet set, int value) {
        this.flagBits = this.flagBits & set.getUnmask() | value << set.getShift() & set.getMask();
    }

    public int getFlagValue(FlagSet set) {
        return (this.flagBits & set.getMask()) >> set.getShift();
    }

    public boolean isBit(FlagSet set) {
        return (this.flagBits & set.getMask()) != 0;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public void setTempInt(int tempInt) {
        this.tempInt = tempInt;
    }

    public void setTempObj(Object tempObj) {
        this.tempObj = tempObj;
    }

    public Object getTempObj() {
        return this.tempObj;
    }

    public void setChangeClock(int changeClock) {
        this.changeClock = changeClock;
    }

    public int getChangeClock() {
        return this.changeClock;
    }

    public void setChange(Undo.Change change) {
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        return super.numDisplayableVariables(multipleStrings) + (this.isUsernamed() ? 1 : 0);
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow wnd, boolean multipleStrings) {
        int numVars = 0;
        if (this.isUsernamed()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            double offX = this.nameDescriptor.getXOff();
            double offY = this.nameDescriptor.getYOff();
            TextDescriptor.Position pos = this.nameDescriptor.getPos();
            Poly.Type style = pos.getPolyType();
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.name.toString());
            polys[start].setTextDescriptor(this.nameDescriptor);
            polys[start].setLayer(null);
            polys[start].setName(this.name);
            numVars = 1;
        }
        return super.addDisplayableVariables(rect, polys, start + numVars, wnd, multipleStrings) + numVars;
    }

    public static class RTNode {
        private Rectangle2D bounds;
        private int total;
        private Object[] pointers = new Object[8];
        private boolean flag;
        private RTNode parent;
        private static int branchCount;

        private RTNode() {
            this.bounds = new Rectangle2D.Double();
        }

        private int getTotal() {
            return this.total;
        }

        private void setTotal(int total) {
            this.total = total;
        }

        private RTNode getParent() {
            return this.parent;
        }

        private void setParent(RTNode parent) {
            this.parent = parent;
        }

        private Object getChild(int index) {
            return this.pointers[index];
        }

        private void setChild(int index, Object obj) {
            this.pointers[index] = obj;
        }

        private boolean getFlag() {
            return this.flag;
        }

        private void setFlag(boolean flag) {
            this.flag = flag;
        }

        private Rectangle2D getBounds() {
            return this.bounds;
        }

        private void setBounds(Rectangle2D bounds) {
            this.bounds.setRect(bounds);
        }

        private void unionBounds(Rectangle2D bounds) {
            Rectangle2D.union(this.bounds, bounds, this.bounds);
        }

        public static RTNode makeTopLevel() {
            RTNode top = new RTNode();
            top.total = 0;
            top.flag = true;
            top.parent = null;
            return top;
        }

        public void printRTree(int indent) {
            if (indent == 0) {
                branchCount = 0;
            }
            String line = "";
            for (int i = 0; i < indent; ++i) {
                line = line + " ";
            }
            line = line + "RTNode";
            if (this.flag) {
                line = line + " NUMBER " + ++branchCount;
            }
            line = line + " X(" + this.bounds.getMinX() + "-" + this.bounds.getMaxX() + ") Y(" + this.bounds.getMinY() + "-" + this.bounds.getMaxY() + ") has " + this.total + " children:";
            System.out.println(line);
            for (int j = 0; j < this.total; ++j) {
                if (this.flag) {
                    line = "";
                    for (int i = 0; i < indent + 3; ++i) {
                        line = line + " ";
                    }
                    Geometric child = (Geometric)this.getChild(j);
                    child.setTempInt(branchCount);
                    Rectangle2D childBounds = child.getBounds();
                    line = line + "Child X(" + childBounds.getMinX() + "-" + childBounds.getMaxX() + ") Y(" + childBounds.getMinY() + "-" + childBounds.getMaxY() + ") is " + child.describe();
                    System.out.println(line);
                    continue;
                }
                ((RTNode)this.getChild(j)).printRTree(indent + 3);
            }
        }

        public void checkRTree(int level, Cell cell) {
            int i;
            Rectangle2D.Double localBounds = new Rectangle2D.Double();
            if (this.total == 0) {
                ((Rectangle2D)localBounds).setRect(0.0, 0.0, 0.0, 0.0);
            } else {
                ((Rectangle2D)localBounds).setRect(this.getBBox(0));
                for (i = 1; i < this.total; ++i) {
                    Rectangle2D.union(localBounds, this.getBBox(i), localBounds);
                }
            }
            if (!localBounds.equals(this.bounds) && (Math.abs(localBounds.getMinX() - this.bounds.getMinX()) >= 1.0E-4 || Math.abs(localBounds.getMinY() - this.bounds.getMinY()) >= 1.0E-4 || Math.abs(((RectangularShape)localBounds).getWidth() - this.bounds.getWidth()) >= 1.0E-4 || Math.abs(((RectangularShape)localBounds).getHeight() - this.bounds.getHeight()) >= 1.0E-4)) {
                System.out.println("Tree of " + cell.describe() + " at level " + level + " has bounds " + localBounds + " but stored bounds are " + this.bounds);
                for (i = 0; i < this.total; ++i) {
                    System.out.println("  ---Child " + i + " is " + this.getBBox(i));
                }
            }
            if (!this.flag) {
                for (int j = 0; j < this.total; ++j) {
                    ((RTNode)this.getChild(j)).checkRTree(level + 1, cell);
                }
            }
        }

        private Rectangle2D getBBox(int child) {
            if (this.flag) {
                Geometric geom = (Geometric)this.pointers[child];
                return geom.getBounds();
            }
            RTNode subrtn = (RTNode)this.pointers[child];
            return subrtn.getBounds();
        }

        private void figBounds() {
            if (this.total == 0) {
                this.bounds.setRect(0.0, 0.0, 0.0, 0.0);
                return;
            }
            this.bounds.setRect(this.getBBox(0));
            for (int i = 1; i < this.total; ++i) {
                this.unionBounds(this.getBBox(i));
            }
        }

        private void addToRTNode(Object rtnInsert, Cell cell) {
            Rectangle2D bounds;
            if (this.getTotal() >= 8) {
                RTNode temp = new RTNode();
                temp.setTotal(this.getTotal());
                temp.setFlag(this.getFlag());
                for (int i = 0; i < this.getTotal(); ++i) {
                    temp.setChild(i, this.getChild(i));
                }
                if (rtnInsert instanceof Geometric) {
                    Geometric geom = (Geometric)rtnInsert;
                    bounds = geom.getBounds();
                } else {
                    RTNode subrtn = (RTNode)rtnInsert;
                    bounds = subrtn.getBounds();
                }
                Point2D.Double thisCenter = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                double newDist = 0.0;
                int newN = 0;
                for (int i = 0; i < temp.getTotal(); ++i) {
                    Rectangle2D thisv = temp.getBBox(i);
                    double dist = thisCenter.distance(thisv.getCenterX(), thisv.getCenterY());
                    if (!(dist >= newDist)) continue;
                    newDist = dist;
                    newN = i;
                }
                bounds = temp.getBBox(newN);
                thisCenter = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                double oldDist = 0.0;
                int oldN = 0;
                for (int i = 0; i < temp.getTotal(); ++i) {
                    Rectangle2D thisv;
                    double dist;
                    if (i == newN || !((dist = thisCenter.distance((thisv = temp.getBBox(i)).getCenterX(), thisv.getCenterY())) >= oldDist)) continue;
                    oldDist = dist;
                    oldN = i;
                }
                RTNode newrtn = new RTNode();
                newrtn.setFlag(this.getFlag());
                newrtn.setParent(this.getParent());
                Object obj = temp.getChild(newN);
                temp.setChild(newN, null);
                newrtn.setChild(0, obj);
                newrtn.setTotal(1);
                if (!newrtn.getFlag()) {
                    ((RTNode)obj).setParent(newrtn);
                }
                Rectangle2D newBounds = newrtn.getBBox(0);
                newrtn.setBounds(newBounds);
                double newArea = newBounds.getWidth() * newBounds.getHeight();
                obj = temp.getChild(oldN);
                temp.setChild(oldN, null);
                this.setChild(0, obj);
                for (int i = 1; i < this.getTotal(); ++i) {
                    this.setChild(i, null);
                }
                this.setTotal(1);
                if (!this.getFlag()) {
                    ((RTNode)obj).setParent(this);
                }
                Rectangle2D oldBounds = this.getBBox(0);
                this.setBounds(oldBounds);
                double oldArea = oldBounds.getWidth() * oldBounds.getHeight();
                while (true) {
                    int curPos;
                    int i;
                    int bestNewNode = -1;
                    int bestOldNode = -1;
                    double bestNewExpand = 0.0;
                    double bestOldExpand = 0.0;
                    for (i = 0; i < temp.getTotal(); ++i) {
                        obj = temp.getChild(i);
                        if (obj == null) continue;
                        bounds = temp.getBBox(i);
                        Rectangle2D.Double newUnion = new Rectangle2D.Double();
                        Rectangle2D.Double oldUnion = new Rectangle2D.Double();
                        Rectangle2D.union(newBounds, bounds, newUnion);
                        Rectangle2D.union(oldBounds, bounds, oldUnion);
                        double newAreaPlus = ((RectangularShape)newUnion).getWidth() * ((RectangularShape)newUnion).getHeight();
                        double oldAreaPlus = ((RectangularShape)oldUnion).getWidth() * ((RectangularShape)oldUnion).getHeight();
                        if (bestNewNode < 0 || newAreaPlus - newArea < bestNewExpand) {
                            bestNewExpand = newAreaPlus - newArea;
                            bestNewNode = i;
                        }
                        if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                        bestOldExpand = oldAreaPlus - oldArea;
                        bestOldNode = i;
                    }
                    if (bestNewNode == -1 && bestOldNode == -1) break;
                    if (bestNewNode == bestOldNode) {
                        bestOldNode = -1;
                        for (i = 0; i < temp.getTotal(); ++i) {
                            if (i == bestNewNode || (obj = temp.getChild(i)) == null) continue;
                            bounds = temp.getBBox(i);
                            Rectangle2D.Double oldUnion = new Rectangle2D.Double();
                            Rectangle2D.union(oldBounds, bounds, oldUnion);
                            double oldAreaPlus = ((RectangularShape)oldUnion).getWidth() * ((RectangularShape)oldUnion).getHeight();
                            if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                            bestOldExpand = oldAreaPlus - oldArea;
                            bestOldNode = i;
                        }
                    }
                    if (bestOldNode != -1) {
                        obj = temp.getChild(bestOldNode);
                        temp.setChild(bestOldNode, null);
                        curPos = this.getTotal();
                        this.setChild(curPos, obj);
                        this.setTotal(curPos + 1);
                        if (!this.getFlag()) {
                            ((RTNode)obj).setParent(this);
                        }
                        this.unionBounds(this.getBBox(curPos));
                        oldBounds = this.getBounds();
                        oldArea = oldBounds.getWidth() * oldBounds.getHeight();
                    }
                    if (bestNewNode == -1) continue;
                    obj = temp.getChild(bestNewNode);
                    temp.setChild(bestNewNode, null);
                    curPos = newrtn.getTotal();
                    newrtn.setChild(curPos, obj);
                    newrtn.setTotal(curPos + 1);
                    if (!newrtn.getFlag()) {
                        ((RTNode)obj).setParent(newrtn);
                    }
                    newrtn.unionBounds(newrtn.getBBox(curPos));
                    newBounds = newrtn.getBounds();
                    newArea = newBounds.getWidth() * newBounds.getHeight();
                }
                if (temp.getTotal() != this.getTotal() + newrtn.getTotal()) {
                    System.out.println("R-trees: " + temp.getTotal() + " nodes split to " + this.getTotal() + " and " + newrtn.getTotal() + "!");
                }
                if (this.getParent() == null) {
                    RTNode newroot = new RTNode();
                    newroot.setTotal(2);
                    newroot.setChild(0, this);
                    newroot.setChild(1, newrtn);
                    newroot.setFlag(false);
                    newroot.setParent(null);
                    this.setParent(newroot);
                    newrtn.setParent(newroot);
                    newroot.figBounds();
                    cell.setRTree(newroot);
                } else {
                    for (RTNode r = this.getParent(); r != null; r = r.getParent()) {
                        r.figBounds();
                    }
                    this.getParent().addToRTNode(newrtn, cell);
                }
            }
            int curPos = this.getTotal();
            this.setChild(curPos, rtnInsert);
            this.setTotal(curPos + 1);
            bounds = this.getBBox(curPos);
            if (this.getTotal() == 1 && this.getParent() == null) {
                this.setBounds(bounds);
                return;
            }
            RTNode climb = this;
            while (true) {
                climb.unionBounds(bounds);
                if (climb.getParent() == null) break;
                climb = climb.getParent();
            }
        }

        private void removeRTNode(int ind, Cell cell) {
            int j = 0;
            for (int i = 0; i < this.getTotal(); ++i) {
                if (i == ind) continue;
                this.setChild(j++, this.getChild(i));
            }
            this.setTotal(j);
            if (this.getTotal() < 4) {
                RTNode prtn = this.getParent();
                if (prtn == null) {
                    int i;
                    if (this.getFlag()) {
                        this.figBounds();
                        return;
                    }
                    RTNode temp = new RTNode();
                    temp.setTotal(this.getTotal());
                    temp.setFlag(true);
                    for (i = 0; i < this.getTotal(); ++i) {
                        temp.setChild(i, this.getChild(i));
                    }
                    this.setTotal(0);
                    this.setFlag(true);
                    for (i = 0; i < temp.getTotal(); ++i) {
                        ((RTNode)temp.getChild(i)).reInsert(cell);
                    }
                    return;
                }
                int found = -1;
                for (int i = 0; i < prtn.getTotal(); ++i) {
                    if (prtn.getChild(i) != this) continue;
                    found = i;
                    break;
                }
                if (found < 0) {
                    System.out.println("R-trees: cannot find entry in parent");
                }
                prtn.removeRTNode(found, cell);
                this.reInsert(cell);
                return;
            }
            RTNode climb = this;
            while (true) {
                climb.figBounds();
                if (climb.getParent() == null) break;
                climb = climb.getParent();
            }
        }

        private void reInsert(Cell cell) {
            if (this.getFlag()) {
                for (int i = 0; i < this.getTotal(); ++i) {
                    ((Geometric)this.getChild(i)).linkGeom(cell);
                }
            } else {
                for (int i = 0; i < this.getTotal(); ++i) {
                    ((RTNode)this.getChild(i)).reInsert(cell);
                }
            }
        }

        private Object[] findGeom(Geometric geom) {
            if (this.getFlag()) {
                for (int i = 0; i < this.getTotal(); ++i) {
                    if (this.getChild(i) != geom) continue;
                    Object[] retObj = new Object[]{this, new Integer(i)};
                    return retObj;
                }
                return null;
            }
            Rectangle2D geomBounds = geom.getBounds();
            for (int i = 0; i < this.getTotal(); ++i) {
                Object[] subRet;
                Rectangle2D bounds = this.getBBox(i);
                if (bounds.getMaxX() < geomBounds.getMinX() || bounds.getMinX() > geomBounds.getMaxX() || bounds.getMaxY() < geomBounds.getMinY() || bounds.getMinY() > geomBounds.getMaxY() || (subRet = ((RTNode)this.getChild(i)).findGeom(geom)) == null) continue;
                return subRet;
            }
            return null;
        }

        private Object[] findGeomAnywhere(Geometric geom) {
            if (this.getFlag()) {
                for (int i = 0; i < this.getTotal(); ++i) {
                    if (this.getChild(i) != geom) continue;
                    Object[] retVal = new Object[]{this, new Integer(i)};
                    return retVal;
                }
                return null;
            }
            for (int i = 0; i < this.getTotal(); ++i) {
                Object[] retVal = ((RTNode)this.getChild(i)).findGeomAnywhere(geom);
                if (retVal == null) continue;
                return retVal;
            }
            return null;
        }
    }

    public static class Search
    implements Iterator {
        private static final int MAXDEPTH = 100;
        private int depth = 0;
        private RTNode[] rtn = new RTNode[100];
        private int[] position = new int[100];
        private Rectangle2D searchBounds;
        private Geometric nextObj;

        public Search(Rectangle2D bounds, Cell cell) {
            this.rtn[0] = cell.getRTree();
            this.searchBounds = new Rectangle2D.Double();
            this.searchBounds.setRect(bounds);
            this.nextObj = null;
        }

        private Geometric nextObject() {
            while (true) {
                int i;
                RTNode rtnode = this.rtn[this.depth];
                int n = this.depth;
                this.position[n] = this.position[n] + 1;
                if (i < rtnode.getTotal()) {
                    Rectangle2D nodeBounds = rtnode.getBBox(i);
                    if (nodeBounds.getMaxX() < this.searchBounds.getMinX() || nodeBounds.getMinX() > this.searchBounds.getMaxX() || nodeBounds.getMaxY() < this.searchBounds.getMinY() || nodeBounds.getMinY() > this.searchBounds.getMaxY()) continue;
                    if (rtnode.getFlag()) {
                        return (Geometric)rtnode.getChild(i);
                    }
                    if (this.depth >= 99) {
                        System.out.println("R-trees: search too deep");
                        continue;
                    }
                    ++this.depth;
                    this.rtn[this.depth] = (RTNode)rtnode.getChild(i);
                    this.position[this.depth] = 0;
                    continue;
                }
                if (this.depth == 0) break;
                --this.depth;
            }
            return null;
        }

        public boolean hasNext() {
            if (this.nextObj == null) {
                this.nextObj = this.nextObject();
            }
            return this.nextObj != null;
        }

        public Object next() {
            if (this.nextObj != null) {
                Geometric ret = this.nextObj;
                this.nextObj = null;
                return ret;
            }
            return this.nextObject();
        }

        public void remove() {
            throw new UnsupportedOperationException("Search.remove()");
        }
    }
}

