/*
 * Electric(tm) VLSI Design System
 *
 * File: network.h
 * Network tool: header file for fully instantiated networks
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

extern INTBIG      net_ncc_optionskey;			/* key for "NET_ncc_options" */
extern INTBIG      net_lastgoodncckey;			/* key for "NET_last_good_ncc" */
extern INTBIG      net_ncc_comptolerancekey;	/* key for "NET_ncc_component_tolerance" */

/* the meaning of aid:network.NET_ncc_options */
#define NCCHIERARCHICAL            01			/* set to expand hierarchy during NCC */
#define NCCUSEPORTNAMES            02			/* set to use port names during NCC */
#define NCCVERBOSE                010			/* set to dump information during NCC */
#define NCCIGNOREPWRGND           020			/* set to ignore power/ground during NCC */
#define NCCRECURSE                040			/* set to do NCC recursively */
#define NCCUSEPORTNAMESOVER      0100			/* set to override port names use for a facet */
#define NCCIGNOREPWRGNDOVER      0400			/* set to override P&G ignoring for a facet */
#define NCCCHECKSIZE            01000			/* set to check component size during NCC */
#define NCCCHECKSIZEOVER        02000			/* set to override check component size check for a facet */
#define NCCNOMERGEPARALLEL      04000			/* set to not merge parallel components during NCC */
#define NCCNOMERGEPARALLELOVER 010000			/* set to override parallel component nonmerge for a facet */

/*********************** EQUIVALENCE MODULES ***********************/

#define NOEQUIV ((EQUIV *)-1)

typedef struct Iequiv
{
	NODEINST      *first;					/* component */
	NODEINST      *second;					/* component */
	struct Iequiv *nextequiv;				/* next in list */
} EQUIV;

extern EQUIV *net_firstequiv;

/*********************** PCOMP MODULES ***********************/

#define NOPCOMP ((PCOMP *)-1)

/* meaning of PCOMP->state */
#define NEGATEDPORT  1				/* if port is negated */
#define EXPORTEDPORT 2				/* if port is exported */

typedef struct Ipcomp
{
	INTBIG           numactual;			/* number of components associated with this */
	void            *actuallist;		/* actual components */
	NODEINST        *topactual;			/* actual component at topmost level */
	INTSML           function;			/* component function */
	INTSML           hassize;			/* whether this component has size information */
	INTSML           wirecount;			/* number of unconnected ports (wires) */
	float            length;			/* length/size of component */
	float            width;				/* width of component (if FET) */
	INTBIG           id;				/* local data for component */
	INTSML          *portindices;		/* normalized indices for each wire */
	PORTPROTO      **portlist;			/* PORTPROTOs on each wire */
	struct Ipnet   **netnumbers;		/* initial netnumbers for each wire */
	INTSML          *state;				/* information about the connection */
	INTSML          *count;				/* connection count on each wire */
	struct Ipcomp ***pconnarray;		/* array of connections */
	INTSML         **portindexarray;	/* array of normalized indices on the other component */
	struct Ipcomp   *nextinbucket;		/* next in bucket list */
	struct Ipcomp   *nextpcomp;			/* next in list of pseudocomponents */
} PCOMP;
extern PCOMP *net_pcompfree;

/*********************** PNET MODULES ***********************/

#define NOPNET ((PNET *)-1)

/* meaning of PNET->flags */
#define POWERNET      1				/* if net is power */
#define GROUNDNET     2				/* if net is ground */
#define EXPORTEDNET   4				/* if net is exported */
#define USEDNET     010				/* if net is used */

typedef struct Ipnet
{
	INTSML         flags;			/* state bits */
	PORTPROTO     *realport;		/* top-level port on this net (if any) */
	NETWORK       *network;			/* real network that this references */
	struct Ipnet  *nextpnet;		/* next in list */
} PNET;
extern PNET *net_pnetfree;

/*********************** BUCKET MODULES (for NCC) ***********************/

#define NOBUCKET ((BUCKET *)-1)

typedef struct Ibucket
{
	INTSML          bucketid;				/* id of this bucket */
	INTSML          function;				/* function of this component */
	INTSML          hassize;				/* 1: has fractional size, 2: has pure size */
	INTSML          complete;				/* nonzero if bucket is complete */
	float           length;					/* length/size of this component */
	float           width;					/* width of this component (if FET) */
	INTSML          wirecount;				/* number of wires on this component */
	INTSML          net1count;				/* number of components from net 1 */
	PCOMP          *net1list;				/* linked list of net 1 components */
	INTSML          net2count;				/* number of components from net 2 */
	PCOMP          *net2list;				/* linked list of net 2 components */
	struct Ibucket *nextbucket;				/* next in list */
} BUCKET;

/*********************** AREAPERIM and TRANSISTORINFO MODULES ***********************/

#define NOAREAPERIM ((AREAPERIM *)-1)

typedef struct Iareaperim
{
	float              area;
	INTBIG             perimeter;
	INTSML             layer;
	TECHNOLOGY        *tech;
	struct Iareaperim *nextareaperim;
} AREAPERIM;

typedef struct
{
	INTBIG count;			/* number of transistors found */
	INTBIG area;			/* sum of area of transistors */
	INTBIG width;			/* sum of width of transistors */
	INTBIG length;			/* sum of length of transistors */
} TRANSISTORINFO;

/* prototypes for tool interface */
void net_init(INTBIG*, char*[], AIDENTRY*);
void net_done(void);
INTSML net_set(INTSML, char*[]);
INTBIG net_request(char*, va_list);
void net_examinenodeproto(NODEPROTO*);
void net_slice(void);
void net_startbatch(AIDENTRY*, INTSML);
void net_endbatch(void);
void net_modifyportproto(PORTPROTO*, NODEINST*, PORTPROTO*);
void net_newobject(INTBIG, INTBIG);
void net_killobject(INTBIG, INTBIG);
void net_newvariable(INTBIG, INTBIG, INTBIG, INTBIG);
void net_killvariable(INTBIG, INTBIG, INTBIG, INTBIG, INTBIG, INTBIG);
void net_readlibrary(LIBRARY*);
void net_eraselibrary(LIBRARY*);

/* prototypes for intratool interface */
INTBIG   net_getfunction(NODEINST*);
NETWORK *net_gethighlightednet(INTSML, INTSML);
void     net_freeallpcomp(PCOMP*);
void     net_freeallpnet(PNET*);
PCOMP   *net_makepseudo(NODEPROTO*, INTBIG*, INTBIG*, INTBIG*, INTBIG*, PNET**,
			INTSML, INTSML, INTSML, INTSML, INTSML);
AREAPERIM *net_gathergeometry(NETWORK *net, TRANSISTORINFO **p_gate, TRANSISTORINFO **n_gate,
			TRANSISTORINFO **p_active, TRANSISTORINFO **n_active);
INTSML   net_equate(INTSML);
INTSML   net_compare(void);
INTSML   net_setfirst(void);
INTSML   net_setsecond(void);
INTSML   net_setequiv(void);
INTSML   net_clearequiv(void);
INTBIG   net_buswidth(char*);
void     net_reevaluatefacet(NODEPROTO*);
INTBIG   net_evalbusname(INTBIG, char*, char***, ARCINST*, NODEPROTO*, INTBIG);
void     net_freediffmemory(void);
void     net_freeflatmemory(void);
INTSML   net_diffwirelist(PCOMP*, PCOMP*, BUCKET*, BUCKET*, INTSML);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
