/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : STREAM1
    Description :
    Author      :
    Date        :
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class STREAM1
***************************************************
*/
 
/*
***************************************************
  Method Declaration for class 
***************************************************
*/
 
ESint32 EDMAPROC 
STREAMopenZZrS32(OBJID IdObj, EPChar Name, EPChar Mode)
{
  EPChar       c[2] = {NULL,NULL};
  EChar        OutSys[50], pName[255];
  EPChar       Aux;
  POBJ         pObj;

  /* parse implementation information*/
  Aux = strchr (Name, ')');
  memset (OutSys, 0, 50);
  strncpy (OutSys, Name + 1, (Aux - Name - 1));
  edma_printf_obj (IdObj, "-OPEN-Output System : %s", OutSys);
  /* Mutating object */
  c[0] = OutSys;
  pObj = edma_get_obj_pobj (IdObj);

  edma_printf_obj (IdObj, "[%s] Name: '%s' OutputSystem: '%s' Classid: %d", 
		   __FUNCTION__, Name, OutSys, edma_get_class_id (Name));
  edma_add_subclass (IdObj, edma_get_class_id (OutSys), 
		     "IMP", NULL);
  /* Get resource name*/
  strncpy (pName, Aux + 1, (Name + strlen (Name)) - Aux + 1);
  edma_printf_obj (IdObj, "-OPEN-Resource name : %s", pName);
  
  /* Auto-override virtual methods*/
  /* Open isn't override, is this method and it is that does object mutation*/

  /* When we modify EDMA to automatically override upper virtual methods
     this code'll disappear... it's been used for testing purpouses*/
  /* TEST: This sill be done by EDMA*/
  /*
  OverMet3 (IdObj,"close", "IMP<close");
  OverMet3 (IdObj,"read",  "IMP<read");
  OverMet3 (IdObj,"write", "IMP<write");
  OverMet3 (IdObj,"puts",  "IMP<puts");
  OverMet3 (IdObj,"putc",  "IMP<putc");
  OverMet3 (IdObj,"gets",  "IMP<gets");
  OverMet3 (IdObj,"getc",  "IMP<getc");
  OverMet3 (IdObj,"flush", "IMP<flush");
  OverMet3 (IdObj,"seek",  "IMP<seek");
  OverMet3 (IdObj,"tell",  "IMP<tell");
  OverMet3 (IdObj,"rewind","IMP<rewind");
  OverMet3 (IdObj,"eof",   "IMP<eof");
  OverMet3 (IdObj,"error", "IMP<error");
  OverMet3 (IdObj,"Load",  "IMP<Load");
  OverMet3 (IdObj,"Save",  "IMP<Save");
  */
  /* Real stream open...*/
  edma_met3 (IdObj, "IMP<open", pName, Mode);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
