#line 424 "../grecs/build-aux/getopt.m4"
/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/
#line 1 "cmdline.opt"
/* This file is part of GNU Dico. -*- c -*-
   Copyright (C) 1998-2000, 2008, 2010, 2012, 2016-2018 Sergey
   Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#include <dicod.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <getopt.h>
#include <gettext.h>

static struct grecs_txtacc *pp_cmd_acc;

#line 189 "cmdline.opt"

#line 189

#line 189
#ifdef HAVE_CONFIG_H
#line 189
# include <config.h>
#line 189
#endif
#line 189
#ifdef HAVE_GETOPT_H
#line 189
# include <getopt.h>
#line 189
#endif
#line 189
#include <unistd.h>
#line 189

#line 189
#include <grecs.h>
#line 189
#include <grecs/opt.h>
#line 189
/* Option codes */
#line 189
enum {
#line 189
	_OPTION_INIT=255,
#line 189
	#line 66 "cmdline.opt"

#line 66
	OPTION_CONFIG,
#line 78 "cmdline.opt"

#line 78
	OPTION_STDERR,
#line 84 "cmdline.opt"

#line 84
	OPTION_SYSLOG,
#line 112 "cmdline.opt"

#line 112
	OPTION_NO_TRANSCRIPT,
#line 125 "cmdline.opt"

#line 125
	OPTION_SOURCE_INFO,
#line 131 "cmdline.opt"

#line 131
	OPTION_TRACE_GRAMMAR,
#line 137 "cmdline.opt"

#line 137
	OPTION_TRACE_LEX,
#line 145 "cmdline.opt"

#line 145
	OPTION_CONFIG_HELP,
#line 154 "cmdline.opt"

#line 154
	OPTION_PREPROCESSOR,
#line 160 "cmdline.opt"

#line 160
	OPTION_NO_PREPROCESSOR,
#line 189 "cmdline.opt"

#line 189
	OPTION_USAGE,

#line 189 "cmdline.opt"
	MAX_OPTION
#line 189
};
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
static struct option long_options[] = {
#line 189
	#line 44 "cmdline.opt"

#line 44
	{ "lint", no_argument, 0, 't' },
#line 50 "cmdline.opt"

#line 50
	{ "inetd", no_argument, 0, 'i' },
#line 56 "cmdline.opt"

#line 56
	{ "runtest", no_argument, 0, 'r' },
#line 66 "cmdline.opt"

#line 66
	{ "config", required_argument, 0, OPTION_CONFIG },
#line 72 "cmdline.opt"

#line 72
	{ "foreground", no_argument, 0, 'f' },
#line 78 "cmdline.opt"

#line 78
	{ "stderr", no_argument, 0, OPTION_STDERR },
#line 84 "cmdline.opt"

#line 84
	{ "syslog", no_argument, 0, OPTION_SYSLOG },
#line 90 "cmdline.opt"

#line 90
	{ "single-process", no_argument, 0, 's' },
#line 96 "cmdline.opt"

#line 96
	{ "load-dir", required_argument, 0, 'L' },
#line 106 "cmdline.opt"

#line 106
	{ "transcript", no_argument, 0, 'T' },
#line 112 "cmdline.opt"

#line 112
	{ "no-transcript", no_argument, 0, OPTION_NO_TRANSCRIPT },
#line 118 "cmdline.opt"

#line 118
	{ "debug", required_argument, 0, 'x' },
#line 125 "cmdline.opt"

#line 125
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 131 "cmdline.opt"

#line 131
	{ "trace-grammar", no_argument, 0, OPTION_TRACE_GRAMMAR },
#line 137 "cmdline.opt"

#line 137
	{ "trace-lex", no_argument, 0, OPTION_TRACE_LEX },
#line 145 "cmdline.opt"

#line 145
	{ "config-help", no_argument, 0, OPTION_CONFIG_HELP },
#line 154 "cmdline.opt"

#line 154
	{ "preprocessor", required_argument, 0, OPTION_PREPROCESSOR },
#line 160 "cmdline.opt"

#line 160
	{ "no-preprocessor", no_argument, 0, OPTION_NO_PREPROCESSOR },
#line 166 "cmdline.opt"

#line 166
	{ "include-dir", required_argument, 0, 'I' },
#line 172 "cmdline.opt"

#line 172
	{ "define", required_argument, 0, 'D' },
#line 189 "cmdline.opt"

#line 189
	{ "help", no_argument, 0, 'h' },
#line 189 "cmdline.opt"

#line 189
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 189 "cmdline.opt"

#line 189
	{ "version", no_argument, 0, 'V' },

#line 189 "cmdline.opt"
	{0, 0, 0, 0}
#line 189
};
#line 189
#endif
#line 189
static struct grecs_opthelp opthelp[] = {
#line 189
	#line 37 "cmdline.opt"

#line 37
	{ NULL, NULL, 0, N_("Select program mode") },
#line 40 "cmdline.opt"

#line 40
	{
#line 40
#ifdef HAVE_GETOPT_LONG
#line 40
	  "-E",
#line 40
#else
#line 40
	  "-E",
#line 40
#endif
#line 40
				   NULL, 0, N_("preprocess configuration file and exit") },
#line 46 "cmdline.opt"

#line 46
	{
#line 46
#ifdef HAVE_GETOPT_LONG
#line 46
	  "-t, --lint",
#line 46
#else
#line 46
	  "-t",
#line 46
#endif
#line 46
				   NULL, 0, N_("check configuration file syntax and exit") },
#line 52 "cmdline.opt"

#line 52
	{
#line 52
#ifdef HAVE_GETOPT_LONG
#line 52
	  "-i, --inetd",
#line 52
#else
#line 52
	  "-i",
#line 52
#endif
#line 52
				   NULL, 0, N_("inetd mode") },
#line 58 "cmdline.opt"

#line 58
	{
#line 58
#ifdef HAVE_GETOPT_LONG
#line 58
	  "-r, --runtest",
#line 58
#else
#line 58
	  "-r",
#line 58
#endif
#line 58
				   NULL, 0, N_("run unit tests for module; subsequent arguments are treated as module name and unit test arguments; the -- marker introduces module initialization arguments") },
#line 64 "cmdline.opt"

#line 64
	{ NULL, NULL, 0, N_("Modifiers") },
#line 68 "cmdline.opt"

#line 68
	{
#line 68
#ifdef HAVE_GETOPT_LONG
#line 68
	  "--config",
#line 68
#else
#line 68
	  "",
#line 68
#endif
#line 68
				   N_("FILE"), 0, N_("read this configuration file") },
#line 74 "cmdline.opt"

#line 74
	{
#line 74
#ifdef HAVE_GETOPT_LONG
#line 74
	  "-f, --foreground",
#line 74
#else
#line 74
	  "-f",
#line 74
#endif
#line 74
				   NULL, 0, N_("operate in foreground") },
#line 80 "cmdline.opt"

#line 80
	{
#line 80
#ifdef HAVE_GETOPT_LONG
#line 80
	  "--stderr",
#line 80
#else
#line 80
	  "",
#line 80
#endif
#line 80
				   NULL, 0, N_("output diagnostic to stderr") },
#line 86 "cmdline.opt"

#line 86
	{
#line 86
#ifdef HAVE_GETOPT_LONG
#line 86
	  "--syslog",
#line 86
#else
#line 86
	  "",
#line 86
#endif
#line 86
				   NULL, 0, N_("output diagnostic to syslog (default)") },
#line 92 "cmdline.opt"

#line 92
	{
#line 92
#ifdef HAVE_GETOPT_LONG
#line 92
	  "-s, --single-process",
#line 92
#else
#line 92
	  "-s",
#line 92
#endif
#line 92
				   NULL, 0, N_("single-process mode") },
#line 98 "cmdline.opt"

#line 98
	{
#line 98
#ifdef HAVE_GETOPT_LONG
#line 98
	  "-L, --load-dir",
#line 98
#else
#line 98
	  "-L",
#line 98
#endif
#line 98
				   N_("DIR"), 0, N_("prepend DIR to the module load path") },
#line 104 "cmdline.opt"

#line 104
	{ NULL, NULL, 0, N_("Debugging") },
#line 108 "cmdline.opt"

#line 108
	{
#line 108
#ifdef HAVE_GETOPT_LONG
#line 108
	  "-T, --transcript",
#line 108
#else
#line 108
	  "-T",
#line 108
#endif
#line 108
				   NULL, 0, N_("enable session transcript") },
#line 114 "cmdline.opt"

#line 114
	{
#line 114
#ifdef HAVE_GETOPT_LONG
#line 114
	  "--no-transcript",
#line 114
#else
#line 114
	  "",
#line 114
#endif
#line 114
				   NULL, 0, N_("disable session transcript") },
#line 120 "cmdline.opt"

#line 120
	{
#line 120
#ifdef HAVE_GETOPT_LONG
#line 120
	  "-x, --debug",
#line 120
#else
#line 120
	  "-x",
#line 120
#endif
#line 120
				   N_("NUMBER"), 0, N_("set debug verbosity level") },
#line 127 "cmdline.opt"

#line 127
	{
#line 127
#ifdef HAVE_GETOPT_LONG
#line 127
	  "--source-info",
#line 127
#else
#line 127
	  "",
#line 127
#endif
#line 127
				   NULL, 0, N_("include source line information in the debugging output") },
#line 133 "cmdline.opt"

#line 133
	{
#line 133
#ifdef HAVE_GETOPT_LONG
#line 133
	  "--trace-grammar",
#line 133
#else
#line 133
	  "",
#line 133
#endif
#line 133
				   NULL, 0, N_("trace parsing of configuration file") },
#line 139 "cmdline.opt"

#line 139
	{
#line 139
#ifdef HAVE_GETOPT_LONG
#line 139
	  "--trace-lex",
#line 139
#else
#line 139
	  "",
#line 139
#endif
#line 139
				   NULL, 0, N_("trace config file lexer") },
#line 143 "cmdline.opt"

#line 143
	{ NULL, NULL, 0, N_("Additional help") },
#line 147 "cmdline.opt"

#line 147
	{
#line 147
#ifdef HAVE_GETOPT_LONG
#line 147
	  "--config-help",
#line 147
#else
#line 147
	  "",
#line 147
#endif
#line 147
				   NULL, 0, N_("show configuration file summary") },
#line 152 "cmdline.opt"

#line 152
	{ NULL, NULL, 0, N_("Preprocessor control") },
#line 156 "cmdline.opt"

#line 156
	{
#line 156
#ifdef HAVE_GETOPT_LONG
#line 156
	  "--preprocessor",
#line 156
#else
#line 156
	  "",
#line 156
#endif
#line 156
				   N_("PROG"), 0, N_("use PROG as a preprocessor for config file") },
#line 162 "cmdline.opt"

#line 162
	{
#line 162
#ifdef HAVE_GETOPT_LONG
#line 162
	  "--no-preprocessor",
#line 162
#else
#line 162
	  "",
#line 162
#endif
#line 162
				   NULL, 0, N_("do not use external preprocessor") },
#line 168 "cmdline.opt"

#line 168
	{
#line 168
#ifdef HAVE_GETOPT_LONG
#line 168
	  "-I, --include-dir",
#line 168
#else
#line 168
	  "-I",
#line 168
#endif
#line 168
				   N_("DIR"), 0, N_("add the directory DIR to the list of directories to be searched for preprocessor include files") },
#line 174 "cmdline.opt"

#line 174
	{
#line 174
#ifdef HAVE_GETOPT_LONG
#line 174
	  "-D, --define",
#line 174
#else
#line 174
	  "-D",
#line 174
#endif
#line 174
				   N_("SYMBOL[=VALUE]"), 0, N_("define a preprocessor symbol") },
#line 189 "cmdline.opt"

#line 189
	{ NULL, NULL, 0, N_("Other options") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-h, --help",
#line 189
#else
#line 189
	  "-h",
#line 189
#endif
#line 189
				   NULL, 0, N_("Give this help list") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "--usage",
#line 189
#else
#line 189
	  "",
#line 189
#endif
#line 189
				   NULL, 0, N_("Give a short usage message") },
#line 189 "cmdline.opt"

#line 189
	{
#line 189
#ifdef HAVE_GETOPT_LONG
#line 189
	  "-V, --version",
#line 189
#else
#line 189
	  "-V",
#line 189
#endif
#line 189
				   NULL, 0, N_("Print program version") },

#line 189 "cmdline.opt"
};
#line 28 "cmdline.opt"

#line 28

#line 28
static struct grecs_proginfo proginfo = {
#line 28
	"dicod", /* progname */
#line 28
	NULL, /* subcommands */
#line 28
	N_("GNU dictionary server"), /* docstring */
#line 28
	"", /* args_doc */
#line 28
	opthelp, /* opthelp */
#line 28
	sizeof(opthelp)/sizeof(opthelp[0]), /* optcount */
#line 28
	NULL, /* print_help_hook */
#line 28
	NULL, /* print_version_hook */
#line 28
	PACKAGE_NAME,    /* package */
#line 28
	PACKAGE_VERSION, /* version */
#line 28
	NULL, /* license */
#line 28
	"2005-2017",/* copyright_year */
#line 28
	"Free Software Foundation, Inc.", /* copyright_holder */
#line 28
	NULL, /* *authors */
#line 28
	"<" PACKAGE_BUGREPORT ">", /* bug_address */
#line 28
	PACKAGE_URL, /* url */
#line 28
	NULL  /* epilogue */
#line 28
};
#line 28
static struct grecs_node *cmdline_tree;
#line 28

#line 28
const char *program_version = "dicod" " (" PACKAGE_NAME ") " PACKAGE_VERSION;
#line 28

#line 189 "cmdline.opt"

#line 189


void
get_options(int *pargc, char **pargv[], struct dicod_conf_override *conf)
{
    int i;
    int argc = *pargc;
    char **argv = *pargv;
    
    
#line 198
 {
#line 198
  int c;
#line 198

#line 198
  optind = 0;
#line 198
#ifdef HAVE_GETOPT_LONG
#line 198
  while ((c = getopt_long(argc, argv, "EtirfsL:Tx:I:D:hV",
#line 198
			  long_options, NULL)) != EOF)
#line 198
#else
#line 198
  while ((c = getopt(argc, argv, "EtirfsL:Tx:I:D:hV")) != EOF)
#line 198
#endif
#line 198
    {
#line 198
      switch (c)
#line 198
	{
#line 198
	default:
#line 198
	   exit(EX_USAGE);	   exit(EX_USAGE);
#line 198
	#line 40 "cmdline.opt"
	 case 'E':
#line 40
	  {
#line 40

   mode = MODE_PREPROC;

#line 42
	     break;
#line 42
	  }
#line 46 "cmdline.opt"
	 case 't':
#line 46
	  {
#line 46

   config_lint_option = 1;

#line 48
	     break;
#line 48
	  }
#line 52 "cmdline.opt"
	 case 'i':
#line 52
	  {
#line 52

   mode = MODE_INETD;

#line 54
	     break;
#line 54
	  }
#line 58 "cmdline.opt"
	 case 'r':
#line 58
	  {
#line 58

   mode = MODE_TEST;
   log_to_stderr = 1;
   goto lastoptlab;

#line 62
	     break;
#line 62
	  }
#line 68 "cmdline.opt"
	 case OPTION_CONFIG:
#line 68
	  {
#line 68

   config_file = optarg;

#line 70
	     break;
#line 70
	  }
#line 74 "cmdline.opt"
	 case 'f':
#line 74
	  {
#line 74

   foreground = 1;

#line 76
	     break;
#line 76
	  }
#line 80 "cmdline.opt"
	 case OPTION_STDERR:
#line 80
	  {
#line 80

   log_to_stderr = 1;

#line 82
	     break;
#line 82
	  }
#line 86 "cmdline.opt"
	 case OPTION_SYSLOG:
#line 86
	  {
#line 86

   log_to_stderr = 0;

#line 88
	     break;
#line 88
	  }
#line 92 "cmdline.opt"
	 case 's':
#line 92
	  {
#line 92

   single_process = 1;

#line 94
	     break;
#line 94
	  }
#line 98 "cmdline.opt"
	 case 'L':
#line 98
	  {
#line 98

   prepend_load_path = xdico_list_create();
   dico_list_set_free_item(prepend_load_path, dicod_free_item, NULL);
   xdico_list_append(prepend_load_path, xstrdup(optarg));

#line 102
	     break;
#line 102
	  }
#line 108 "cmdline.opt"
	 case 'T':
#line 108
	  {
#line 108

   conf->transcript = 1;

#line 110
	     break;
#line 110
	  }
#line 114 "cmdline.opt"
	 case OPTION_NO_TRANSCRIPT:
#line 114
	  {
#line 114

   conf->transcript = 0;

#line 116
	     break;
#line 116
	  }
#line 120 "cmdline.opt"
	 case 'x':
#line 120
	  {
#line 120

   debug_level_str = optarg;
   debug_level = atoi(optarg);

#line 123
	     break;
#line 123
	  }
#line 127 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 127
	  {
#line 127

   debug_source_info = 1;

#line 129
	     break;
#line 129
	  }
#line 133 "cmdline.opt"
	 case OPTION_TRACE_GRAMMAR:
#line 133
	  {
#line 133

   grecs_gram_trace(1);

#line 135
	     break;
#line 135
	  }
#line 139 "cmdline.opt"
	 case OPTION_TRACE_LEX:
#line 139
	  {
#line 139

   grecs_lex_trace(1);

#line 141
	     break;
#line 141
	  }
#line 147 "cmdline.opt"
	 case OPTION_CONFIG_HELP:
#line 147
	  {
#line 147

   config_help();
   exit(0);

#line 150
	     break;
#line 150
	  }
#line 156 "cmdline.opt"
	 case OPTION_PREPROCESSOR:
#line 156
	  {
#line 156

   grecs_preprocessor = optarg;

#line 158
	     break;
#line 158
	  }
#line 162 "cmdline.opt"
	 case OPTION_NO_PREPROCESSOR:
#line 162
	  {
#line 162

   grecs_preprocessor = NULL;

#line 164
	     break;
#line 164
	  }
#line 168 "cmdline.opt"
	 case 'I':
#line 168
	  {
#line 168

   grecs_preproc_add_include_dir(optarg); 

#line 170
	     break;
#line 170
	  }
#line 174 "cmdline.opt"
	 case 'D':
#line 174
	  {
#line 174

   char *p;

   if (!pp_cmd_acc)
       pp_cmd_acc = grecs_txtacc_create();
   grecs_txtacc_grow(pp_cmd_acc, " \"-D", 4);
   for (p = optarg; *p; p++) {
       if (*p == '\\' || *p == '"')
	   grecs_txtacc_grow_char(pp_cmd_acc, '\\');
       grecs_txtacc_grow_char(pp_cmd_acc, *p);
   }
   grecs_txtacc_grow_char(pp_cmd_acc, '"');			

#line 186
	     break;
#line 186
	  }
#line 189 "cmdline.opt"
	 case 'h':
#line 189
	  {
#line 189

#line 189
		grecs_print_help(&proginfo);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }
#line 189 "cmdline.opt"
	 case OPTION_USAGE:
#line 189
	  {
#line 189

#line 189
		grecs_print_usage(&proginfo);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }
#line 189 "cmdline.opt"
	 case 'V':
#line 189
	  {
#line 189

#line 189
		/* Give version */
#line 189
		grecs_print_version(&proginfo, stdout);
#line 189
		exit(0);
#line 189
	 
#line 189
	     break;
#line 189
	  }

#line 198 "cmdline.opt"
	}
#line 198
    }
#line 198
lastoptlab:
#line 198
  i = optind;
#line 198
  if (cmdline_tree)
#line 198
    {
#line 198
      struct grecs_node *rn = grecs_node_create(grecs_node_root, NULL);
#line 198
      rn->down = cmdline_tree;
#line 198
      cmdline_tree = rn;
#line 198
    }
#line 198
 }
#line 198

    if (pp_cmd_acc && grecs_preprocessor) {
	char *args, *cmd;

	grecs_txtacc_grow_char(pp_cmd_acc, 0);
	args = grecs_txtacc_finish(pp_cmd_acc, 0);
	cmd = grecs_malloc(strlen(grecs_preprocessor) +
			   strlen(args) + 1);
	strcpy(cmd, grecs_preprocessor);
	strcat(cmd, args);
	grecs_preprocessor = cmd;
    }
    grecs_txtacc_free(pp_cmd_acc);

    if (mode == MODE_TEST) {
	*pargc = argc - i;
	*pargv = argv + i;
    } else if (i < argc) {
	fprintf(stderr, "%s: unexpected arguments\n", argv[0]);
	exit(EX_USAGE);
    }
}
