;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: LAPIDARY; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package "LAPIDARY" :use '("LISP" "KR"))


(create-instance 'SLOT-BOX garnet-gadgets:labeled-box
   (:left (o-formula (opal:gv-center-x-is-center-of (gvl :parent))))
   (:top (o-formula (gvl :parent :top)))
   (:label-font *slot-font*)
   (:value "0")
   (:old-value "0")
   (:min-frame-width 30))


(create-instance 'OFFSET-BOX garnet-gadgets:labeled-box
   (:maybe-constant (append (g-value garnet-gadgets:labeled-box :maybe-constant)
			    '(:label-string :label-font)))
   (:left (o-formula (opal:gv-center-x-is-center-of (gvl :parent))))
   (:top (o-formula (+ 5 (opal:gv-bottom (gvl :parent :slot-box)))))
   (:label-string "offset")
   (:label-font opal:default-font)
   (:old-value "0")
   (:value "0")
   (:min-frame-width 30))


(create-instance 'CON-PANEL garnet-gadgets:text-button-panel
   (:width (o-formula (+ (gvl :shadow-offset) (gvl :fixed-width-size))))
   (:height (o-formula (+ (* 2 (+ (gvl :fixed-height-size)
				  (gvl :shadow-offset)))
			  (gvl :v-spacing))))
   (:shadow-offset 5) (:gray-width 3) (:text-offset 3)
   (:final-feedback-p NIL)
   (:items `(("unconstrain" remove-constraint)
	     ("customize" create-custom-constraint))))


(create-instance 'SCALE-BOX garnet-gadgets:labeled-box
   (:label-string "Scale")
   (:label-font opal:default-font)
   (:value "1")
   (:old-value "1")
   (:min-frame-width 30))


(create-instance 'DIFFERENCE-BOX garnet-gadgets:labeled-box
   (:left (o-formula (opal:gv-center-x-is-center-of (gvl :parent))))
   (:top (o-formula (+ 5 (opal:gv-bottom (gvl :parent :scale-box)))))
   (:label-string "Difference
in pixels")
   (:label-font opal:default-font)
   (:value "0")
   (:min-frame-width 30)
   (:parts `((:label-text ,opal:multi-text :inherit (:left :top :string :font))
	     :field-text :frame)))


(create-instance 'BOX-CONSTRAINT-BUTTON opal:aggregadget
   (:maybe-constant :left :top :width :height :where-attach :visible)
   (:floating-left (o-formula (+ (gvl :left)
				 (if (gvl :interim-selected) 4 0))))
   (:floating-top (o-formula (+ (gvl :top)
				(if (gvl :interim-selected) 4 0))))
   (:width 23) (:height 23)
   (:selected (o-formula (progn (gv *selection-info* :selected)
				nil)))
   (:where-attach (o-formula (nth (gvl :rank)
				  (gvl :parent :parent :where-attach))))
   (:parts
    `((:shadow ,opal:rectangle
	   (:constant (:visible))
	   (:left ,(o-formula (+ 4 (gvl :parent :left))))
	   (:top ,(o-formula (+ 4 (gvl :parent :top))))
	   (:width 19) (:height 19)
	   (:filling-style ,opal:black-fill)
	   (:line-style NIL))
      (:gray-outline ,opal:rectangle
	   (:constant (:visible))
	   (:left ,(o-formula (gvl :parent :floating-left)))
	   (:top ,(o-formula (gvl :parent :floating-top)))
	   (:width 19) (:height 19)
	   (:filling-style ,opal:gray-fill))
      (:white-field ,opal:rectangle
	   (:constant (:visible))
	   (:left ,(o-formula (+ 4 (gvl :parent :floating-left))))
	   (:top ,(o-formula (+ 4 (gvl :parent :floating-top))))
	   (:width 11) (:height 11)
	   (:filling-style ,opal:white-fill))
      (:label ,opal:rectangle
	   (:left ,(o-formula (+ 7 (gvl :parent :floating-left))))
	   (:top ,(o-formula (+ 7 (gvl :parent :floating-top))))
	   (:width 5) (:height 5)
	   (:line-style NIL)
	   (:filling-style ,opal:black-fill)
	   (:fast-redraw-p T) (:draw-function :xor)
	   (:visible ,(o-formula (not (gvl :parent :selected))))))))


(create-instance 'BOX-CONSTRAINT-FEEDBACK opal:rectangle
   (:maybe-constant '(:left :top :width :height :filling-style :line-style
			    :draw-function))
   (:left (o-formula (1+ (gvl :obj-over :white-field :left))))
   (:top (o-formula (1+ (gvl :obj-over :white-field :top))))
   (:width 9) (:height 9)
   (:filling-style opal:black-fill)
   (:fast-redraw-p T)
   (:draw-function :xor)
   (:visible (o-formula (gvl :obj-over)))
   (:obj-over (o-formula (gvl :parent :selected))))


(create-instance 'BOX-CONSTRAINT-INTER inter:button-interactor
   (:window (o-formula (gvl :operates-on :window)))
   (:start-where (o-formula (list :element-of (gvl :operates-on)
				  :type BOX-CONSTRAINT-BUTTON)))
   (:how-set :set))


(create-instance 'CONSTRAINT-ARROW garnet-gadgets:arrow-line
   (:filling-style opal:black-fill)
   (:parts
    `(:line
      (:arrowhead :modify (:diameter 7)))))


(create-instance 'DIMENSION-ARROW garnet-gadgets:double-arrow-line
   (:parts
    `(:line
      (:arrowhead1 :modify (:diameter 7) (:length 7))
      (:arrowhead2 :modify (:diameter 7) (:length 7)))))


(create-instance 'SEL-BOX opal:rectangle
   (:left (o-formula (- (gvl :center-x) 2)))
   (:top (o-formula (- (gvl :center-y) 2)))
   (:width 10) (:height 10))
