/* LocaleInformation_vi.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_vi extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "VND";

  private static final String currenciesDisplayNameValues = "\u0111\u1ed3ng";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "VND";

  private static final String currenciesSymbolValues = "\u0111";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "thg 1",
    "thg 2",
    "thg 3",
    "thg 4",
    "thg 5",
    "thg 6",
    "thg 7",
    "thg 8",
    "thg 9",
    "thg 10",
    "thg 11",
    "thg 12",
    null,
  };

  private static final String[] months = {
    "th\u00e1ng m\u1ed9t",
    "th\u00e1ng hai",
    "th\u00e1ng ba",
    "th\u00e1ng t\u01b0",
    "th\u00e1ng n\u0103m",
    "th\u00e1ng s\u00e1u",
    "th\u00e1ng b\u1ea3y",
    "th\u00e1ng t\u00e1m",
    "th\u00e1ng ch\u00edn",
    "th\u00e1ng m\u01b0\u1eddi",
    "th\u00e1ng m\u01b0\u1eddi m\u1ed9t",
    "th\u00e1ng m\u01b0\u1eddi hai",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "CN",
    "Th 2",
    "Th 3",
    "Th 4",
    "Th 5",
    "Th 6",
    "Th 7",
  };

  private static final String[] weekdays = {
    null,
    "Ch\u1ee7 nh\u1eadt",
    "Th\u1ee9 hai",
    "Th\u1ee9 ba",
    "Th\u1ee9 t\u01b0",
    "Th\u1ee9 n\u0103m",
    "Th\u1ee9 s\u00e1u",
    "Th\u1ee9 b\u1ea3y",
  };

  private static final String[] eras = {
    "tr. CN",
    "sau CN",
  };

  private static final String[] ampms = {
    "SA",
    "CH",
  };

  private static final String territoriesKeys = "TJ|TH|TG|GY|TD|GW|GT|GR|GQ|SZ|SY|GN|GM|SV|ST|GH|SR|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SI|SG|SE|SD|SC|SB|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|PY|DK|DJ|PT|DE|PL|PK|PH|PG|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BS|BR|NZ|BO|BN|BJ|BI|BH|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|ZM|AU|NA|AT|AR|MZ|AO|MY|MX|AM|MW|AL|MV|ZA|MU|MT|MR|AG|AF|AE|MN|MM|ML|MK|YU|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|JP|JO|JM|VU|VN|VE|VC|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|TV|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "T\u00e1t-gi-ki-xtan|Th\u00e1i Lan|T\u00f4-g\u00f4|Guy-a-na|S\u00e1t|Ghi-n\u00ea B\u00edt-xao|Goa-t\u00ea-ma-la|Hy L\u1ea1p|Ghi-n\u00ea X\u00edch-\u0111\u1ea1o|Xoa-di-len|Xi-ri|Ghi-n\u00ea|G\u0103m-bi-a|En-san-va-\u0111o|Xao T\u00f4-m\u00ea v\u00e0 Prin-xi-p\u00ea|Gha-na|Xu-ri-nam|S\u00e9c-bia|Gru-di-a|X\u00f4-ma-li|Gr\u00ea-na-\u0111a|X\u00ea-n\u00ea-gan|Xan Ma-ri-n\u00f4|V\u01b0\u01a1ng qu\u1ed1c Anh|Xi-\u00ea-ra L\u00ea-\u00f4n|Ga-b\u00f4ng|Xl\u00f4-va-ki-a|Xl\u00f4-ven-ni-a|Xin-ga-po|Th\u1ee5y \u0110i\u1ec3n|Xu-\u0111\u0103ng|X\u00e2y-sen|Qu\u1ea7n \u0111\u1ea3o X\u00f4-l\u00f4-m\u00f4ng|A-r\u1eadp X\u00ea-\u00fat|Ph\u00e1p|Mi-cr\u00f4-n\u00ea-xi-a|Ru-an-\u0111a|Nga|Phi-gi|Ph\u1ea7n Lan|Ru-ma-ni|\u00ca-ti-\u00f4-pi-a|T\u00e2y Ban Nha|\u00ca-ri-t\u01a1-r\u00ea-a|T\u00e2y Sahara|Ai C\u1eadp|E-xt\u00f4-ni-a|\u00ca-cu-a-\u0111o|An-gi\u00ea-ri|Ca-ta|Pa-ra-goay|\u0110an M\u1ea1ch|Gi-bu-ti|B\u1ed3 \u0110\u00e0o Nha|\u0110\u1ee9c|Ba Lan|Pa-ki-xtan|Phi-lip-pin|Pa-pu-a Niu Ghi-n\u00ea|C\u1ed9ng h\u00f2a S\u00e9c|P\u00ea-ru|S\u00edp|C\u00e1p-ve|Pa-na-ma|Cu Ba|C\u1ed1t-xta Ri-ca|C\u00f4-l\u00f4m-bi-a|Trung Qu\u1ed1c|Ca-m\u01a1-run|Chi-l\u00ea|B\u1edd Bi\u1ec3n Ng\u00e0|Th\u1ee5y S\u0129|C\u00f4ng-g\u00f4|C\u1ed9ng h\u00f2a Trung Phi|\u00d4-man|Ca-na-\u0111a|B\u00ea-li-x\u00ea|B\u00ea-la-r\u00fat|B\u1ed1t-xoa-na|Ba-ha-ma|Bra-xin|Niu Di-l\u00e2n|B\u00f4-li-vi-a|Bru-n\u00e2y|B\u00ea-nanh|Bu-run-\u0111i|Ba-ren|Bun-ga-ri|Bu\u1ed1c-ki-na Pha-x\u00f4|N\u00ea-pan|B\u1ec9|Na Uy|B\u0103ng-la-\u0111\u00e9t|B\u00e1c-ba-\u0111\u1ed1t|Dim-ba-bu-\u00ea|H\u00e0 Lan|B\u00f4-xni-a H\u00e9c-x\u00ea-g\u00f4-vi-na|Ni-ca-ra-goa|Ni-gi\u00ea-ri-a|Ai-d\u00e9c-bai-gian|Ni-gi\u00ea|D\u0103m-bi-a|\u00dac|Nam-mi-bi-a|\u00c1o|\u00c1c-hen-ti-na|M\u00f4-d\u0103m-b\u00edch|\u0102ng-g\u00f4-la|Ma-lay-xi-a|M\u00ea-hi-c\u00f4|\u00c1c-m\u00ea-ni-a|Ma-la-uy|An-ba-ni|Man-\u0111i-v\u01a1|Nam Phi|M\u00f4-ri-x\u01a1|Man-ta|M\u00f4-ri-ta-ni|An-ti-gu-a v\u00e0 Ba-bu-\u0111a|\u00c1p-ga-ni-xtan|C\u00e1c Ti\u1ec3u V\u01b0\u01a1ng qu\u1ed1c A-r\u1eadp Th\u1ed1ng nh\u1ea5t|M\u00f4ng C\u1ed5|Mi-an-ma|Ma-li|Ma-x\u00ea-\u0111\u00f4-ni-a|Nam T\u01b0|Qu\u1ea7n \u0111\u1ea3o M\u00e1c-san|Ma-\u0111a-g\u00e1t-xca|M\u00f4n-\u0111\u00f4-va|M\u00f4-na-c\u00f4|Ma-r\u1ed1c|Y-\u00ea-men|Li-bi|L\u00e1t-vi-a|L\u00fac-x\u0103m-bua|Li-tu-a-ni-a|L\u00ea-x\u00f4-th\u00f4|Li-b\u00ea-ri-a|Xri Lan-ca|Lich-ten-xt\u00ean|Xan Lu-xi|Li-b\u0103ng|L\u00e0o|Ka-d\u1eafc-xtan|C\u00f4-o\u00e9t|H\u00e0n Qu\u1ed1c|B\u1eafc Tri\u1ec1u Ti\u00ean|Xan-k\u00edt v\u00e0 N\u00ea-vi|C\u00f4-m\u00f4|Ki-ri-ba-ti|Xa-moa|Campuchia|C\u01b0-r\u01a1-g\u01b0-xtan|K\u00ea-ni-a|Nh\u1eadt B\u1ea3n|Gi\u00f3c-\u0111a-ni|Ha-mai-ca|Va-nu-a-tu|Vi\u1ec7t Nam|V\u00ea-n\u00ea-zu-\u00ea-la|Xan Vin-xen v\u00e0 Gr\u00ea-na-din|Va-ti-c\u0103ng|\u00dd|Ai-x\u01a1-len|I-ran|I-r\u1eafc|U-d\u01a1-b\u00ea-ki-xtan|U-ru-goay|\u1ea4n \u0110\u1ed9|I-xra-en|Hoa K\u1ef3|Ai-len|Nam D\u01b0\u01a1ng|U-gan-\u0111a|U-crai-na|Hung-ga-ri|Ha-i-ti|Cr\u00f4-a-ti-a|Tan-da-ni-a|H\u00f4n-\u0111u-r\u00e1t|\u0110\u00e0i Loan|Tu-va-lu|Tri-ni-\u0111\u00e1t v\u00e0 T\u00f4-ba-g\u00f4|Th\u1ed5 Nh\u0129 K\u1ef3|T\u00f4ng-ga|Tuy-ni-di|Tu\u1ed1c-m\u00ea-ni-xtan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ne|th|az|zh|ar|jv|ms|sv|pt|sr|mn|sq|so|mk|de|pl|sl|sk|da|ga|vi|ja|yi|sa|cs|lv|it|fr|is|uz|lt|ru|lo|fi|ro|ca|id|uk|fa|ia|la|hy|et|hu|es|bo|hr|eo|en|el|ko|kn|no|km|bg|tr|hi|be|nl|he";

  private static final String languagesValues = "Ti\u1ebfng N\u00ea-pan|Ti\u1ebfng Th\u00e1i|Ti\u1ebfng Ai-d\u00e9c-bai-gian|Ti\u1ebfng Trung Qu\u1ed1c|Ti\u1ebfng A-r\u1eadp|Ti\u1ebfng Gia-va|Ti\u1ebfng Ma-lay-xi-a|Ti\u1ebfng Th\u1ee5y \u0110i\u1ec3n|Ti\u1ebfng B\u1ed3 \u0110\u00e0o Nha|Ti\u1ebfng S\u00e9c-bi|Ti\u1ebfng M\u00f4ng C\u1ed5|Ti\u1ebfng An-ba-ni|Ti\u1ebfng X\u00f4-ma-li|Ti\u1ebfng Ma-x\u00ea-\u0111\u00f4-ni-a|Ti\u1ebfng \u0110\u1ee9c|Ti\u1ebfng Ba Lan|Ti\u1ebfng Xl\u00f4-ven|Ti\u1ebfng Xl\u00f4-v\u00e1c|Ti\u1ebfng \u0110an M\u1ea1ch|Ti\u1ebfng Ai-len|Ti\u1ebfng Vi\u1ec7t|Ti\u1ebfng Nh\u1eadt|Ti\u1ebfng Y-\u0111it|Ti\u1ebfng Ph\u1ea1n|Ti\u1ebfng S\u00e9c|Ti\u1ebfng L\u00e1t-vi-a|Ti\u1ebfng \u00dd|Ti\u1ebfng Ph\u00e1p|Ti\u1ebfng Ai-x\u01a1-len|Ti\u1ebfng U-d\u01a1-b\u1ebfch|Ti\u1ebfng L\u00edt-va|Ti\u1ebfng Nga|Ti\u1ebfng L\u00e0o|Ti\u1ebfng Ph\u1ea7n Lan|Ti\u1ebfng Ru-ma-ni|Ti\u1ebfng Ca-ta-l\u0103ng|Ti\u1ebfng In-\u0111\u00f4-n\u00ea-xia|Ti\u1ebfng U-crai-na|Ti\u1ebfng Ba T\u01b0|Ti\u1ebfng Khoa H\u1ecdc Qu\u1ed1c T\u1ebf|Ti\u1ebfng La-tinh|Ti\u1ebfng \u00c1c-m\u00ea-ni|Ti\u1ebfng E-xt\u00f4-ni-a|Ti\u1ebfng Hung-ga-ri|Ti\u1ebfng T\u00e2y Ban Nha|Ti\u1ebfng T\u00e2y T\u1ea1ng|Ti\u1ebfng Cr\u00f4-a-ti-a|Ti\u1ebfng Qu\u1ed1c T\u1ebf Ng\u1eef|Ti\u1ebfng Anh|Ti\u1ebfng Hy L\u1ea1p|Ti\u1ebfng H\u00e0n Qu\u1ed1c|Ti\u1ebfng Kan-na-\u0111a|Ti\u1ebfng Na Uy|Ti\u1ebfng Campuchia|Ti\u1ebfng Bun-ga-ri|Ti\u1ebfng Th\u1ed5 Nh\u0129 K\u1ef3|Ti\u1ebfng Hin-\u0111i|Ti\u1ebfng B\u00ea-la-r\u00fat|Ti\u1ebfng H\u00e0 Lan|Ti\u1ebfng H\u00ea-br\u01a1";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currencyFormat", "#,##0.00 \u00a4;-#,##0.00 \u00a4" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd/MM/yyyy" },
    { "mediumDateFormat", "dd-MM-yyyy" },
    { "longDateFormat", "'Ng\u00e0y' dd 'th\u00e1ng' M 'n\u0103m' yyyy" },
    { "fullDateFormat", "EEEE, 'ng\u00e0y' dd MMMM 'n\u0103m' yyyy" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
