/*  -*- Mode: C -*-
 * --------------------------------------------------------------------
 * DO NOT EDIT THIS FILE!  It has been automatically generated
 * from:    configure.in and compat.h.in
 * on host: oranda
 * --------------------------------------------------------------------
 * compat.h --- portability code generated for snprintfv by configure.in
 *
 * Author:           Gary V. Vaughan <gvv@techie.com>
 * Maintainer:       Gary V. Vaughan <gvv@techie.com>
 * Created:          Thu Apr 22 14:20:31 1999
 * Last Modified:    Mon Jul 12 11:51:15 1999
 *            by:    Gary V. Vaughan <gvv@techie.com>
 * --------------------------------------------------------------------
 */

/* Copyright (C) 1999 Gary V. Vaughan

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef SNPRINTFV_COMPAT_H
#define SNPRINTFV_COMPAT_H 1

#ifdef __cplusplus
extern "C" {
#if 0
/* This brace is so that emacs can still indent properly: */ }
#endif
#endif /* __cplusplus */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <errno.h>
#ifndef errno
/* Some sytems #define this! */
extern int errno;
#endif
#include <limits.h>
#ifndef MAXINT
#  include <values.h>
#endif /* MAXINT */
#include <string.h>
#include <memory.h>

#define   SNV_USING_STDARG_H
#include <stdarg.h>
#ifndef   VA_START
#  define VA_START(a, f) va_start(a, f)
#  define VA_END(a)	 va_end(a)
#endif /* VA_START */


/* Define macros for storing integers inside pointers.
 * Be aware that it is only safe to use these macros to store `int'
 * values in `char*' (or `void*') words, and then extract them later.
 * Although it will work the other way round on many common
 * architectures, it is not portable to assume a `char*' can be
 * stored in an `int' and extracted later without loss of the msb's
 */
#define SNV_POINTER_TO_INT(p)	((int)(long)(p))
#define SNV_POINTER_TO_UINT(p)	((unsigned)(unsigned long)(p))
#define SNV_INT_TO_POINTER(i)	((snv_pointer)(long)(i))
#define SNV_UINT_TO_POINTER(u)	((snv_pointer)(unsigned long)(u))



#if ENABLE_NLS
# include <libintl.h>
# define _(Text) gettext (Text)
#else
# define textdomain(Domain)
# define _(Text) Text
#endif

/* inline and const keywords are (mostly) handled by config.h */
#ifdef __GNUC__
#  ifndef const
#    define const	__const
#  endif
#  ifndef signed
#    define signed	__signed
#  endif
#  ifndef volatile
#    define volatile	__volatile
#  endif
#else
#  ifndef __STDC__
#    undef  signed
#    define signed
#    undef  volatile
#    define volatile
#  endif
#endif

#ifdef __STDC__
#define _STR(x)		#x
#define _CONC(x, y)	x##y
typedef void* snv_pointer;
typedef const void *snv_constpointer;
#else
#define _STR(x)		"x"
#define _CONC(x, y)	x/**/y
typedef char* snv_pointer;
typedef char *snv_constpointer;
#endif

/* If FALSE is defined, we presume TRUE is defined too.  In this case,
   merely typedef boolean as being int.  Or else, define these all.  */
#ifndef FALSE
/* Do not use `enum boolean': this tag is used in SVR4 <sys/types.h>.  */
typedef enum { FALSE = 0, TRUE = 1 } compatboolean;
#else
typedef int compatboolean;
#endif
#ifndef boolean
#  define boolean compatboolean
#endif

#ifdef __CYGWIN32__
#  ifndef __CYGWIN__
#    define __CYGWIN__
#  endif
#endif
#ifdef __CYGWIN__
#  ifndef _WIN32
#    define _WIN32
#  endif
#endif

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS  0
#  define EXIT_FAILURE  1
#endif

#ifndef PARAMS
#  if __STDC__
#    ifndef NOPROTOS
#      define PARAMS(args)      args
#    endif
#  endif
#  ifndef PARAMS
#    define PARAMS(args)        ()
#  endif
#endif

#undef SNV_STMT_START
#undef SNV_STMT_END
#if defined (__GNUC__) && !defined (__STRICT_ANSI__) && !defined (__cplusplus)
#  define SNV_STMT_START	(void)(
#  define SNV_STMT_END		)
#else
#  if (defined (sun) || defined (__sun__))
#    define SNV_STMT_START	if (1)
#    define SNV_STMT_END	else (void)0
#  else
#    define SNV_STMT_START	do
#    define SNV_STMT_END	while (0)
#  endif
#endif

#undef SNV_GNUC_PRINTF
#undef SNV_GNUC_NORETURN
#if	__GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
#  ifdef SNV_USING_STDARG_H
#    define SNV_GNUC_PRINTF( args, format_idx, arg_idx )		\
  	args __attribute__((format (printf, format_idx, arg_idx)))
#  else
#    define SNV_GNUC_PRINTF( args, format_idx, arg_idx ) ()
#  endif
#  define SNV_GNUC_NORETURN						\
	__attribute__((noreturn))
#else	/* !__GNUC__ */
#  ifdef SNV_USING_STDARG_H
#    define SNV_GNUC_PRINTF( args, format_idx, arg_idx ) args
#  else
#    define SNV_GNUC_PRINTF( args, format_idx, arg_idx ) ()
#  endif
#  define SNV_GNUC_NORETURN
#endif	/* !__GNUC__ */

#ifdef __GNUC__
#define ERROR_FUNCTION		" (" __PRETTY_FUNCTION__ ")"
#else
#define ERROR_FUNCTION		""
#endif

#ifndef STR
#  define STR(s) _STR(s)
#endif 

#define snv_assert(expr)		snv_fassert(stderr, expr)
#define snv_fassert(stream, expr)	SNV_STMT_START{			\
    if (!(expr))							\
    {									\
	fprintf (stream, "file %s: line %d%s: assertion \"%s\" failed.\n", \
	__FILE__, __LINE__, ERROR_FUNCTION, _STR(expr));		\
	exit(EXIT_FAILURE);						\
    };					}SNV_STMT_END

#define return_if_fail(expr)		freturn_if_fail(stderr, expr)
#define freturn_if_fail(expr)		SNV_STMT_START{			\
    if (!(expr))							\
    {									\
	fprintf (stream, "file %s: line %d%s: assertion \"%s\" failed.\n", \
	__FILE__, __LINE__, ERROR_FUNCTION, _STR(expr));		\
	return;								\
    };					}SNV_STMT_END

#define return_val_if_fail(expr, val)	freturn_val_if_fail(stderr, expr, val)
#define freturn_val_if_fail(stream, expr, val)	SNV_STMT_START{		\
    if (!(expr))							\
    {									\
	fprintf (stream, "file %s: line %d%s: assertion \"%s\" failed.\n", \
	__FILE__, __LINE__, ERROR_FUNCTION, _STR(expr));		\
	return val;							\
    };					}SNV_STMT_END

#ifndef MAX
#define MAX(a,b)	((a) > (b) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(a)		((a) < 0 ? -(a) : (a))
#endif


#ifdef __cplusplus
#if 0
/* This brace is so that emacs can still indent properly: */ {
#endif
}
#endif /* __cplusplus */

#endif /* COMPAT_H */
