/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.internal.AbstractTemplateRptPathProvider;
import com.oracle.bmc.util.internal.Validate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentRptPathProvider
extends AbstractTemplateRptPathProvider {
    static final String OCI_RESOURCE_PRINCIPAL_RPT_PATH = "OCI_RESOURCE_PRINCIPAL_RPT_PATH";
    static final String OCI_RESOURCE_PRINCIPAL_RPT_ID = "OCI_RESOURCE_PRINCIPAL_RPT_ID";
    private final Map<String, String> replacements = Validate.notNull(EnvironmentRptPathProvider.buildReplacements(), "Environment variable 'OCI_RESOURCE_PRINCIPAL_RPT_ID' was not set", new Object[0]);

    protected EnvironmentRptPathProvider(String pathTemplate) {
        super(pathTemplate);
    }

    public EnvironmentRptPathProvider() {
        this(EnvironmentRptPathProvider.getPathTemplate());
    }

    @Override
    protected Map<String, String> getReplacements() {
        return this.replacements;
    }

    protected static String getPathTemplate() {
        return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_PATH);
    }

    protected static String getRptId() {
        return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_ID);
    }

    protected static Map<String, String> buildReplacements() {
        return EnvironmentRptPathProvider.getRptIdAndReplace(EnvironmentRptPathProvider.getRptId());
    }

    private static Map<String, String> getRptIdAndReplace(String rptId) {
        String rpt_id = rptId;
        if (rpt_id != null) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("id", rpt_id);
            return Collections.unmodifiableMap(replacements);
        }
        return null;
    }

    public static class LeafResourceRptPathProvider
    extends EnvironmentRptPathProvider {
        static final String OCI_RESOURCE_PRINCIPAL_RPT_PATH_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPT_PATH_FOR_LEAF_RESOURCE";
        static final String OCI_RESOURCE_PRINCIPAL_RPT_ID_FOR_LEAF_RESOURCE = "OCI_RESOURCE_PRINCIPAL_RPT_ID_FOR_LEAF_RESOURCE";
        private final Map<String, String> replacements = Validate.notNull(LeafResourceRptPathProvider.buildReplacements(), "Environment variable 'OCI_RESOURCE_PRINCIPAL_RPT_ID_FOR_LEAF_RESOURCE' was not set", new Object[0]);

        public LeafResourceRptPathProvider() {
            super(LeafResourceRptPathProvider.getPathTemplate());
        }

        protected static String getRptId() {
            return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_ID_FOR_LEAF_RESOURCE);
        }

        protected static String getPathTemplate() {
            return System.getenv(OCI_RESOURCE_PRINCIPAL_RPT_PATH_FOR_LEAF_RESOURCE);
        }

        protected static Map<String, String> buildReplacements() {
            return EnvironmentRptPathProvider.getRptIdAndReplace(LeafResourceRptPathProvider.getRptId());
        }
    }
}

