package com.github.marschall.memoryfilesystem;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.junit.jupiter.api.Assertions.assertTrue;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributes;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MemorySymbolicLinkTest {

  private MemorySymbolicLink memoryFile;

  @BeforeEach
  void setUp() {
    this.memoryFile = new MemorySymbolicLink("", null, EntryCreationContextUtil.empty());
  }

  @Test
  void testCheckMethods() throws IOException {
    BasicFileAttributes attributes = this.memoryFile.getBasicFileAttributeView().readAttributes();

    assertFalse(attributes.isRegularFile());

    assertFalse(attributes.isDirectory());
    assertFalse(attributes.isOther());
    assertTrue(attributes.isSymbolicLink());

    assertEquals(-1L, attributes.size());

    assertNotNull(attributes.fileKey());
  }

}
