// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2007 Konrad Twardowski

#pragma once

#include "../kshutdown.h"

#include <QFileInfo>
#include <QMenu>
#include <QPushButton>

class CommandAction;
class UCommandEdit;

class Extras final: public Action {
	friend class CommandAction;
public:
	virtual QString getStringOption() override;
	virtual void setStringOption(const QString &option) override;
	void initContainerWidget() override;
	virtual bool onAction() override;
	virtual bool onCommandLineOption() override;
	virtual void readConfig() override;
	static Extras *self() {
		if (!m_instance)
			m_instance = new Extras();

		return m_instance;
	}
	virtual void writeConfig() override;
private:
	Q_DISABLE_COPY(Extras)
	bool m_examplesCreated = false;
	CommandAction *m_quickCommandAction;
	CommandAction *m_selectedCommandAction = nullptr;
	inline static Extras *m_instance = nullptr;
	QMenu *m_menu = nullptr;
	QPushButton *m_menuButton;
	UCommandEdit *m_quickCommandEdit = nullptr;
	explicit Extras();
	CommandAction *createCommandAction(const QFileInfo &fileInfo, const bool returnNull);
	QMenu *createMenu();
	void createMenu(QMenu *parentMenu, const QString &parentDir);
	QString getFilesDirectory();
	static QIcon readDesktopInfo(const QFileInfo &fileInfo, QString &text, QString &description);
	void setCommandAction(CommandAction *command);
	void showHelp(const bool always);

	// event handlers:
	void onModify();
	void onUpdateMenu();
};

class CommandAction final: private QAction {
	friend class Extras;
private:
	Q_DISABLE_COPY(CommandAction)
	QString m_command;
	explicit CommandAction(QObject *parent);
	explicit CommandAction(const QIcon &icon, const QString &text, QObject *parent, const QFileInfo &fileInfo, const QString &description);
	void init(const QString &command);
};
