/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.ui.internal.dnd.MindMapDNDClientBase;
import org.xmind.ui.internal.iconfinder.IconfinderCore;
import org.xmind.ui.internal.iconfinder.IconfinderIconTransfer;
import org.xmind.ui.internal.iconfinder.model.Icon;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;

public class IconfinderIconDndClient
extends MindMapDNDClientBase {
    private static final String CREATE_IMAGE = "CREATE_IMAGE";
    private static final String COPY = "COPY";
    private IconfinderIconTransfer transfer = IconfinderIconTransfer.getInstance();

    public Object getData(Transfer transfer, TransferData data) {
        if (transfer == this.transfer) {
            return this.transfer.nativeToJava(data);
        }
        return null;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Object toTransferData(Object[] viewerElements, IViewer viewer) {
        return null;
    }

    protected Object[] toViewerElements(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent) {
        if (transferData instanceof Icon[]) {
            List<FileDropHandler> handlers;
            Icon[] icons = (Icon[])transferData;
            ArrayList<Icon> toDownLoadIcons = new ArrayList<Icon>();
            int rasterSize = IconfinderCore.getInstance().getModelPage().getRasterSize();
            Icon[] iconArray = icons;
            int n = icons.length;
            int n2 = 0;
            while (n2 < n) {
                Icon icon = iconArray[n2];
                File iconFile = IconfinderCore.getIconFile(icon.getIconId());
                if (!iconFile.exists()) {
                    toDownLoadIcons.add(icon);
                } else {
                    try {
                        if (ImageIO.read(iconFile).getWidth() != rasterSize) {
                            toDownLoadIcons.add(icon);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            if (!toDownLoadIcons.isEmpty()) {
                IconfinderCore.blockDowloadIconImage(toDownLoadIcons.toArray(new Icon[toDownLoadIcons.size()]), IconfinderCore.getInstance().getModelPage().getRasterSize());
            }
            if (workbook != null && (handlers = this.createFileDropHandlers(icons, dropInParent)) != null) {
                ArrayList<Object> elements = new ArrayList<Object>(handlers.size());
                for (FileDropHandler handler : handlers) {
                    handler.createViewerElements(workbook, targetParent, elements);
                }
                return elements.toArray();
            }
        }
        return null;
    }

    private List<FileDropHandler> createFileDropHandlers(Icon[] icons, boolean dropInParent) {
        ArrayList<FileDropHandler> handlers = new ArrayList<FileDropHandler>(icons.length);
        if (IconfinderIconDndClient.isSingleImage(icons) && dropInParent) {
            this.createFileDropHandlers(handlers, CREATE_IMAGE, icons[0]);
        } else {
            this.createFileDropHandlers(handlers, COPY, icons);
        }
        return handlers;
    }

    private void createFileDropHandlers(List<FileDropHandler> handlers, String action, Icon ... icons) {
        int i = 0;
        while (i < icons.length) {
            File iconFile = IconfinderCore.getIconFile(icons[i].getIconId());
            if (iconFile.exists()) {
                handlers.add(new FileDropHandler(iconFile, action));
            }
            ++i;
        }
    }

    private static boolean isSingleImage(Icon[] icons) {
        return icons.length == 1 && IconfinderIconDndClient.isImagePath(IconfinderCore.getIconFile(icons[0].getIconId()).getAbsolutePath());
    }

    private static boolean isImagePath(String path) {
        String ext = FileUtils.getExtension((String)path);
        return ImageFormat.findByExtension((String)ext, null) != null;
    }

    private static Dimension getImageSize(String path) {
        try {
            Image tempImage = new Image((Device)Display.getCurrent(), path);
            Rectangle imageBounds = tempImage.getBounds();
            tempImage.dispose();
            return Geometry.getScaledConstrainedSize((int)imageBounds.width, (int)imageBounds.height, (int)400, (int)400);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private class FileDropHandler {
        private File file;
        private String action;

        public FileDropHandler(File file, String action) {
            this.file = file;
            this.action = action;
        }

        public void createViewerElements(IWorkbook workbook, ITopic targetParent, List<Object> elements) {
            if (IconfinderIconDndClient.CREATE_IMAGE.equals(this.action)) {
                if (targetParent != null) {
                    elements.add(this.createImageOnTopic(workbook, targetParent, this.file));
                }
            } else if (IconfinderIconDndClient.COPY.equals(this.action)) {
                elements.add(this.createAttachmentTopic(workbook, this.file, null));
            }
        }

        private ITopic createAttachmentTopic(IWorkbook workbook, File file, ITopic parent) {
            ITopic topic = workbook.createTopic();
            topic.setTitleText(file.getName());
            if (file.isDirectory()) {
                String[] subfiles = file.list();
                int i = 0;
                while (i < subfiles.length) {
                    File subfile = new File(file, subfiles[i]);
                    ITopic subtopic = this.createAttachmentTopic(workbook, subfile, topic);
                    topic.add(subtopic, "attached");
                    ++i;
                }
            } else {
                try {
                    IFileEntry entry = workbook.getManifest().createAttachmentFromFilePath(file.getAbsolutePath());
                    entry.decreaseReference();
                    entry.increaseReference();
                    if (IconfinderIconDndClient.isImagePath(file.getAbsolutePath())) {
                        Dimension size = IconfinderIconDndClient.getImageSize(file.getAbsolutePath());
                        if (size != null) {
                            topic.getImage().setSource(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                            topic.getImage().setSize(size.width, size.height);
                            topic.setTitleText("");
                        }
                        topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                    }
                    topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)entry.getPath()));
                }
                catch (IOException e) {
                    Logger.log((Throwable)e, (String)("Error occurred when transfering file: " + file.getAbsolutePath()));
                }
            }
            return topic;
        }

        private Object createImageOnTopic(IWorkbook workbook, ITopic topic, File file) {
            try {
                IFileEntry entry = workbook.getManifest().createAttachmentFromFilePath(file.getAbsolutePath());
                entry.decreaseReference();
                entry.increaseReference();
                Dimension size = IconfinderIconDndClient.getImageSize(file.getAbsolutePath());
                if (size != null) {
                    return IconfinderIconDndClient.this.createModifyImageCommand(topic, HyperlinkUtils.toAttachmentURL((String)entry.getPath()), size.width, size.height, null);
                }
                Logger.log((String)("[IconfinderDndClient] Failed to open invalid image file: " + file.getAbsolutePath()));
            }
            catch (IOException e) {
                Logger.log((Throwable)e, (String)("Error occurred when transfering file: " + file.getAbsolutePath()));
            }
            return null;
        }
    }
}

