/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.part.PartRegistry;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt2.gefext.IConnectionManager;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.gefext.NodePart;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.IHostFigureProvider;
import org.xmind.ui.gantt2.viewer.OffsetLayer;
import org.xmind.ui.gantt2.viewer.OffsetLayout;
import org.xmind.ui.gantt2.viewer.OffsetVerticalToolbarLayout;
import org.xmind.ui.gantt2.viewer.ProgressFigure;
import org.xmind.ui.gantt2.viewer.TaskBar;
import org.xmind.ui.gantt2.viewer.TaskBarCreateFeedback;
import org.xmind.ui.gantt2.viewer.TaskBarDependencyAnchorsFeedback;
import org.xmind.ui.gantt2.viewer.TaskBarFigure;
import org.xmind.ui.gantt2.viewer.TaskBarMoveFeedback;
import org.xmind.ui.gantt2.viewer.TaskBarSelectablePolicy;
import org.xmind.ui.gantt2.viewer.TaskBarSelectionFeedback;
import org.xmind.ui.gantt2.viewer.TaskBarToolTipFeedback;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBarPart
extends NodePart
implements ICoreEventListener,
IHostFigureProvider {
    public static final Object ROLE_TOOLTIP_PROVIDER = "tooltip provider role";
    public static final Object ROLE_PROGRESS_PROVIDER = "progress provider role";
    private static final Rectangle AREA = new Rectangle();
    private static final Rectangle RECT = new Rectangle();
    private IFigure barFigure = null;
    private IFigure progressFigure = null;
    private IFigure childContainer = null;
    private ICoreEventRegister eventRegister = null;
    private TaskBar data = null;
    private TaskBarToolTipFeedback tooltipFeedback;

    public TaskBarPart(Object model) {
        this.setModel(model);
        this.setFigure(this.createFigure());
        this.installFeedback("connectable role", new TaskBarDependencyAnchorsFeedback());
        this.installFeedback("selectable role", new TaskBarSelectionFeedback());
        this.installFeedback("movable role", new TaskBarMoveFeedback());
        this.tooltipFeedback = new TaskBarToolTipFeedback();
        this.installFeedback(ROLE_TOOLTIP_PROVIDER, this.tooltipFeedback);
        this.installFeedback("creatable role", new TaskBarCreateFeedback());
    }

    public ITopic getTask() {
        return (ITopic)this.getModel();
    }

    public TaskBar getTaskBar() {
        return this.data;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.data = new TaskBar((ITopic)model);
    }

    protected void register() {
        super.register();
        this.registerModel(this.getModel());
        this.registerFigure(this.getMainFigure());
    }

    protected void unregister() {
        this.unregisterFigure(this.getMainFigure());
        this.unregisterModel(this.getModel());
        super.unregister();
    }

    @Override
    protected IFigure createFigure() {
        OffsetLayer layer = new OffsetLayer();
        layer.setLayoutManager((LayoutManager)new TaskBarLayout());
        this.barFigure = new TaskBarFigure();
        layer.add(this.barFigure);
        this.barFigure.setLayoutManager((LayoutManager)new TaskBarInnerLayout());
        this.progressFigure = new ProgressFigure();
        this.barFigure.add(this.progressFigure);
        this.childContainer = new OffsetLayer();
        layer.add(this.childContainer);
        this.childContainer.setLayoutManager((LayoutManager)new OffsetVerticalToolbarLayout());
        if ("allTopics".equals(this.getViewerMode()) || TaskInfoUtils.hasCascadeTaskInfo((ITopic)this.getTask())) {
            layer.setVisible(true);
        } else {
            layer.setVisible(false);
        }
        return layer;
    }

    @Override
    public IFigure getContentPane() {
        return this.childContainer;
    }

    public IFigure getBarFigure() {
        return this.barFigure;
    }

    public IFigure getProgressFigure() {
        return this.progressFigure;
    }

    protected Object[] getModelChildren(Object model) {
        ITopic task = (ITopic)model;
        return task.getAllChildren().toArray();
    }

    protected void installModelListeners() {
        super.installModelListeners();
        Object m = this.getModel();
        this.eventRegister = new CoreEventRegister(m, (ICoreEventListener)this);
        this.registerCoreEvents(m, this.eventRegister);
    }

    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("markerRefAdd");
        register.register("markerRefRemove");
        register.register("taskInfoChange");
    }

    protected void uninstallModelListeners() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListeners();
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control c = this.getSite().getViewerControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            public void run() {
                String type = event.getType();
                if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
                    TaskBarPart.this.refresh();
                    TaskBarPart.this.updateParent(event.getTarget());
                } else if ("taskInfoChange".equals(type)) {
                    Object target = event.getTarget();
                    TaskBarPart.this.update(target);
                    TaskBarPart.this.updateParent(target);
                    TaskBarPart.this.collectTaskData(target);
                    if ("predecessors".equals(target)) {
                        TaskBarPart.this.refreshDependencies();
                    }
                } else if ("markerRefAdd".equals(type) || "markerRefRemove".equals(type)) {
                    TaskBarPart.this.update(type);
                }
            }
        });
    }

    private void collectTaskData(Object target) {
        TaskBar taskBar = this.getTaskBar();
        ITopic task = this.getTask();
        DateInfo startDate = taskBar.getStartDate();
        if (task != null) {
            VerifyUI20141031.getUsageDataCollector().put(String.format("Task/endTime/%s", task.getId()), startDate != null && startDate.date != null ? startDate.date.getTimeInMillis() : -1L);
        }
        DateInfo endDate = taskBar.getEndDate();
        if (task != null) {
            VerifyUI20141031.getUsageDataCollector().put(String.format("Task/startTime/%s", task.getId()), endDate != null && endDate.date != null ? endDate.date.getTimeInMillis() : -1L);
        }
    }

    private void updateParent(Object target) {
        if (this.getParent() instanceof TaskBarPart) {
            TaskBarPart parent = (TaskBarPart)this.getParent();
            parent.updateView(target);
            parent.updateParent(target);
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        this.getRequestHandler().installEditPolicy("selectable role", (IEditPolicy)TaskBarSelectablePolicy.getInstance());
    }

    @Override
    protected void updateView(Object property) {
        boolean childrenShowing;
        boolean priorityChanged;
        boolean markerChanged;
        ITopic task = this.getTask();
        TaskBar bar = this.getTaskBar();
        String viewerMode = this.getViewerMode();
        DateInfo oldStartDate = bar.getStartDate();
        DateInfo oldEndDate = bar.getEndDate();
        int oldProgress = bar.getProgress();
        boolean oldCheckpoint = bar.isCheckpoint();
        String oldPriority = bar.getPriority();
        TaskBarFigure taskBarFigure = (TaskBarFigure)this.getBarFigure();
        ProgressFigure progressFigure = (ProgressFigure)this.getProgressFigure();
        boolean oldChildrenShowing = this.getContentPane().isShowing();
        if (!"flat".equals(viewerMode) && TaskInfoUtils.hasCascadeTaskInfo2((ITopic)task)) {
            taskBarFigure.setHasChild(true);
            progressFigure.setHasChild(true);
        } else {
            taskBarFigure.setHasChild(false);
            progressFigure.setHasChild(false);
        }
        if (property == null || "topicFolded".equals(property)) {
            boolean folded = ((GanttEditDomain)this.getSite().getDomain()).getConfigurations().isFolded(task);
            this.getContentPane().setVisible(!folded);
        }
        if (property == null || "check-point".equals(property)) {
            bar.updateCheckpoint();
        }
        boolean bl = markerChanged = property == null || "markerRefAdd".equals(property) || "markerRefRemove".equals(property);
        if (markerChanged || "progress".equals(property)) {
            bar.updateProgress();
        }
        if (markerChanged) {
            bar.updatePriority();
        }
        if (property == null || "start-date".equals(property) || "duration".equals(property) || "end-date".equals(property) || "predecessors".equals(property) || "check-point".equals(property)) {
            bar.updateStartDate();
            bar.updateEndDate();
        }
        boolean startDateChanged = property == null || !TaskBarPart.objEquals(oldStartDate, bar.getStartDate());
        boolean endDateChanged = property == null || !TaskBarPart.objEquals(oldEndDate, bar.getEndDate());
        boolean progressChanged = property == null || oldProgress != bar.getProgress();
        boolean checkpointChanged = property == null || oldCheckpoint != bar.isCheckpoint();
        boolean bl2 = priorityChanged = property == null || !TaskBarPart.objEquals(oldPriority, bar.getPriority());
        if (checkpointChanged) {
            ((TaskBarFigure)this.getBarFigure()).setCheckpoint(bar.isCheckpoint());
        }
        if (progressChanged || checkpointChanged) {
            progressFigure.setVisible(bar.getProgress() >= 0 && !bar.isCheckpoint());
            if (progressFigure.isVisible()) {
                progressFigure.revalidate();
            }
        }
        if (priorityChanged) {
            this.getBarFigure().setForegroundColor(Colors.taskBar(bar.getPriority()));
            this.getProgressFigure().setForegroundColor(Colors.progress(bar.getPriority()));
        }
        if (startDateChanged || endDateChanged) {
            DateInfo startDate = bar.getStartDate();
            DateInfo endDate = bar.getEndDate();
            taskBarFigure.setOffset(this.calculateBarOffset(startDate, endDate));
            taskBarFigure.setLength(this.calculateBarLength(startDate, endDate));
            taskBarFigure.setVisible(taskBarFigure.hasOffset());
            for (IConnectionPart connection : this.getSourceConnections()) {
                INodePart target = connection.getTargetNode();
                if (target == null) continue;
                if (target instanceof IEditPart) {
                    ((IEditPart)target).update(property);
                    continue;
                }
                target.update();
            }
        }
        if (("flat".equals(viewerMode) || "hierarchical".equals(viewerMode)) && !TaskInfoUtils.hasTaskInfo((ITopic)this.getTask())) {
            this.getBarFigure().setVisible(false);
        }
        if (oldChildrenShowing != (childrenShowing = this.getContentPane().isShowing())) {
            for (IPart c : this.getChildren()) {
                if (!(c instanceof TaskBarPart)) continue;
                ((TaskBarPart)c).treeUpdateConnections();
            }
        }
        ITopic topic = this.getTask();
        if ("allTopics".equals(viewerMode) || TaskInfoUtils.hasCascadeTaskInfo((ITopic)topic)) {
            this.getFigure().setVisible(true);
        } else {
            this.getFigure().setVisible(false);
        }
        this.getBarFigure().revalidate();
    }

    protected void treeUpdateConnections() {
        for (IConnectionPart c : this.getSourceConnections()) {
            c.update();
        }
        for (IConnectionPart c : this.getTargetConnections()) {
            c.update();
        }
        for (IConnectionPart c : this.getChildren()) {
            if (!(c instanceof TaskBarPart)) continue;
            ((TaskBarPart)c).treeUpdateConnections();
        }
    }

    private static boolean objEquals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private Integer calculateBarOffset(DateInfo startDate, DateInfo endDate) {
        DateInfo start;
        DateInfo dateInfo = start = startDate == null ? endDate : startDate;
        if (start == null) {
            return null;
        }
        Calendar origin = this.getTimelineModel().getOriginDate();
        long millis = start.date.getTimeInMillis() - origin.getTimeInMillis();
        return this.calculatePixels(millis);
    }

    private int calculateBarLength(DateInfo startDate, DateInfo endDate) {
        if (startDate == null) {
            return 1;
        }
        if (endDate == null) {
            return 1;
        }
        long millis = endDate.date.getTimeInMillis() - startDate.date.getTimeInMillis();
        return Math.max(1, this.calculatePixels(millis));
    }

    private int calculatePixels(long millis) {
        return this.getTimelineModel().getPixelsFromMillis(millis);
    }

    public TimelineModel getTimelineModel() {
        return ((GanttEditDomain)this.getSite().getDomain()).getTimelineModel();
    }

    @Override
    protected void onActivated() {
        super.onActivated();
        IConnectionManager cm = this.getConnectionManager();
        if (cm != null) {
            cm.solvePendingSource(this.getTask().getId());
            this.refreshDependencies(cm);
        }
    }

    private IConnectionManager getConnectionManager() {
        return (IConnectionManager)this.getSite().getRoot().getAdapter(IConnectionManager.class);
    }

    @Override
    protected void onDeactivated() {
        IConnectionManager cm = this.getConnectionManager();
        if (cm != null) {
            this.deleteDependencyConnections(cm, this.getTargetConnections());
            cm.removeAllPendingSources(this.getTask().getId());
            this.deleteSourceConnections(cm);
        }
        super.onDeactivated();
    }

    private void deleteDependencyConnections(IConnectionManager cm, List<IConnectionPart> connections) {
        Object[] objectArray = connections.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = objectArray[n2];
            IConnectionPart connection = (IConnectionPart)c;
            cm.deleteConnection(connection);
            Dependency dependency = (Dependency)connection.getModel();
            cm.removePendingSource(dependency.getTaskId(), dependency, this.getTask().getId());
            ++n2;
        }
    }

    private void deleteSourceConnections(IConnectionManager cm) {
        Object[] objectArray = this.getSourceConnections().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = objectArray[n2];
            IConnectionPart connection = (IConnectionPart)c;
            Dependency dependency = (Dependency)connection.getModel();
            INodePart target = connection.getTargetNode();
            boolean targetActive = target != null && target.getStatus().isActive();
            cm.deleteConnection(connection);
            if (targetActive) {
                cm.addPendingSource(dependency.getTaskId(), dependency, dependency.getSuccessor().getId());
            }
            ++n2;
        }
    }

    private void refreshDependencies() {
        IConnectionManager cm = this.getConnectionManager();
        if (cm != null) {
            this.refreshDependencies(cm);
        }
    }

    private void refreshDependencies(IConnectionManager cm) {
        PartRegistry reg = this.getSite().getViewer().getPartRegistry();
        ArrayList<IConnectionPart> remainingConnections = new ArrayList<IConnectionPart>(this.getTargetConnections());
        for (Dependency dependency : TaskInfoUtils.getDependencies((ITopic)this.getTask())) {
            IPart part = reg.getPartByModel((Object)dependency);
            if (part != null) {
                remainingConnections.remove(part);
                continue;
            }
            cm.createConnection(dependency, dependency.getTaskId(), this.getTask().getId());
        }
        this.deleteDependencyConnections(cm, remainingConnections);
    }

    public void addTooltipRequester(Object requester) {
        this.tooltipFeedback.addTooltipRequester(requester);
    }

    public void removeTooltipRequester(Object requester) {
        this.tooltipFeedback.removeTooltipRequester(requester);
    }

    @Override
    protected IFigure getMainFigure() {
        return this.getBarFigure();
    }

    public int getConnectionOrientation(Point point) {
        IFigure figure = this.getBarFigure();
        if (figure.isVisible()) {
            Rectangle r = figure.getBounds();
            int c = r.x + r.width / 2;
            int min = r.x - 20;
            int max = r.x + r.width + 20;
            int x = point.x;
            if (x >= min && x < c) {
                return 8;
            }
            if (x >= c && x < max) {
                return 16;
            }
        }
        return 0;
    }

    private String getViewerMode() {
        String viewerMode = GanttPlugin.getDefault().getPreferenceStore().getString("org.xmind.ui.gantt.radioState.viewerMode");
        return viewerMode == null || "".equals(viewerMode) ? "allTopics" : viewerMode;
    }

    @Override
    public IFigure getHostFigure() {
        return this.getBarFigure();
    }

    @Override
    public boolean isHostFigureVisible() {
        IFigure layer = this.getFigure();
        IFigure hostFigure = this.getHostFigure();
        return layer.isVisible() && hostFigure.getSize().height != 0;
    }

    private class TaskBarInnerLayout
    extends AbstractLayout {
        private TaskBarInnerLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            return new Dimension();
        }

        public void layout(IFigure container) {
            Rectangle a = container.getClientArea(AREA);
            int progress = TaskBarPart.this.getTaskBar().getProgress();
            Rectangle r = RECT;
            if (TaskBarPart.this.progressFigure.isVisible()) {
                r.width = Math.max(a.width * progress / 100, 1);
                r.height = a.height;
                r.x = a.x;
                r.y = a.y;
                TaskBarPart.this.progressFigure.setBounds(r);
            }
        }
    }

    private class TaskBarLayout
    extends OffsetLayout {
        private TaskBarLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            boolean hasMainOffset;
            Dimension size = new Dimension(TaskBarPart.this.getBarFigure().getPreferredSize());
            size.height += 7;
            if (("flat".equals(TaskBarPart.this.getViewerMode()) || "hierarchical".equals(TaskBarPart.this.getViewerMode())) && !TaskInfoUtils.hasTaskInfo((ITopic)TaskBarPart.this.getTask())) {
                size.height = 0;
            }
            if (!(hasMainOffset = ((IHasOffset)TaskBarPart.this.getBarFigure()).hasOffset())) {
                size.width = 0;
            }
            if (TaskBarPart.this.getContentPane().isVisible()) {
                Dimension childrenSize = TaskBarPart.this.getContentPane().getPreferredSize();
                if (((IHasOffset)TaskBarPart.this.getContentPane()).hasOffset()) {
                    int childrenOffset = ((IHasOffset)TaskBarPart.this.getContentPane()).getOffset();
                    if (hasMainOffset) {
                        int mainOffset = ((IHasOffset)TaskBarPart.this.getBarFigure()).getOffset();
                        size.width = Math.max(mainOffset + size.width, childrenOffset + childrenSize.width) - Math.min(mainOffset, childrenOffset);
                    } else {
                        size.width = childrenSize.width;
                    }
                }
                size.height += childrenSize.height;
            }
            return size;
        }

        public void layout(IFigure container) {
            container.getClientArea(AREA);
            Dimension s1 = TaskBarPart.this.getBarFigure().getPreferredSize();
            RECT.setSize(s1);
            RECT.x = TaskBarPart.this.getBarFigure().isVisible() && ((IHasOffset)TaskBarPart.this.getBarFigure()).hasOffset() ? ((IHasOffset)TaskBarPart.this.getBarFigure()).getOffset() : AREA.x;
            RECT.y = AREA.y + 3;
            if (("flat".equals(TaskBarPart.this.getViewerMode()) || "hierarchical".equals(TaskBarPart.this.getViewerMode())) && !TaskInfoUtils.hasTaskInfo((ITopic)TaskBarPart.this.getTask())) {
                TaskBarPart.this.getBarFigure().setBounds(new Rectangle(RECT.x, RECT.y, 0, 0));
            } else {
                TaskBarPart.this.getBarFigure().setBounds(RECT);
            }
            if (TaskBarPart.this.getContentPane().isVisible()) {
                if (((IHasOffset)TaskBarPart.this.getContentPane()).hasOffset()) {
                    Dimension s2 = TaskBarPart.this.getContentPane().getPreferredSize();
                    RECT.setSize(s2);
                    RECT.x = ((IHasOffset)TaskBarPart.this.getContentPane()).getOffset();
                } else {
                    RECT.setSize(0, 0);
                    RECT.x = AREA.x;
                }
                RECT.y = ("flat".equals(TaskBarPart.this.getViewerMode()) || "hierarchical".equals(TaskBarPart.this.getViewerMode())) && !TaskInfoUtils.hasTaskInfo((ITopic)TaskBarPart.this.getTask()) ? AREA.y : AREA.y + s1.height + 7;
                TaskBarPart.this.getContentPane().setBounds(RECT);
            } else {
                RECT.y += RECT.height;
                RECT.width = 0;
                RECT.height = 0;
                TaskBarPart.this.getContentPane().setBounds(RECT);
            }
        }
    }
}

