/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.ui.gantt2.viewer.IHasOffset;
import org.xmind.ui.gantt2.viewer.OffsetLayout;

public class OffsetVerticalToolbarLayout
extends OffsetLayout {
    private int spacing;
    private static final Rectangle AREA = new Rectangle();
    private static final Rectangle RECT = new Rectangle();

    public OffsetVerticalToolbarLayout() {
        this(0);
    }

    public OffsetVerticalToolbarLayout(int spacing) {
        this.spacing = spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.invalidate();
    }

    public int getSpacing() {
        return this.spacing;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int width = 0;
        int height = 0;
        Integer lastOffset = null;
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (!this.isObservingVisibility() || child.isVisible()) {
                Dimension childSize = child.getPreferredSize();
                if (this.doesChildHaveOffset(child)) {
                    int childOffset = ((IHasOffset)child).getOffset();
                    if (lastOffset == null) {
                        width = childSize.width;
                        lastOffset = childOffset;
                    } else {
                        width = Math.max(lastOffset + width, childOffset + childSize.width) - Math.min(lastOffset, childOffset);
                        lastOffset = Math.min(lastOffset, childOffset);
                    }
                }
                height += childSize.height + this.getSpacing();
            }
            ++i;
        }
        return new Dimension(width, height);
    }

    public void layout(IFigure container) {
        container.getClientArea(AREA);
        int origin = this.getHorizontalOrigin(container, AREA);
        int y = this.getVerticalOrigin(container, AREA);
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (!this.isObservingVisibility() || child.isVisible()) {
                Dimension childSize = child.getPreferredSize();
                RECT.setSize(childSize);
                if (((IHasOffset)child).hasOffset()) {
                    RECT.setLocation(origin + ((IHasOffset)child).getOffset(), y);
                } else {
                    RECT.setLocation(origin, y);
                }
                child.setBounds(RECT);
                y += childSize.height + this.getSpacing();
            }
            ++i;
        }
    }

    protected int getVerticalOrigin(IFigure container, Rectangle clientArea) {
        return clientArea.y;
    }

    protected int getHorizontalOrigin(IFigure container, Rectangle clientArea) {
        return 0;
    }
}

