/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttView;
import org.xmind.ui.gantt.export.GanttPrintClient;
import org.xmind.ui.gantt.export.PrintGanttSetupDialog;
import org.xmind.ui.gantt2.viewer.GanttViewer;

public class PrintGanttChartHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(part instanceof GanttView)) {
            return null;
        }
        final GanttViewer ganttViewer = ((GanttView)part).getCurrentViewer();
        if (ganttViewer == null || ganttViewer.getInput() == null) {
            return null;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            return null;
        }
        final Shell parentShell = window.getShell();
        if (parentShell == null || parentShell.isDisposed()) {
            return null;
        }
        VerifyUI20141031.runAction20141031((String)"PrintGantt", (String)GanttMessages.PrintGanttChart_ActionName, (int)3, (Runnable)new Runnable(){

            public void run() {
                VerifyUI20141031.getUsageDataCollector().increase("PrintGanttChartCount");
                PrintGanttChartHandler.this.print(ganttViewer, parentShell);
            }
        }, null);
        return null;
    }

    private void print(GanttViewer ganttViewer, Shell parentShell) {
        PrintGanttSetupDialog setupDialog = new PrintGanttSetupDialog(parentShell, ganttViewer);
        int open = setupDialog.open();
        if (open == 1) {
            return;
        }
        IDialogSettings settings = setupDialog.getSettings();
        PrinterData printerData = new PrinterData();
        try {
            printerData.orientation = settings.getInt("orientation");
        }
        catch (NumberFormatException numberFormatException) {
            printerData.orientation = 2;
        }
        PrintDialog printDialog = new PrintDialog(parentShell);
        printDialog.setPrinterData(printerData);
        printerData = printDialog.open();
        if (printerData != null) {
            GanttPrintClient client = new GanttPrintClient(GanttMessages.PrintGanttChart_jobName, parentShell, printerData, settings, ganttViewer);
            try {
                client.print();
            }
            finally {
                client.dispose();
            }
        }
    }
}

