/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryMovablePolicy;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.AddSlideCommand;
import org.xmind.ui.internal.presentation.slide.DeleteSlideCommand;
import org.xmind.ui.internal.presentation.slide.PresentationGallerySelectTool;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryLabelProvider;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tools.GalleryMoveTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationStoryGalleryViewer
extends GalleryViewer {
    private static final Comparator<PresentationSlide> SLIDE_COMPARATOR_BY_INDEX = new Comparator<PresentationSlide>(){

        @Override
        public int compare(PresentationSlide s1, PresentationSlide s2) {
            Integer s1Index = s1.getIndex();
            Integer s2Index = s2.getIndex();
            return s1Index.compareTo(s2Index);
        }
    };
    private IEditorPart editor;
    private boolean playMode = false;
    private PresentationStory story;

    public PresentationStoryGalleryViewer(IEditorPart editor) {
        this(editor, false);
        this.init();
    }

    public PresentationStoryGalleryViewer(IEditorPart editor, boolean playMode) {
        this.editor = editor;
        this.playMode = playMode;
        this.init();
    }

    private void init() {
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PresentationStoryLabelProvider());
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new PresentationGallerySelectTool(this.editor, this.playMode));
        editDomain.installTool("move tool", (ITool)new GalleryMoveTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.movable", (IEditPolicy)new PresentationStoryMovablePolicy());
        this.setEditDomain(editDomain);
        Properties props = this.getProperties();
        props.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(0, 3, 3, 0, new Insets(9, 8, 15, 8)));
        props.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(180, 100));
        props.set("org.xmind.ui.gallery.packFrameContent", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.titlePlacement", (Object)TITLE_BOTTOM);
        props.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        props.set("constrained", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
        props.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        props.set("org.xmind.ui.gallery.contentPaneBorderColor", (Object)((Color)new LocalResourceManager(JFaceResources.getResources()).get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#bbbbbb"))));
        props.set("org.xmind.ui.gallery.contentPaneMargins", (Object)new Insets(2));
    }

    protected void hookControl(Control control) {
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), control);
        control.setBackground(resourceManager.createColor(new RGB(240, 242, 238)));
        control.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PresentationStoryGalleryViewer.this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        super.hookControl(control);
    }

    public void setStory(PresentationStory story) {
        this.story = story;
    }

    public List<PresentationSlide> getSlideSelections() {
        ISelection s = this.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            ArrayList<PresentationSlide> selections = new ArrayList<PresentationSlide>();
            for (Object o : ss) {
                if (!(o instanceof PresentationSlide)) continue;
                selections.add((PresentationSlide)o);
            }
            Collections.sort(selections, SLIDE_COMPARATOR_BY_INDEX);
            return selections;
        }
        return Collections.emptyList();
    }

    private class PresentationStoryMovablePolicy
    extends GalleryMovablePolicy {
        private PresentationStoryMovablePolicy() {
        }

        protected void moveGallery(Request request) {
            IPart sourcePart = request.getPrimaryTarget();
            IPart targetPart = (IPart)request.getParameter("insertTarget");
            if (sourcePart == null || targetPart == null) {
                return;
            }
            boolean isBefore = (Boolean)request.getParameter("insertPosition");
            PresentationSlide source = (PresentationSlide)sourcePart.getModel();
            PresentationSlide target = (PresentationSlide)targetPart.getModel();
            if (source == null || target == null || source == target) {
                return;
            }
            ArrayList<PresentationSlide> slides = new ArrayList<PresentationSlide>(PresentationStoryGalleryViewer.this.story.getSlides());
            slides.remove(source);
            int index = slides.indexOf(target);
            if (!isBefore) {
                ++index;
            }
            ArrayList<SourceCommand> commands = new ArrayList<SourceCommand>();
            commands.add(new DeleteSlideCommand(PresentationStoryGalleryViewer.this.story, source));
            commands.add(new AddSlideCommand(PresentationStoryGalleryViewer.this.story, source, index));
            CompoundCommand cc = new CompoundCommand(PresentationMessages.PresentationStoryGalleryViewer_Command_Move_Slide, commands);
            if (PresentationStoryGalleryViewer.this.editor instanceof IGraphicalEditor) {
                ((IGraphicalEditor)PresentationStoryGalleryViewer.this.editor).getCommandStack().execute((Command)cc);
            }
        }
    }
}

